/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.FigureListener;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.roi.model.util.UnitPoint;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.EllipseTextFigure;

public class MeasureEllipseFigure
extends EllipseTextFigure
implements ROIFigure {
    private boolean deletable;
    private boolean annotatable;
    private boolean editable;
    private boolean readOnly;
    private boolean clientObject;
    private boolean dirty;
    private Rectangle2D measurementBounds;
    protected ROI roi;
    protected ROIShape shape;
    private MeasurementUnits units;
    private int status;
    private boolean interactable;

    public MeasureEllipseFigure() {
        this("");
    }

    public MeasureEllipseFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0, false, true, true, true, true);
    }

    public MeasureEllipseFigure(boolean readOnly, boolean isClientObject, boolean editable, boolean deletable, boolean annotatable) {
        this("", 0.0, 0.0, 0.0, 0.0, readOnly, isClientObject, editable, deletable, annotatable);
    }

    public MeasureEllipseFigure(double x, double y, double width, double height) {
        this("", x, y, width, height, false, true, true, true, true);
    }

    public MeasureEllipseFigure(String text, double x, double y, double width, double height, boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        super(text, x, y, width, height);
        this.setAttributeEnabled(MeasurementAttributes.TEXT_COLOR, true);
        this.setAttribute(MeasurementAttributes.FONT_FACE, DEFAULT_FONT);
        this.setAttribute(MeasurementAttributes.FONT_SIZE, new Double(12.0));
        this.setAttribute(MeasurementAttributes.SCALE_PROPORTIONALLY, Boolean.FALSE);
        this.shape = null;
        this.roi = null;
        this.status = 0;
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
        this.deletable = deletable;
        this.annotatable = annotatable;
        this.editable = editable;
        this.interactable = true;
    }

    public Length getMeasurementX() {
        return this.transformX(this.getX());
    }

    public Length getMeasurementY() {
        return this.transformX(this.getY());
    }

    public Length getMeasurementWidth() {
        return this.transformX(this.getWidth());
    }

    public Length getMeasurementHeight() {
        return this.transformX(this.getHeight());
    }

    public UnitPoint getMeasurementCentre() {
        Point2D p = this.getCentre();
        return new UnitPoint(this.transformX(p.getX()), this.transformY(p.getY()));
    }

    public double getX() {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        if (t == null) {
            return this.ellipse.getX();
        }
        Point2D.Double src = new Point2D.Double(this.ellipse.getX(), this.ellipse.getY());
        Point2D.Double dest = new Point2D.Double();
        t.transform(src, dest);
        return ((Point2D)dest).getX();
    }

    public double getY() {
        AffineTransform t = AttributeKeys.TRANSFORM.get(this);
        if (t == null) {
            return this.ellipse.getY();
        }
        Point2D.Double src = new Point2D.Double(this.ellipse.getX(), this.ellipse.getY());
        Point2D.Double dest = new Point2D.Double();
        t.transform(src, dest);
        return ((Point2D)dest).getY();
    }

    @Override
    public double getWidth() {
        return super.getWidth();
    }

    @Override
    public double getHeight() {
        return super.getHeight();
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue() || MeasurementAttributes.SHOWID.get(this).booleanValue()) {
            Length a = this.getArea();
            String ellipseArea = UIUtilities.formatValue(a, true);
            Double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
            Font font = (Font)this.getAttribute(MeasurementAttributes.FONT_FACE);
            if (font != null) {
                g.setFont(font.deriveFont(sz.floatValue()));
            } else {
                g.setFont(new Font("sans-serif", 0, sz.intValue()));
            }
            Rectangle2D stringBoundsbounds = g.getFontMetrics().getStringBounds(ellipseArea, g);
            this.measurementBounds = new Rectangle2D.Double(this.getCentreX() - stringBoundsbounds.getWidth() / 2.0, this.getCentreY() + stringBoundsbounds.getHeight() / 2.0, stringBoundsbounds.getWidth(), stringBoundsbounds.getHeight());
            if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue()) {
                g.setColor(MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get(this));
                g.drawString(ellipseArea, (int)this.measurementBounds.getX(), (int)this.measurementBounds.getY());
            }
            if (MeasurementAttributes.SHOWID.get(this).booleanValue()) {
                g.setColor(this.getTextColor());
                this.measurementBounds = g.getFontMetrics().getStringBounds(this.getROI().getID() + "", g);
                this.measurementBounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.measurementBounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.measurementBounds.getHeight() / 2.0, this.measurementBounds.getWidth(), this.measurementBounds.getHeight());
                g.drawString(this.getROI().getID() + "", (int)this.measurementBounds.getX(), (int)this.measurementBounds.getY());
            }
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.measurementBounds != null) {
            double diff;
            if (newBounds.getX() > this.measurementBounds.getX()) {
                diff = newBounds.x - this.measurementBounds.getX();
                newBounds.x = this.measurementBounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.measurementBounds.getY()) {
                diff = newBounds.y - this.measurementBounds.getY();
                newBounds.y = this.measurementBounds.getY();
                newBounds.height += diff;
            }
            if (this.measurementBounds.getX() + this.measurementBounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.measurementBounds.getX() + this.measurementBounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.measurementBounds.getY() + this.measurementBounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.measurementBounds.getY() + this.measurementBounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public Length getArea() {
        Length h = this.getMeasurementHeight();
        Length w = this.getMeasurementWidth();
        double value = h.getValue() / 2.0 * (w.getValue() / 2.0) * Math.PI;
        return new LengthI(value, this.getUnit());
    }

    public Length getPerimeter() {
        double value;
        Length h = this.getMeasurementHeight();
        Length w = this.getMeasurementWidth();
        if (w.getValue() == h.getValue()) {
            value = w.getValue() * 2.0 * Math.PI;
        } else {
            double a = Math.max(w.getValue(), h.getValue());
            double b = Math.min(w.getValue(), h.getValue());
            value = Math.PI * (3.0 * a + 3.0 * b - Math.sqrt((a + 3.0 * b) * (b + 3.0 * a)));
        }
        return new LengthI(value, this.getUnit());
    }

    public Point2D getCentre() {
        return new Point2D.Double(Math.round(this.getCentreX()), Math.round(this.getCentreY()));
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        AnnotationKeys.AREA.set(this.shape, this.getArea());
        AnnotationKeys.HEIGHT.set(this.shape, this.getMeasurementHeight());
        AnnotationKeys.WIDTH.set(this.shape, this.getMeasurementWidth());
        AnnotationKeys.PERIMETER.set(this.shape, this.getPerimeter());
        AnnotationKeys.CENTREX.set(this.shape, this.getMeasurementCentre().x);
        AnnotationKeys.CENTREY.set(this.shape, this.getMeasurementCentre().y);
    }

    @Override
    public String getType() {
        return "Ellipse";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        double startY;
        Shape transformedEllipse = this.getTransformedShape();
        Rectangle2D r = transformedEllipse.getBounds2D();
        ArrayList<Point> vector = new ArrayList<Point>((int)r.getHeight() * (int)r.getWidth());
        double xEnd = r.getX() + r.getWidth();
        double yEnd = r.getY() + r.getHeight();
        double startX = r.getX();
        for (double y = startY = r.getY(); y < yEnd; y += 1.0) {
            for (double x = startX; x < xEnd; x += 1.0) {
                if (!transformedEllipse.intersects(x, y, 0.001, 0.001)) continue;
                vector.add(new Point((int)x, (int)y));
            }
        }
        return vector;
    }

    @Override
    public int getSize() {
        double startY;
        Shape transformedEllipse = this.getTransformedShape();
        Rectangle2D r = transformedEllipse.getBounds2D();
        int total = 0;
        double xEnd = r.getX() + r.getWidth();
        double yEnd = r.getY() + r.getHeight();
        double startX = r.getX();
        for (double y = startY = r.getY(); y < yEnd; y += 1.0) {
            for (double x = startX; x < xEnd; x += 1.0) {
                if (!transformedEllipse.intersects(x, y, 0.001, 0.001)) continue;
                ++total;
            }
        }
        return total;
    }

    @Override
    public void transform(AffineTransform tx) {
        if (!this.readOnly && this.interactable) {
            this.setObjectDirty(true);
            super.transform(tx);
        }
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly && this.interactable) {
            this.setObjectDirty(true);
            super.setBounds(anchor, lead);
        }
    }

    @Override
    public void invalidate() {
        if (!this.readOnly) {
            super.invalidate();
        }
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureEllipseFigure clone() {
        MeasureEllipseFigure that = (MeasureEllipseFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        that.setInteractable(true);
        return that;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }

    @Override
    public boolean canAnnotate() {
        return this.annotatable;
    }

    @Override
    public boolean canDelete() {
        return this.deletable;
    }

    @Override
    public boolean canEdit() {
        return this.editable;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public boolean canInteract() {
        return this.interactable;
    }

    private Length transformX(double x) {
        return this.transformX((int)x);
    }

    private Length transformY(double y) {
        return this.transformY((int)y);
    }

    private Length transformX(int x) {
        if (this.units.getPixelSizeX() != null) {
            return new LengthI((double)x * this.units.getPixelSizeX().getValue(), this.units.getPixelSizeX().getUnit());
        }
        return new LengthI((double)x, UnitsLength.PIXEL);
    }

    private Length transformY(int y) {
        if (this.units.getPixelSizeY() != null) {
            return new LengthI((double)y * this.units.getPixelSizeY().getValue(), this.units.getPixelSizeY().getUnit());
        }
        return new LengthI((double)y, UnitsLength.PIXEL);
    }

    private UnitsLength getUnit() {
        if (this.units.getPixelSizeX() != null) {
            return this.units.getPixelSizeX().getUnit();
        }
        return UnitsLength.PIXEL;
    }
}

