/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.roi.model.util.UnitPoint;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.LineTextFigure;

public class MeasureLineFigure
extends LineTextFigure
implements ROIFigure {
    private boolean deletable;
    private boolean annotatable;
    private boolean editable;
    private boolean readOnly;
    private boolean clientObject;
    private boolean dirty;
    private List<Rectangle2D> boundsArray;
    private List<Length> lengthArray;
    private List<Double> angleArray;
    private List<Length> pointArrayX;
    private List<Length> pointArrayY;
    protected ROI roi;
    protected ROIShape shape;
    private MeasurementUnits units;
    private int status;
    private boolean interactable;
    private boolean allowSplitSegment = true;

    private UnitPoint getPt(int i) {
        Point2D.Double p = this.getPoint(i);
        return new UnitPoint(this.transformX(((Point2D)p).getX()), this.transformY(((Point2D)p).getY()));
    }

    public MeasureLineFigure() {
        this("", false, true, true, true, true);
    }

    public MeasureLineFigure(boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        this("", readOnly, clientObject, editable, deletable, annotatable);
    }

    public MeasureLineFigure(String text, boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        super(text);
        this.setAttribute(MeasurementAttributes.FONT_FACE, DEFAULT_FONT);
        this.setAttribute(MeasurementAttributes.FONT_SIZE, new Double(12.0));
        this.setAttribute(MeasurementAttributes.SCALE_PROPORTIONALLY, Boolean.FALSE);
        this.setAttribute(MeasurementAttributes.START_DECORATION, null);
        this.setAttribute(MeasurementAttributes.END_DECORATION, null);
        this.boundsArray = new ArrayList<Rectangle2D>();
        this.lengthArray = new ArrayList<Length>();
        this.angleArray = new ArrayList<Double>();
        this.pointArrayX = new ArrayList<Length>();
        this.pointArrayY = new ArrayList<Length>();
        this.shape = null;
        this.roi = null;
        this.status = 0;
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
        this.deletable = deletable;
        this.annotatable = annotatable;
        this.editable = editable;
        this.interactable = true;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        this.boundsArray.clear();
        this.lengthArray.clear();
        this.angleArray.clear();
        if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue()) {
            Rectangle2D.Double bounds;
            Double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
            Font font = (Font)this.getAttribute(MeasurementAttributes.FONT_FACE);
            if (font != null) {
                g.setFont(font.deriveFont(sz.floatValue()));
            } else {
                g.setFont(new Font("sans-serif", 0, sz.intValue()));
            }
            g.setColor((Color)MeasurementAttributes.STROKE_COLOR.get(this));
            if (this.getPointCount() == 2) {
                double angle = this.getAngle(0, 1);
                if (angle > 90.0) {
                    angle = Math.abs(angle - 180.0);
                }
                this.angleArray.add(angle);
                String lineAngle = this.addDegrees(UIUtilities.twoDecimalPlaces(angle));
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineAngle, g);
                Point2D.Double lengthPoint = this.getLengthPosition(0, 1);
                bounds = new Rectangle2D.Double(lengthPoint.x, lengthPoint.y + rect.getHeight() * 2.0, rect.getWidth(), rect.getHeight());
                g.drawString(lineAngle, (int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY());
                this.boundsArray.add(bounds);
            }
            for (int x = 1; x < this.getPointCount() - 1; ++x) {
                double angle = this.getAngle(x - 1, x, x + 1);
                this.angleArray.add(angle);
                String lineAngle = this.addDegrees(UIUtilities.twoDecimalPlaces(angle));
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineAngle, g);
                bounds = new Rectangle2D.Double(this.getPoint((int)x).x, this.getPoint((int)x).y, rect.getWidth(), rect.getHeight());
                g.drawString(lineAngle, (int)((RectangularShape)bounds).getX(), (int)((RectangularShape)bounds).getY());
                this.boundsArray.add(bounds);
            }
            double total = 0.0;
            int n = this.getPointCount();
            String v = "";
            DecimalFormat formatter = new DecimalFormat("###.#");
            for (int x = 1; x < n; ++x) {
                Length length = this.getLength(x - 1, x);
                this.lengthArray.add(length);
                String lineLength = UIUtilities.formatValue(length);
                Point2D.Double lengthPoint = this.getLengthPosition(x - 1, x);
                Rectangle2D rect = g.getFontMetrics().getStringBounds(lineLength, g);
                Rectangle2D.Double bounds2 = new Rectangle2D.Double(lengthPoint.x - 15.0, lengthPoint.y - 15.0, rect.getWidth() + 30.0, rect.getHeight() + 30.0);
                int px = (int)lengthPoint.x;
                int py = (int)lengthPoint.y;
                g.drawString(lineLength, px, py);
                this.boundsArray.add(bounds2);
                total += length.getValue();
                v = v + formatter.format(length.getValue());
                if (x == n - 1) continue;
                v = v + "+";
            }
            v = v + "=" + formatter.format(total);
            v = v + LengthI.lookupSymbol((UnitsLength)this.getUnit());
            if (n > 2) {
                List<Point> l = this.getPoints();
                Iterator<Point> j = l.iterator();
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int yLoc = 0;
                while (j.hasNext()) {
                    Point p = j.next();
                    if (minX > p.x) {
                        minX = p.x;
                    }
                    if (maxX < p.x) {
                        maxX = p.x;
                    }
                    if (yLoc >= p.y) continue;
                    yLoc = p.y;
                }
                Rectangle2D b = g.getFontMetrics().getStringBounds(v, g);
                g.drawString(v, minX, (int)((double)yLoc + b.getHeight()));
            }
        }
        if (MeasurementAttributes.SHOWID.get(this).booleanValue()) {
            g.setColor(this.getTextColor());
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.getROI().getID() + "", g);
            bounds = new Rectangle2D.Double(this.path.getCenter().getX() - bounds.getWidth() / 2.0, this.path.getCenter().getY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight());
            g.drawString(this.getROI().getID() + "", (int)bounds.getX(), (int)bounds.getY());
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (!this.readOnly && this.interactable) {
            super.transform(tx);
            this.setObjectDirty(true);
        }
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly && this.interactable) {
            super.setBounds(anchor, lead);
            this.setObjectDirty(true);
        }
    }

    public List<Length> getLengthArray() {
        return this.lengthArray;
    }

    public List<Double> getAngleArray() {
        return this.angleArray;
    }

    public String addDegrees(String str) {
        if (str == null) {
            str = "0";
        }
        return str + "\u00b0";
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.boundsArray != null) {
            for (int i = 0; i < this.boundsArray.size(); ++i) {
                double diff;
                Rectangle2D bounds = this.boundsArray.get(i);
                if (newBounds.getX() > bounds.getX()) {
                    diff = newBounds.x - bounds.getX();
                    newBounds.x = bounds.getX();
                    newBounds.width += diff;
                }
                if (newBounds.getY() > bounds.getY()) {
                    diff = newBounds.y - bounds.getY();
                    newBounds.y = bounds.getY();
                    newBounds.height += diff;
                }
                if (bounds.getX() + bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                    diff = bounds.getX() + bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                    newBounds.width += diff;
                }
                if (!(bounds.getY() + bounds.getHeight() > newBounds.getY() + newBounds.getHeight())) continue;
                diff = bounds.getY() + bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public Point2D.Double getLengthPosition(int i, int j) {
        Point2D.Double p0 = this.getPoint(i);
        Point2D.Double p1 = this.getPoint(j);
        double lx = (p0.x - p1.x) / 2.0;
        double ly = (p0.y - p1.y) / 2.0;
        double x = p0.x - lx;
        double y = p0.y - ly;
        return new Point2D.Double(x, y);
    }

    public Length getLength(int i, int j) {
        UnitPoint pt1 = this.getPt(i);
        UnitPoint pt2 = this.getPt(j);
        return pt1.getDistance(pt2);
    }

    public double getAngle(int i, int j, int k) {
        Point2D p0 = this.getPt(i).getValue();
        Point2D p1 = this.getPt(j).getValue();
        Point2D p2 = this.getPt(k).getValue();
        Point2D.Double v0 = new Point2D.Double(p0.getX() - p1.getX(), p0.getY() - p1.getY());
        Point2D.Double v1 = new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        return Math.toDegrees(Math.acos(this.dotProd(v0, v1)));
    }

    public double getAngle(int i, int j) {
        Point2D p0 = this.getPt(i).getValue();
        Point2D p1 = this.getPt(j).getValue();
        Point2D.Double v0 = new Point2D.Double(p0.getX() - p1.getX(), p0.getY() - p1.getY());
        Point2D.Double v1 = new Point2D.Double(1.0, 0.0);
        return Math.toDegrees(Math.acos(this.dotProd(v0, v1)));
    }

    public double dotProd(Point2D p0, Point2D p1) {
        double adotb = p0.getX() * p1.getX() + p0.getY() * p1.getY();
        double normab = Math.sqrt(p0.getX() * p0.getX() + p0.getY() * p0.getY()) * Math.sqrt(p1.getX() * p1.getX() + p1.getY() * p1.getY());
        return adotb / normab;
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        this.pointArrayX.clear();
        this.pointArrayY.clear();
        this.lengthArray.clear();
        this.angleArray.clear();
        for (int i = 0; i < this.getPointCount(); ++i) {
            UnitPoint pt = this.getPt(i);
            this.pointArrayX.add(pt.x);
            this.pointArrayY.add(pt.y);
        }
        if (this.getPointCount() == 2) {
            double angle = this.getAngle(0, 1);
            if (angle > 90.0) {
                angle = Math.abs(angle - 180.0);
            }
            this.angleArray.add(angle);
            this.lengthArray.add(this.getLength(0, 1));
        } else {
            int x;
            for (x = 1; x < this.getPointCount() - 1; ++x) {
                this.angleArray.add(this.getAngle(x - 1, x, x + 1));
            }
            for (x = 1; x < this.getPointCount(); ++x) {
                this.lengthArray.add(this.getLength(x - 1, x));
            }
        }
        AnnotationKeys.ANGLE.set(this.shape, this.angleArray);
        AnnotationKeys.LENGTH.set(this.shape, this.lengthArray);
        AnnotationKeys.STARTPOINTX.set(this.shape, this.getPt((int)0).x);
        AnnotationKeys.STARTPOINTY.set(this.shape, this.getPt((int)0).y);
        AnnotationKeys.ENDPOINTX.set(this.shape, this.getPt((int)(this.getPointCount() - 1)).x);
        AnnotationKeys.ENDPOINTY.set(this.shape, this.getPt((int)(this.getPointCount() - 1)).y);
        AnnotationKeys.POINTARRAYX.set(this.shape, this.pointArrayX);
        AnnotationKeys.POINTARRAYY.set(this.shape, this.pointArrayY);
    }

    @Override
    public String getType() {
        return "Line";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        ArrayList<Point> vector = new ArrayList<Point>();
        for (int i = 0; i < this.getNodeCount() - 1; ++i) {
            this.iterateLine((Line2D)new Line2D.Double(this.getPoint(i), this.getPoint(i + 1)), vector);
        }
        return vector;
    }

    @Override
    public int getSize() {
        int total = 0;
        for (int i = 0; i < this.getNodeCount() - 1; ++i) {
            this.iterateLine((Line2D)new Line2D.Double(this.getPoint(i), this.getPoint(i + 1)), total);
        }
        return total;
    }

    private void iterateLine(Line2D line, List<Point> vector) {
        Point2D start = line.getP1();
        Point2D end = line.getP2();
        Point2D.Double m = new Point2D.Double(end.getX() - start.getX(), end.getY() - start.getY());
        double lengthM = Math.sqrt(((Point2D)m).getX() * ((Point2D)m).getX() + ((Point2D)m).getY() * ((Point2D)m).getY());
        Point2D.Double mNorm = new Point2D.Double(((Point2D)m).getX() / lengthM, ((Point2D)m).getY() / lengthM);
        LinkedHashMap<Point2D.Double, Boolean> map = new LinkedHashMap<Point2D.Double, Boolean>();
        for (double i = 0.0; i < lengthM; i += 0.1) {
            Point2D pt = new Point2D.Double(start.getX() + i * ((Point2D)mNorm).getX(), start.getY() + i * ((Point2D)mNorm).getY());
            Point2D.Double quantisedPoint = new Point2D.Double(Math.floor(pt.getX()), Math.floor(pt.getY()));
            if (map.containsKey(quantisedPoint)) continue;
            map.put(quantisedPoint, true);
        }
        for (Point2D pt : map.keySet()) {
            vector.add(new Point((int)pt.getX(), (int)pt.getY()));
        }
    }

    private void iterateLine(Line2D line, int total) {
        Point2D start = line.getP1();
        Point2D end = line.getP2();
        Point2D.Double m = new Point2D.Double(end.getX() - start.getX(), end.getY() - start.getY());
        double lengthM = Math.sqrt(((Point2D)m).getX() * ((Point2D)m).getX() + ((Point2D)m).getY() * ((Point2D)m).getY());
        Point2D.Double mNorm = new Point2D.Double(((Point2D)m).getX() / lengthM, ((Point2D)m).getY() / lengthM);
        HashMap<Point2D.Double, Boolean> map = new HashMap<Point2D.Double, Boolean>();
        for (double i = 0.0; i < lengthM; i += 0.1) {
            Point2D.Double pt = new Point2D.Double(start.getX() + i * ((Point2D)mNorm).getX(), start.getY() + i * ((Point2D)mNorm).getY());
            Point2D.Double quantisedPoint = new Point2D.Double(Math.floor(((Point2D)pt).getX()), Math.floor(((Point2D)pt).getY()));
            if (map.containsKey(quantisedPoint)) continue;
            map.put(quantisedPoint, true);
        }
        total += map.size();
    }

    @Override
    public void removeAllNodes() {
        super.removeAllNodes();
        this.setObjectDirty(true);
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureLineFigure clone() {
        MeasureLineFigure that = (MeasureLineFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        that.setInteractable(true);
        return that;
    }

    @Override
    public void setClosed(boolean newValue) {
        super.setClosed(newValue);
        this.setObjectDirty(true);
    }

    @Override
    public void setBezierPath(BezierPath newValue) {
        if (this.isReadOnly() || !this.interactable) {
            return;
        }
        super.setBezierPath(newValue);
        this.setObjectDirty(true);
    }

    @Override
    public void setEndPoint(Point2D.Double p) {
        if (this.isReadOnly() || !this.interactable) {
            return;
        }
        super.setEndPoint(p);
        this.setObjectDirty(true);
    }

    @Override
    public void setNode(int index, BezierPath.Node p) {
        if (this.isReadOnly() || !this.interactable) {
            return;
        }
        super.setNode(index, p);
        this.setObjectDirty(true);
    }

    @Override
    public void setPoint(int index, int coord, Point2D.Double p) {
        if (this.isReadOnly() || !this.interactable) {
            return;
        }
        super.setPoint(index, coord, p);
        this.setObjectDirty(true);
    }

    @Override
    public void setStartPoint(Point2D.Double p) {
        if (this.isReadOnly() || !this.interactable) {
            return;
        }
        super.setStartPoint(p);
        this.setObjectDirty(true);
    }

    @Override
    public int splitSegment(Point2D.Double split) {
        if (!this.canBeSplit()) {
            return -1;
        }
        this.setObjectDirty(true);
        return super.splitSegment(split);
    }

    @Override
    public int splitSegment(Point2D.Double split, float tolerance) {
        if (!this.canBeSplit()) {
            return -1;
        }
        this.setObjectDirty(true);
        return super.splitSegment(split, tolerance);
    }

    @Override
    public int joinSegments(Point2D.Double join, float tolerance) {
        if (!this.canBeSplit()) {
            return -1;
        }
        this.setObjectDirty(true);
        return super.joinSegments(join, tolerance);
    }

    private boolean canBeSplit() {
        return !this.isReadOnly() && this.interactable && this.allowSplitSegment;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }

    @Override
    public boolean canAnnotate() {
        return this.annotatable;
    }

    @Override
    public boolean canDelete() {
        return this.deletable;
    }

    @Override
    public boolean canEdit() {
        return this.editable;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public boolean canInteract() {
        return this.interactable;
    }

    private Length transformX(double x) {
        return this.transformX((int)x);
    }

    private Length transformY(double y) {
        return this.transformY((int)y);
    }

    private Length transformX(int x) {
        if (this.units.getPixelSizeX() != null) {
            return new LengthI((double)x * this.units.getPixelSizeX().getValue(), this.units.getPixelSizeX().getUnit());
        }
        return new LengthI((double)x, UnitsLength.PIXEL);
    }

    private Length transformY(int y) {
        if (this.units.getPixelSizeY() != null) {
            return new LengthI((double)y * this.units.getPixelSizeY().getValue(), this.units.getPixelSizeY().getUnit());
        }
        return new LengthI((double)y, UnitsLength.PIXEL);
    }

    private UnitsLength getUnit() {
        if (this.units.getPixelSizeX() != null) {
            return this.units.getPixelSizeX().getUnit();
        }
        return UnitsLength.PIXEL;
    }
}

