/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.jhotdraw.draw.FigureListener;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.roi.model.util.UnitPoint;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.RectangleTextFigure;

public class MeasureRectangleFigure
extends RectangleTextFigure
implements ROIFigure {
    private boolean deletable;
    private boolean annotatable;
    private boolean editable;
    protected boolean readOnly;
    protected boolean clientObject;
    protected boolean dirty;
    protected Rectangle2D bounds;
    protected ROI roi;
    protected ROIShape shape;
    protected MeasurementUnits units;
    protected int status;
    private boolean interactable;

    public MeasureRectangleFigure() {
        this("");
    }

    public MeasureRectangleFigure(boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        this("", 0.0, 0.0, 0.0, 0.0, readOnly, clientObject, editable, deletable, annotatable);
    }

    public MeasureRectangleFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0);
    }

    public MeasureRectangleFigure(String text, double x, double y, double width, double height) {
        this(text, x, y, width, height, false, true, true, true, true);
    }

    public MeasureRectangleFigure(double x, double y, double width, double height) {
        this("", x, y, width, height);
    }

    public MeasureRectangleFigure(double x, double y, double width, double height, boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        this("", x, y, width, height, readOnly, clientObject, editable, deletable, annotatable);
    }

    public MeasureRectangleFigure(String text, double x, double y, double width, double height, boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        super(text, x, y, width, height);
        this.setAttributeEnabled(MeasurementAttributes.HEIGHT, true);
        this.setAttributeEnabled(MeasurementAttributes.WIDTH, true);
        this.setAttribute(MeasurementAttributes.WIDTH, width);
        this.setAttribute(MeasurementAttributes.HEIGHT, height);
        this.setAttribute(MeasurementAttributes.FONT_FACE, DEFAULT_FONT);
        this.setAttribute(MeasurementAttributes.FONT_SIZE, new Double(12.0));
        this.setAttribute(MeasurementAttributes.SCALE_PROPORTIONALLY, Boolean.FALSE);
        this.shape = null;
        this.roi = null;
        this.status = 0;
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
        this.deletable = deletable;
        this.annotatable = annotatable;
        this.editable = editable;
        this.interactable = true;
    }

    public Length getMeasurementX() {
        return this.transformX(this.getX());
    }

    public Length getMeasurementY() {
        return this.transformY(this.getY());
    }

    public Length getMeasurementWidth() {
        return this.transformY(this.getWidth());
    }

    public Length getMeasurementHeight() {
        return this.transformY(this.getHeight());
    }

    public double getX() {
        return this.rectangle.getX();
    }

    public double getY() {
        return this.rectangle.getY();
    }

    public double getWidth() {
        return this.rectangle.getWidth();
    }

    public double getHeight() {
        return this.rectangle.getHeight();
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue() || MeasurementAttributes.SHOWID.get(this).booleanValue()) {
            Length a = this.getArea();
            String rectangleArea = UIUtilities.formatValue(a, true);
            Double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
            Font font = (Font)this.getAttribute(MeasurementAttributes.FONT_FACE);
            if (font != null) {
                g.setFont(font.deriveFont(sz.floatValue()));
            } else {
                g.setFont(new Font("sans-serif", 0, sz.intValue()));
            }
            this.bounds = g.getFontMetrics().getStringBounds(rectangleArea, g);
            this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
            if (MeasurementAttributes.SHOWMEASUREMENT.get(this).booleanValue()) {
                g.setColor(MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get(this));
                g.drawString(rectangleArea, (int)this.bounds.getX(), (int)this.bounds.getY());
            }
            if (MeasurementAttributes.SHOWID.get(this).booleanValue()) {
                g.setColor(this.getTextColor());
                this.bounds = g.getFontMetrics().getStringBounds(this.getROI().getID() + "", g);
                this.bounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.bounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.bounds.getHeight() / 2.0, this.bounds.getWidth(), this.bounds.getHeight());
                g.drawString(this.getROI().getID() + "", (int)this.bounds.getX(), (int)this.bounds.getY());
            }
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (!this.readOnly && this.interactable) {
            super.transform(tx);
            this.setObjectDirty(true);
        }
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly && this.interactable) {
            super.setBounds(anchor, lead);
            this.setObjectDirty(true);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.bounds != null) {
            double diff;
            if (newBounds.getX() > this.bounds.getX()) {
                diff = newBounds.x - this.bounds.getX();
                newBounds.x = this.bounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.bounds.getY()) {
                diff = newBounds.y - this.bounds.getY();
                newBounds.y = this.bounds.getY();
                newBounds.height += diff;
            }
            if (this.bounds.getX() + this.bounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.bounds.getX() + this.bounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.bounds.getY() + this.bounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.bounds.getY() + this.bounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public Length getArea() {
        return new LengthI(this.getMeasurementWidth().getValue() * this.getMeasurementHeight().getValue(), this.getUnit());
    }

    public Length getPerimeter() {
        return new LengthI(this.getMeasurementWidth().getValue() * 2.0 + this.getMeasurementHeight().getValue() * 2.0, this.getUnit());
    }

    public UnitPoint getCentre() {
        double cx = this.rectangle.getCenterX();
        double cy = this.rectangle.getCenterY();
        return new UnitPoint(this.transformX(cx), this.transformY(cy));
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        AnnotationKeys.AREA.set(this.shape, this.getArea());
        AnnotationKeys.WIDTH.set(this.shape, this.getMeasurementWidth());
        AnnotationKeys.HEIGHT.set(this.shape, this.getMeasurementHeight());
        AnnotationKeys.PERIMETER.set(this.shape, this.getPerimeter());
        AnnotationKeys.CENTREX.set(this.shape, this.getCentre().x);
        AnnotationKeys.CENTREY.set(this.shape, this.getCentre().y);
    }

    @Override
    public String getType() {
        return "Rectangle";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        Rectangle r = this.rectangle.getBounds();
        ArrayList<Point> vector = new ArrayList<Point>(r.height * r.width);
        int xEnd = r.x + r.width;
        int yEnd = r.y + r.height;
        for (int y = r.y; y < yEnd; ++y) {
            for (int x = r.x; x < xEnd; ++x) {
                if (!this.rectangle.contains(x, y)) continue;
                vector.add(new Point(x, y));
            }
        }
        return vector;
    }

    @Override
    public int getSize() {
        Rectangle r = this.rectangle.getBounds();
        int total = 0;
        int xEnd = r.x + r.width;
        int yEnd = r.y + r.height;
        for (int y = r.y; y < yEnd; ++y) {
            for (int x = r.x; x < xEnd; ++x) {
                if (!this.rectangle.contains(x, y)) continue;
                ++total;
            }
        }
        return total;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureRectangleFigure clone() {
        MeasureRectangleFigure that = (MeasureRectangleFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        that.setInteractable(true);
        return that;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }

    @Override
    public boolean canAnnotate() {
        return this.annotatable;
    }

    @Override
    public boolean canDelete() {
        return this.deletable;
    }

    @Override
    public boolean canEdit() {
        return this.editable;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public boolean canInteract() {
        return this.interactable;
    }

    private Length transformX(double x) {
        return this.transformX((int)x);
    }

    private Length transformY(double y) {
        return this.transformY((int)y);
    }

    private Length transformX(int x) {
        if (this.units.getPixelSizeX() != null) {
            return new LengthI((double)x * this.units.getPixelSizeX().getValue(), this.units.getPixelSizeX().getUnit());
        }
        return new LengthI((double)x, UnitsLength.PIXEL);
    }

    private Length transformY(int y) {
        if (this.units.getPixelSizeY() != null) {
            return new LengthI((double)y * this.units.getPixelSizeY().getValue(), this.units.getPixelSizeY().getUnit());
        }
        return new LengthI((double)y, UnitsLength.PIXEL);
    }

    private UnitsLength getUnit() {
        if (this.units.getPixelSizeX() != null) {
            return this.units.getPixelSizeX().getUnit();
        }
        return UnitsLength.PIXEL;
    }
}

