/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.TextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;

public class MeasureTextFigure
extends TextFigure
implements ROIFigure {
    private boolean deletable;
    private boolean annotatable;
    private boolean editable;
    private boolean readOnly;
    private boolean clientObject;
    private boolean dirty;
    protected Rectangle2D bounds;
    protected ROI roi;
    protected ROIShape shape;
    private boolean interactable;
    private int status;

    public MeasureTextFigure() {
        this(0.0, 0.0);
    }

    public MeasureTextFigure(boolean readOnly, boolean clientObject) {
        this(0.0, 0.0, readOnly, clientObject, true, true, true);
    }

    public MeasureTextFigure(boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        this(0.0, 0.0, readOnly, clientObject, true, true, true);
    }

    public MeasureTextFigure(double x, double y) {
        this(x, y, false, true, true, true, true);
    }

    public MeasureTextFigure(double x, double y, boolean readOnly, boolean clientObject, boolean editable, boolean deletable, boolean annotatable) {
        this.setAttribute(MeasurementAttributes.FONT_FACE, ROIFigure.DEFAULT_FONT);
        this.setAttribute(MeasurementAttributes.FONT_SIZE, new Double(12.0));
        this.willChange();
        this.changed();
        this.shape = null;
        this.roi = null;
        this.status = 0;
        this.setReadOnly(readOnly);
        this.setClientObject(clientObject);
        this.deletable = deletable;
        this.annotatable = annotatable;
        this.editable = editable;
        this.interactable = true;
        this.setBounds(new Point2D.Double(x, y), new Point2D.Double(x, y));
    }

    @Override
    public void transform(AffineTransform tx) {
        if (!this.readOnly && this.interactable) {
            super.transform(tx);
            this.setObjectDirty(true);
        }
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (!this.readOnly && this.interactable) {
            super.setBounds(anchor, lead);
            this.setObjectDirty(true);
        }
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public String getType() {
        return "Text";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
    }

    @Override
    public void calculateMeasurements() {
    }

    @Override
    public List<Point> getPoints() {
        return null;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setEditable(!readOnly);
    }

    @Override
    public boolean isClientObject() {
        return this.clientObject;
    }

    @Override
    public void setClientObject(boolean clientSide) {
        this.clientObject = clientSide;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setObjectDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public MeasureTextFigure clone() {
        MeasureTextFigure that = (MeasureTextFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        that.setInteractable(true);
        return that;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setObjectDirty(true);
    }

    @Override
    protected void drawText(Graphics2D g) {
        if (this.getText() != null) {
            g.setColor((Color)MeasurementAttributes.STROKE_COLOR.get(this));
            super.drawText(g);
        }
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }

    @Override
    public boolean canAnnotate() {
        return this.annotatable;
    }

    @Override
    public boolean canDelete() {
        return this.deletable;
    }

    @Override
    public boolean canEdit() {
        return this.editable;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public boolean canInteract() {
        return this.interactable;
    }
}

