/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import omero.gateway.model.FolderData;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.attachment.Attachment;
import org.openmicroscopy.shoola.util.roi.model.attachment.AttachmentKey;
import org.openmicroscopy.shoola.util.roi.model.attachment.AttachmentMap;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

public class ROI {
    static final int DEFAULTMAPSIZE = 101;
    private long id;
    private boolean deletable;
    private boolean annotatable;
    private boolean editable;
    private boolean clientSide;
    private TreeMap<Coord3D, ROIShape> roiShapes;
    private AttachmentMap attachments;
    private Map<AnnotationKey, Object> annotations = new HashMap<AnnotationKey, Object>();
    private Collection<FolderData> folders = new ArrayList<FolderData>();
    private Set<AnnotationKey> forbiddenAnnotations;
    private long ownerID;
    private String uuid;

    private void init(long id, boolean clientSide, boolean editable, boolean deletable, boolean annotatable) {
        this.ownerID = -1L;
        this.id = id;
        this.clientSide = clientSide;
        this.deletable = deletable;
        this.annotatable = annotatable;
        this.editable = editable;
        this.roiShapes = new TreeMap(new Coord3D());
        this.attachments = new AttachmentMap();
        this.uuid = UUID.randomUUID().toString();
    }

    public String getUUID() {
        return this.uuid;
    }

    public ROI(long id, boolean clientSide, boolean editable, boolean deletable, boolean annotatable) {
        this.init(id, clientSide, editable, deletable, annotatable);
    }

    public ROI(long id, boolean clientSide, Coord3D coord, ROIShape shape, boolean editable, boolean deletable, boolean annotatable) {
        this.init(id, clientSide, editable, deletable, annotatable);
        this.roiShapes.put(coord, shape);
    }

    public void addAttachment(AttachmentKey key, Attachment attachment) {
        this.attachments.addAttachment(key, attachment);
    }

    public Attachment getAttachment(AttachmentKey key) {
        return this.attachments.getAttachment(key);
    }

    public AttachmentMap getAttachmentMap() {
        return this.attachments;
    }

    public long getID() {
        return this.id;
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public String getTRange() {
        Coord3D low = this.roiShapes.firstKey();
        Coord3D high = this.roiShapes.lastKey();
        int s = low.getTimePoint();
        int e = high.getTimePoint();
        if (s < 0 || e < 0) {
            return "";
        }
        if (++s == ++e) {
            return "" + s;
        }
        return s + "-" + e;
    }

    public String getZRange() {
        Coord3D low = this.roiShapes.firstKey();
        Coord3D high = this.roiShapes.lastKey();
        int s = low.getZSection();
        int e = high.getZSection();
        if (s < 0 || e < 0) {
            return "";
        }
        if (++s == ++e) {
            return "" + s;
        }
        return s + "-" + e;
    }

    public String getShapeTypes() {
        String type;
        HashMap<String, Integer> shapeTypes = new HashMap<String, Integer>();
        for (ROIShape shape : this.roiShapes.values()) {
            type = shape.getFigure().getType();
            if (shapeTypes.containsKey(type)) {
                int value = (Integer)shapeTypes.get(type) + 1;
                shapeTypes.put(type, value);
                continue;
            }
            shapeTypes.put(type, 1);
        }
        Iterator typeIterator = shapeTypes.keySet().iterator();
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        while (typeIterator.hasNext()) {
            type = (String)typeIterator.next();
            if (!first) {
                buffer.append(",");
                first = false;
            }
            buffer.append(type);
        }
        return buffer.toString();
    }

    public boolean isVisible() {
        boolean visible = false;
        for (ROIShape shape : this.roiShapes.values()) {
            visible |= shape.getFigure().isVisible();
        }
        return visible;
    }

    public boolean containsShape(Coord3D coord) {
        return this.roiShapes.containsKey(coord);
    }

    public boolean containsShape(Coord3D start, Coord3D end) {
        for (int t = start.getTimePoint(); t < end.getTimePoint(); ++t) {
            for (int z = start.getZSection(); z < end.getZSection(); ++z) {
                if (this.roiShapes.containsKey(new Coord3D(z, t))) continue;
                return false;
            }
        }
        return true;
    }

    public TreeMap<Coord3D, ROIShape> getShapes() {
        return this.roiShapes;
    }

    public ROIShape getShape(Coord3D coord) throws NoSuchROIException {
        if (!this.roiShapes.containsKey(coord)) {
            throw new NoSuchROIException("ROI " + this.id + " does not contain ROIShape on Coord " + coord.toString());
        }
        return this.roiShapes.get(coord);
    }

    public ROIFigure getFigure(Coord3D coord) throws NoSuchROIException {
        if (!this.roiShapes.containsKey(coord)) {
            throw new NoSuchROIException("ROI " + this.id + " does not contain ROIShape on Coord " + coord.toString());
        }
        return this.getShape(coord).getFigure();
    }

    public List<ROIFigure> getAllFigures() {
        ArrayList<ROIFigure> figures = new ArrayList<ROIFigure>();
        Collection<ROIShape> set = this.roiShapes.values();
        Iterator<ROIShape> i = set.iterator();
        while (i.hasNext()) {
            figures.add(i.next().getFigure());
        }
        return figures;
    }

    public void addShape(ROIShape shape) throws ROICreationException {
        if (this.roiShapes.containsKey(shape.getCoord3D())) {
            throw new ROICreationException();
        }
        this.roiShapes.put(shape.getCoord3D(), shape);
    }

    public void deleteShape(Coord3D coord) throws NoSuchROIException {
        if (!this.roiShapes.containsKey(coord)) {
            throw new NoSuchROIException("ROI " + this.id + " does not contain ROIShape on Coord " + coord.toString());
        }
        this.roiShapes.remove(coord);
    }

    public void setAnnotation(AnnotationKey key, Object newValue) {
        if (this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key)) {
            Object oldValue = this.annotations.get(key);
            if (!this.annotations.containsKey(key) || oldValue != newValue || oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                this.basicSetAnnotation(key, newValue);
            }
        }
    }

    public void setAnnotationEnabled(AnnotationKey key, boolean b) {
        if (this.forbiddenAnnotations == null) {
            this.forbiddenAnnotations = new HashSet<AnnotationKey>();
        }
        if (b) {
            this.forbiddenAnnotations.remove(key);
        } else {
            this.forbiddenAnnotations.add(key);
        }
    }

    public boolean isAnnotationEnabled(AnnotationKey key) {
        return this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key);
    }

    public void basicSetAnnotations(Map<AnnotationKey, Object> map) {
        for (Map.Entry<AnnotationKey, Object> entry : map.entrySet()) {
            this.basicSetAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public void setAnnotations(Map<AnnotationKey, Object> map) {
        for (Map.Entry<AnnotationKey, Object> entry : map.entrySet()) {
            this.setAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public Map<AnnotationKey, Object> getAnnotation() {
        return new HashMap<AnnotationKey, Object>(this.annotations);
    }

    public void basicSetAnnotation(AnnotationKey key, Object newValue) {
        if (this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key)) {
            this.annotations.put(key, newValue);
        }
    }

    public boolean hasAnnotation(String key) {
        for (AnnotationKey annotationKey : this.annotations.keySet()) {
            if (!annotationKey.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public Object getAnnotation(AnnotationKey key) {
        return this.hasAnnotation(key) ? this.annotations.get(key) : key.getDefaultValue();
    }

    protected AnnotationKey getAnnotationKey(String name) {
        return AnnotationKeys.supportedAnnotationMap.get(name);
    }

    protected void applyAnnotationsTo(ROIShape that) {
        for (Map.Entry<AnnotationKey, Object> entry : this.annotations.entrySet()) {
            that.setAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public void removeAnnotation(AnnotationKey key) {
        if (this.hasAnnotation(key)) {
            this.annotations.remove(key);
        }
    }

    public boolean hasAnnotation(AnnotationKey key) {
        return this.annotations.containsKey(key);
    }

    public void setOwnerID(long ownerID) {
        this.ownerID = ownerID;
    }

    public long getOwnerID() {
        return this.ownerID;
    }

    public boolean canAnnotate() {
        return this.annotatable;
    }

    public boolean canDelete() {
        return this.deletable;
    }

    public boolean canEdit() {
        return this.editable;
    }

    public Collection<FolderData> getFolders() {
        return this.folders;
    }
}

