/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import omero.gateway.model.ShapeData;
import org.jhotdraw.draw.AttributeKey;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

public class ROIShape {
    private ShapeData data;
    private long id;
    private ROI parent;
    private Coord3D coord;
    private Rectangle2D boundingBox;
    private ROIFigure figure;
    private Map<AnnotationKey, Object> annotations = new HashMap<AnnotationKey, Object>();
    private Set<AnnotationKey> forbiddenAnnotations;

    private void copyAttributes(ROIFigure src, ROIFigure dst) {
        Map<AttributeKey, Object> map = src.getAttributes();
        for (Map.Entry<AttributeKey, Object> entry : map.entrySet()) {
            dst.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public ROIShape(ROI parent, Coord3D coord, ROIShape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("No Shape specified.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No ROI specified.");
        }
        ROIFigure src = shape.getFigure();
        if (src == null) {
            throw new IllegalArgumentException("No Figure associated to shape.");
        }
        this.parent = parent;
        this.coord = coord;
        this.boundingBox = (Rectangle2D)shape.getBoundingBox().clone();
        this.figure = (ROIFigure)src.clone();
        this.figure.setROIShape(this);
        this.figure.setROI(parent);
        this.copyAttributes(src, this.figure);
    }

    public ROIShape(ROI parent, Coord3D coord, ROIFigure figure, Rectangle2D boundingBox) {
        if (figure == null) {
            throw new IllegalArgumentException("No Figure specified.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No ROI specified.");
        }
        this.parent = parent;
        this.coord = coord;
        this.figure = figure;
        this.figure.setROIShape(this);
        this.figure.setROI(parent);
        this.boundingBox = boundingBox;
        this.copyAttributes(figure, this.figure);
    }

    public long getROIShapeID() {
        return this.id;
    }

    public void setROIShapeID(long id) {
        this.id = id;
    }

    public ShapeData getData() {
        return this.data;
    }

    public void setData(ShapeData data) {
        this.data = data;
    }

    public long getID() {
        return this.parent.getID();
    }

    public Coord3D getCoord3D() {
        return this.coord;
    }

    public int getZ() {
        return this.coord.getZSection();
    }

    public int getT() {
        return this.coord.getTimePoint();
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public ROIFigure getFigure() {
        return this.figure;
    }

    public ROI getROI() {
        return this.parent;
    }

    public void setAnnotation(AnnotationKey key, Object newValue) {
        if (this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key)) {
            Object oldValue = this.annotations.get(key);
            if (!this.annotations.containsKey(key) || oldValue != newValue || oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                this.basicSetAnnotation(key, newValue);
            }
        }
    }

    public void setAnnotationEnabled(AnnotationKey key, boolean b) {
        if (this.forbiddenAnnotations == null) {
            this.forbiddenAnnotations = new HashSet<AnnotationKey>();
        }
        if (b) {
            this.forbiddenAnnotations.remove(key);
        } else {
            this.forbiddenAnnotations.add(key);
        }
    }

    public boolean isAnnotationEnabled(AnnotationKey key) {
        return this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key);
    }

    public void basicSetAnnotations(Map<AnnotationKey, Object> map) {
        for (Map.Entry<AnnotationKey, Object> entry : map.entrySet()) {
            this.basicSetAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public void setAnnotations(Map<AnnotationKey, Object> map) {
        for (Map.Entry<AnnotationKey, Object> entry : map.entrySet()) {
            this.setAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public Map<AnnotationKey, Object> getAnnotation() {
        return new HashMap<AnnotationKey, Object>(this.annotations);
    }

    public void basicSetAnnotation(AnnotationKey key, Object newValue) {
        if (this.forbiddenAnnotations == null || !this.forbiddenAnnotations.contains(key)) {
            this.annotations.put(key, newValue);
        }
    }

    public Object getAnnotation(AnnotationKey key) {
        return this.hasAnnotation(key) ? this.annotations.get(key) : key.getDefaultValue();
    }

    protected AnnotationKey getAnnotationKey(String name) {
        return AnnotationKeys.supportedAnnotationMap.get(name);
    }

    protected void applyAnnotationsTo(ROIShape that) {
        for (Map.Entry<AnnotationKey, Object> entry : this.annotations.entrySet()) {
            that.setAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public void removeAnnotation(AnnotationKey key) {
        if (this.hasAnnotation(key)) {
            this.annotations.remove(key);
        }
    }

    public boolean hasAnnotation(AnnotationKey key) {
        return this.annotations.containsKey(key);
    }

    public ROIShape copy(Coord3D plane) {
        if (plane == null) {
            plane = this.coord;
        }
        return new ROIShape(this.parent, plane, this.figure, this.boundingBox);
    }
}

