/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;

public class FileTableNode
extends JPanel {
    private static final Dimension SIZE = new Dimension(16, 16);
    private ImportErrorObject failure;
    private JXBusyLabel status;

    private void buildGUI() {
        this.removeAll();
        this.setLayout(new FlowLayout(0));
        this.add((Component)this.status);
        this.add(new JSeparator(1));
        if (this.failure.getFile() != null) {
            this.add(new JLabel(this.failure.getFile().getName()));
        } else {
            this.add(new JLabel("Log File ID:" + this.failure.getLogFileID()));
        }
        this.add(Box.createHorizontalStrut(15));
    }

    FileTableNode(ImportErrorObject failure) {
        if (failure == null) {
            throw new IllegalArgumentException("No Object to send");
        }
        this.failure = failure;
        this.status = new JXBusyLabel(SIZE);
        this.buildGUI();
    }

    public ImportErrorObject getFailure() {
        return this.failure;
    }

    public void setStatus(boolean busy) {
        this.status.setBusy(busy);
        if (!busy) {
            this.status.setText("done");
        }
    }

    @Override
    public void setBackground(Color color) {
        if (this.status != null) {
            this.status.setBackground(color);
        }
        super.setBackground(color);
    }
}

