/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JLabelButton
extends JLabel {
    public static final String SELECTED_PROPERTY = "selected";
    private long actionID;
    private boolean hover = false;

    private void installDefaultListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JLabelButton.this.onMouseReleased();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (JLabelButton.this.hover) {
                    JLabelButton.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (JLabelButton.this.hover) {
                    JLabelButton.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    private void onMouseReleased() {
        this.firePropertyChange(SELECTED_PROPERTY, this.actionID - 1L, this.actionID);
    }

    public JLabelButton(String text) {
        this(text, false);
    }

    public JLabelButton(String text, boolean hover) {
        super(text);
        this.setBorder(null);
        this.actionID = -1L;
        this.hover = hover;
        this.installDefaultListeners();
    }

    public JLabelButton(Icon icon) {
        this(icon, false);
    }

    public JLabelButton(Icon icon, boolean hover) {
        super(icon);
        this.setBorder(null);
        this.actionID = -1L;
        this.hover = hover;
        this.installDefaultListeners();
    }

    public void setActionID(long actionID) {
        this.actionID = actionID;
    }
}

