/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.UIManager;

public class OMEComboBox
extends JComboBox {
    private Color editedColor;
    private Color defaultForeground;
    private int originalIndex;

    private void updateForeground() {
        int index = this.getSelectedIndex();
        if (this.editedColor != null) {
            if (this.originalIndex == index) {
                this.setForeground(this.defaultForeground);
            } else {
                this.setForeground(this.editedColor);
            }
        }
    }

    public OMEComboBox(Object[] values) {
        this(values, null);
    }

    public OMEComboBox(Object[] values, Color editedColor) {
        super(values);
        this.setEditedColor(editedColor);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OMEComboBox.this.updateForeground();
            }
        });
        this.defaultForeground = this.getForeground();
        this.originalIndex = -1;
        this.setFocusable(false);
    }

    public void setEditedColor(Color editedColor) {
        this.editedColor = editedColor;
    }

    @Override
    public void setSelectedItem(Object value) {
        super.setSelectedItem(value);
        if (this.originalIndex == -1) {
            this.originalIndex = this.getSelectedIndex();
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.originalIndex == -1) {
            this.originalIndex = index;
        }
        super.setSelectedIndex(index);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        UIManager.getDefaults().put("ComboBox.disabledBackground", c);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setBackground(this.getBackground());
        super.setEnabled(enabled);
    }
}

