/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExFactory {
    private static final List<Character> SUPPORTED_SPECIAL_CHAR = new ArrayList<Character>();

    public static boolean find(Pattern p, String input) {
        Matcher m = p.matcher(input);
        return m.find();
    }

    public static Pattern createCaseInsensitivePattern(String regEx) {
        return Pattern.compile(regEx, 2);
    }

    public static Pattern createPattern(String regEx) {
        return Pattern.compile(regEx);
    }

    public static String[] formatSearchText(List<String> terms) {
        if (terms == null) {
            return new String[0];
        }
        String[] formattedTerms = new String[terms.size()];
        Iterator<String> i = terms.iterator();
        int j = 0;
        while (i.hasNext()) {
            String value = i.next();
            if (value == null) {
                value = "";
            }
            int n = value.length();
            char[] arr = new char[n];
            String v = "";
            value.getChars(0, n, arr, 0);
            StringBuffer buffer = new StringBuffer();
            for (int k = 0; k < arr.length; ++k) {
                if (SUPPORTED_SPECIAL_CHAR.contains(Character.valueOf(arr[k]))) {
                    buffer.append("\\" + arr[k]);
                    continue;
                }
                buffer.append(arr[k]);
            }
            formattedTerms[j] = buffer.toString();
            ++j;
        }
        return formattedTerms;
    }

    public static String formatSearchTextAsString(List<String> terms) {
        if (terms == null) {
            return "";
        }
        String[] formattedTerms = RegExFactory.formatSearchText(terms);
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < formattedTerms.length; ++i) {
            text.append(formattedTerms[i]);
        }
        return text.toString();
    }

    static {
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('-'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('['));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf(']'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('?'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('+'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('*'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('.'));
    }
}

