/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JMenu;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class SelectableMenu<T>
extends JMenu {
    public static final String GROUP_SELECTION_PROPERTY;
    private static final Icon DEFAULT_SELECTED;
    private static final Icon DEFAULT_DESELECTED;
    private Icon selectedIcon;
    private Icon deselectedIcon;
    private boolean selectable;
    private T object;

    public SelectableMenu(Icon selectedIcon, Icon deselectedIcon, boolean selectable) {
        this(selectedIcon, deselectedIcon, false, "", selectable);
    }

    public SelectableMenu(Icon selectedIcon, Icon deselectedIcon, String text, boolean selectable) {
        this(selectedIcon, deselectedIcon, false, "", selectable);
    }

    public SelectableMenu(Icon selectedIcon, Icon deselectedIcon, boolean selected, boolean selectable) {
        this(selectedIcon, deselectedIcon, selected, "", selectable);
    }

    public SelectableMenu(boolean selected, String text, boolean selectable) {
        this(DEFAULT_SELECTED, DEFAULT_DESELECTED, selected, text, selectable);
    }

    public SelectableMenu(Icon selectedIcon, Icon deselectedIcon, boolean selected, String text, boolean selectable) {
        this.selectedIcon = selectedIcon;
        this.deselectedIcon = deselectedIcon;
        this.setMenuSelected(selected, false);
        this.setText(text);
        this.selectable = selectable;
        if (selectable) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    SelectableMenu.this.setMenuSelected(!SelectableMenu.this.isMenuSelected(), true);
                    SelectableMenu.this.repaint();
                }
            });
        }
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public boolean isMenuSelected() {
        return this.getIcon() == this.selectedIcon;
    }

    public void setMenuSelected(boolean selected, boolean fireProperty) {
        if (selected) {
            this.setIcon(this.selectedIcon);
        } else {
            this.setIcon(this.deselectedIcon);
        }
        if (fireProperty) {
            this.firePropertyChange(GROUP_SELECTION_PROPERTY, null, this);
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    static {
        IconManager icons = IconManager.getInstance();
        DEFAULT_DESELECTED = icons.getIcon(157);
        DEFAULT_SELECTED = icons.getIcon(156);
        GROUP_SELECTION_PROPERTY = "groupSelection";
    }
}

