/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public class TooltipTableHeader
extends JTableHeader {
    private final List<String> toolTips;

    public TooltipTableHeader(TableColumnModel model, List<String> toolTips) {
        super(model);
        if (toolTips == null) {
            throw new IllegalArgumentException("No tool tips specified.");
        }
        this.toolTips = toolTips;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String retStr;
        int col = this.columnAtPoint(e.getPoint());
        JTable table = this.getTable();
        if (table == null) {
            return "";
        }
        int modelCol = this.getTable().convertColumnIndexToModel(col);
        try {
            retStr = this.toolTips.get(modelCol);
        }
        catch (Exception ex) {
            retStr = "";
        }
        if (CommonsLangUtils.isBlank(retStr)) {
            retStr = super.getToolTipText(e);
        }
        return retStr;
    }
}

