/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.FigureUtil;
import org.openmicroscopy.shoola.util.ui.drawingtools.texttools.DrawingTextTool;

public class BezierTextFigure
extends BezierFigure
implements TextHolderFigure {
    private boolean editable;
    private Rectangle2D.Double textBounds;

    public BezierTextFigure(String text) {
        this(text, false);
        this.editable = true;
    }

    public BezierTextFigure(String text, boolean closed) {
        super(closed);
        this.setText(text);
        this.textBounds = null;
        this.editable = true;
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    protected void drawFill(Graphics2D g) {
        super.drawFill(g);
        this.drawText(g);
    }

    @Override
    protected void drawText(Graphics2D g) {
        if (!DrawingAttributes.SHOWTEXT.get(this).booleanValue()) {
            return;
        }
        String text = this.getText();
        if (text != null) {
            double textWidth;
            if ((text = text.trim()).length() == 0) {
                return;
            }
            Rectangle2D.Double r = this.getBounds();
            Font font = AttributeKeys.FONT_FACE.get(this);
            font = font.deriveFont(AttributeKeys.FONT_SIZE.get(this).floatValue());
            FontMetrics fm = g.getFontMetrics(font);
            double width = textWidth = (double)fm.stringWidth(text);
            double avgCharWidth = textWidth / (double)text.length();
            double maxTextWidth = avgCharWidth * 100.0;
            if (textWidth > maxTextWidth) {
                width = maxTextWidth;
            }
            double textHeight = (textWidth / width + 1.0) * (double)(fm.getAscent() + fm.getDescent() + fm.getLeading());
            double x = r.x + r.width / 2.0 - width / 2.0;
            double y = r.y + textHeight / 2.0;
            this.textBounds = new Rectangle2D.Double(x, y, width, textHeight);
            FontRenderContext frc = g.getFontRenderContext();
            AttributedString styledText = new AttributedString(text);
            FigureUtil.formatLayout(font, styledText, this);
            AttributedCharacterIterator i = styledText.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(i, frc);
            Color c = AttributeKeys.STROKE_COLOR.get(this);
            if (c != null) {
                g.setColor(c);
            }
            int w = (int)width;
            while (measurer.getPosition() < text.length()) {
                TextLayout layout = measurer.nextLayout(w);
                layout.draw(g, (float)x, (float)(y += (double)layout.getAscent()));
                y += (double)(layout.getDescent() + layout.getLeading());
            }
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    protected void validate() {
        super.validate();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.add(this.getTextBounds());
        return r;
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        boolean showText = false;
        if (this.isEditable() && this.getBounds().contains(p)) {
            showText = true;
        }
        if (this.path != null && showText) {
            if (!this.isClosed() && this.path.outlineContains(p, 10.0)) {
                showText = false;
            }
            if (this.isClosed() && this.path.outlineContains(p, 3.0)) {
                showText = false;
            }
        }
        if (showText) {
            this.invalidate();
            return new DrawingTextTool(this);
        }
        return null;
    }

    @Override
    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    @Override
    public void setText(String newText) {
        boolean b = newText != null && newText.trim().length() > 0;
        this.setAttribute(DrawingAttributes.SHOWTEXT, b);
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    @Override
    public int getTextColumns() {
        String t = this.getText();
        int n = 4;
        return t == null ? n : Math.max(t.length(), n);
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    @Override
    public Font getFont() {
        return AttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return AttributeKeys.TEXT_COLOR.get(this);
    }

    @Override
    public Color getFillColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    @Override
    public float getFontSize() {
        return AttributeKeys.FONT_SIZE.get(this).floatValue();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setFontSize(float size) {
        AttributeKeys.FONT_SIZE.set(this, new Double(size));
    }

    @Override
    public boolean isTextOverflow() {
        return false;
    }

    @Override
    public BezierTextFigure clone() {
        BezierTextFigure that = (BezierTextFigure)super.clone();
        that.setText(this.getText());
        return that;
    }

    @Override
    public BezierPath.Node removeNode(int node) {
        return super.removeNode(node);
    }
}

