/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.CreateFolderDialog;
import org.openmicroscopy.shoola.util.ui.filechooser.CustomizedFileChooser;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

class FileSaverUI
implements ActionListener,
PropertyChangeListener {
    static final String SAVE_AS = "Save the current file in the specified format.";
    static final String LOAD = "Load the current file in the specified format.";
    static final String DOWNLOAD = "Download the current file in the selected folder.";
    static final String IMPORT = "Import the selected files or folders.";
    private static final Dimension H_SPACER_SIZE = new Dimension(3, 10);
    private static final int CANCEL = 0;
    private static final int APPROVE = 1;
    private static final int NEW_FOLDER = 2;
    private FileChooser model;
    private CustomizedFileChooser chooser;
    private JCheckBox settings;
    private JButton cancelButton;
    private JButton approveButton;
    private JButton newFolderButton;
    private JPanel buttonPanel;
    private JPanel controlsPanel;
    private TitlePanel titlePane;

    private void initComponents(boolean accept) {
        this.chooser = new CustomizedFileChooser(this.model, this, accept);
        this.chooser.addPropertyChangeListener(this);
        this.settings = new JCheckBox();
        this.settings.setText("Set the current directory as default.");
        this.settings.setSelected(true);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.newFolderButton = new JButton("New Folder");
        this.newFolderButton.setToolTipText(UIUtilities.formatToolTipText("Create a new folder"));
        this.newFolderButton.addActionListener(this);
        this.newFolderButton.setActionCommand("2");
        this.approveButton = new JButton();
        switch (this.model.getChooserType()) {
            case 1: {
                this.approveButton.setText("Save as");
                this.approveButton.setToolTipText(UIUtilities.formatToolTipText(SAVE_AS));
                break;
            }
            case 0: {
                this.approveButton.setText("Load");
                this.approveButton.setToolTipText(UIUtilities.formatToolTipText(LOAD));
                break;
            }
            case 2: {
                this.approveButton.setText("Download");
                this.approveButton.setToolTipText(UIUtilities.formatToolTipText(DOWNLOAD));
                break;
            }
            case 3: {
                this.approveButton.setText("Import");
                this.approveButton.setToolTipText(UIUtilities.formatToolTipText(IMPORT));
            }
        }
        this.chooser.setApproveButtonText(this.approveButton.getText());
        this.chooser.setApproveButtonToolTipText(this.approveButton.getToolTipText());
        this.approveButton.addActionListener(this);
        this.approveButton.setActionCommand("1");
        this.approveButton.setEnabled(this.model.getChooserType() == 2);
        this.model.getRootPane().setDefaultButton(this.approveButton);
    }

    private void fillControlButtonsPanel(JButton button, int location) {
        this.buttonPanel.removeAll();
        if (button == null) {
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
            this.buttonPanel.add(this.approveButton);
            return;
        }
        switch (location) {
            case 100: {
                this.buttonPanel.add(button);
                this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
                this.buttonPanel.add(this.cancelButton);
                this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
                this.buttonPanel.add(this.approveButton);
                break;
            }
            case 101: {
                this.buttonPanel.add(this.cancelButton);
                this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
                this.buttonPanel.add(button);
                this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
                this.buttonPanel.add(this.approveButton);
                break;
            }
            case 102: {
                this.buttonPanel.add(this.cancelButton);
                this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
                this.buttonPanel.add(this.approveButton);
                this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
                this.buttonPanel.add(button);
            }
        }
    }

    private JPanel buildToolbar() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(null);
        this.fillControlButtonsPanel(null, -1);
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 0));
        int type = this.model.getChooserType();
        if (type != 0 && type != 3) {
            controls.add(Box.createRigidArea(new Dimension(20, 5)));
            controls.add(this.newFolderButton);
        }
        JPanel p = UIUtilities.buildComponentPanelRight(this.buttonPanel);
        p.setOpaque(true);
        controls.add(p);
        return controls;
    }

    private JPanel buildSelectionPane() {
        JPanel p = new JPanel();
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        p.setLayout(new BoxLayout(p, 0));
        p.add(result);
        p.add(UIUtilities.buildComponentPanel(this.settings));
        return p;
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        Icon icon;
        this.controlsPanel = new JPanel();
        this.controlsPanel.setLayout(new BorderLayout(0, 0));
        if (!this.chooser.areControlButtonsShown()) {
            this.controlsPanel.add((Component)this.buildToolbar(), "Center");
        }
        if (this.model.getChooserType() != 2) {
            this.controlsPanel.add((Component)this.buildSelectionPane(), "South");
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)this.controlsPanel, "South");
        IconManager im = IconManager.getInstance();
        switch (this.model.getChooserType()) {
            case 1: {
                icon = im.getIcon(53);
                break;
            }
            case 0: {
                icon = im.getIcon(54);
                break;
            }
            case 2: {
                icon = im.getIcon(30);
                break;
            }
            case 3: {
                icon = im.getIcon(131);
                break;
            }
            default: {
                icon = im.getIcon(53);
            }
        }
        Container c = this.model.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        this.titlePane = new TitlePanel(this.model.getTitle(), this.model.getNote(), icon);
        c.add((Component)((Object)this.titlePane), "North");
        c.add((Component)p, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.model.getRootPane().setWindowDecorationStyle(6);
        }
    }

    FileSaverUI(FileChooser model, boolean accept) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents(accept);
        this.buildGUI();
    }

    void setCurrentDirectory(File directory) {
        this.chooser.setCurrentDirectory(directory);
    }

    void setSelectedFile(File file) {
        this.chooser.setOriginalName(file.getName());
        this.chooser.setSelectedFile(file);
    }

    File getCurrentDirectory() {
        return this.chooser.getCurrentDirectory();
    }

    File getSelectedFile() {
        return this.chooser.getSelectedFile();
    }

    File[] getSelectedFiles() {
        return this.chooser.getSelectedFiles();
    }

    File getFormattedSelectedFile() {
        return this.chooser.getFormattedSelectedFile();
    }

    boolean isSetDefaultFolder() {
        return this.settings.isSelected();
    }

    void setControlsEnabled(boolean b) {
        if (this.approveButton != null && this.model.getChooserType() != 2) {
            this.approveButton.setEnabled(b);
        }
    }

    void setApproveButtonText(String text) {
        if (this.approveButton != null) {
            this.approveButton.setText(text);
        }
        this.chooser.setApproveButtonText(text);
    }

    void setApproveButtonToolTipText(String text) {
        if (this.approveButton != null) {
            this.approveButton.setToolTipText(text);
        }
        this.chooser.setToolTipText(text);
    }

    void addControlButton(JButton button, int location) {
        if (button == null) {
            throw new IllegalArgumentException("Button cannot be null.");
        }
        switch (location) {
            case 100: 
            case 101: 
            case 102: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Location not supported.");
            }
        }
        this.fillControlButtonsPanel(button, location);
        this.buttonPanel.repaint();
    }

    void addComponentToControls(JComponent component) {
        this.controlsPanel.add((Component)component, "North");
    }

    void requestFocusOnName() {
        this.chooser.requestFocusOnName();
    }

    void setTitleIcon(Icon icon) {
        Container c = this.model.getContentPane();
        c.remove((Component)((Object)this.titlePane));
        this.titlePane = new TitlePanel(this.model.getTitle(), this.model.getNote(), icon);
        c.add((Component)((Object)this.titlePane), "North");
        c.repaint();
    }

    FileFilter getSelectedFilter() {
        return this.chooser.getFileFilter();
    }

    void setMultiSelectionEnabled(boolean enabled) {
        this.chooser.setMultiSelectionEnabled(enabled);
    }

    boolean isMultisSelectionEnabled() {
        return this.chooser.isMultiSelectionEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.chooser.cancelSelection();
                break;
            }
            case 1: {
                this.chooser.approveSelection();
                break;
            }
            case 2: {
                CreateFolderDialog d = new CreateFolderDialog(this.model);
                d.addPropertyChangeListener("createFolder", this);
                d.pack();
                UIUtilities.centerAndShow(this.model, d);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("createFolder".equals(propName)) {
            String name = (String)evt.getNewValue();
            this.chooser.createFolder(name);
            this.chooser.rescanCurrentDirectory();
            this.chooser.repaint();
        } else if ("SelectedFileChangedProperty".equals(propName) || "directoryChanged".equals(propName)) {
            File f = (File)evt.getNewValue();
            if (f == null) {
                return;
            }
            this.chooser.resetSelection();
        }
    }
}

