/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

class LensModel {
    static final Color LENS_DARK_COLOUR = new Color(96, 96, 96, 255);
    static final Color LENS_LIGHT_COLOUR = new Color(196, 196, 196, 255);
    static final Color DEFAULT_BACKGROUND = new Color(200, 200, 200);
    static final int MINIMUM_ZOOM = 1;
    static final int MAXIMUM_ZOOM = 10;
    static final int DEFAULT_SIZE = 562500;
    static final long MINHEAPSIZE = 0x800000L;
    private int x;
    private int y;
    private int width;
    private int height;
    private float zoomFactor;
    private float imageZoomFactor;
    private BufferedImage planeImage;
    private DataBuffer zoomedDataBuffer;
    private int zoomedDataBufferSize;
    private Color background;
    private String imageName;

    private void flushDataBuffer() {
        this.zoomedDataBuffer = null;
    }

    private WritableRaster getZoomedRaster(int dataBufferType, ColorModel colorModel, int w, int h) {
        double f = this.zoomFactor * this.zoomFactor;
        switch (dataBufferType) {
            case 3: {
                if (!(this.zoomedDataBuffer instanceof DataBufferByte)) break;
                this.flushDataBuffer();
                break;
            }
            case 0: {
                if (!(this.zoomedDataBuffer instanceof DataBufferInt)) break;
                this.flushDataBuffer();
            }
        }
        if ((double)this.zoomedDataBufferSize < (double)(this.height * this.width) * f) {
            this.flushDataBuffer();
            switch (dataBufferType) {
                case 3: {
                    this.zoomedDataBuffer = new DataBufferInt((int)(22500.0 * f), 1);
                    break;
                }
                case 0: {
                    this.zoomedDataBuffer = new DataBufferByte((int)(22500.0 * f), 1);
                }
            }
        } else if (this.zoomedDataBuffer != null && this.zoomedDataBuffer.getSize() != 562500) {
            this.flushDataBuffer();
        }
        if (this.zoomedDataBuffer == null) {
            switch (dataBufferType) {
                case 3: {
                    this.zoomedDataBuffer = new DataBufferInt(562500, 1);
                    break;
                }
                case 0: {
                    this.zoomedDataBuffer = new DataBufferByte(562500, 1);
                }
            }
        }
        if (dataBufferType == 0 && this.zoomedDataBuffer.getSize() < w * h * 3) {
            this.zoomedDataBuffer = new DataBufferByte(w * h * 3, 1);
        }
        SampleModel sm = colorModel.createCompatibleSampleModel(w, h);
        return Raster.createWritableRaster(sm, this.zoomedDataBuffer, null);
    }

    private BufferedImage scaleBufferedImage(BufferedImage image, float xScale, float yScale) {
        int thumbHeight = (int)((float)image.getHeight() * yScale);
        int thumbWidth = (int)((float)image.getWidth() * xScale);
        ColorModel cm = image.getColorModel();
        int type = image.getData().getDataBuffer().getDataType();
        WritableRaster r = this.getZoomedRaster(type, cm, thumbWidth, thumbHeight);
        BufferedImage thumbImage = new BufferedImage(cm, r, false, null);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        graphics2D.dispose();
        return thumbImage;
    }

    LensModel(BufferedImage planeImage) {
        this.planeImage = planeImage;
        this.x = 0;
        this.y = 0;
        this.width = 50;
        this.height = 50;
        this.setBackgroundColor(DEFAULT_BACKGROUND);
        this.zoomedDataBufferSize = 562500;
    }

    void setPlaneImage(BufferedImage img) {
        this.planeImage = img;
    }

    int getImageWidth() {
        if (this.planeImage != null) {
            return this.planeImage.getWidth();
        }
        return 0;
    }

    int getImageScaledWidth() {
        return (int)((float)this.getImageWidth() * this.imageZoomFactor);
    }

    int getImageScaledHeight() {
        return (int)((float)this.getImageHeight() * this.imageZoomFactor);
    }

    int getImageHeight() {
        if (this.planeImage != null) {
            return this.planeImage.getHeight();
        }
        return 0;
    }

    BufferedImage getZoomedImage() {
        try {
            if (this.planeImage == null) {
                return null;
            }
            ColorModel cm = this.planeImage.getColorModel();
            Raster raster = this.planeImage.getData();
            Raster r = raster.createChild(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0, 0, null);
            BufferedImage img = new BufferedImage(cm, (WritableRaster)r, false, null);
            return this.scaleBufferedImage(img, this.zoomFactor, this.zoomFactor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    BufferedImage createZoomedImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        ColorModel cm = image.getColorModel();
        Raster r = image.getData().createChild(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0, 0, null);
        BufferedImage img = new BufferedImage(cm, (WritableRaster)r, false, null);
        int thumbHeight = (int)((float)img.getHeight() * this.zoomFactor);
        int thumbWidth = (int)((float)img.getWidth() * this.zoomFactor);
        int type = image.getData().getDataBuffer().getDataType();
        WritableRaster wr = this.getZoomedRaster(type, cm, thumbWidth, thumbHeight);
        BufferedImage thumbImage = new BufferedImage(img.getColorModel(), wr, false, null);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.drawImage(img, 0, 0, thumbWidth, thumbHeight, null);
        graphics2D.dispose();
        return thumbImage;
    }

    int getHeight() {
        return this.height;
    }

    int getWidth() {
        return this.width;
    }

    int getScaledHeight() {
        return (int)Math.ceil((float)this.height * this.imageZoomFactor);
    }

    int getScaledWidth() {
        return (int)Math.ceil((float)this.width * this.imageZoomFactor);
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getScaledX() {
        return (int)((float)this.x * this.imageZoomFactor);
    }

    int getScaledY() {
        return (int)((float)this.y * this.imageZoomFactor);
    }

    void setHeight(int height) {
        this.height = height;
    }

    void setWidth(int width) {
        this.width = width;
    }

    void setLensLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    float getZoomFactor() {
        return this.zoomFactor;
    }

    void setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    void setImageZoomFactor(float imageZoomFactor) {
        this.imageZoomFactor = imageZoomFactor;
    }

    float getImageZoomFactor() {
        return this.imageZoomFactor;
    }

    Dimension getLensScaledSize() {
        return new Dimension(this.getScaledWidth(), this.getScaledHeight());
    }

    Point getLensScaledLocation() {
        return new Point(this.getScaledX(), this.getScaledY());
    }

    Point getLensLocation() {
        return new Point(this.getX(), this.getY());
    }

    Rectangle getLensScaledBounds() {
        Point p = this.getLensScaledLocation();
        Dimension d = this.getLensScaledSize();
        return new Rectangle(p.x, p.y, d.width, d.height);
    }

    Color getLensPreferredColour() {
        return LENS_LIGHT_COLOUR;
    }

    void resetDataBuffer() {
        this.zoomedDataBuffer = null;
        this.zoomedDataBufferSize = 562500;
    }

    Color getBackgroundColor() {
        return this.background;
    }

    void setBackgroundColor(Color color) {
        if (color == null) {
            this.background = DEFAULT_BACKGROUND;
        }
        this.background = color;
    }

    void setImageName(String imageName) {
        this.imageName = imageName;
    }

    String getImageName() {
        return this.imageName;
    }
}

