/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JProgressBar;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogin;

public class ScreenLogo
extends JFrame {
    public static final String MOVE_FRONT_PROPERTY = "moveFront";
    private static final int GAP = 5;
    private static final int TEXT_INDENT = 15;
    private JLayeredPane layers;
    private JLabel currentTask;
    private JProgressBar progressBar;

    private void initComponents() {
        this.currentTask = new JLabel();
        Font newFont = this.currentTask.getFont().deriveFont(8);
        this.currentTask.setFont(newFont);
        this.currentTask.setForeground(ScreenLogin.TEXT_COLOR);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(false);
        this.progressBar.setFont(newFont);
    }

    private void buildGUI(Icon logo) {
        JLabel splash = new JLabel(logo);
        this.layers = new JLayeredPane();
        this.layers.add((Component)splash, (Object)0);
        this.getContentPane().add(this.layers);
        int width = logo.getIconWidth();
        int height = logo.getIconHeight();
        this.layers.setBounds(0, 0, width, height);
        splash.setBounds(0, 0, width, height);
        int h = this.progressBar.getFontMetrics(this.progressBar.getFont()).getHeight();
        this.currentTask.setBounds(15, height - 3 * h, width, h);
        this.progressBar.setBounds(0, height - 2 * h, width, h);
        this.addToLayer(this.currentTask);
        this.addToLayer(this.progressBar);
    }

    private void setProperties(Image frameIcon) {
        this.setIconImage(frameIcon);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setUndecorated(true);
        this.toFront();
    }

    public ScreenLogo(String title, Icon logo, Image frameIcon) {
        super(title);
        if (logo == null) {
            throw new NullPointerException("No Frame icon.");
        }
        this.initComponents();
        Dimension d = new Dimension(logo.getIconWidth(), logo.getIconHeight());
        this.setSize(d);
        this.setPreferredSize(d);
        this.buildGUI(logo);
        this.setProperties(frameIcon);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScreenLogo.this.firePropertyChange(ScreenLogo.MOVE_FRONT_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
        });
    }

    public ScreenLogo(Icon logo, Image frameIcon) {
        this(null, logo, frameIcon);
    }

    public void initProgressBar(int maxTask) {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(maxTask);
        this.progressBar.setValue(0);
    }

    public void addToLayer(JComponent c) {
        if (c == null) {
            return;
        }
        this.layers.add((Component)c, (Object)1);
    }

    public Dimension getExtendedSize() {
        Dimension d = this.getSize();
        return new Dimension(d.width, d.height + 5);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void setStatus(String value, int perc) {
        this.currentTask.setText(value);
        this.progressBar.setValue(perc);
    }

    public void setStatusVisible(boolean b) {
        this.currentTask.setVisible(b);
        this.progressBar.setVisible(b);
    }
}

