/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSliderModel;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSliderUI;

public class TwoKnobsSlider
extends JPanel {
    public static final int DEFAULT_MIN = 0;
    public static final int DEFAULT_MAX = 100;
    public static final String KNOB_RELEASED_PROPERTY = "knobReleased";
    public static final String LEFT_MOVED_PROPERTY = "leftMoved";
    public static final String RIGHT_MOVED_PROPERTY = "rightMoved";
    public static final String START_VALUE_PROPERTY = "startValue";
    public static final String END_VALUE_PROPERTY = "endValue";
    public static final String MAX_VALUE_PROPERTY = "maxValue";
    public static final String MIN_VALUE_PROPERTY = "minValue";
    public static final String SET_VALUES_PROPERTY = "setValues";
    public static final int HORIZONTAL = 100;
    public static final int VERTICAL = 101;
    public static final int INITIAL = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    protected static final Dimension MIN_HORIZONTAL = new Dimension(36, 21);
    protected static final Dimension MIN_VERTICAL = new Dimension(21, 36);
    protected static final Dimension PREFERRED_VERTICAL = new Dimension(21, 80);
    protected static final Dimension PREFERRED_HORIZONTAL = new Dimension(80, 21);
    protected Insets insetCache = null;
    private int knobWidth;
    private int knobHeight;
    private TwoKnobsSliderModel model;
    private TwoKnobsSliderUI uiDelegate;
    private Color[] gradients;
    private int knobControl;
    private Dimension preferredSize_;
    private int fontHeight;
    private boolean colourGradient;
    private BufferedImage image;
    private boolean squeezeBackground = true;

    private void calculatePreferredSize() {
        int h = this.knobHeight;
        int w = 0;
        if (this.model.isPaintTicks()) {
            h += this.knobHeight;
        }
        if (this.model.isPaintLabels() || this.model.isPaintEndLabels()) {
            h += 3 + this.fontHeight + 2;
        }
        if (this.model.isPaintCurrentValues()) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            w += fm.stringWidth(this.model.render(this.model.getAbsoluteMinimum()));
            w += fm.stringWidth(this.model.render(this.model.getAbsoluteMaximum()));
        }
        this.preferredSize_ = this.model.getOrientation() == 101 ? PREFERRED_VERTICAL : new Dimension(TwoKnobsSlider.PREFERRED_HORIZONTAL.width + w, h);
    }

    private void setDefault() {
        this.insetCache = this.getInsets();
        this.fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        this.knobControl = 0;
        this.knobWidth = this.uiDelegate.getKnobWidth();
        this.knobHeight = this.uiDelegate.getKnobHeight();
        this.colourGradient = false;
        this.calculatePreferredSize();
    }

    private void attachListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TwoKnobsSlider.this.handleMouseEvent(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TwoKnobsSlider.this.release();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                TwoKnobsSlider.this.handleMouseEvent(evt);
            }
        });
    }

    private void release() {
        if (!this.model.isEnabled()) {
            return;
        }
        this.firePropertyChange(KNOB_RELEASED_PROPERTY, (Object)0, (Object)this.knobControl);
        this.knobControl = 0;
    }

    private void handleMouseEvent(MouseEvent me) {
        if (!this.model.isEnabled()) {
            return;
        }
        double oldStart = this.getStartValue();
        double oldEnd = this.getEndValue();
        if (this.model.getOrientation() == 100) {
            this.handleMouseEventForHorizSlider((int)me.getPoint().getX());
            switch (this.knobControl) {
                case 1: {
                    if (oldStart == this.getStartValue()) break;
                    this.firePropertyChange(LEFT_MOVED_PROPERTY, oldStart, this.getStartValue());
                    break;
                }
                case 2: {
                    if (oldEnd == this.getEndValue()) break;
                    this.firePropertyChange(RIGHT_MOVED_PROPERTY, oldEnd, this.getEndValue());
                }
            }
        } else {
            this.handleMouseEventForVertSlider((int)me.getPoint().getY());
            switch (this.knobControl) {
                case 1: {
                    if (oldEnd == this.getEndValue()) break;
                    this.firePropertyChange(LEFT_MOVED_PROPERTY, oldEnd, this.getEndValue());
                    break;
                }
                case 2: {
                    if (oldStart == this.getStartValue()) break;
                    this.firePropertyChange(RIGHT_MOVED_PROPERTY, oldStart, this.getStartValue());
                }
            }
        }
    }

    private void handleMouseEventForHorizSlider(int x) {
        int leftKnob = this.uiDelegate.xPositionForValue(this.model.getStartValue());
        int rightKnob = this.uiDelegate.xPositionForValue(this.model.getEndValue());
        int left = leftKnob;
        int right = rightKnob;
        int xmin = this.uiDelegate.xPositionForValue(this.model.getPartialMinimum());
        int xmax = this.uiDelegate.xPositionForValue(this.model.getPartialMaximum());
        int limit = leftKnob + (rightKnob - leftKnob) / 2;
        if (x < limit && this.knobControl != 2) {
            this.knobControl = 1;
            left = x;
        } else if (x > limit && this.knobControl != 1) {
            this.knobControl = 2;
            right = x;
        }
        if (this.knobControl == 1) {
            this.model.setStartValue(this.uiDelegate.xValueForPosition(left, true));
        } else if (this.knobControl == 2) {
            this.model.setEndValue(this.uiDelegate.xValueForPosition(x, false));
        }
        this.repaint();
    }

    private void handleMouseEventForVertSlider(int y) {
        int upKnob = this.uiDelegate.yPositionForValue(this.model.getEndValue());
        int downKnob = this.uiDelegate.yPositionForValue(this.model.getStartValue());
        int up = upKnob;
        int down = downKnob;
        int ymin = this.uiDelegate.yPositionForValue(this.model.getPartialMaximum());
        int ymax = this.uiDelegate.yPositionForValue(this.model.getPartialMinimum());
        int limit = upKnob + (downKnob - upKnob) / 2;
        if (y < limit && this.knobControl != 2) {
            this.knobControl = 1;
            up = y;
        } else if (y > limit && this.knobControl != 1) {
            this.knobControl = 2;
            down = y;
        }
        if (this.knobControl == 1) {
            if (up < ymin) {
                up = ymin;
            } else if (up > ymax - this.knobHeight) {
                up = ymax - this.knobHeight;
            } else if (up > down && down < ymax) {
                up = down - 1;
            }
            this.model.setEndValue(this.uiDelegate.yValueForPosition(up, true));
        } else if (this.knobControl == 2) {
            if (down > ymax) {
                down = ymax;
            } else if (down < ymin + this.knobHeight) {
                down = ymin + this.knobHeight;
            } else if (down < up && up > ymin) {
                down = up + 1;
            }
            this.model.setStartValue(this.uiDelegate.yValueForPosition(down, false));
        }
        this.repaint();
    }

    protected Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL;
    }

    protected Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL;
    }

    protected Dimension getMinimumHorizontalSize() {
        return MIN_HORIZONTAL;
    }

    protected Dimension getMinimumVerticalSize() {
        return MIN_VERTICAL;
    }

    int getKnobControl() {
        return this.knobControl;
    }

    public TwoKnobsSlider() {
        this(0.0, 100.0, 0.0, 100.0);
    }

    public TwoKnobsSlider(double min, double max, double start, double end) {
        this(min, max, min, max, start, end);
    }

    public TwoKnobsSlider(double absoluteMin, double absoluteMax, double min, double max, double start, double end) {
        this.model = new TwoKnobsSliderModel(absoluteMax, absoluteMin, max, min, start, end);
        this.uiDelegate = new TwoKnobsSliderUI(this, this.model);
        this.attachListeners();
        this.setDefault();
    }

    public int getKnobHeight() {
        return this.knobHeight;
    }

    public int getKnobWidth() {
        return this.knobWidth;
    }

    public void setFontColor(Color c) {
        if (c == null) {
            return;
        }
        this.uiDelegate.setFontColor(c);
    }

    public double getStartValue() {
        return this.model.getStartValue();
    }

    public int getStartValueAsInt() {
        return (int)(this.model.getStartValue() + 0.5);
    }

    public double getEndValue() {
        return this.model.getEndValue();
    }

    public int getEndValueAsInt() {
        return (int)(this.model.getEndValue() + 0.5);
    }

    public void setStartValue(double v) {
        double old = this.model.getStartValue();
        this.model.setStartValue(v);
        this.firePropertyChange(START_VALUE_PROPERTY, (Object)old, (Object)v);
        this.repaint();
    }

    public void setEndValue(double v) {
        double old = this.model.getStartValue();
        this.model.setEndValue(v);
        this.firePropertyChange(END_VALUE_PROPERTY, (Object)old, (Object)v);
        this.repaint();
    }

    public void setValues(double absoluteMax, double absoluteMin, double max, double min, double start, double end) {
        this.model.checkValues(absoluteMax, absoluteMin, max, min, start, end);
        this.firePropertyChange(SET_VALUES_PROPERTY, (Object)false, (Object)true);
        this.repaint();
    }

    public void setInterval(double start, double end) {
        if (start > end) {
            return;
        }
        double max = this.model.getAbsoluteMaximum();
        if (end > max) {
            return;
        }
        double oldEnd = this.model.getEndValue();
        double oldStart = this.model.getStartValue();
        this.model.setInterval(start, end);
        this.firePropertyChange(START_VALUE_PROPERTY, (Object)oldStart, (Object)start);
        this.firePropertyChange(END_VALUE_PROPERTY, (Object)oldEnd, (Object)end);
        this.repaint();
    }

    public void setPaintLabels(boolean paintLabel) {
        if (this.model.isPaintLabels() == paintLabel) {
            return;
        }
        this.model.setPaintLabels(paintLabel);
        this.calculatePreferredSize();
        this.repaint();
    }

    public void setPaintCurrentValues(boolean paintCurrentValues) {
        if (this.model.isPaintCurrentValues() == paintCurrentValues) {
            return;
        }
        this.model.setPaintCurrentValues(paintCurrentValues);
        this.calculatePreferredSize();
        this.repaint();
    }

    public void setPaintEndLabels(boolean paintLabel) {
        if (this.model.isPaintEndLabels() == paintLabel) {
            return;
        }
        this.model.setPaintEndLabels(paintLabel);
        this.calculatePreferredSize();
        this.repaint();
    }

    public void setPaintTicks(boolean paintTicks) {
        if (this.model.isPaintTicks() == paintTicks) {
            return;
        }
        this.model.setPaintTicks(paintTicks);
        this.calculatePreferredSize();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.model.setEnabled(b);
    }

    public int getOrientation() {
        return this.model.getOrientation();
    }

    public void setOrientation(int v) {
        if (v != 100 && v != 101) {
            throw new IllegalArgumentException("Orientation not supported.");
        }
        this.model.setOrientation(v);
    }

    public void setPaintMinorTicks(boolean b) {
        if (b) {
            double m = this.model.getMinorTickSpacing();
            if (m == 0.0) {
                m = 1.0;
            }
            this.model.setMinorTickSpacing(m);
        }
        this.model.setMinorTickSpacing(0.0);
        this.repaint();
    }

    public void setMinorTickSpacing(int s) {
        this.model.setMinorTickSpacing(s);
    }

    public double getPartialMinimum() {
        return this.model.getPartialMinimum();
    }

    public double getPartialMaximum() {
        return this.model.getPartialMaximum();
    }

    public void setColourGradients(Color rgbStart, Color rgbEnd) {
        if (rgbStart == null || rgbEnd == null) {
            return;
        }
        this.colourGradient = true;
        this.gradients = new Color[2];
        this.gradients[0] = rgbStart;
        this.gradients[1] = rgbEnd;
    }

    public void setColourGradients(Color[] colors) {
        if (colors == null || colors.length < 2) {
            return;
        }
        this.colourGradient = true;
        this.gradients = colors;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    Color[] getGradientColors() {
        return this.gradients;
    }

    BufferedImage getImage() {
        return this.image;
    }

    boolean isSqueezeBackground() {
        return this.squeezeBackground;
    }

    public boolean getColourGradient() {
        return this.colourGradient;
    }

    public void setOverlap(boolean overlap) {
        this.model.setOverlap(overlap);
        this.uiDelegate.createDarkerImage();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getOrientation() == 101) {
            return this.getPreferredVerticalSize();
        }
        int width = this.getPreferredHorizontalSize().width;
        int height = this.insetCache.top + this.insetCache.bottom;
        return new Dimension(width, height += this.preferredSize_.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.preferredSize_;
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.calculatePreferredSize();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.uiDelegate.paintComponent((Graphics2D)g, this.getSize());
    }
}

