/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

class TwoKnobsSliderModel {
    private double absoluteMin;
    private double absoluteMax;
    private double maximum;
    private double minimum;
    private double startValue;
    private double endValue;
    private boolean enabled;
    private boolean paintLabels;
    private boolean paintTicks;
    private boolean paintCurrentValues;
    private boolean paintEndLabels;
    private double majorTickSpacing;
    private double minorTickSpacing;
    private double increment;
    private Map<Double, String> labels;
    private int orientation;
    private double partialMin;
    private double partialMax;
    private boolean overlap;

    private void createEndLabels() {
        this.labels.put(this.minimum, this.render(this.minimum));
        this.labels.put(this.maximum, this.render(this.maximum));
    }

    private void createLabels() {
        for (double i = this.minimum; i <= this.maximum; i += this.increment) {
            this.labels.put(i, this.render(i));
        }
    }

    private void installDefaults() {
        this.paintTicks = true;
        this.enabled = true;
        this.increment = (this.maximum - this.minimum) / 10.0;
        this.minorTickSpacing = 1.0;
        this.majorTickSpacing = 10.0;
        this.labels = new HashMap<Double, String>();
        this.setPaintLabels(false);
        this.setPaintEndLabels(true);
        this.setOrientation(100);
    }

    TwoKnobsSliderModel(double absoluteMax, double absoluteMin, double maximum, double minimum, double startValue, double endValue) {
        this.checkValues(absoluteMax, absoluteMin, maximum, minimum, startValue, endValue);
        this.installDefaults();
    }

    void checkValues(double absoluteMax, double absoluteMin, double maximum, double minimum, double startValue, double endValue) {
        if (maximum >= minimum && startValue <= endValue && absoluteMax >= absoluteMin && maximum <= absoluteMax && minimum >= absoluteMin) {
            this.startValue = startValue;
            this.endValue = endValue;
            this.minimum = minimum;
            this.maximum = maximum;
            this.absoluteMax = absoluteMax;
            this.absoluteMin = absoluteMin;
        }
        if (startValue < absoluteMin) {
            startValue = minimum;
        }
        if (endValue > absoluteMax) {
            endValue = absoluteMax;
        }
        this.increment = (maximum - minimum) / 10.0;
        this.partialMin = startValue < minimum ? startValue : minimum;
        this.partialMax = endValue > maximum ? endValue : maximum;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    double getEndValue() {
        return this.endValue;
    }

    double getStartValue() {
        return this.startValue;
    }

    double getMaximum() {
        return this.maximum;
    }

    double getMinimum() {
        return this.minimum;
    }

    double getAbsoluteMaximum() {
        return this.absoluteMax;
    }

    double getAbsoluteMinimum() {
        return this.absoluteMin;
    }

    double getPartialMinimum() {
        return this.absoluteMin;
    }

    double getPartialMaximum() {
        return this.absoluteMax;
    }

    void setStartValue(double startValue) {
        if (this.overlap ? startValue > this.endValue : startValue >= this.endValue) {
            return;
        }
        if (startValue < this.absoluteMin) {
            startValue = this.absoluteMin;
        }
        if (startValue <= this.partialMin) {
            this.partialMin = startValue;
        }
        this.startValue = startValue;
    }

    void setEndValue(double endValue) {
        if (this.overlap ? endValue < this.startValue : endValue <= this.startValue) {
            return;
        }
        if (endValue > this.absoluteMax) {
            endValue = this.absoluteMax;
        }
        if (endValue >= this.partialMax) {
            this.partialMax = endValue;
        }
        this.endValue = endValue;
    }

    void setInterval(double start, double end) {
        if (end > this.absoluteMax) {
            end = this.absoluteMax;
        }
        if (end >= this.partialMax) {
            this.partialMax = end;
        }
        if (start < this.absoluteMin) {
            start = this.absoluteMin;
        }
        if (start <= this.partialMin) {
            this.partialMin = start;
        }
        this.startValue = start;
        this.endValue = end;
    }

    void setPaintCurrentValues(boolean paintCurrentValues) {
        this.paintCurrentValues = paintCurrentValues;
    }

    void setPaintLabels(boolean paintLabels) {
        this.paintLabels = paintLabels;
        if (paintLabels) {
            this.createLabels();
        }
    }

    void setPaintTicks(boolean paintTicks) {
        this.paintTicks = paintTicks;
    }

    void setPaintEndLabels(boolean b) {
        this.paintEndLabels = b;
        if (this.paintEndLabels) {
            this.createEndLabels();
        }
    }

    boolean isPaintLabels() {
        return this.paintLabels;
    }

    boolean isPaintCurrentValues() {
        return this.paintCurrentValues;
    }

    boolean isPaintTicks() {
        return this.paintTicks;
    }

    boolean isPaintEndLabels() {
        return this.paintEndLabels;
    }

    double getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    void setMajorTickSpacing(int v) {
        this.majorTickSpacing = v;
    }

    double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    void setMinorTickSpacing(double v) {
        this.minorTickSpacing = v;
    }

    double getIncrement() {
        return this.increment;
    }

    Map<Double, String> getLabels() {
        return this.labels;
    }

    String render(double value) {
        return new DecimalFormat().format(value);
    }

    int getOrientation() {
        return this.orientation;
    }

    void setOrientation(int v) {
        this.orientation = v;
    }

    boolean allowOverlap() {
        return this.overlap;
    }

    void setOverlap(boolean overlap) {
        this.overlap = overlap;
    }
}

