/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tdialog;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.util.ui.tdialog.CloseButton;
import org.openmicroscopy.shoola.util.ui.tdialog.SizeButton;
import org.openmicroscopy.shoola.util.ui.tdialog.TitleBarLayout;
import org.openmicroscopy.shoola.util.ui.tdialog.TitlePainter;

class TitleBar
extends JComponent {
    static final int SIZE_BUTTON = 0;
    static final int CLOSE_BUTTON = 1;
    static final int SIZE_BUTTON_DIM = 9;
    static final int H_SPACING = 2;
    private static final int SIZE_BUTTON_AREA_WIDTH = 24;
    static final int HEIGHT = 12;
    static final int MIN_WIDTH = 50;
    private TitlePainter titlePainter;
    private SizeButton sizeButton;
    private CloseButton closeButton;
    private int buttonAreaWidth;

    private Rectangle getTitleAreaBounds() {
        int w = this.getWidth();
        if (w <= 24) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(this.buttonAreaWidth, 0, w - 24, this.getHeight());
    }

    TitleBar(String title, int index) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.titlePainter = new TitlePainter(new Font("SansSerif", 0, 16));
        this.update(title);
        this.sizeButton = new SizeButton();
        this.sizeButton.setActionType(1);
        this.buttonAreaWidth = 13;
        this.closeButton = new CloseButton();
        this.closeButton.setActionType(1);
        this.add(this.closeButton);
        this.buttonAreaWidth += 11;
        this.setLayout(new TitleBarLayout());
        this.setDecoration(null, index);
    }

    void setDecoration(List l, int index) {
        this.removeAll();
        switch (index) {
            case 1: {
                this.buttonAreaWidth = 13;
                this.add(this.closeButton);
                break;
            }
            case 2: {
                this.buttonAreaWidth = 13;
                this.add(this.sizeButton);
                break;
            }
            case 0: {
                this.buttonAreaWidth = 24;
                this.add(this.sizeButton);
                this.add(this.closeButton);
            }
        }
        if (l == null) {
            return;
        }
        for (Object object : l) {
            if (!(object instanceof JComponent)) continue;
            JComponent c = (JComponent)object;
            this.add(c);
            this.buttonAreaWidth += c.getPreferredSize().width + 2;
        }
    }

    JButton getButton(int id) {
        switch (id) {
            case 0: {
                return this.sizeButton;
            }
            case 1: {
                return this.closeButton;
            }
        }
        return null;
    }

    void update(String t) {
        this.setToolTipText(t);
        this.titlePainter.setTitle(t);
        this.repaint();
    }

    void setFontStyle(int style) {
        this.titlePainter.setFontStyle(style);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.titlePainter.paint(g2D, this.getTitleAreaBounds(), new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }
}

