/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tpane;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPaneLayout;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPaneModel;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPaneUI;

public class TinyPane
extends JPanel {
    public static final int NO_BAR = 0;
    public static final int SMALL_BAR = 1;
    public static final int HEADER_BAR = 2;
    public static final int FULL_BAR = 3;
    public static final int STATIC_BAR = 4;
    public static final int SMALL_TITLE_BAR = 5;
    public static final String CLOSED_PROPERTY = "closedPane";
    public static final String COLLAPSED_PROPERTY = "collapsed";
    public static final String HIGHLIGHT_PROPERTY = "highlight";
    public static final String TITLEBAR_TYPE_PROPERTY = "titleBarType";
    public static final String TITLE_PROPERTY = "title";
    public static final String SINGLE_VIEW_PROPERTY = "singleViewMode";
    public static final String FRAME_ICON_PROPERTY = "frameIcon";
    public static final String BORDER_LISTENER_PROPERTY = "borderListener";
    public static final String RESIZABLE_PROPERTY = "resizable";
    public static final String DECORATION_PROPERTY = "decoration";
    public static final String FRAME_ICON_PRESSED_PROPERTY = "frameIconPressed";
    public static final String END_MOVING_PROPERTY = "endMoving";
    private TinyPaneUI uiDelegate;
    private TinyPaneModel model = null;
    private Component lastFocusOwner;

    protected Container createContentPane() {
        JPanel c = new JPanel();
        c.setName(this.getName() + ".contentPane");
        c.setLayout(new BorderLayout(){

            @Override
            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints == null) {
                    constraints = "Center";
                }
                super.addLayoutComponent(comp, constraints);
            }
        });
        return c;
    }

    protected TinyPaneUI createUIDelegate() {
        return new TinyPaneUI(this);
    }

    public TinyPane() {
        this("", "");
    }

    public TinyPane(String title) {
        this(title, "");
    }

    public TinyPane(String title, String note) {
        Container container = this.createContentPane();
        this.model = new TinyPaneModel(container, title, new Dimension(this.getWidth(), this.getHeight()));
        this.model.setNote(note);
        this.uiDelegate = this.createUIDelegate();
        this.setLayout(new TinyPaneLayout());
        this.add(this.uiDelegate.getTitleBar());
        container.add(this.getInternalDesktop());
        this.add(container);
        this.setUI(this.uiDelegate);
        this.model.setSingleViewMode(false, this.uiDelegate);
    }

    DesktopManager getDesktopManager() {
        return this.uiDelegate.getDesktopManager();
    }

    void setChildView(Component child) {
        this.model.setChildView(child);
    }

    String getNote() {
        return this.model.getNote();
    }

    List getDecoration() {
        return this.model.getDecoration();
    }

    void onFrameIconPressed(Point p) {
        Rectangle bounds = this.uiDelegate.getFrameIconBounds();
        if (bounds.contains(p)) {
            this.firePropertyChange(FRAME_ICON_PRESSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        }
    }

    void notifyEndMoving() {
        this.firePropertyChange(END_MOVING_PROPERTY, null, this);
    }

    boolean isClosed() {
        return this.model.isClosed();
    }

    void setClosed(boolean b) {
        boolean closed = this.model.isClosed();
        if (b == closed) {
            return;
        }
        this.model.setClosed(b);
        this.setVisible(!b);
        this.firePropertyChange(CLOSED_PROPERTY, null, this);
    }

    public void pack() {
        this.setSize(this.getPreferredSize());
        this.validate();
        this.repaint();
    }

    public String getTitle() {
        return this.model.getTitle();
    }

    public void setTitle(String title) {
        String oldValue = this.model.getTitle();
        this.model.setTitle(title);
        this.firePropertyChange(TITLE_PROPERTY, oldValue, title);
    }

    public void setCollapsed(boolean b) {
        boolean collapsed = this.model.isCollapsed();
        if (b == collapsed) {
            return;
        }
        if (!collapsed) {
            this.model.setRestoreSize(new Dimension(this.getWidth(), this.getHeight()));
        }
        Boolean oldValue = collapsed ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.model.setCollapsed(b);
        this.firePropertyChange(COLLAPSED_PROPERTY, oldValue, newValue);
    }

    public boolean isCollapsed() {
        return this.model.isCollapsed();
    }

    public Dimension getRestoreSize() {
        return this.model.getRestoreSize();
    }

    public Color getHighlight() {
        return this.model.getHighlight();
    }

    public Color getPreviousHighlight() {
        return this.model.getPreviousHighlight();
    }

    public void setHighlight(Color highlight) {
        Color oldValue = this.model.getHighlight();
        this.model.setHighlight(highlight);
        this.firePropertyChange(HIGHLIGHT_PROPERTY, oldValue, highlight);
    }

    public void setBorderColor(Color borderColor) {
        this.uiDelegate.setBorderColor(borderColor);
        this.repaint();
    }

    public int getTitleBarType() {
        return this.model.getTitleBarType();
    }

    public void setTitleBarType(int type) {
        Integer oldValue = this.model.getTitleBarType();
        Integer newValue = type;
        if (this.model.setTitleBarType(type)) {
            this.firePropertyChange(TITLEBAR_TYPE_PROPERTY, oldValue, newValue);
        }
    }

    public boolean isSingleViewMode() {
        return this.model.isSingleViewMode();
    }

    public void setSingleViewMode(boolean singleViewMode) {
        Boolean oldValue = this.model.isSingleViewMode() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = singleViewMode ? Boolean.TRUE : Boolean.FALSE;
        this.model.setSingleViewMode(singleViewMode, this.uiDelegate);
        this.firePropertyChange(SINGLE_VIEW_PROPERTY, oldValue, newValue);
    }

    public Component getChildView() {
        return this.model.getChildView();
    }

    public JComponent getTitleBar() {
        return this.uiDelegate.getTitleBar();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.uiDelegate.getIdealSize();
    }

    public Rectangle getContentsBounds() {
        return this.model.getContentsBounds();
    }

    public JComponent getInternalDesktop() {
        return this.model.getDesktopPane();
    }

    public Container getContentPane() {
        return this.model.getContentPane();
    }

    public JScrollPane getDeskDecorator() {
        return this.uiDelegate.getDeskDecorator();
    }

    public void setResizable(boolean resizable) {
        Boolean oldValue = this.model.isResizable() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = resizable ? Boolean.TRUE : Boolean.FALSE;
        this.model.setResizable(resizable);
        this.firePropertyChange(RESIZABLE_PROPERTY, oldValue, newValue);
    }

    public boolean isResizable() {
        return this.model.isResizable();
    }

    public void setFrameIcon(Icon icon) {
        Icon oldIcon = this.model.getFrameIcon();
        this.model.setFrameIcon(icon);
        this.firePropertyChange(FRAME_ICON_PROPERTY, oldIcon, icon);
    }

    public Icon getFrameIcon() {
        return this.model.getFrameIcon();
    }

    public void setListenToBorder(boolean listenToBorder) {
        Boolean oldValue = this.model.isListenToBorder() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = listenToBorder ? Boolean.TRUE : Boolean.FALSE;
        this.model.setListenToBorder(listenToBorder);
        this.firePropertyChange(BORDER_LISTENER_PROPERTY, oldValue, newValue);
    }

    public boolean isListenToBorder() {
        return this.model.isListenToBorder();
    }

    public void moveToFront() {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            Component focusOwner;
            Component component = focusOwner = this.lastFocusOwner != null ? this.lastFocusOwner : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null && !SwingUtilities.isDescendingFrom(focusOwner, this)) {
                focusOwner = null;
            }
            ((JLayeredPane)this.getParent()).moveToFront(this);
            if (focusOwner != null) {
                focusOwner.requestFocus();
            }
        }
    }

    public void moveToBack() {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).moveToBack(this);
        }
    }

    public void restoreDisplay() {
        this.model.restoreDisplay(this.uiDelegate);
    }

    public void setDecoration(List decoration) {
        List oldValue = this.model.getDecoration();
        this.model.setDecoration(decoration);
        this.firePropertyChange(DECORATION_PROPERTY, oldValue, decoration);
    }

    public void noDecoration() {
        this.setDecoration(new ArrayList());
    }

    public void allowClose(boolean b) {
        this.uiDelegate.allowClose(b);
    }

    public void clearDefaultButtons() {
        this.uiDelegate.clearDefaultButtons();
    }

    public void setFontTitleStyle(int style) {
        this.uiDelegate.setFontStyle(style);
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.uiDelegate.getTitleBar().setToolTipText(text);
    }
}

