/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.logging.Logger;
import ome.model.IObject;
import ome.model.internal.Permissions;

public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class.getName());
    protected static final String CGLIB_IDENTIFIER = "$$EnhancerByCGLIB$$";
    protected static final String JAVASSIST_IDENTIFIER = "_$$_javassist";
    static String msg = "Failed to instantiate %s. This may be caused by an abstract class not being properly \"join fetch\"'d. Please review your query or contact your server administrator.";

    public static <T extends IObject> Class<T> trueClass(Class<T> source) {
        String s = source.getName();
        if (s.contains(CGLIB_IDENTIFIER)) {
            try {
                return Class.forName(s.substring(0, s.indexOf(CGLIB_IDENTIFIER)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Classname contains $$EnhancerByCGLIB$$ but base class cannout be found.");
            }
        }
        if (s.contains(JAVASSIST_IDENTIFIER)) {
            try {
                return Class.forName(s.substring(0, s.indexOf(JAVASSIST_IDENTIFIER)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Classname contains _$$_javassist but base class cannout be found.");
            }
        }
        return source;
    }

    public static <T extends IObject> T trueInstance(Class<T> source) {
        IObject result;
        Class<T> trueClass = Utils.trueClass(source);
        try {
            result = (IObject)trueClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.format(msg, trueClass), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Not allowed to create class:" + trueClass, e);
        }
        return (T)result;
    }

    public static <T> String[] getObjectVoidMethods(Class<T> clazz) {
        HashSet<String> set = new HashSet<String>();
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getReturnType().equals(Object.class) || method.getParameterTypes().length != 0) continue;
            set.add(method.getName());
        }
        return set.toArray(new String[set.size()]);
    }

    public static Object internalForm(Permissions p) {
        P pp = new P(p);
        return pp.toLong();
    }

    public static Permissions toPermissions(Object o) {
        P pp = new P((Long)o);
        return new Permissions(pp);
    }

    public static String getThreadIdentifier() {
        return new StringBuilder(32).append(Runtime.getRuntime().hashCode()).append("::").append(Thread.currentThread().getId()).toString();
    }

    public static void closeQuietly(Closeable is) {
        if (is == null) {
            log.fine("Closeable is null");
        } else {
            try {
                is.close();
            }
            catch (Exception e) {
                log.info("Exception on closing closeable " + is + ":" + e);
            }
        }
    }

    private static class P
    extends Permissions {
        private static final long serialVersionUID = -18133057809465999L;

        protected P(Permissions p) {
            this.revokeAll(p);
            this.grantAll(p);
        }

        protected P(Long l) {
            this.setPerm1(l);
        }

        long toLong() {
            return super.getPerm1();
        }
    }
}

