/* gf.c --- part of pbmtogf program

Copyright (C) 1998 Wai Wong

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  

Version 0.1 1998/03/31 Initial version
*/

#include <stdio.h>
#include <string.h>

#define EXTERN extern
#define GF
#include "pbmtogf.h"
#include "gf.h"

unsigned long bytecnt = 0L;
unsigned long charoff[MAXNCHARS];

char charbuf[MAXCHARHT*MAXCHARWID];

void proc_char(FILE *fp, char *cbuf,
	       const unsigned short ch_wid, const unsigned short ch_ht)
{
  unsigned short i, j, cnt;
  char *cp;
  char st = 0;

  if(debug > 1){
    for (j = 0; j < ch_ht; j++){
      cp = cbuf + (j * ch_wid);
      fprintf(stderr, "\n%.4d:(%d,%d)", j, ch_wid, cp);
      for (i = 0; i < ch_wid; i++){
	fprintf(stderr, "%c", ((*cp++) == 0) ? '0' :'1');
      }
    }
    fprintf(stderr, "\n" );
  }

  i = j = cnt = 0;
  cp = cbuf;
  for (j = 0; j < ch_ht; j++){
    cp = cbuf + (j * ch_wid);
    i = 0;
    do{
      while((i < ch_wid) && (*cp == st)){
	cnt++; i++; cp++;
      }
      checksum += cnt;
      if(cnt < 64){
	fputc((GF_PAINT+cnt), fp);
	bytecnt++;
      }else if(cnt < 256){
	fputc(GF_PAINT1, fp);
	fputc((unsigned char)cnt, fp);
	bytecnt += 2;
      }else if(cnt < 65536){
	fputc(GF_PAINT2, fp);
	fputc((unsigned char)(0xff & (cnt>>8)), fp);
	fputc((unsigned char)(0xff & cnt), fp);
	bytecnt += 3;
      }else error(FATAL, "Character to width, should not happen");
      cnt = 0;
      st  = (st == 0)? 1 : 0;
    }while(i < ch_wid);
    fputc(GF_SKIP0, fp);
    bytecnt++;
    st = 0;
  }/* end for j */

}/* end of proc_char() */

/* should not be longer than 255 */
static char gfstring[] = "GENERATED BY PBMTOGF";

unsigned short preamble(FILE *fp)
{
  unsigned char len = (unsigned char)strlen(gfstring);

  fputc(GF_PRE, fp);
  fputc(GF_ID, fp);
  fputc(len, fp);
  fprintf(fp, "%s", gfstring);

  return(3+(unsigned short)len);
}

void write4bytes(long n, FILE * fp)
{
  fputc( (char)((n>>24) & 0xFF), fp);
  fputc( (char)((n>>16) & 0xFF), fp);
  fputc( (char)((n>> 8) & 0xFF), fp);
  fputc( (char)((n    ) & 0xFF), fp);
}

void proc_image(FILE *fp, char *pp,
	   unsigned short width, unsigned short height,
	   unsigned short ch_wid, unsigned short ch_ht)
{
  unsigned short c, r, i, j;
  unsigned short curchar = ccode1;
  unsigned long cnt_at_post;
  unsigned short cc;
  char *cp;

  
  bytecnt = (unsigned long)preamble(fp);

  for (r = 0; r < (height / ch_ht); r++){
    for (c = 0; c < (width / ch_wid); c++){

      /* process one character */
      for(j = 0; j < ch_ht; j++){
	cp = pp + ((r*ch_ht + j) * width) + (c * ch_wid);
	if(debug >1) fprintf(stderr,"PI:r%d_c%d_j%d(%d)\n", r, c, j, cp);
	for(i = 0; i < ch_wid; i++){
	  charbuf[j*ch_wid+i] = *cp++;
	}
      }
      fprintf(stderr, "[%d]", curchar);
      charoff[curchar] = bytecnt;
      if(debug) fprintf(stderr, "\nCHAR_%d_%d at %d::\n", r, c, bytecnt);
	/* write BOC */
      if((ch_wid < 256) && (ch_ht < 256)){ /* short form */
	fputc(GF_BOC1, fp);
	fputc((unsigned char)curchar, fp);
	fputc((unsigned char)ch_wid, fp);
	fputc((unsigned char)(ch_wid-1), fp);
	fputc((unsigned char)ch_ht, fp);
	fputc((unsigned char)(ch_ht-1), fp);
	bytecnt += 6;
      }else{                              /* long form */
	fputc(GF_BOC, fp);
	write4bytes((long)curchar, fp);
	write4bytes(-1L, fp);
	write4bytes(0L, fp);
	write4bytes((long)(ch_wid-1), fp);
	write4bytes(0L, fp);
	write4bytes((long)(ch_ht-1), fp);
	bytecnt += 25;
      }
      proc_char(fp, &charbuf[0], ch_wid, ch_ht);
      /* write EOC */
      fputc(GF_EOC, fp);
      bytecnt++;
      curchar++;
      if(curchar >= (ccode1 + ccode2)) goto postamble;
    }
  }
 postamble:
  nchars = curchar - ccode1;
  /* write postamble */
  cnt_at_post = bytecnt;
  fputc(GF_POST, fp);
  write4bytes(bytecnt, fp); /* p */
  write4bytes((((long)design_size)<<20), fp); /* ds --- design size */
  write4bytes((checksum), fp); /* cs --- checksum */
  write4bytes(((unsigned long)(res/72.27)<<16), fp); /* hppp */
  write4bytes(((unsigned long)(res/72.27)<<16), fp); /* vppp */
  write4bytes(-1L, fp);   /* min_m */
  write4bytes((long)(ch_wid-1), fp); /* max_m */
  write4bytes(-1L, fp);   /* min_n */
  write4bytes((long)(ch_ht-1), fp); /* max_n */
  bytecnt +=37;
  /* character locators */
  for(cc = ccode1; cc < curchar; cc++){
    fputc(GF_CHARLOC0, fp);
    fputc((unsigned char)cc, fp);               /* c */
    fputc((unsigned char)ch_wid, fp); /* dm */
    /*    write4bytes((unsigned long)(ch_wid/8.3022) << 24, fp);*/ /* w */
    /* w = (ch_wid * 72.27 * 16) /(12 * 600) <<16*/
    write4bytes(((unsigned long)((ch_wid * (72.27 * 4 / 3))/res)<<16), fp);
    write4bytes(charoff[cc], fp); /* p */
  }

  bytecnt += curchar * 11;
  /* write post_post */
  fputc(GF_POSTPOST, fp);
  write4bytes(cnt_at_post, fp); /* q */
  fputc(GF_ID, fp);
  bytecnt += 6;
  for(cc = 0; cc < (4 + bytecnt % 4); cc++)
    fputc(GF_PAD, fp);


}/* end of proc_image() */
