// -*- c++ -*-
// $Id: BifStream.h,v 1.1 2000/12/13 00:12:27 yotam Exp $
// Convenient binary integer  wrapper to ifstream
#ifndef _BifStream_H
#define _BifStream_H

#include <fstream>
#include "baseint.h"

class BifStream : public std::ifstream
{
 public:

   // Constructors
   BifStream() {};
   BifStream(int fd): ifstream(fd) {};
   BifStream(const char *fn): ifstream(fn, std::ios::in | 
                                           std::ios::nocreate | 
                                           std::ios::bin, 
                                       0) {};
   virtual ~BifStream() {};

   Int8    get1byte();
   US8     get1ubyte();

   Int16   get2byte();
   US16    get2ubyte();

   Int32   get3byte();
   US32    get3ubyte();

   Int32   get4byte();
   US32    get4ubyte();

   void    bitscanFlush(); 
   US8     get4bits();

   US8     getByteBits(US8 nBits);  //  0 < nBits <= 8
   US32    getWordBits(US8 nBits);  //  0 < nbits <= 32

 private:
   US8  savedByte;             // For extracting bits
   int  nBitsCashed;           // 0 means savedByte invalid.
}; // BifStream

#endif /* _BifStream_H */
