# $Id: lsp.py,v 1.3 2000/11/21 22:38:43 yotam Exp $
# lspath module
#

import os.path;
import re;

import lsd;

class ListPath:
   "Maintain list of file entries in a path with recursive components"
   def __init__(self, path):
      self.base2full = {}
      for dir in re.split(":", path):
         # print "ListPath: dir=", dir;
         lsDir = lsd.lsd(dir);
         n = lsDir.nitems();
         for i in xrange(0,n):
            filename = lsDir.get(i);
            base = os.path.basename(filename);
            if not base in self.base2full.keys():
               self.base2full[base] = filename;
             
   

#
if __name__ == '__main__':
   import sys;
   for i in range(1,3):
      path = sys.argv[i];
      listPath = ListPath(path);
      print "path=", path
      for item in listPath.base2full.items():
         print "item=", item
