// $Id: debug.h,v 1.1 2000/09/09 08:39:55 yotam Exp $
// Debug smart macros
#ifndef _dEbUg
#define _dEbUg

#if DEBUG

#  include <iostream>
   extern void waitOnFile(unsigned maxSleep);
#  define DHEREBASE  (std::cerr << __FILE__ "[" << dec << __LINE__  << "]")
#  if defined(__GNUC__)
#    define DHERENONL (DHEREBASE << "(" << __FUNCTION__ << "): ")
#  else
#    define DHERENONL (DHEREBASE << ": ")
#  endif
#  define DHERE      (DHERENONL << std::endl)
#  define DASSERT(p) if (!(p)) { DHERE << "Assertion Failed" << std::endl; \
                                 waitOnFile(28);}
#  define DPR(x)     (DHERENONL << x << std::endl)
#  define DPRNONL(x) (DHERENONL << x)
#  define DCODE(x)   x

#else

#  define DHERE
#  define DHERENONL
#  define DASSERT(p)
#  define DPR(x)
#  define DPRNONL(x)
#  define DCODE(x)

#endif

// cancel but keep the code
#define DHERE0
#define DPR0(x)
#define DCODE0(x)

#endif /* _dEbUg */
