#include "TeXpk.h"
#include <cctype>
#include <iostream>

using namespace std;

int main(int argc, char** argv)
{
   bool  ok = (argc == 2);
   if (!ok)
   {
      cerr << "Usage: " << argv[0] << " <pk-file>" << endl;
   }
   else
   {
      TeXpk  pk(argv[1]);
      ok = pk.active();
      if (ok)
      {
         cout << "id=" << pk.id() << endl <<
         "comment=" << pk.comment() << endl <<
         "checkSum=" << pk.checkSum() << 
         "hppp=" << pk.hppp() << endl << 
         "vppp=" << pk.vppp() << endl << 
         "nChars=" << pk.nChars() << endl;
         US8  bc = pk.charFirst();
         US8  ec = pk.charLast();
         cout << "bc=" << (int)bc << ", ec=" << (int)ec << endl;
         for (US8  c = bc;  c <= ec;  ++c)
         {
            Int32  hoff = pk.hoff(c);
            Int32  voff = pk.voff(c);
            Int32  bmw  = pk.bitmapWidth(c);
            Int32  bmh  = pk.bitmapHeight(c);
            cout << "c=" << (int)c << "=" << (isprint(c) ? (char)c : ' ') << 
                    ", off=(" << hoff << "," << voff << 
                    "), bm=(" << bmw << "," << bmh << ")" << endl;
         }
      }
   }
   return !ok;
} // main
