\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{buch}[1996/06/25 I.Kloeckl]
\typeout{BUCH.CLS 25/6/96 I. Kloeckl}
\RequirePackage{ifthen}
%
% multi muss VOR allen anderen Optionen deklariert
% sein, damit diese das Flag auswerten koennen!
%
\newboolean{multi}    \setboolean{multi}{false}
\DeclareOption{multi}{\setboolean{multi}{true}}
\newcommand{\filename}{}
% unbekannte Optionen an book.cls weiterreichen
\DeclareOption{bel}
  {\renewcommand{\filename}{bel.clo}}
\DeclareOption{elegant}
  {\renewcommand{\filename}{elegant.clo}}
\DeclareOption{tech}
  {\renewcommand{\filename}{tech.clo}}
\DeclareOption{modern}
  {\renewcommand{\filename}{modern.clo}}
\DeclareOption{celg}
  {\renewcommand{\filename}{celg.clo}}
\DeclareOption*
  {\PassOptionsToClass{\CurrentOption}{book}}
%
\AtEndOfClass{\input{\filename}}
%
% Hier Defaultoptionen fuer BUCH.CLS eintragen
\ExecuteOptions{elegant}
\ProcessOptions\relax
%
% Hier Defaultoptionen fuer BOOK.CLS eintragen, 
% dann Klasse laden: \LoadClass[...]{book}
\LoadClass{book}
%
% Hier nun die Defaultpackages laden
\RequirePackage{german,makeidx,calc}
%
% Noch ein paar gemeinsame Dinge tun...
\AtEndDocument{\renewcommand{\baselinestretch}{1.0}
  \addcontentsline{toc}{chapter}{Index}
  {\small\printindex}}
%
\newcommand{\@subtitle}{}
\newcommand{\subtitle}[1]{\gdef\@subtitle{#1}}
\newcommand{\@dateob}{}
\newcommand{\dateofbook}[1]{\gdef\@dateob{#1}}
\newcommand{\@edition}{}
\newcommand{\edition}[1]{\gdef\@edition{#1}}
\newcommand{\@editor}{}
\newcommand{\editor}[1]{\gdef\@editor{#1}}
\newcommand{\@verlag}{}
\newcommand{\publisher}[1]{\gdef\@verlag{#1}}
\newcommand{\@mauthor}{}
\newcommand{\partauthor}[1]{\gdef\@mauthor{#1}}
\newcommand{\editorname}{Hrsg.}
%
\providecommand{\prefacename}{Vorwort}
\newcommand{\preface}[2][\prefacename]
  {\chapter*{#2}\markboth{#1}{#1}}
%
\makeindex
