/* $NetBSD: linux_syscalls.c,v 1.88 2021/12/02 04:39:45 ryo Exp $ */

/*
 * System call names.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.74 2021/11/24 18:52:13 ryo Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux_syscalls.c,v 1.88 2021/12/02 04:39:45 ryo Exp $");

#if defined(_KERNEL_OPT)
#include <sys/param.h>
#include <sys/poll.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <sys/time.h>
#include <compat/sys/time.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_machdep.h>
#include <compat/linux/linux_syscallargs.h>
#else /* _KERNEL_OPT */
#include <sys/null.h>
#endif /* _KERNEL_OPT */

const char *const linux_syscallnames[] = {
	/*   0 */	"nosys",
	/*   1 */	"exit",
	/*   2 */	"fork",
	/*   3 */	"read",
	/*   4 */	"write",
	/*   5 */	"open",
	/*   6 */	"close",
	/*   7 */	"waitpid",
	/*   8 */	"creat",
	/*   9 */	"link",
	/*  10 */	"unlink",
	/*  11 */	"execve",
	/*  12 */	"chdir",
	/*  13 */	"time",
	/*  14 */	"mknod",
	/*  15 */	"chmod",
	/*  16 */	"lchown16",
	/*  17 */	"#17 (obsolete break)",
	/*  18 */	"#18 (obsolete ostat)",
	/*  19 */	"lseek",
	/*  20 */	"getpid",
	/*  21 */	"#21 (unimplemented mount)",
	/*  22 */	"#22 (obsolete umount)",
	/*  23 */	"setuid",
	/*  24 */	"getuid",
	/*  25 */	"stime",
	/*  26 */	"ptrace",
	/*  27 */	"alarm",
	/*  28 */	"#28 (obsolete ofstat)",
	/*  29 */	"pause",
	/*  30 */	"utime",
	/*  31 */	"#31 (obsolete stty)",
	/*  32 */	"#32 (obsolete gtty)",
	/*  33 */	"access",
	/*  34 */	"nice",
	/*  35 */	"#35 (obsolete ftime)",
	/*  36 */	"sync",
	/*  37 */	"kill",
	/*  38 */	"__posix_rename",
	/*  39 */	"mkdir",
	/*  40 */	"rmdir",
	/*  41 */	"dup",
	/*  42 */	"pipe",
	/*  43 */	"times",
	/*  44 */	"#44 (obsolete prof)",
	/*  45 */	"brk",
	/*  46 */	"setgid",
	/*  47 */	"getgid",
	/*  48 */	"signal",
	/*  49 */	"geteuid",
	/*  50 */	"getegid",
	/*  51 */	"acct",
	/*  52 */	"#52 (unimplemented umount)",
	/*  53 */	"#53 (obsolete lock)",
	/*  54 */	"ioctl",
	/*  55 */	"fcntl",
	/*  56 */	"#56 (obsolete mpx)",
	/*  57 */	"setpgid",
	/*  58 */	"#58 (obsolete ulimit)",
	/*  59 */	"oldolduname",
	/*  60 */	"umask",
	/*  61 */	"chroot",
	/*  62 */	"#62 (unimplemented ustat)",
	/*  63 */	"dup2",
	/*  64 */	"getppid",
	/*  65 */	"getpgrp",
	/*  66 */	"setsid",
	/*  67 */	"sigaction",
	/*  68 */	"siggetmask",
	/*  69 */	"sigsetmask",
	/*  70 */	"setreuid16",
	/*  71 */	"setregid16",
	/*  72 */	"sigsuspend",
	/*  73 */	"sigpending",
	/*  74 */	"sethostname",
	/*  75 */	"setrlimit",
	/*  76 */	"getrlimit",
	/*  77 */	"getrusage",
	/*  78 */	"gettimeofday",
	/*  79 */	"settimeofday",
	/*  80 */	"getgroups16",
	/*  81 */	"setgroups16",
	/*  82 */	"oldselect",
	/*  83 */	"symlink",
	/*  84 */	"oolstat",
	/*  85 */	"readlink",
#ifdef EXEC_AOUT
	/*  86 */	"uselib",
#else
	/*  86 */	"#86 (excluded uselib)",
#endif
	/*  87 */	"swapon",
	/*  88 */	"reboot",
	/*  89 */	"readdir",
	/*  90 */	"old_mmap",
	/*  91 */	"munmap",
	/*  92 */	"truncate",
	/*  93 */	"ftruncate",
	/*  94 */	"fchmod",
	/*  95 */	"fchown16",
	/*  96 */	"getpriority",
	/*  97 */	"setpriority",
	/*  98 */	"profil",
	/*  99 */	"statfs",
	/* 100 */	"fstatfs",
	/* 101 */	"#101 (unimplemented)",
	/* 102 */	"socketcall",
	/* 103 */	"#103 (unimplemented syslog)",
	/* 104 */	"setitimer",
	/* 105 */	"getitimer",
	/* 106 */	"stat",
	/* 107 */	"lstat",
	/* 108 */	"fstat",
	/* 109 */	"olduname",
	/* 110 */	"#110 (unimplemented)",
	/* 111 */	"#111 (unimplemented vhangup)",
	/* 112 */	"#112 (unimplemented idle)",
	/* 113 */	"#113 (unimplemented syscall)",
	/* 114 */	"wait4",
	/* 115 */	"swapoff",
	/* 116 */	"sysinfo",
	/* 117 */	"ipc",
	/* 118 */	"fsync",
	/* 119 */	"sigreturn",
	/* 120 */	"clone",
	/* 121 */	"setdomainname",
	/* 122 */	"uname",
	/* 123 */	"#123 (unimplemented modify_ldt)",
	/* 124 */	"#124 (unimplemented adjtimex)",
	/* 125 */	"mprotect",
	/* 126 */	"sigprocmask",
	/* 127 */	"#127 (unimplemented create_module)",
	/* 128 */	"#128 (unimplemented init_module)",
	/* 129 */	"#129 (unimplemented delete_module)",
	/* 130 */	"#130 (unimplemented get_kernel_syms)",
	/* 131 */	"#131 (unimplemented quotactl)",
	/* 132 */	"getpgid",
	/* 133 */	"fchdir",
	/* 134 */	"#134 (unimplemented bdflush)",
	/* 135 */	"#135 (unimplemented sysfs)",
	/* 136 */	"personality",
	/* 137 */	"#137 (unimplemented afs_syscall)",
	/* 138 */	"setfsuid",
	/* 139 */	"setfsgid",
	/* 140 */	"llseek",
	/* 141 */	"getdents",
	/* 142 */	"select",
	/* 143 */	"flock",
	/* 144 */	"__msync13",
	/* 145 */	"readv",
	/* 146 */	"writev",
	/* 147 */	"getsid",
	/* 148 */	"fdatasync",
	/* 149 */	"__sysctl",
	/* 150 */	"mlock",
	/* 151 */	"munlock",
	/* 152 */	"mlockall",
	/* 153 */	"munlockall",
	/* 154 */	"sched_setparam",
	/* 155 */	"sched_getparam",
	/* 156 */	"sched_setscheduler",
	/* 157 */	"sched_getscheduler",
	/* 158 */	"sched_yield",
	/* 159 */	"sched_get_priority_max",
	/* 160 */	"sched_get_priority_min",
	/* 161 */	"#161 (unimplemented sched_rr_get_interval)",
	/* 162 */	"nanosleep",
	/* 163 */	"mremap",
	/* 164 */	"setresuid16",
	/* 165 */	"getresuid16",
	/* 166 */	"#166 (unimplemented)",
	/* 167 */	"#167 (unimplemented query_module)",
	/* 168 */	"poll",
	/* 169 */	"#169 (unimplemented nfsservctl)",
	/* 170 */	"setresgid16",
	/* 171 */	"getresgid16",
	/* 172 */	"#172 (unimplemented prctl)",
	/* 173 */	"#173 (unimplemented rt_sigreturn)",
	/* 174 */	"rt_sigaction",
	/* 175 */	"rt_sigprocmask",
	/* 176 */	"rt_sigpending",
	/* 177 */	"rt_sigtimedwait",
	/* 178 */	"rt_queueinfo",
	/* 179 */	"rt_sigsuspend",
	/* 180 */	"pread",
	/* 181 */	"pwrite",
	/* 182 */	"chown16",
	/* 183 */	"__getcwd",
	/* 184 */	"#184 (unimplemented capget)",
	/* 185 */	"#185 (unimplemented capset)",
	/* 186 */	"sigaltstack",
	/* 187 */	"#187 (unimplemented sendfile)",
	/* 188 */	"#188 (unimplemented getpmsg)",
	/* 189 */	"#189 (unimplemented putpmsg)",
	/* 190 */	"vfork",
	/* 191 */	"ugetrlimit",
#define linux_sys_mmap2_args linux_sys_mmap_args
	/* 192 */	"mmap2",
	/* 193 */	"truncate64",
	/* 194 */	"ftruncate64",
	/* 195 */	"stat64",
	/* 196 */	"lstat64",
	/* 197 */	"fstat64",
	/* 198 */	"__posix_lchown",
	/* 199 */	"getuid32",
	/* 200 */	"getgid32",
	/* 201 */	"geteuid32",
	/* 202 */	"getegid32",
	/* 203 */	"setreuid32",
	/* 204 */	"setregid32",
	/* 205 */	"getgroups32",
	/* 206 */	"setgroups32",
	/* 207 */	"fchown32",
	/* 208 */	"setresuid32",
	/* 209 */	"getresuid32",
	/* 210 */	"setresgid32",
	/* 211 */	"getresgid32",
	/* 212 */	"chown32",
	/* 213 */	"setuid32",
	/* 214 */	"setgid32",
	/* 215 */	"setfsuid32",
	/* 216 */	"setfsgid32",
	/* 217 */	"getdents64",
	/* 218 */	"#218 (unimplemented pivot_root)",
	/* 219 */	"mincore",
	/* 220 */	"madvise",
	/* 221 */	"fcntl64",
	/* 222 */	"#222 (unimplemented / * for tux * /)",
	/* 223 */	"#223 (unimplemented / * unused * /)",
	/* 224 */	"gettid",
	/* 225 */	"#225 (unimplemented readahead)",
	/* 226 */	"setxattr",
	/* 227 */	"lsetxattr",
	/* 228 */	"fsetxattr",
	/* 229 */	"getxattr",
	/* 230 */	"lgetxattr",
	/* 231 */	"fgetxattr",
	/* 232 */	"listxattr",
	/* 233 */	"llistxattr",
	/* 234 */	"flistxattr",
	/* 235 */	"removexattr",
	/* 236 */	"lremovexattr",
	/* 237 */	"fremovexattr",
	/* 238 */	"tkill",
	/* 239 */	"#239 (unimplemented sendfile64)",
	/* 240 */	"futex",
	/* 241 */	"sched_setaffinity",
	/* 242 */	"sched_getaffinity",
	/* 243 */	"#243 (unimplemented io_setup)",
	/* 244 */	"#244 (unimplemented io_destroy)",
	/* 245 */	"#245 (unimplemented io_getevents)",
	/* 246 */	"#246 (unimplemented io_submit)",
	/* 247 */	"#247 (unimplemented io_cancel)",
	/* 248 */	"exit_group",
	/* 249 */	"#249 (unimplemented lookup_dcookie)",
	/* 250 */	"#250 (unimplemented epoll_create)",
	/* 251 */	"#251 (unimplemented epoll_ctl)",
	/* 252 */	"#252 (unimplemented epoll_wait)",
	/* 253 */	"#253 (unimplemented remap_file_pages)",
	/* 254 */	"#254 (unimplemented set_thread_area)",
	/* 255 */	"#255 (unimplemented get_thread_area)",
	/* 256 */	"set_tid_address",
	/* 257 */	"timer_create",
	/* 258 */	"timer_settime",
	/* 259 */	"timer_gettime",
	/* 260 */	"timer_getoverrun",
	/* 261 */	"timer_delete",
	/* 262 */	"clock_settime",
	/* 263 */	"clock_gettime",
	/* 264 */	"clock_getres",
	/* 265 */	"clock_nanosleep",
	/* 266 */	"statfs64",
	/* 267 */	"fstatfs64",
	/* 268 */	"tgkill",
	/* 269 */	"utimes",
	/* 270 */	"fadvise64_64",
	/* 271 */	"#271 (unimplemented pciconfig_iobase)",
	/* 272 */	"#272 (unimplemented pciconfig_read)",
	/* 273 */	"#273 (unimplemented pciconfig_write)",
	/* 274 */	"#274 (unimplemented mq_open)",
	/* 275 */	"#275 (unimplemented mq_unlink)",
	/* 276 */	"#276 (unimplemented mq_timedsend)",
	/* 277 */	"#277 (unimplemented mq_timedreceive)",
	/* 278 */	"#278 (unimplemented mq_notify)",
	/* 279 */	"#279 (unimplemented mq_getsetattr)",
	/* 280 */	"#280 (unimplemented waitid)",
	/* 281 */	"#281 (unimplemented socket)",
	/* 282 */	"#282 (unimplemented bind)",
	/* 283 */	"#283 (unimplemented connect)",
	/* 284 */	"#284 (unimplemented listen)",
	/* 285 */	"#285 (unimplemented accept)",
	/* 286 */	"#286 (unimplemented getsockname)",
	/* 287 */	"#287 (unimplemented getpeername)",
	/* 288 */	"#288 (unimplemented socketpair)",
	/* 289 */	"#289 (unimplemented send)",
	/* 290 */	"#290 (unimplemented sendto)",
	/* 291 */	"#291 (unimplemented recv)",
	/* 292 */	"#292 (unimplemented recvfrom)",
	/* 293 */	"#293 (unimplemented shutdown)",
	/* 294 */	"#294 (unimplemented setsockopt)",
	/* 295 */	"#295 (unimplemented getsockopt)",
	/* 296 */	"#296 (unimplemented sendmsg)",
	/* 297 */	"#297 (unimplemented recvmsg)",
	/* 298 */	"#298 (unimplemented semop)",
	/* 299 */	"#299 (unimplemented semget)",
	/* 300 */	"#300 (unimplemented semctl)",
	/* 301 */	"#301 (unimplemented msgsnd)",
	/* 302 */	"#302 (unimplemented msgrcv)",
	/* 303 */	"#303 (unimplemented msgget)",
	/* 304 */	"#304 (unimplemented msgctl)",
	/* 305 */	"#305 (unimplemented shmat)",
	/* 306 */	"#306 (unimplemented shmdt)",
	/* 307 */	"#307 (unimplemented shmget)",
	/* 308 */	"#308 (unimplemented shmctl)",
	/* 309 */	"#309 (unimplemented add_key)",
	/* 310 */	"#310 (unimplemented request_key)",
	/* 311 */	"#311 (unimplemented keyctl)",
	/* 312 */	"#312 (unimplemented semtimedop)",
	/* 313 */	"#313 (unimplemented vserver)",
	/* 314 */	"#314 (unimplemented ioptio_set)",
	/* 315 */	"#315 (unimplemented ioptio_get)",
	/* 316 */	"#316 (unimplemented inotify_init)",
	/* 317 */	"#317 (unimplemented inotify_add_watch)",
	/* 318 */	"#318 (unimplemented inotify_rm_watch)",
	/* 319 */	"#319 (unimplemented mbind)",
	/* 320 */	"#320 (unimplemented get_mempolicy)",
	/* 321 */	"#321 (unimplemented set_mempolicy)",
	/* 322 */	"openat",
	/* 323 */	"mkdirat",
	/* 324 */	"mknodat",
	/* 325 */	"fchownat",
	/* 326 */	"#326 (unimplemented futimesat)",
	/* 327 */	"fstatat64",
	/* 328 */	"unlinkat",
	/* 329 */	"renameat",
	/* 330 */	"linkat",
	/* 331 */	"symlinkat",
	/* 332 */	"readlinkat",
	/* 333 */	"fchmodat",
	/* 334 */	"faccessat",
	/* 335 */	"pselect6",
	/* 336 */	"ppoll",
	/* 337 */	"#337 (unimplemented unshare)",
	/* 338 */	"__futex_set_robust_list",
	/* 339 */	"__futex_get_robust_list",
	/* 340 */	"#340 (unimplemented splice)",
	/* 341 */	"#341 (unimplemented sync_file_range2)",
	/* 342 */	"#342 (unimplemented tee)",
	/* 343 */	"#343 (unimplemented vmsplice)",
	/* 344 */	"#344 (unimplemented move_pages)",
	/* 345 */	"#345 (unimplemented getcpu)",
	/* 346 */	"#346 (unimplemented epoll_wait)",
	/* 347 */	"#347 (unimplemented kexec_load)",
	/* 348 */	"utimensat",
	/* 349 */	"#349 (unimplemented signalfd)",
	/* 350 */	"timerfd_create",
	/* 351 */	"eventfd",
	/* 352 */	"fallocate",
	/* 353 */	"timerfd_settime",
	/* 354 */	"timerfd_gettime",
	/* 355 */	"#355 (unimplemented signalfd4)",
	/* 356 */	"eventfd2",
	/* 357 */	"#357 (unimplemented epoll_create1)",
	/* 358 */	"dup3",
	/* 359 */	"pipe2",
	/* 360 */	"#360 (unimplemented inotify_init1)",
	/* 361 */	"preadv",
	/* 362 */	"pwritev",
	/* 363 */	"#363 (unimplemented rt_tgsigqueueinfo)",
	/* 364 */	"#364 (unimplemented perf_counter_open)",
	/* 365 */	"recvmmsg",
	/* 366 */	"accept4",
	/* 367 */	"#367 (unimplemented fanotify_init)",
	/* 368 */	"#368 (unimplemented fanotify_mark)",
	/* 369 */	"prlimit64",
	/* 370 */	"#370 (unimplemented name_to_handle_at)",
	/* 371 */	"#371 (unimplemented open_by_handle_at)",
	/* 372 */	"#372 (unimplemented clock_adjtime)",
	/* 373 */	"#373 (unimplemented syncfs)",
	/* 374 */	"sendmmsg",
	/* 375 */	"#375 (unimplemented setns)",
	/* 376 */	"#376 (unimplemented process_vm_readv)",
	/* 377 */	"#377 (unimplemented process_vm_writev)",
	/* 378 */	"#378 (unimplemented kcmp)",
	/* 379 */	"#379 (unimplemented finit_module)",
	/* 380 */	"#380 (unimplemented sched_setattr)",
	/* 381 */	"#381 (unimplemented sched_getattr)",
	/* 382 */	"#382 (unimplemented renameat2)",
	/* 383 */	"#383 (unimplemented seccomp)",
	/* 384 */	"#384 (unimplemented / * base * /)",
	/* 385 */	"breakpoint",
	/* 386 */	"cacheflush",
	/* 387 */	"#387 (unimplemented usr26)",
	/* 388 */	"#388 (unimplemented usr32)",
	/* 389 */	"set_tls",
	/* 390 */	"# filler",
	/* 391 */	"# filler",
	/* 392 */	"# filler",
	/* 393 */	"# filler",
	/* 394 */	"# filler",
	/* 395 */	"# filler",
	/* 396 */	"# filler",
	/* 397 */	"# filler",
	/* 398 */	"# filler",
	/* 399 */	"# filler",
	/* 400 */	"# filler",
	/* 401 */	"# filler",
	/* 402 */	"# filler",
	/* 403 */	"# filler",
	/* 404 */	"# filler",
	/* 405 */	"# filler",
	/* 406 */	"# filler",
	/* 407 */	"# filler",
	/* 408 */	"# filler",
	/* 409 */	"# filler",
	/* 410 */	"# filler",
	/* 411 */	"# filler",
	/* 412 */	"# filler",
	/* 413 */	"# filler",
	/* 414 */	"# filler",
	/* 415 */	"# filler",
	/* 416 */	"# filler",
	/* 417 */	"# filler",
	/* 418 */	"# filler",
	/* 419 */	"# filler",
	/* 420 */	"# filler",
	/* 421 */	"# filler",
	/* 422 */	"# filler",
	/* 423 */	"# filler",
	/* 424 */	"# filler",
	/* 425 */	"# filler",
	/* 426 */	"# filler",
	/* 427 */	"# filler",
	/* 428 */	"# filler",
	/* 429 */	"# filler",
	/* 430 */	"# filler",
	/* 431 */	"# filler",
	/* 432 */	"# filler",
	/* 433 */	"# filler",
	/* 434 */	"# filler",
	/* 435 */	"# filler",
	/* 436 */	"# filler",
	/* 437 */	"# filler",
	/* 438 */	"# filler",
	/* 439 */	"# filler",
	/* 440 */	"# filler",
	/* 441 */	"# filler",
	/* 442 */	"# filler",
	/* 443 */	"# filler",
	/* 444 */	"# filler",
	/* 445 */	"# filler",
	/* 446 */	"# filler",
	/* 447 */	"# filler",
	/* 448 */	"# filler",
	/* 449 */	"# filler",
	/* 450 */	"# filler",
	/* 451 */	"# filler",
	/* 452 */	"# filler",
	/* 453 */	"# filler",
	/* 454 */	"# filler",
	/* 455 */	"# filler",
	/* 456 */	"# filler",
	/* 457 */	"# filler",
	/* 458 */	"# filler",
	/* 459 */	"# filler",
	/* 460 */	"# filler",
	/* 461 */	"# filler",
	/* 462 */	"# filler",
	/* 463 */	"# filler",
	/* 464 */	"# filler",
	/* 465 */	"# filler",
	/* 466 */	"# filler",
	/* 467 */	"# filler",
	/* 468 */	"# filler",
	/* 469 */	"# filler",
	/* 470 */	"# filler",
	/* 471 */	"# filler",
	/* 472 */	"# filler",
	/* 473 */	"# filler",
	/* 474 */	"# filler",
	/* 475 */	"# filler",
	/* 476 */	"# filler",
	/* 477 */	"# filler",
	/* 478 */	"# filler",
	/* 479 */	"# filler",
	/* 480 */	"# filler",
	/* 481 */	"# filler",
	/* 482 */	"# filler",
	/* 483 */	"# filler",
	/* 484 */	"# filler",
	/* 485 */	"# filler",
	/* 486 */	"# filler",
	/* 487 */	"# filler",
	/* 488 */	"# filler",
	/* 489 */	"# filler",
	/* 490 */	"# filler",
	/* 491 */	"# filler",
	/* 492 */	"# filler",
	/* 493 */	"# filler",
	/* 494 */	"# filler",
	/* 495 */	"# filler",
	/* 496 */	"# filler",
	/* 497 */	"# filler",
	/* 498 */	"# filler",
	/* 499 */	"# filler",
	/* 500 */	"# filler",
	/* 501 */	"# filler",
	/* 502 */	"# filler",
	/* 503 */	"# filler",
	/* 504 */	"# filler",
	/* 505 */	"# filler",
	/* 506 */	"# filler",
	/* 507 */	"# filler",
	/* 508 */	"# filler",
	/* 509 */	"# filler",
	/* 510 */	"# filler",
	/* 511 */	"# filler",
};


/* libc style syscall names */
const char *const altlinux_syscallnames[] = {
	/*   0 */	NULL, /* nosys */
	/*   1 */	NULL, /* exit */
	/*   2 */	NULL, /* fork */
	/*   3 */	NULL, /* read */
	/*   4 */	NULL, /* write */
	/*   5 */	NULL, /* open */
	/*   6 */	NULL, /* close */
	/*   7 */	NULL, /* waitpid */
	/*   8 */	NULL, /* creat */
	/*   9 */	NULL, /* link */
	/*  10 */	NULL, /* unlink */
	/*  11 */	NULL, /* execve */
	/*  12 */	NULL, /* chdir */
	/*  13 */	NULL, /* time */
	/*  14 */	NULL, /* mknod */
	/*  15 */	NULL, /* chmod */
	/*  16 */	NULL, /* lchown16 */
	/*  17 */	NULL, /* obsolete break */
	/*  18 */	NULL, /* obsolete ostat */
	/*  19 */	NULL, /* lseek */
	/*  20 */	NULL, /* getpid */
	/*  21 */	NULL, /* unimplemented mount */
	/*  22 */	NULL, /* obsolete umount */
	/*  23 */	NULL, /* setuid */
	/*  24 */	NULL, /* getuid */
	/*  25 */	NULL, /* stime */
	/*  26 */	NULL, /* ptrace */
	/*  27 */	NULL, /* alarm */
	/*  28 */	NULL, /* obsolete ofstat */
	/*  29 */	NULL, /* pause */
	/*  30 */	NULL, /* utime */
	/*  31 */	NULL, /* obsolete stty */
	/*  32 */	NULL, /* obsolete gtty */
	/*  33 */	NULL, /* access */
	/*  34 */	NULL, /* nice */
	/*  35 */	NULL, /* obsolete ftime */
	/*  36 */	NULL, /* sync */
	/*  37 */	NULL, /* kill */
	/*  38 */	NULL, /* __posix_rename */
	/*  39 */	NULL, /* mkdir */
	/*  40 */	NULL, /* rmdir */
	/*  41 */	NULL, /* dup */
	/*  42 */	NULL, /* pipe */
	/*  43 */	NULL, /* times */
	/*  44 */	NULL, /* obsolete prof */
	/*  45 */	NULL, /* brk */
	/*  46 */	NULL, /* setgid */
	/*  47 */	NULL, /* getgid */
	/*  48 */	NULL, /* signal */
	/*  49 */	NULL, /* geteuid */
	/*  50 */	NULL, /* getegid */
	/*  51 */	NULL, /* acct */
	/*  52 */	NULL, /* unimplemented umount */
	/*  53 */	NULL, /* obsolete lock */
	/*  54 */	NULL, /* ioctl */
	/*  55 */	NULL, /* fcntl */
	/*  56 */	NULL, /* obsolete mpx */
	/*  57 */	NULL, /* setpgid */
	/*  58 */	NULL, /* obsolete ulimit */
	/*  59 */	NULL, /* oldolduname */
	/*  60 */	NULL, /* umask */
	/*  61 */	NULL, /* chroot */
	/*  62 */	NULL, /* unimplemented ustat */
	/*  63 */	NULL, /* dup2 */
	/*  64 */	NULL, /* getppid */
	/*  65 */	NULL, /* getpgrp */
	/*  66 */	NULL, /* setsid */
	/*  67 */	NULL, /* sigaction */
	/*  68 */	NULL, /* siggetmask */
	/*  69 */	NULL, /* sigsetmask */
	/*  70 */	NULL, /* setreuid16 */
	/*  71 */	NULL, /* setregid16 */
	/*  72 */	NULL, /* sigsuspend */
	/*  73 */	NULL, /* sigpending */
	/*  74 */	NULL, /* sethostname */
	/*  75 */	NULL, /* setrlimit */
	/*  76 */	NULL, /* getrlimit */
	/*  77 */	NULL, /* getrusage */
	/*  78 */	NULL, /* gettimeofday */
	/*  79 */	NULL, /* settimeofday */
	/*  80 */	NULL, /* getgroups16 */
	/*  81 */	NULL, /* setgroups16 */
	/*  82 */	NULL, /* oldselect */
	/*  83 */	NULL, /* symlink */
	/*  84 */	"lstat",
	/*  85 */	NULL, /* readlink */
#ifdef EXEC_AOUT
	/*  86 */	NULL, /* uselib */
#else
	/*  86 */	NULL, /* excluded uselib */
#endif
	/*  87 */	NULL, /* swapon */
	/*  88 */	NULL, /* reboot */
	/*  89 */	NULL, /* readdir */
	/*  90 */	NULL, /* old_mmap */
	/*  91 */	NULL, /* munmap */
	/*  92 */	NULL, /* truncate */
	/*  93 */	NULL, /* ftruncate */
	/*  94 */	NULL, /* fchmod */
	/*  95 */	NULL, /* fchown16 */
	/*  96 */	NULL, /* getpriority */
	/*  97 */	NULL, /* setpriority */
	/*  98 */	NULL, /* profil */
	/*  99 */	NULL, /* statfs */
	/* 100 */	NULL, /* fstatfs */
	/* 101 */	NULL, /* unimplemented */
	/* 102 */	NULL, /* socketcall */
	/* 103 */	NULL, /* unimplemented syslog */
	/* 104 */	NULL, /* setitimer */
	/* 105 */	NULL, /* getitimer */
	/* 106 */	NULL, /* stat */
	/* 107 */	NULL, /* lstat */
	/* 108 */	NULL, /* fstat */
	/* 109 */	NULL, /* olduname */
	/* 110 */	NULL, /* unimplemented */
	/* 111 */	NULL, /* unimplemented vhangup */
	/* 112 */	NULL, /* unimplemented idle */
	/* 113 */	NULL, /* unimplemented syscall */
	/* 114 */	NULL, /* wait4 */
	/* 115 */	NULL, /* swapoff */
	/* 116 */	NULL, /* sysinfo */
	/* 117 */	NULL, /* ipc */
	/* 118 */	NULL, /* fsync */
	/* 119 */	NULL, /* sigreturn */
	/* 120 */	NULL, /* clone */
	/* 121 */	NULL, /* setdomainname */
	/* 122 */	NULL, /* uname */
	/* 123 */	NULL, /* unimplemented modify_ldt */
	/* 124 */	NULL, /* unimplemented adjtimex */
	/* 125 */	NULL, /* mprotect */
	/* 126 */	NULL, /* sigprocmask */
	/* 127 */	NULL, /* unimplemented create_module */
	/* 128 */	NULL, /* unimplemented init_module */
	/* 129 */	NULL, /* unimplemented delete_module */
	/* 130 */	NULL, /* unimplemented get_kernel_syms */
	/* 131 */	NULL, /* unimplemented quotactl */
	/* 132 */	NULL, /* getpgid */
	/* 133 */	NULL, /* fchdir */
	/* 134 */	NULL, /* unimplemented bdflush */
	/* 135 */	NULL, /* unimplemented sysfs */
	/* 136 */	NULL, /* personality */
	/* 137 */	NULL, /* unimplemented afs_syscall */
	/* 138 */	NULL, /* setfsuid */
	/* 139 */	NULL, /* setfsgid */
	/* 140 */	NULL, /* llseek */
	/* 141 */	NULL, /* getdents */
	/* 142 */	NULL, /* select */
	/* 143 */	NULL, /* flock */
	/* 144 */	"msync",
	/* 145 */	NULL, /* readv */
	/* 146 */	NULL, /* writev */
	/* 147 */	NULL, /* getsid */
	/* 148 */	NULL, /* fdatasync */
	/* 149 */	NULL, /* __sysctl */
	/* 150 */	NULL, /* mlock */
	/* 151 */	NULL, /* munlock */
	/* 152 */	NULL, /* mlockall */
	/* 153 */	NULL, /* munlockall */
	/* 154 */	NULL, /* sched_setparam */
	/* 155 */	NULL, /* sched_getparam */
	/* 156 */	NULL, /* sched_setscheduler */
	/* 157 */	NULL, /* sched_getscheduler */
	/* 158 */	NULL, /* sched_yield */
	/* 159 */	NULL, /* sched_get_priority_max */
	/* 160 */	NULL, /* sched_get_priority_min */
	/* 161 */	NULL, /* unimplemented sched_rr_get_interval */
	/* 162 */	NULL, /* nanosleep */
	/* 163 */	NULL, /* mremap */
	/* 164 */	NULL, /* setresuid16 */
	/* 165 */	NULL, /* getresuid16 */
	/* 166 */	NULL, /* unimplemented */
	/* 167 */	NULL, /* unimplemented query_module */
	/* 168 */	NULL, /* poll */
	/* 169 */	NULL, /* unimplemented nfsservctl */
	/* 170 */	NULL, /* setresgid16 */
	/* 171 */	NULL, /* getresgid16 */
	/* 172 */	NULL, /* unimplemented prctl */
	/* 173 */	NULL, /* unimplemented rt_sigreturn */
	/* 174 */	NULL, /* rt_sigaction */
	/* 175 */	NULL, /* rt_sigprocmask */
	/* 176 */	NULL, /* rt_sigpending */
	/* 177 */	NULL, /* rt_sigtimedwait */
	/* 178 */	NULL, /* rt_queueinfo */
	/* 179 */	NULL, /* rt_sigsuspend */
	/* 180 */	NULL, /* pread */
	/* 181 */	NULL, /* pwrite */
	/* 182 */	NULL, /* chown16 */
	/* 183 */	NULL, /* __getcwd */
	/* 184 */	NULL, /* unimplemented capget */
	/* 185 */	NULL, /* unimplemented capset */
	/* 186 */	NULL, /* sigaltstack */
	/* 187 */	NULL, /* unimplemented sendfile */
	/* 188 */	NULL, /* unimplemented getpmsg */
	/* 189 */	NULL, /* unimplemented putpmsg */
	/* 190 */	NULL, /* vfork */
	/* 191 */	NULL, /* ugetrlimit */
#define linux_sys_mmap2_args linux_sys_mmap_args
	/* 192 */	NULL, /* mmap2 */
	/* 193 */	NULL, /* truncate64 */
	/* 194 */	NULL, /* ftruncate64 */
	/* 195 */	NULL, /* stat64 */
	/* 196 */	NULL, /* lstat64 */
	/* 197 */	NULL, /* fstat64 */
	/* 198 */	NULL, /* __posix_lchown */
	/* 199 */	"getuid",
	/* 200 */	"getgid",
	/* 201 */	"geteuid",
	/* 202 */	"getegid",
	/* 203 */	"setreuid",
	/* 204 */	"setregid",
	/* 205 */	"getgroups",
	/* 206 */	"setgroups",
	/* 207 */	"__posix_fchown",
	/* 208 */	"setresuid",
	/* 209 */	"getresuid",
	/* 210 */	"setresgid",
	/* 211 */	"getresgid",
	/* 212 */	"__posix_chown",
	/* 213 */	"setuid",
	/* 214 */	"setgid",
	/* 215 */	"setfsuid",
	/* 216 */	"setfsgid",
	/* 217 */	NULL, /* getdents64 */
	/* 218 */	NULL, /* unimplemented pivot_root */
	/* 219 */	NULL, /* mincore */
	/* 220 */	NULL, /* madvise */
	/* 221 */	NULL, /* fcntl64 */
	/* 222 */	NULL, /* unimplemented / * for tux * / */
	/* 223 */	NULL, /* unimplemented / * unused * / */
	/* 224 */	NULL, /* gettid */
	/* 225 */	NULL, /* unimplemented readahead */
	/* 226 */	NULL, /* setxattr */
	/* 227 */	NULL, /* lsetxattr */
	/* 228 */	NULL, /* fsetxattr */
	/* 229 */	NULL, /* getxattr */
	/* 230 */	NULL, /* lgetxattr */
	/* 231 */	NULL, /* fgetxattr */
	/* 232 */	NULL, /* listxattr */
	/* 233 */	NULL, /* llistxattr */
	/* 234 */	NULL, /* flistxattr */
	/* 235 */	NULL, /* removexattr */
	/* 236 */	NULL, /* lremovexattr */
	/* 237 */	NULL, /* fremovexattr */
	/* 238 */	NULL, /* tkill */
	/* 239 */	NULL, /* unimplemented sendfile64 */
	/* 240 */	NULL, /* futex */
	/* 241 */	NULL, /* sched_setaffinity */
	/* 242 */	NULL, /* sched_getaffinity */
	/* 243 */	NULL, /* unimplemented io_setup */
	/* 244 */	NULL, /* unimplemented io_destroy */
	/* 245 */	NULL, /* unimplemented io_getevents */
	/* 246 */	NULL, /* unimplemented io_submit */
	/* 247 */	NULL, /* unimplemented io_cancel */
	/* 248 */	NULL, /* exit_group */
	/* 249 */	NULL, /* unimplemented lookup_dcookie */
	/* 250 */	NULL, /* unimplemented epoll_create */
	/* 251 */	NULL, /* unimplemented epoll_ctl */
	/* 252 */	NULL, /* unimplemented epoll_wait */
	/* 253 */	NULL, /* unimplemented remap_file_pages */
	/* 254 */	NULL, /* unimplemented set_thread_area */
	/* 255 */	NULL, /* unimplemented get_thread_area */
	/* 256 */	NULL, /* set_tid_address */
	/* 257 */	NULL, /* timer_create */
	/* 258 */	NULL, /* timer_settime */
	/* 259 */	NULL, /* timer_gettime */
	/* 260 */	NULL, /* timer_getoverrun */
	/* 261 */	NULL, /* timer_delete */
	/* 262 */	NULL, /* clock_settime */
	/* 263 */	NULL, /* clock_gettime */
	/* 264 */	NULL, /* clock_getres */
	/* 265 */	NULL, /* clock_nanosleep */
	/* 266 */	NULL, /* statfs64 */
	/* 267 */	NULL, /* fstatfs64 */
	/* 268 */	NULL, /* tgkill */
	/* 269 */	NULL, /* utimes */
	/* 270 */	NULL, /* fadvise64_64 */
	/* 271 */	NULL, /* unimplemented pciconfig_iobase */
	/* 272 */	NULL, /* unimplemented pciconfig_read */
	/* 273 */	NULL, /* unimplemented pciconfig_write */
	/* 274 */	NULL, /* unimplemented mq_open */
	/* 275 */	NULL, /* unimplemented mq_unlink */
	/* 276 */	NULL, /* unimplemented mq_timedsend */
	/* 277 */	NULL, /* unimplemented mq_timedreceive */
	/* 278 */	NULL, /* unimplemented mq_notify */
	/* 279 */	NULL, /* unimplemented mq_getsetattr */
	/* 280 */	NULL, /* unimplemented waitid */
	/* 281 */	NULL, /* unimplemented socket */
	/* 282 */	NULL, /* unimplemented bind */
	/* 283 */	NULL, /* unimplemented connect */
	/* 284 */	NULL, /* unimplemented listen */
	/* 285 */	NULL, /* unimplemented accept */
	/* 286 */	NULL, /* unimplemented getsockname */
	/* 287 */	NULL, /* unimplemented getpeername */
	/* 288 */	NULL, /* unimplemented socketpair */
	/* 289 */	NULL, /* unimplemented send */
	/* 290 */	NULL, /* unimplemented sendto */
	/* 291 */	NULL, /* unimplemented recv */
	/* 292 */	NULL, /* unimplemented recvfrom */
	/* 293 */	NULL, /* unimplemented shutdown */
	/* 294 */	NULL, /* unimplemented setsockopt */
	/* 295 */	NULL, /* unimplemented getsockopt */
	/* 296 */	NULL, /* unimplemented sendmsg */
	/* 297 */	NULL, /* unimplemented recvmsg */
	/* 298 */	NULL, /* unimplemented semop */
	/* 299 */	NULL, /* unimplemented semget */
	/* 300 */	NULL, /* unimplemented semctl */
	/* 301 */	NULL, /* unimplemented msgsnd */
	/* 302 */	NULL, /* unimplemented msgrcv */
	/* 303 */	NULL, /* unimplemented msgget */
	/* 304 */	NULL, /* unimplemented msgctl */
	/* 305 */	NULL, /* unimplemented shmat */
	/* 306 */	NULL, /* unimplemented shmdt */
	/* 307 */	NULL, /* unimplemented shmget */
	/* 308 */	NULL, /* unimplemented shmctl */
	/* 309 */	NULL, /* unimplemented add_key */
	/* 310 */	NULL, /* unimplemented request_key */
	/* 311 */	NULL, /* unimplemented keyctl */
	/* 312 */	NULL, /* unimplemented semtimedop */
	/* 313 */	NULL, /* unimplemented vserver */
	/* 314 */	NULL, /* unimplemented ioptio_set */
	/* 315 */	NULL, /* unimplemented ioptio_get */
	/* 316 */	NULL, /* unimplemented inotify_init */
	/* 317 */	NULL, /* unimplemented inotify_add_watch */
	/* 318 */	NULL, /* unimplemented inotify_rm_watch */
	/* 319 */	NULL, /* unimplemented mbind */
	/* 320 */	NULL, /* unimplemented get_mempolicy */
	/* 321 */	NULL, /* unimplemented set_mempolicy */
	/* 322 */	NULL, /* openat */
	/* 323 */	NULL, /* mkdirat */
	/* 324 */	NULL, /* mknodat */
	/* 325 */	NULL, /* fchownat */
	/* 326 */	NULL, /* unimplemented futimesat */
	/* 327 */	NULL, /* fstatat64 */
	/* 328 */	NULL, /* unlinkat */
	/* 329 */	NULL, /* renameat */
	/* 330 */	NULL, /* linkat */
	/* 331 */	NULL, /* symlinkat */
	/* 332 */	NULL, /* readlinkat */
	/* 333 */	NULL, /* fchmodat */
	/* 334 */	NULL, /* faccessat */
	/* 335 */	NULL, /* pselect6 */
	/* 336 */	NULL, /* ppoll */
	/* 337 */	NULL, /* unimplemented unshare */
	/* 338 */	NULL, /* __futex_set_robust_list */
	/* 339 */	NULL, /* __futex_get_robust_list */
	/* 340 */	NULL, /* unimplemented splice */
	/* 341 */	NULL, /* unimplemented sync_file_range2 */
	/* 342 */	NULL, /* unimplemented tee */
	/* 343 */	NULL, /* unimplemented vmsplice */
	/* 344 */	NULL, /* unimplemented move_pages */
	/* 345 */	NULL, /* unimplemented getcpu */
	/* 346 */	NULL, /* unimplemented epoll_wait */
	/* 347 */	NULL, /* unimplemented kexec_load */
	/* 348 */	NULL, /* utimensat */
	/* 349 */	NULL, /* unimplemented signalfd */
	/* 350 */	NULL, /* timerfd_create */
	/* 351 */	NULL, /* eventfd */
	/* 352 */	NULL, /* fallocate */
	/* 353 */	NULL, /* timerfd_settime */
	/* 354 */	NULL, /* timerfd_gettime */
	/* 355 */	NULL, /* unimplemented signalfd4 */
	/* 356 */	NULL, /* eventfd2 */
	/* 357 */	NULL, /* unimplemented epoll_create1 */
	/* 358 */	NULL, /* dup3 */
	/* 359 */	NULL, /* pipe2 */
	/* 360 */	NULL, /* unimplemented inotify_init1 */
	/* 361 */	NULL, /* preadv */
	/* 362 */	NULL, /* pwritev */
	/* 363 */	NULL, /* unimplemented rt_tgsigqueueinfo */
	/* 364 */	NULL, /* unimplemented perf_counter_open */
	/* 365 */	NULL, /* recvmmsg */
	/* 366 */	NULL, /* accept4 */
	/* 367 */	NULL, /* unimplemented fanotify_init */
	/* 368 */	NULL, /* unimplemented fanotify_mark */
	/* 369 */	NULL, /* prlimit64 */
	/* 370 */	NULL, /* unimplemented name_to_handle_at */
	/* 371 */	NULL, /* unimplemented open_by_handle_at */
	/* 372 */	NULL, /* unimplemented clock_adjtime */
	/* 373 */	NULL, /* unimplemented syncfs */
	/* 374 */	NULL, /* sendmmsg */
	/* 375 */	NULL, /* unimplemented setns */
	/* 376 */	NULL, /* unimplemented process_vm_readv */
	/* 377 */	NULL, /* unimplemented process_vm_writev */
	/* 378 */	NULL, /* unimplemented kcmp */
	/* 379 */	NULL, /* unimplemented finit_module */
	/* 380 */	NULL, /* unimplemented sched_setattr */
	/* 381 */	NULL, /* unimplemented sched_getattr */
	/* 382 */	NULL, /* unimplemented renameat2 */
	/* 383 */	NULL, /* unimplemented seccomp */
	/* 384 */	NULL, /* unimplemented / * base * / */
	/* 385 */	NULL, /* breakpoint */
	/* 386 */	NULL, /* cacheflush */
	/* 387 */	NULL, /* unimplemented usr26 */
	/* 388 */	NULL, /* unimplemented usr32 */
	/* 389 */	NULL, /* set_tls */
	/* 390 */	NULL, /* filler */
	/* 391 */	NULL, /* filler */
	/* 392 */	NULL, /* filler */
	/* 393 */	NULL, /* filler */
	/* 394 */	NULL, /* filler */
	/* 395 */	NULL, /* filler */
	/* 396 */	NULL, /* filler */
	/* 397 */	NULL, /* filler */
	/* 398 */	NULL, /* filler */
	/* 399 */	NULL, /* filler */
	/* 400 */	NULL, /* filler */
	/* 401 */	NULL, /* filler */
	/* 402 */	NULL, /* filler */
	/* 403 */	NULL, /* filler */
	/* 404 */	NULL, /* filler */
	/* 405 */	NULL, /* filler */
	/* 406 */	NULL, /* filler */
	/* 407 */	NULL, /* filler */
	/* 408 */	NULL, /* filler */
	/* 409 */	NULL, /* filler */
	/* 410 */	NULL, /* filler */
	/* 411 */	NULL, /* filler */
	/* 412 */	NULL, /* filler */
	/* 413 */	NULL, /* filler */
	/* 414 */	NULL, /* filler */
	/* 415 */	NULL, /* filler */
	/* 416 */	NULL, /* filler */
	/* 417 */	NULL, /* filler */
	/* 418 */	NULL, /* filler */
	/* 419 */	NULL, /* filler */
	/* 420 */	NULL, /* filler */
	/* 421 */	NULL, /* filler */
	/* 422 */	NULL, /* filler */
	/* 423 */	NULL, /* filler */
	/* 424 */	NULL, /* filler */
	/* 425 */	NULL, /* filler */
	/* 426 */	NULL, /* filler */
	/* 427 */	NULL, /* filler */
	/* 428 */	NULL, /* filler */
	/* 429 */	NULL, /* filler */
	/* 430 */	NULL, /* filler */
	/* 431 */	NULL, /* filler */
	/* 432 */	NULL, /* filler */
	/* 433 */	NULL, /* filler */
	/* 434 */	NULL, /* filler */
	/* 435 */	NULL, /* filler */
	/* 436 */	NULL, /* filler */
	/* 437 */	NULL, /* filler */
	/* 438 */	NULL, /* filler */
	/* 439 */	NULL, /* filler */
	/* 440 */	NULL, /* filler */
	/* 441 */	NULL, /* filler */
	/* 442 */	NULL, /* filler */
	/* 443 */	NULL, /* filler */
	/* 444 */	NULL, /* filler */
	/* 445 */	NULL, /* filler */
	/* 446 */	NULL, /* filler */
	/* 447 */	NULL, /* filler */
	/* 448 */	NULL, /* filler */
	/* 449 */	NULL, /* filler */
	/* 450 */	NULL, /* filler */
	/* 451 */	NULL, /* filler */
	/* 452 */	NULL, /* filler */
	/* 453 */	NULL, /* filler */
	/* 454 */	NULL, /* filler */
	/* 455 */	NULL, /* filler */
	/* 456 */	NULL, /* filler */
	/* 457 */	NULL, /* filler */
	/* 458 */	NULL, /* filler */
	/* 459 */	NULL, /* filler */
	/* 460 */	NULL, /* filler */
	/* 461 */	NULL, /* filler */
	/* 462 */	NULL, /* filler */
	/* 463 */	NULL, /* filler */
	/* 464 */	NULL, /* filler */
	/* 465 */	NULL, /* filler */
	/* 466 */	NULL, /* filler */
	/* 467 */	NULL, /* filler */
	/* 468 */	NULL, /* filler */
	/* 469 */	NULL, /* filler */
	/* 470 */	NULL, /* filler */
	/* 471 */	NULL, /* filler */
	/* 472 */	NULL, /* filler */
	/* 473 */	NULL, /* filler */
	/* 474 */	NULL, /* filler */
	/* 475 */	NULL, /* filler */
	/* 476 */	NULL, /* filler */
	/* 477 */	NULL, /* filler */
	/* 478 */	NULL, /* filler */
	/* 479 */	NULL, /* filler */
	/* 480 */	NULL, /* filler */
	/* 481 */	NULL, /* filler */
	/* 482 */	NULL, /* filler */
	/* 483 */	NULL, /* filler */
	/* 484 */	NULL, /* filler */
	/* 485 */	NULL, /* filler */
	/* 486 */	NULL, /* filler */
	/* 487 */	NULL, /* filler */
	/* 488 */	NULL, /* filler */
	/* 489 */	NULL, /* filler */
	/* 490 */	NULL, /* filler */
	/* 491 */	NULL, /* filler */
	/* 492 */	NULL, /* filler */
	/* 493 */	NULL, /* filler */
	/* 494 */	NULL, /* filler */
	/* 495 */	NULL, /* filler */
	/* 496 */	NULL, /* filler */
	/* 497 */	NULL, /* filler */
	/* 498 */	NULL, /* filler */
	/* 499 */	NULL, /* filler */
	/* 500 */	NULL, /* filler */
	/* 501 */	NULL, /* filler */
	/* 502 */	NULL, /* filler */
	/* 503 */	NULL, /* filler */
	/* 504 */	NULL, /* filler */
	/* 505 */	NULL, /* filler */
	/* 506 */	NULL, /* filler */
	/* 507 */	NULL, /* filler */
	/* 508 */	NULL, /* filler */
	/* 509 */	NULL, /* filler */
	/* 510 */	NULL, /* filler */
	/* 511 */	NULL, /* filler */
};
