/*	$NetBSD: rk3588_cru.h,v 1.1 2022/08/23 05:39:06 ryo Exp $	*/

/*-
 * Copyright (c) 2022 Ryo Shimizu <ryo@nerv.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _RK3588_CRU_H_
#define _RK3588_CRU_H_

#define RK3588_PLL_B0PLL			1
#define RK3588_PLL_B1PLL			2
#define RK3588_PLL_LPLL				3
#define RK3588_PLL_V0PLL			4
#define RK3588_PLL_AUPLL			5
#define RK3588_PLL_CPLL				6
#define RK3588_PLL_GPLL				7
#define RK3588_PLL_NPLL				8
#define RK3588_PLL_PPLL				9
#define RK3588_ARMCLK_L				10
#define RK3588_ARMCLK_B01			11
#define RK3588_ARMCLK_B23			12
/* 13 */
/* 14 */
/* 15 */
/* 16 */
/* 17 */
/* 18 */
/* 19 */
#define RK3588_PCLK_BIGCORE0_ROOT		20
#define RK3588_PCLK_BIGCORE0_PVTM		21
#define RK3588_PCLK_BIGCORE1_ROOT		22
#define RK3588_PCLK_BIGCORE1_PVTM		23
#define RK3588_PCLK_DSU_S_ROOT			24
#define RK3588_PCLK_DSU_ROOT			25
#define RK3588_PCLK_DSU_NS_ROOT			26
#define RK3588_PCLK_LITCORE_PVTM		27
#define RK3588_PCLK_DBG				28
#define RK3588_PCLK_DSU				29
#define RK3588_PCLK_S_DAPLITE			30
#define RK3588_PCLK_M_DAPLITE			31
#define RK3588_MBIST_MCLK_PDM1			32
#define RK3588_MBIST_CLK_ACDCDIG		33
#define RK3588_HCLK_I2S2_2CH			34
#define RK3588_HCLK_I2S3_2CH			35
#define RK3588_CLK_I2S2_2CH_SRC			36
#define RK3588_CLK_I2S2_2CH_FRAC		37
#define RK3588_CLK_I2S2_2CH			38
#define RK3588_MCLK_I2S2_2CH			39
#define RK3588_I2S2_2CH_MCLKOUT			40
#define RK3588_CLK_DAC_ACDCDIG			41
#define RK3588_CLK_I2S3_2CH_SRC			42
#define RK3588_CLK_I2S3_2CH_FRAC		43
#define RK3588_CLK_I2S3_2CH			44
#define RK3588_MCLK_I2S3_2CH			45
#define RK3588_I2S3_2CH_MCLKOUT			46
#define RK3588_PCLK_ACDCDIG			47
#define RK3588_HCLK_I2S0_8CH			48
#define RK3588_CLK_I2S0_8CH_TX_SRC		49
#define RK3588_CLK_I2S0_8CH_TX_FRAC		50
#define RK3588_MCLK_I2S0_8CH_TX			51
#define RK3588_CLK_I2S0_8CH_TX			52
#define RK3588_CLK_I2S0_8CH_RX_SRC		53
#define RK3588_CLK_I2S0_8CH_RX_FRAC		54
#define RK3588_MCLK_I2S0_8CH_RX			55
#define RK3588_CLK_I2S0_8CH_RX			56
#define RK3588_I2S0_8CH_MCLKOUT			57
#define RK3588_HCLK_PDM1			58
#define RK3588_MCLK_PDM1			59
#define RK3588_HCLK_AUDIO_ROOT			60
#define RK3588_PCLK_AUDIO_ROOT			61
#define RK3588_HCLK_SPDIF0			62
#define RK3588_CLK_SPDIF0_SRC			63
#define RK3588_CLK_SPDIF0_FRAC			64
#define RK3588_MCLK_SPDIF0			65
#define RK3588_CLK_SPDIF0			66
#define RK3588_CLK_SPDIF1			67
#define RK3588_HCLK_SPDIF1			68
#define RK3588_CLK_SPDIF1_SRC			69
#define RK3588_CLK_SPDIF1_FRAC			70
#define RK3588_MCLK_SPDIF1			71
#define RK3588_ACLK_AV1_ROOT			72
#define RK3588_ACLK_AV1				73
#define RK3588_PCLK_AV1_ROOT			74
#define RK3588_PCLK_AV1				75
#define RK3588_PCLK_MAILBOX0			76
#define RK3588_PCLK_MAILBOX1			77
#define RK3588_PCLK_MAILBOX2			78
#define RK3588_PCLK_PMU2			79
#define RK3588_PCLK_PMUCM0_INTMUX		80
#define RK3588_PCLK_DDRCM0_INTMUX		81
#define RK3588_PCLK_TOP				82
#define RK3588_PCLK_PWM1			83
#define RK3588_CLK_PWM1				84
#define RK3588_CLK_PWM1_CAPTURE			85
#define RK3588_PCLK_PWM2			86
#define RK3588_CLK_PWM2				87
#define RK3588_CLK_PWM2_CAPTURE			88
#define RK3588_PCLK_PWM3			89
#define RK3588_CLK_PWM3				90
#define RK3588_CLK_PWM3_CAPTURE			91
#define RK3588_PCLK_BUSTIMER0			92
#define RK3588_PCLK_BUSTIMER1			93
#define RK3588_CLK_BUS_TIMER_ROOT		94
#define RK3588_CLK_BUSTIMER0			95
#define RK3588_CLK_BUSTIMER1			96
#define RK3588_CLK_BUSTIMER2			97
#define RK3588_CLK_BUSTIMER3			98
#define RK3588_CLK_BUSTIMER4			99
#define RK3588_CLK_BUSTIMER5			100
#define RK3588_CLK_BUSTIMER6			101
#define RK3588_CLK_BUSTIMER7			102
#define RK3588_CLK_BUSTIMER8			103
#define RK3588_CLK_BUSTIMER9			104
#define RK3588_CLK_BUSTIMER10			105
#define RK3588_CLK_BUSTIMER11			106
#define RK3588_PCLK_WDT0			107
#define RK3588_TCLK_WDT0			108
/* 109 */
/* 110 */
#define RK3588_PCLK_CAN0			111
#define RK3588_CLK_CAN0				112
#define RK3588_PCLK_CAN1			113
#define RK3588_CLK_CAN1				114
#define RK3588_PCLK_CAN2			115
#define RK3588_CLK_CAN2				116
#define RK3588_ACLK_DECOM			117
#define RK3588_PCLK_DECOM			118
#define RK3588_DCLK_DECOM			119
#define RK3588_ACLK_DMAC0			120
#define RK3588_ACLK_DMAC1			121
#define RK3588_ACLK_DMAC2			122
#define RK3588_ACLK_BUS_ROOT			123
#define RK3588_ACLK_GIC				124
#define RK3588_PCLK_GPIO1			125
#define RK3588_DBCLK_GPIO1			126
#define RK3588_PCLK_GPIO2			127
#define RK3588_DBCLK_GPIO2			128
#define RK3588_PCLK_GPIO3			129
#define RK3588_DBCLK_GPIO3			130
#define RK3588_PCLK_GPIO4			131
#define RK3588_DBCLK_GPIO4			132
#define RK3588_PCLK_I2C1			133
#define RK3588_PCLK_I2C2			134
#define RK3588_PCLK_I2C3			135
#define RK3588_PCLK_I2C4			136
#define RK3588_PCLK_I2C5			137
#define RK3588_PCLK_I2C6			138
#define RK3588_PCLK_I2C7			139
#define RK3588_PCLK_I2C8			140
#define RK3588_CLK_I2C1				141
#define RK3588_CLK_I2C2				142
#define RK3588_CLK_I2C3				143
#define RK3588_CLK_I2C4				144
#define RK3588_CLK_I2C5				145
#define RK3588_CLK_I2C6				146
#define RK3588_CLK_I2C7				147
#define RK3588_CLK_I2C8				148
#define RK3588_PCLK_OTPC_NS			149
#define RK3588_CLK_OTPC_NS			150
#define RK3588_CLK_OTPC_ARB			151
#define RK3588_CLK_OTPC_AUTO_RD_G		152
#define RK3588_CLK_OTP_PHY_G			153
/* 154 */
/* 155 */
#define RK3588_PCLK_SARADC			156
#define RK3588_CLK_SARADC			157
#define RK3588_PCLK_SPI0			158
#define RK3588_PCLK_SPI1			159
#define RK3588_PCLK_SPI2			160
#define RK3588_PCLK_SPI3			161
#define RK3588_PCLK_SPI4			162
#define RK3588_CLK_SPI0				163
#define RK3588_CLK_SPI1				164
#define RK3588_CLK_SPI2				165
#define RK3588_CLK_SPI3				166
#define RK3588_CLK_SPI4				167
#define RK3588_ACLK_SPINLOCK			168
#define RK3588_PCLK_TSADC			169
#define RK3588_CLK_TSADC			170
#define RK3588_PCLK_UART1			171
#define RK3588_PCLK_UART2			172
#define RK3588_PCLK_UART3			173
#define RK3588_PCLK_UART4			174
#define RK3588_PCLK_UART5			175
#define RK3588_PCLK_UART6			176
#define RK3588_PCLK_UART7			177
#define RK3588_PCLK_UART8			178
#define RK3588_PCLK_UART9			179
#define RK3588_CLK_UART1_SRC			180
#define RK3588_CLK_UART1_FRAC			181
#define RK3588_CLK_UART1			182
#define RK3588_SCLK_UART1			183
#define RK3588_CLK_UART2_SRC			184
#define RK3588_CLK_UART2_FRAC			185
#define RK3588_CLK_UART2			186
#define RK3588_SCLK_UART2			187
#define RK3588_CLK_UART3_SRC			188
#define RK3588_CLK_UART3_FRAC			189
#define RK3588_CLK_UART3			190
#define RK3588_SCLK_UART3			191
#define RK3588_CLK_UART4_SRC			192
#define RK3588_CLK_UART4_FRAC			193
#define RK3588_CLK_UART4			194
#define RK3588_SCLK_UART4			195
#define RK3588_CLK_UART5_SRC			196
#define RK3588_CLK_UART5_FRAC			197
#define RK3588_CLK_UART5			198
#define RK3588_SCLK_UART5			199
#define RK3588_CLK_UART6_SRC			200
#define RK3588_CLK_UART6_FRAC			201
#define RK3588_CLK_UART6			202
#define RK3588_SCLK_UART6			203
#define RK3588_CLK_UART7_SRC			204
#define RK3588_CLK_UART7_FRAC			205
#define RK3588_CLK_UART7			206
#define RK3588_SCLK_UART7			207
#define RK3588_CLK_UART8_SRC			208
#define RK3588_CLK_UART8_FRAC			209
#define RK3588_CLK_UART8			210
#define RK3588_SCLK_UART8			211
#define RK3588_CLK_UART9_SRC			212
#define RK3588_CLK_UART9_FRAC			213
#define RK3588_CLK_UART9			214
#define RK3588_SCLK_UART9			215
#define RK3588_ACLK_CENTER_ROOT			216
#define RK3588_ACLK_CENTER_LOW_ROOT		217
#define RK3588_HCLK_CENTER_ROOT			218
#define RK3588_PCLK_CENTER_ROOT			219
#define RK3588_ACLK_DMA2DDR			220
#define RK3588_ACLK_DDR_SHAREMEM		221
#define RK3588_ACLK_CENTER_S200_ROOT		222
#define RK3588_ACLK_CENTER_S400_ROOT		223
#define RK3588_FCLK_DDR_CM0_CORE		224
#define RK3588_CLK_DDR_TIMER_ROOT		225
#define RK3588_CLK_DDR_TIMER0			226
#define RK3588_CLK_DDR_TIMER1			227
#define RK3588_TCLK_WDT_DDR			228
#define RK3588_CLK_DDR_CM0_RTC			228	/* dup */
/* 229 */
#define RK3588_PCLK_WDT				230
#define RK3588_PCLK_TIMER			231
#define RK3588_PCLK_DMA2DDR			232
#define RK3588_PCLK_SHAREMEM			233
#define RK3588_CLK_50M_SRC			234
#define RK3588_CLK_100M_SRC			235
#define RK3588_CLK_150M_SRC			236
#define RK3588_CLK_200M_SRC			237
#define RK3588_CLK_250M_SRC			238
#define RK3588_CLK_300M_SRC			239
#define RK3588_CLK_350M_SRC			240
#define RK3588_CLK_400M_SRC			241
#define RK3588_CLK_450M_SRC			242
#define RK3588_CLK_500M_SRC			243
#define RK3588_CLK_600M_SRC			244
#define RK3588_CLK_650M_SRC			245
#define RK3588_CLK_700M_SRC			246
#define RK3588_CLK_800M_SRC			247
#define RK3588_CLK_1000M_SRC			248
#define RK3588_CLK_1200M_SRC			249
#define RK3588_ACLK_TOP_M300_ROOT		250
#define RK3588_ACLK_TOP_M500_ROOT		251
#define RK3588_ACLK_TOP_M400_ROOT		252
#define RK3588_ACLK_TOP_S200_ROOT		253
#define RK3588_ACLK_TOP_S400_ROOT		254
#define RK3588_CLK_MIPI_CAMARAOUT_M0		255
#define RK3588_CLK_MIPI_CAMARAOUT_M1		256
#define RK3588_CLK_MIPI_CAMARAOUT_M2		257
#define RK3588_CLK_MIPI_CAMARAOUT_M3		258
#define RK3588_CLK_MIPI_CAMARAOUT_M4		259
#define RK3588_MCLK_GMAC0_OUT			260
#define RK3588_REFCLKO25M_ETH0_OUT		261
#define RK3588_REFCLKO25M_ETH1_OUT		262
#define RK3588_CLK_CIFOUT_OUT			263
#define RK3588_PCLK_MIPI_DCPHY0			264
#define RK3588_PCLK_MIPI_DCPHY1			265
/* 266 */
/* 267 */
#define RK3588_PCLK_CSIPHY0			268
#define RK3588_PCLK_CSIPHY1			269
#define RK3588_ACLK_TOP_ROOT			270
#define RK3588_PCLK_TOP_ROOT			271
#define RK3588_ACLK_LOW_TOP_ROOT		272
#define RK3588_PCLK_CRU				273
#define RK3588_PCLK_GPU_ROOT			274
#define RK3588_CLK_GPU_SRC			275
#define RK3588_CLK_GPU				276
#define RK3588_CLK_GPU_COREGROUP		277
#define RK3588_CLK_GPU_STACKS			278
#define RK3588_PCLK_GPU_PVTM			279
#define RK3588_CLK_GPU_PVTM			280
#define RK3588_CLK_CORE_GPU_PVTM		281
#define RK3588_PCLK_GPU_GRF			282
#define RK3588_ACLK_ISP1_ROOT			283
#define RK3588_HCLK_ISP1_ROOT			284
#define RK3588_CLK_ISP1_CORE			285
#define RK3588_CLK_ISP1_CORE_MARVIN		286
#define RK3588_CLK_ISP1_CORE_VICAP		287
#define RK3588_ACLK_ISP1			288
#define RK3588_HCLK_ISP1			289
#define RK3588_ACLK_NPU1			290
#define RK3588_HCLK_NPU1			291
#define RK3588_ACLK_NPU2			292
#define RK3588_HCLK_NPU2			293
#define RK3588_HCLK_NPU_CM0_ROOT		294
#define RK3588_FCLK_NPU_CM0_CORE		295
#define RK3588_CLK_NPU_CM0_RTC			296
#define RK3588_PCLK_NPU_PVTM			297
#define RK3588_PCLK_NPU_GRF			298
#define RK3588_CLK_NPU_PVTM			299
#define RK3588_CLK_CORE_NPU_PVTM		300
#define RK3588_ACLK_NPU0			301
#define RK3588_HCLK_NPU0			302
#define RK3588_HCLK_NPU_ROOT			303
#define RK3588_CLK_NPU_DSU0			304
#define RK3588_PCLK_NPU_ROOT			305
#define RK3588_PCLK_NPU_TIMER			306
#define RK3588_CLK_NPUTIMER_ROOT		307
#define RK3588_CLK_NPUTIMER0			308
#define RK3588_CLK_NPUTIMER1			309
#define RK3588_PCLK_NPU_WDT			310
#define RK3588_TCLK_NPU_WDT			311
#define RK3588_HCLK_EMMC			312
#define RK3588_ACLK_EMMC			313
#define RK3588_CCLK_EMMC			314
#define RK3588_BCLK_EMMC			315
#define RK3588_TMCLK_EMMC			316
#define RK3588_SCLK_SFC				317
#define RK3588_HCLK_SFC				318
#define RK3588_HCLK_SFC_XIP			319
#define RK3588_HCLK_NVM_ROOT			320
#define RK3588_ACLK_NVM_ROOT			321
#define RK3588_CLK_GMAC0_PTP_REF		322
#define RK3588_CLK_GMAC1_PTP_REF		323
#define RK3588_CLK_GMAC_125M			324
#define RK3588_CLK_GMAC_50M			325
#define RK3588_ACLK_PHP_GIC_ITS			326
#define RK3588_ACLK_MMU_PCIE			327
#define RK3588_ACLK_MMU_PHP			328
#define RK3588_ACLK_PCIE_4L_DBI			329
#define RK3588_ACLK_PCIE_2L_DBI			330
#define RK3588_ACLK_PCIE_1L0_DBI		331
#define RK3588_ACLK_PCIE_1L1_DBI		332
#define RK3588_ACLK_PCIE_1L2_DBI		333
#define RK3588_ACLK_PCIE_4L_MSTR		334
#define RK3588_ACLK_PCIE_2L_MSTR		335
#define RK3588_ACLK_PCIE_1L0_MSTR		336
#define RK3588_ACLK_PCIE_1L1_MSTR		337
#define RK3588_ACLK_PCIE_1L2_MSTR		338
#define RK3588_ACLK_PCIE_4L_SLV			339
#define RK3588_ACLK_PCIE_2L_SLV			340
#define RK3588_ACLK_PCIE_1L0_SLV		341
#define RK3588_ACLK_PCIE_1L1_SLV		342
#define RK3588_ACLK_PCIE_1L2_SLV		343
#define RK3588_PCLK_PCIE_4L			344
#define RK3588_PCLK_PCIE_2L			345
/* 346 */
#define RK3588_PCLK_PCIE_1L0			347
#define RK3588_PCLK_PCIE_1L1			348
#define RK3588_PCLK_PCIE_1L2			349
#define RK3588_CLK_PCIE_AUX0			350
#define RK3588_CLK_PCIE_AUX1			351
#define RK3588_CLK_PCIE_AUX2			352
#define RK3588_CLK_PCIE_AUX3			353
#define RK3588_CLK_PCIE_AUX4			354
#define RK3588_CLK_PIPEPHY0_REF			355
#define RK3588_CLK_PIPEPHY1_REF			356
#define RK3588_CLK_PIPEPHY2_REF			357
#define RK3588_PCLK_PHP_ROOT			358
#define RK3588_PCLK_GMAC0			359
#define RK3588_PCLK_GMAC1			360
#define RK3588_ACLK_PCIE_ROOT			361
#define RK3588_ACLK_PHP_ROOT			362
#define RK3588_ACLK_PCIE_BRIDGE			363
#define RK3588_ACLK_GMAC0			364
#define RK3588_ACLK_GMAC1			365
#define RK3588_CLK_PMALIVE0			366
#define RK3588_CLK_PMALIVE1			367
#define RK3588_CLK_PMALIVE2			368
#define RK3588_ACLK_SATA0			369
#define RK3588_ACLK_SATA1			370
#define RK3588_ACLK_SATA2			371
#define RK3588_CLK_RXOOB0			372
#define RK3588_CLK_RXOOB1			373
#define RK3588_CLK_RXOOB2			374
#define RK3588_ACLK_USB3OTG2			375
#define RK3588_SUSPEND_CLK_USB3OTG2		376
#define RK3588_REF_CLK_USB3OTG2			377
#define RK3588_CLK_UTMI_OTG2			378
#define RK3588_CLK_PIPEPHY0_PIPE_G		379
#define RK3588_CLK_PIPEPHY1_PIPE_G		380
#define RK3588_CLK_PIPEPHY2_PIPE_G		381
#define RK3588_CLK_PIPEPHY0_PIPE_ASIC_G		382
#define RK3588_CLK_PIPEPHY1_PIPE_ASIC_G		383
#define RK3588_CLK_PIPEPHY2_PIPE_ASIC_G		384
#define RK3588_CLK_PIPEPHY2_PIPE_U3_G		385
#define RK3588_CLK_PCIE1L2_PIPE			386
#define RK3588_CLK_PCIE4L_PIPE			387
#define RK3588_CLK_PCIE2L_PIPE			388
#define RK3588_PCLK_PCIE_COMBO_PIPE_PHY0	389
#define RK3588_PCLK_PCIE_COMBO_PIPE_PHY1	390
#define RK3588_PCLK_PCIE_COMBO_PIPE_PHY2	391
#define RK3588_PCLK_PCIE_COMBO_PIPE_PHY		392
#define RK3588_HCLK_RGA3_1			393
#define RK3588_ACLK_RGA3_1			394
#define RK3588_CLK_RGA3_1_CORE			395
#define RK3588_ACLK_RGA3_ROOT			396
#define RK3588_HCLK_RGA3_ROOT			397
#define RK3588_ACLK_RKVDEC_CCU			398
#define RK3588_HCLK_RKVDEC0			399
#define RK3588_ACLK_RKVDEC0			400
#define RK3588_CLK_RKVDEC0_CA			401
#define RK3588_CLK_RKVDEC0_HEVC_CA		402
#define RK3588_CLK_RKVDEC0_CORE			403
#define RK3588_HCLK_RKVDEC1			404
#define RK3588_ACLK_RKVDEC1			405
#define RK3588_CLK_RKVDEC1_CA			406
#define RK3588_CLK_RKVDEC1_HEVC_CA		407
#define RK3588_CLK_RKVDEC1_CORE			408
#define RK3588_HCLK_SDIO			409
#define RK3588_CCLK_SRC_SDIO			410
#define RK3588_ACLK_USB_ROOT			411
#define RK3588_HCLK_USB_ROOT			412
#define RK3588_HCLK_HOST0			413
#define RK3588_HCLK_HOST_ARB0			414
#define RK3588_HCLK_HOST1			415
#define RK3588_HCLK_HOST_ARB1			416
#define RK3588_ACLK_USB3OTG0			417
#define RK3588_SUSPEND_CLK_USB3OTG0		418
#define RK3588_REF_CLK_USB3OTG0			419
#define RK3588_ACLK_USB3OTG1			420
#define RK3588_SUSPEND_CLK_USB3OTG1		421
#define RK3588_REF_CLK_USB3OTG1			422
#define RK3588_UTMI_OHCI_CLK48_HOST0		423
#define RK3588_UTMI_OHCI_CLK48_HOST1		424
#define RK3588_HCLK_IEP2P0			425
#define RK3588_ACLK_IEP2P0			426
#define RK3588_CLK_IEP2P0_CORE			427
#define RK3588_ACLK_JPEG_ENCODER0		428
#define RK3588_HCLK_JPEG_ENCODER0		429
#define RK3588_ACLK_JPEG_ENCODER1		430
#define RK3588_HCLK_JPEG_ENCODER1		431
#define RK3588_ACLK_JPEG_ENCODER2		432
#define RK3588_HCLK_JPEG_ENCODER2		433
#define RK3588_ACLK_JPEG_ENCODER3		434
#define RK3588_HCLK_JPEG_ENCODER3		435
#define RK3588_ACLK_JPEG_DECODER		436
#define RK3588_HCLK_JPEG_DECODER		437
#define RK3588_HCLK_RGA2			438
#define RK3588_ACLK_RGA2			439
#define RK3588_CLK_RGA2_CORE			440
#define RK3588_HCLK_RGA3_0			441
#define RK3588_ACLK_RGA3_0			442
#define RK3588_CLK_RGA3_0_CORE			443
#define RK3588_ACLK_VDPU_ROOT			444
#define RK3588_ACLK_VDPU_LOW_ROOT		445
#define RK3588_HCLK_VDPU_ROOT			446
#define RK3588_ACLK_JPEG_DECODER_ROOT		447
#define RK3588_ACLK_VPU				448
#define RK3588_HCLK_VPU				449
#define RK3588_HCLK_RKVENC0_ROOT		450
#define RK3588_ACLK_RKVENC0_ROOT		451
#define RK3588_HCLK_RKVENC0			452
#define RK3588_ACLK_RKVENC0			453
#define RK3588_CLK_RKVENC0_CORE			454
#define RK3588_HCLK_RKVENC1_ROOT		455
#define RK3588_ACLK_RKVENC1_ROOT		456
#define RK3588_HCLK_RKVENC1			457
#define RK3588_ACLK_RKVENC1			458
#define RK3588_CLK_RKVENC1_CORE			459
#define RK3588_ICLK_CSIHOST01			460
#define RK3588_ICLK_CSIHOST0			461
#define RK3588_ICLK_CSIHOST1			462
#define RK3588_PCLK_CSI_HOST_0			463
#define RK3588_PCLK_CSI_HOST_1			464
#define RK3588_PCLK_CSI_HOST_2			465
#define RK3588_PCLK_CSI_HOST_3			466
#define RK3588_PCLK_CSI_HOST_4			467
#define RK3588_PCLK_CSI_HOST_5			468
#define RK3588_ACLK_FISHEYE0			469
#define RK3588_HCLK_FISHEYE0			470
#define RK3588_CLK_FISHEYE0_CORE		471
#define RK3588_ACLK_FISHEYE1			472
#define RK3588_HCLK_FISHEYE1			473
#define RK3588_CLK_FISHEYE1_CORE		474
#define RK3588_CLK_ISP0_CORE			475
#define RK3588_CLK_ISP0_CORE_MARVIN		476
#define RK3588_CLK_ISP0_CORE_VICAP		477
#define RK3588_ACLK_ISP0			478
#define RK3588_HCLK_ISP0			479
#define RK3588_ACLK_VI_ROOT			480
#define RK3588_HCLK_VI_ROOT			481
#define RK3588_PCLK_VI_ROOT			482
#define RK3588_DCLK_VICAP			483
#define RK3588_ACLK_VICAP			484
#define RK3588_HCLK_VICAP			485
#define RK3588_PCLK_DP0				486
#define RK3588_PCLK_DP1				487
#define RK3588_PCLK_S_DP0			488
#define RK3588_PCLK_S_DP1			489
#define RK3588_CLK_DP0				490
#define RK3588_CLK_DP1				491
#define RK3588_HCLK_HDCP_KEY0			492
#define RK3588_ACLK_HDCP0			493
#define RK3588_HCLK_HDCP0			494
#define RK3588_PCLK_HDCP0			495
#define RK3588_HCLK_I2S4_8CH			496
#define RK3588_ACLK_TRNG0			497
#define RK3588_PCLK_TRNG0			498
#define RK3588_ACLK_VO0_ROOT			499
#define RK3588_HCLK_VO0_ROOT			500
#define RK3588_HCLK_VO0_S_ROOT			501
#define RK3588_PCLK_VO0_ROOT			502
#define RK3588_PCLK_VO0_S_ROOT			503
#define RK3588_PCLK_VO0GRF			504
#define RK3588_CLK_I2S4_8CH_TX_SRC		505
#define RK3588_CLK_I2S4_8CH_TX_FRAC		506
#define RK3588_MCLK_I2S4_8CH_TX			507
#define RK3588_CLK_I2S4_8CH_TX			508
/* 509 */
#define RK3588_HCLK_I2S8_8CH			510
#define RK3588_CLK_I2S8_8CH_TX_SRC		511
#define RK3588_CLK_I2S8_8CH_TX_FRAC		512
#define RK3588_MCLK_I2S8_8CH_TX			513
#define RK3588_CLK_I2S8_8CH_TX			514
/* 515 */
#define RK3588_HCLK_SPDIF2_DP0			516
#define RK3588_CLK_SPDIF2_DP0_SRC		517
#define RK3588_CLK_SPDIF2_DP0_FRAC		518
#define RK3588_MCLK_SPDIF2_DP0			519
#define RK3588_CLK_SPDIF2_DP0			520
#define RK3588_MCLK_SPDIF2			521
#define RK3588_HCLK_SPDIF5_DP1			522
#define RK3588_CLK_SPDIF5_DP1_SRC		523
#define RK3588_CLK_SPDIF5_DP1_FRAC		524
#define RK3588_MCLK_SPDIF5_DP1			525
#define RK3588_CLK_SPDIF5_DP1			526
#define RK3588_MCLK_SPDIF5			527
#define RK3588_PCLK_EDP0			528
#define RK3588_CLK_EDP0_24M			529
#define RK3588_CLK_EDP0_200M			530
#define RK3588_PCLK_EDP1			531
#define RK3588_CLK_EDP1_24M			532
#define RK3588_CLK_EDP1_200M			533
#define RK3588_HCLK_HDCP_KEY1			534
#define RK3588_ACLK_HDCP1			535
#define RK3588_HCLK_HDCP1			536
#define RK3588_PCLK_HDCP1			537
#define RK3588_ACLK_HDMIRX			538
#define RK3588_PCLK_HDMIRX			539
#define RK3588_CLK_HDMIRX_REF			540
#define RK3588_CLK_HDMIRX_AUD_SRC		541
#define RK3588_CLK_HDMIRX_AUD_FRAC		542
#define RK3588_CLK_HDMIRX_AUD			543
#define RK3588_CLK_HDMIRX_AUD_P_MUX		544
#define RK3588_PCLK_HDMITX0			545
#define RK3588_CLK_HDMITX0_EARC			546
#define RK3588_CLK_HDMITX0_REF			547
#define RK3588_PCLK_HDMITX1			548
#define RK3588_CLK_HDMITX1_EARC			549
#define RK3588_CLK_HDMITX1_REF			550
#define RK3588_CLK_HDMITRX_REFSRC		551
#define RK3588_ACLK_TRNG1			552
#define RK3588_PCLK_TRNG1			553
#define RK3588_ACLK_HDCP1_ROOT			554
#define RK3588_ACLK_HDMIRX_ROOT			555
#define RK3588_HCLK_VO1_ROOT			556
#define RK3588_HCLK_VO1_S_ROOT			557
#define RK3588_PCLK_VO1_ROOT			558
#define RK3588_PCLK_VO1_S_ROOT			559
#define RK3588_PCLK_S_EDP0			560
#define RK3588_PCLK_S_EDP1			561
#define RK3588_PCLK_S_HDMIRX			562
#define RK3588_HCLK_I2S10_8CH			563
#define RK3588_CLK_I2S10_8CH_RX_SRC		564
#define RK3588_CLK_I2S10_8CH_RX_FRAC		565
#define RK3588_CLK_I2S10_8CH_RX			566
#define RK3588_MCLK_I2S10_8CH_RX		567
#define RK3588_HCLK_I2S7_8CH			568
#define RK3588_CLK_I2S7_8CH_RX_SRC		569
#define RK3588_CLK_I2S7_8CH_RX_FRAC		570
#define RK3588_CLK_I2S7_8CH_RX			571
#define RK3588_MCLK_I2S7_8CH_RX			572
/* 573 */
#define RK3588_HCLK_I2S9_8CH			574
#define RK3588_CLK_I2S9_8CH_RX_SRC		575
#define RK3588_CLK_I2S9_8CH_RX_FRAC		576
#define RK3588_CLK_I2S9_8CH_RX			577
#define RK3588_MCLK_I2S9_8CH_RX			578
#define RK3588_CLK_I2S5_8CH_TX_SRC		579
#define RK3588_CLK_I2S5_8CH_TX_FRAC		580
#define RK3588_CLK_I2S5_8CH_TX			581
#define RK3588_MCLK_I2S5_8CH_TX			582
/* 583 */
#define RK3588_HCLK_I2S5_8CH			584
#define RK3588_CLK_I2S6_8CH_TX_SRC		585
#define RK3588_CLK_I2S6_8CH_TX_FRAC		586
#define RK3588_CLK_I2S6_8CH_TX			587
#define RK3588_MCLK_I2S6_8CH_TX			588
#define RK3588_CLK_I2S6_8CH_RX_SRC		589
#define RK3588_CLK_I2S6_8CH_RX_FRAC		590
#define RK3588_CLK_I2S6_8CH_RX			591
#define RK3588_MCLK_I2S6_8CH_RX			592
#define RK3588_I2S6_8CH_MCLKOUT			593
#define RK3588_HCLK_I2S6_8CH			594
#define RK3588_HCLK_SPDIF3			595
#define RK3588_CLK_SPDIF3_SRC			596
#define RK3588_CLK_SPDIF3_FRAC			597
#define RK3588_CLK_SPDIF3			598
#define RK3588_MCLK_SPDIF3			599
#define RK3588_HCLK_SPDIF4			600
#define RK3588_CLK_SPDIF4_SRC			601
#define RK3588_CLK_SPDIF4_FRAC			602
#define RK3588_CLK_SPDIF4			603
#define RK3588_MCLK_SPDIF4			604
#define RK3588_HCLK_SPDIFRX0			605
#define RK3588_MCLK_SPDIFRX0			606
#define RK3588_HCLK_SPDIFRX1			607
#define RK3588_MCLK_SPDIFRX1			608
#define RK3588_HCLK_SPDIFRX2			609
#define RK3588_MCLK_SPDIFRX2			610
#define RK3588_ACLK_VO1USB_TOP_ROOT		611
#define RK3588_HCLK_VO1USB_TOP_ROOT		612
#define RK3588_CLK_HDMIHDP0			613
#define RK3588_CLK_HDMIHDP1			614
#define RK3588_PCLK_HDPTX0			615
#define RK3588_PCLK_HDPTX1			616
#define RK3588_PCLK_USBDPPHY0			617
#define RK3588_PCLK_USBDPPHY1			618
#define RK3588_ACLK_VOP_ROOT			619
#define RK3588_ACLK_VOP_LOW_ROOT		620
#define RK3588_HCLK_VOP_ROOT			621
#define RK3588_PCLK_VOP_ROOT			622
#define RK3588_HCLK_VOP				623
#define RK3588_ACLK_VOP				624
#define RK3588_DCLK_VOP0_SRC			625
#define RK3588_DCLK_VOP1_SRC			626
#define RK3588_DCLK_VOP2_SRC			627
#define RK3588_DCLK_VOP0			628
#define RK3588_DCLK_VOP1			629
#define RK3588_DCLK_VOP2			630
#define RK3588_DCLK_VOP3			631
#define RK3588_PCLK_DSIHOST0			632
#define RK3588_PCLK_DSIHOST1			633
#define RK3588_CLK_DSIHOST0			634
#define RK3588_CLK_DSIHOST1			635
#define RK3588_CLK_VOP_PMU			636
#define RK3588_ACLK_VOP_DOBY			637
#define RK3588_ACLK_VOP_SUB_SRC			638
#define RK3588_CLK_USBDP_PHY0_IMMORTAL		639
#define RK3588_CLK_USBDP_PHY1_IMMORTAL		640
#define RK3588_CLK_PMU0				641
#define RK3588_PCLK_PMU0			642
#define RK3588_PCLK_PMU0IOC			643
#define RK3588_PCLK_GPIO0			644
#define RK3588_DBCLK_GPIO0			645
#define RK3588_PCLK_I2C0			646
#define RK3588_CLK_I2C0				647
#define RK3588_HCLK_I2S1_8CH			648
#define RK3588_CLK_I2S1_8CH_TX_SRC		649
#define RK3588_CLK_I2S1_8CH_TX_FRAC		650
#define RK3588_CLK_I2S1_8CH_TX			651
#define RK3588_MCLK_I2S1_8CH_TX			652
#define RK3588_CLK_I2S1_8CH_RX_SRC		653
#define RK3588_CLK_I2S1_8CH_RX_FRAC		654
#define RK3588_CLK_I2S1_8CH_RX			655
#define RK3588_MCLK_I2S1_8CH_RX			656
#define RK3588_I2S1_8CH_MCLKOUT			657
#define RK3588_CLK_PMU1_50M_SRC			658
#define RK3588_CLK_PMU1_100M_SRC		659
#define RK3588_CLK_PMU1_200M_SRC		660
#define RK3588_CLK_PMU1_300M_SRC		661
#define RK3588_CLK_PMU1_400M_SRC		662
#define RK3588_HCLK_PMU1_ROOT			663
#define RK3588_PCLK_PMU1_ROOT			664
#define RK3588_PCLK_PMU0_ROOT			665
#define RK3588_HCLK_PMU_CM0_ROOT		666
#define RK3588_PCLK_PMU1			667
#define RK3588_CLK_DDR_FAIL_SAFE		668
#define RK3588_CLK_PMU1				669
#define RK3588_HCLK_PDM0			670
#define RK3588_MCLK_PDM0			671
#define RK3588_HCLK_VAD				672
#define RK3588_FCLK_PMU_CM0_CORE		673
#define RK3588_CLK_PMU_CM0_RTC			674
#define RK3588_PCLK_PMU1_IOC			675
#define RK3588_PCLK_PMU1PWM			676
#define RK3588_CLK_PMU1PWM			677
#define RK3588_CLK_PMU1PWM_CAPTURE		678
#define RK3588_PCLK_PMU1TIMER			679
#define RK3588_CLK_PMU1TIMER_ROOT		680
#define RK3588_CLK_PMU1TIMER0			681
#define RK3588_CLK_PMU1TIMER1			682
#define RK3588_CLK_UART0_SRC			683
#define RK3588_CLK_UART0_FRAC			684
#define RK3588_CLK_UART0			685
#define RK3588_SCLK_UART0			686
#define RK3588_PCLK_UART0			687
#define RK3588_PCLK_PMU1WDT			688
#define RK3588_TCLK_PMU1WDT			689
#define RK3588_CLK_CR_PARA			690
#define RK3588_CLK_HDPTX0_REF_XTAL		691	/* obsolete? */
#define RK3588_CLK_REF_MIPI_DCPHY0		692	/* obsolete? */
#define RK3588_CLK_USB2PHY_HDPTXRXPHY_REF	693
#define RK3588_CLK_USBDPPHY_MIPIDCPPHY_REF	694
#define RK3588_CLK_REF_PIPE_PHY0_OSC_SRC	695
#define RK3588_CLK_REF_PIPE_PHY1_OSC_SRC	696
#define RK3588_CLK_REF_PIPE_PHY2_OSC_SRC	697
#define RK3588_CLK_REF_PIPE_PHY0_PLL_SRC	698
#define RK3588_CLK_REF_PIPE_PHY1_PLL_SRC	699
#define RK3588_CLK_REF_PIPE_PHY2_PLL_SRC	700
#define RK3588_CLK_REF_PIPE_PHY0		701
#define RK3588_CLK_REF_PIPE_PHY1		702
#define RK3588_CLK_REF_PIPE_PHY2		703
#define RK3588_SCLK_SDIO_DRV			704
#define RK3588_SCLK_SDIO_SAMPLE			705
#define RK3588_SCLK_SDMMC_DRV			706
#define RK3588_SCLK_SDMMC_SAMPLE		707
#define RK3588_CLK_PCIE1L0_PIPE			708
#define RK3588_CLK_PCIE1L1_PIPE			709
#define RK3588_CLK_BIGCORE0_PVTM		710
#define RK3588_CLK_CORE_BIGCORE0_PVTM		711
#define RK3588_CLK_BIGCORE1_PVTM		712
#define RK3588_CLK_CORE_BIGCORE1_PVTM		713
#define RK3588_CLK_LITCORE_PVTM			714
#define RK3588_CLK_CORE_LITCORE_PVTM		715
#define RK3588_CLK_AUX16M_0			716
#define RK3588_CLK_AUX16M_1			717
#define RK3588_CLK_PHY0_REF_ALT_P		718
#define RK3588_CLK_PHY0_REF_ALT_M		719
#define RK3588_CLK_PHY1_REF_ALT_P		720
#define RK3588_CLK_PHY1_REF_ALT_M		721

#endif /* _#define RK3588_CRU_H_ */
