#! /bin/sh
#
# Copyright (c) 2013 Matthew R. Green
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

#
# Generate a c++config.h that will include the correct multilib c++config.h
#
# mkcxxconfig_h.sh [[<arch> <define>] ...] <arch>
#
#   generates a series of #ifdef 's with the final <arch> being the default
#

emit_intro() {
	cat <<'__EOH1__'
/*	$NetBSD: mkcxxconfig_h.sh,v 1.1 2014/03/01 10:00:47 mrg Exp $	*/

/* 	This file is automatically generated.  DO NOT EDIT!	 */
__EOH1__

	netbsd_id=$(echo '$NetBSD: mkcxxconfig_h.sh,v 1.1 2014/03/01 10:00:47 mrg Exp $' | sed 's,[#$],,g;s,.*,&,')
	cat <<__EOH2__
/* 	Generated from: $netbsd_id	 */

__EOH2__
}

emit_final() {
	echo "#endif"
}

# $1 - arch to include
emit_include() {
	echo "#include "'"'"bits/$1/c++config.h"'"'
}

# $1 - define to ifdef
ifdef=ifdef
emit_ifdef() {
	echo "#$ifdef $1"
	ifdef="elif"
}

main() {
	emit_intro
	while [ $# -gt 0 ]; do
		if [ $# -eq 1 ]; then
			echo '#else'
			emit_include $1
			break
		fi
		emit_ifdef $2
		emit_include $1
		shift
		shift
	done
	emit_final
}

main "$@"
