.\" $NetBSD: X68k.man,v 1.2 2020/08/01 20:09:03 tsutsui Exp $
.\"
.\" Copyright (c) 1998 The NetBSD Foundation, Inc.
.\" All rights reserved.
.\"
.\" This code is derived from software contributed to The NetBSD Foundation
.\" by Minoura Makoto.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
.\" ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
.\" TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
.\" BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
.\" CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
.\" SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
.\" CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
.\" ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
.\" POSSIBILITY OF SUCH DAMAGE.
.\"
.Dd February 24, 2014
.Dt X68K 1
.Os NetBSD
.Sh NAME
.Nm X68k
.Nd X Window System Display Server for NetBSD/x68k
.Sh SYNOPSIS
.Nm
.Op Ar options ...
.Sh DESCRIPTION
.Nm
is the server for Version 11 of the X Window System on X68k hardware
running
.Nx .
It will normally be started by the
.Xr xdm 1
daemon or by a script that runs the program
.Xr xinit 1 .
.Sh SUPPORTED HARDWARE
.Nm
supports both the x68k built-in text bitmap screen and graphics
bitmap screen.
When it is configured to use the text screen, it can be used as
a monochrome server.  Otherwise, it can be used as 4-bit, 8-bit or 15-bit
16-bit color/monochrome server.

.Nm
supports the x68k standard full-size and compact type keyboards.  The
initial arrangement of the keys on the keyboards can be configured
either as the typewriter style (
.So ASCII Sc
arrangement) or as the JIS standard style (
.So JIS Sc
arrangement).  Once it is started, the arrangement is freely configured with
.Xr xmodmap 1
or
.Xr xkbcomp 1
utility.

The pointing device can be either the standard mouse or the
mouse-trackball.  Although the x68k can have two mice connected,
it recognizes only one of them; if two mice are connected,
the result is undefined.

.Sh OPTIONS
In addition to the normal server options described in the
.Xr Xserver 1
manual page,
.Nm
acdepts the following command line switch:
.Bl -tag -width indent
.It Fl x68kconfig Ar config_file
Specify the configuration filename.
.El

.Sh CONFIGURATION FILE
.Nm
configuration is specified in the configuration file called X68kConfig.
If the configuration filename is specified on the command line option
.Ar x68kconfig ,
the named file is used to read the configuration.  Otherwise
.Nm
searches for the file
.Pa /etc/X68kConfig .
If it is not found,
.Pa <XRoot>/lib/X11/X68kConfig
is used instead, where
.Pa <XRoot>
is replaced by the root of the X11 install tree (ordinary
.Pa /usr/X11R7 ) .

X68kConfig has a Lisp-like syntax.  Comments start with the character
.So ; Sc ,
and ends at the end of line.

There are 4 functions recognized:
.Bl -tag -width indent
.It Fn ModeDef
Define a display mode.  18 arguments are required:

.Fa name Fa type Fa depth Fa class Fa width Fa height Fa regs...
.Fa r0 Fa r1 Fa r2 Fa r3 Fa r4
.Fa r5 Fa r6 Fa r7 Fa r8 Fa r20
.Fa videoc-r0 Fa dotclk

.Fa Name
is the name defined by this ModeDef definition.

.Fa Type
is either
.Fa Text
or
.Fa Graphic ,
and specifies the screen to be used by this mode.  Note that the type
Graphic requires the
.Pa /dev/grf1
device driver configured in your kernel.

.Fa Depth
is the framebuffer depth for this mode.  If
.Fa type
is Text, this must be 1.  Otherwise it can be chosen from 4, 8 and 15.

.Fa Class
specifies the display class, and be chosen from either StaticGray,
PseudoColor and TrueColor.

.Fa Width
and
.Fa height
are the size of the screen by pixel.

Remaining arguments are set to the registers of the CRT controler
and the video controler of the x68k.
Be carefull to change these values, or it may
DAMAGE THE DISPLAY HARDWARE!!

.It Fn Mode
One argument
.Fa name
is required.  Set the display mode to
.Fa name
as defined by the
.Fn ModeDef
function.
.It Fn Mouse
One argument
.Fa type
is required.  Specify the pointing device type; currently
.Fa standard
is the only acceptable argument.
.It Fn Keyboard
One argument
.Fa type
is required.  Specify the initial arrangement of the keyboard.
.Fa Type
is either standard or ascii, which means the JIS arrangement and
the typewriter arrangement respectively.
.El

See
.Sx EXAMPLE
section for an example of
.Pa X68kConfig .

.Sh FILES
.Pa /etc/X68kConfig ,
.Pa /usr/X11R7/lib/X11/X68kConfig

.Sh EXAMPLE
Following is the example configuration file:
.Bd -unfilled -offset indent
;; Example configuration file for X68k.
;; These lines are comments.

; Define standard monochrome mode:
(ModeDef Monochrome768x512
;  type depth   class     width height
   Text   1   StaticGray   768   512
; CRTC-R00 -R01 -R02 -R03 -R04 -R05 -R06 -R07 -R08
       137   14   28  124  567    5   40  552   27
; CRTC-R20 VIDEOC-R0 dotclk
      1046         4      0)

; Configure the display as Monochrome768x512 defined above:
(Mode Monochrome768x512)

; Specify the input devices:
(Mouse standard)
(Keyboard standard)
.Ed

.Sh SEE ALSO
.Xr Xserver 1 ,
.Xr X 1 ,
.Xr xdm 1 ,
.Xr xinit 1 ,
.Xr xmodmap 1 ,
.Xr xkbdcomp 1

.Sh HISTORY
.Nm
was originally written by Yamasaki Yasushi <yamapu@osk3.3web.ne.jp>
as XFree68 in May 1996, and was little modified by Minoura Makoto
<minoura@netbsd.org> to fit with the
.Nx
source tree in Jan. 1998.  Officially appeared in
.Nx 1.4 .

.Sh BUGS
.Nm
may damage your display hardware, depending on the configuration.

The keyboard geometry database is not correct currently.
