/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.MessageOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadInfo {
    private static List<ThreadInfo> threads = Collections.synchronizedList(new ArrayList());
    private static boolean gotInitialThreads = false;
    private static ThreadInfo current = null;
    private static ThreadGroupReference group = null;
    private final ThreadReference thread;
    private int currentFrameIndex = 0;

    private ThreadInfo(ThreadReference threadReference) {
        this.thread = threadReference;
        if (threadReference == null) {
            MessageOutput.fatalError("Internal error: null ThreadInfo created");
        }
    }

    private static void initThreads() {
        if (!gotInitialThreads) {
            for (ThreadReference threadReference : Env.vm().allThreads()) {
                threads.add(new ThreadInfo(threadReference));
            }
            gotInitialThreads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addThread(ThreadReference threadReference) {
        List<ThreadInfo> list = threads;
        synchronized (list) {
            ThreadInfo.initThreads();
            ThreadInfo threadInfo = new ThreadInfo(threadReference);
            if (ThreadInfo.getThreadInfo(threadReference) == null) {
                threads.add(threadInfo);
            }
        }
    }

    static void removeThread(ThreadReference threadReference) {
        if (threadReference.equals(current)) {
            String string;
            try {
                string = "\"" + threadReference.name() + "\"";
            }
            catch (Exception exception) {
                string = "";
            }
            ThreadInfo.setCurrentThread(null);
            MessageOutput.println();
            MessageOutput.println("Current thread died. Execution continuing...", string);
        }
        threads.remove(ThreadInfo.getThreadInfo(threadReference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ThreadInfo> threads() {
        List<ThreadInfo> list = threads;
        synchronized (list) {
            ThreadInfo.initThreads();
            return new ArrayList<ThreadInfo>(threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateAll() {
        current = null;
        group = null;
        List<ThreadInfo> list = threads;
        synchronized (list) {
            for (ThreadInfo threadInfo : ThreadInfo.threads()) {
                threadInfo.invalidate();
            }
        }
    }

    static void setThreadGroup(ThreadGroupReference threadGroupReference) {
        group = threadGroupReference;
    }

    static void setCurrentThread(ThreadReference threadReference) {
        if (threadReference == null) {
            ThreadInfo.setCurrentThreadInfo(null);
        } else {
            ThreadInfo threadInfo = ThreadInfo.getThreadInfo(threadReference);
            ThreadInfo.setCurrentThreadInfo(threadInfo);
        }
    }

    static void setCurrentThreadInfo(ThreadInfo threadInfo) {
        current = threadInfo;
        if (current != null) {
            current.invalidate();
        }
    }

    static ThreadInfo getCurrentThreadInfo() {
        return current;
    }

    ThreadReference getThread() {
        return this.thread;
    }

    static ThreadGroupReference group() {
        if (group == null) {
            ThreadInfo.setThreadGroup(Env.vm().topLevelThreadGroups().get(0));
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThreadInfo getThreadInfo(long l) {
        ThreadInfo threadInfo = null;
        List<ThreadInfo> list = threads;
        synchronized (list) {
            for (ThreadInfo threadInfo2 : ThreadInfo.threads()) {
                if (threadInfo2.thread.uniqueID() != l) continue;
                threadInfo = threadInfo2;
                break;
            }
        }
        return threadInfo;
    }

    static ThreadInfo getThreadInfo(ThreadReference threadReference) {
        return ThreadInfo.getThreadInfo(threadReference.uniqueID());
    }

    static ThreadInfo getThreadInfo(String string) {
        ThreadInfo threadInfo = null;
        if (string.startsWith("t@")) {
            string = string.substring(2);
        }
        try {
            long l = Long.decode(string);
            threadInfo = ThreadInfo.getThreadInfo(l);
        }
        catch (NumberFormatException numberFormatException) {
            threadInfo = null;
        }
        return threadInfo;
    }

    List<StackFrame> getStack() throws IncompatibleThreadStateException {
        return this.thread.frames();
    }

    StackFrame getCurrentFrame() throws IncompatibleThreadStateException {
        if (this.thread.frameCount() == 0) {
            return null;
        }
        return this.thread.frame(this.currentFrameIndex);
    }

    void invalidate() {
        this.currentFrameIndex = 0;
    }

    private void assureSuspended() throws IncompatibleThreadStateException {
        if (!this.thread.isSuspended()) {
            throw new IncompatibleThreadStateException();
        }
    }

    int getCurrentFrameIndex() {
        return this.currentFrameIndex;
    }

    void setCurrentFrameIndex(int n) throws IncompatibleThreadStateException {
        this.assureSuspended();
        if (n < 0 || n >= this.thread.frameCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex = n;
    }

    void up(int n) throws IncompatibleThreadStateException {
        this.setCurrentFrameIndex(this.currentFrameIndex + n);
    }

    void down(int n) throws IncompatibleThreadStateException {
        this.setCurrentFrameIndex(this.currentFrameIndex - n);
    }
}

