/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.util.List;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Set;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileIndexArchive
implements JavacFileManager.Archive {
    private final ZipFileIndex zfIndex;
    private JavacFileManager fileManager;

    public ZipFileIndexArchive(JavacFileManager javacFileManager, ZipFileIndex zipFileIndex) throws IOException {
        this.fileManager = javacFileManager;
        this.zfIndex = zipFileIndex;
    }

    @Override
    public boolean contains(RelativePath relativePath) {
        return this.zfIndex.contains(relativePath);
    }

    @Override
    public List<String> getFiles(RelativePath.RelativeDirectory relativeDirectory) {
        return this.zfIndex.getFiles(relativeDirectory);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory relativeDirectory, String string) {
        RelativePath.RelativeFile relativeFile = new RelativePath.RelativeFile(relativeDirectory, string);
        ZipFileIndex.Entry entry = this.zfIndex.getZipIndexEntry(relativeFile);
        ZipFileIndexFileObject zipFileIndexFileObject = new ZipFileIndexFileObject(this.fileManager, this.zfIndex, entry, this.zfIndex.getZipFile().getPath());
        return zipFileIndexFileObject;
    }

    @Override
    public Set<RelativePath.RelativeDirectory> getSubdirectories() {
        return this.zfIndex.getAllDirectories();
    }

    @Override
    public void close() throws IOException {
        this.zfIndex.close();
    }

    public String toString() {
        return "ZipFileIndexArchive[" + this.zfIndex + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZipFileIndexFileObject
    extends BaseFileObject {
        private String name;
        ZipFileIndex zfIndex;
        ZipFileIndex.Entry entry;
        InputStream inputStream = null;
        String zipName;

        ZipFileIndexFileObject(JavacFileManager javacFileManager, ZipFileIndex zipFileIndex, ZipFileIndex.Entry entry, String string) {
            super(javacFileManager);
            this.name = entry.getFileName();
            this.zfIndex = zipFileIndex;
            this.entry = entry;
            this.zipName = string;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new ByteArrayInputStream(this.read());
            }
            return this.inputStream;
        }

        @Override
        protected CharsetDecoder getDecoder(boolean bl) {
            return this.fileManager.getDecoder(this.fileManager.getEncodingName(), bl);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            string.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            return this.name.equals(string + kind.extension);
        }

        @Override
        @Deprecated
        public String getPath() {
            return this.zipName + "(" + this.entry.getName() + ")";
        }

        @Override
        public long getLastModified() {
            return this.entry.getLastModified();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ZipFileIndexFileObject)) {
                return false;
            }
            ZipFileIndexFileObject zipFileIndexFileObject = (ZipFileIndexFileObject)object;
            return this.entry.equals(zipFileIndexFileObject.entry);
        }

        public int hashCode() {
            return this.zipName.hashCode() + (this.name.hashCode() << 10);
        }

        public String getZipName() {
            return this.zipName;
        }

        public String getZipEntryName() {
            return this.entry.getName();
        }

        @Override
        public URI toUri() {
            String string = new File(this.getZipName()).toURI().normalize().getPath();
            String string2 = this.getZipEntryName();
            return URI.create("jar:" + string + "!" + string2);
        }

        private byte[] read() throws IOException {
            assert (this.entry != null);
            return this.zfIndex.read(this.entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBuffer getCharContent(boolean bl) throws IOException {
            CharBuffer charBuffer = this.fileManager.getCachedContent(this);
            if (charBuffer == null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.zfIndex.read(this.entry));
                try {
                    ByteBuffer byteBuffer = this.fileManager.makeByteBuffer(byteArrayInputStream);
                    JavaFileObject javaFileObject = this.fileManager.log.useSource(this);
                    try {
                        charBuffer = this.fileManager.decode(byteBuffer, bl);
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.fileManager.log.useSource(javaFileObject);
                        throw throwable;
                    }
                    this.fileManager.log.useSource(javaFileObject);
                    this.fileManager.recycleByteBuffer(byteBuffer);
                    if (!bl) {
                        this.fileManager.cache(this, charBuffer);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    ((InputStream)byteArrayInputStream).close();
                    throw throwable;
                }
                ((InputStream)byteArrayInputStream).close();
                {
                }
            }
            return charBuffer;
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> iterable) {
            String string;
            String string2 = this.getZipEntryName();
            if (this.zfIndex.symbolFilePrefix != null && string2.startsWith(string = this.zfIndex.symbolFilePrefix.path)) {
                string2 = string2.substring(string.length());
            }
            return ZipFileIndexFileObject.removeExtension(string2).replace('/', '.');
        }
    }
}

