/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.ArrayTypeImpl;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    int length = -1;

    ArrayReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
    }

    @Override
    protected ClassTypeImpl invokableReferenceType(Method method) {
        return (ClassTypeImpl)method.declaringType();
    }

    ArrayTypeImpl arrayType() {
        return (ArrayTypeImpl)this.type();
    }

    @Override
    public int length() {
        if (this.length == -1) {
            try {
                this.length = JDWP.ArrayReference.Length.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this).arrayLength;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.length;
    }

    @Override
    public Value getValue(int n) {
        List<Value> list = this.getValues(n, 1);
        return list.get(0);
    }

    @Override
    public List<Value> getValues() {
        return this.getValues(0, -1);
    }

    private void validateArrayAccess(int n, int n2) {
        if (n < 0 || n > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array index: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid array range length: " + n2);
        }
        if (n + n2 > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array range: " + n + " to " + (n + n2 - 1));
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    @Override
    public List<Value> getValues(int n, int n2) {
        List list;
        if (n2 == -1) {
            n2 = this.length() - n;
        }
        this.validateArrayAccess(n, n2);
        if (n2 == 0) {
            return new ArrayList<Value>();
        }
        try {
            list = (List)ArrayReferenceImpl.cast(JDWP.ArrayReference.GetValues.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this, (int)n, (int)n2).values);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return list;
    }

    @Override
    public void setValue(int n, Value value) throws InvalidTypeException, ClassNotLoadedException {
        ArrayList<Value> arrayList = new ArrayList<Value>(1);
        arrayList.add(value);
        this.setValues(n, arrayList, 0, 1);
    }

    @Override
    public void setValues(List<? extends Value> list) throws InvalidTypeException, ClassNotLoadedException {
        this.setValues(0, list, 0, -1);
    }

    @Override
    public void setValues(int n, List<? extends Value> list, int n2, int n3) throws InvalidTypeException, ClassNotLoadedException {
        if (n3 == -1) {
            n3 = Math.min(this.length() - n, list.size() - n2);
        }
        this.validateMirrorsOrNulls(list);
        this.validateArrayAccess(n, n3);
        if (n2 < 0 || n2 > list.size()) {
            throw new IndexOutOfBoundsException("Invalid source index: " + n2);
        }
        if (n2 + n3 > list.size()) {
            throw new IndexOutOfBoundsException("Invalid source range: " + n2 + " to " + (n2 + n3 - 1));
        }
        boolean bl = false;
        ValueImpl[] valueImplArray = new ValueImpl[n3];
        for (int i = 0; i < n3; ++i) {
            ValueImpl valueImpl = (ValueImpl)list.get(n2 + i);
            try {
                valueImplArray[i] = ValueImpl.prepareForAssignment(valueImpl, new Component());
                bl = true;
                continue;
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                if (valueImpl == null) continue;
                throw classNotLoadedException;
            }
        }
        if (bl) {
            try {
                JDWP.ArrayReference.SetValues.process(this.vm, this, n, valueImplArray);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
    }

    @Override
    public String toString() {
        return "instance of " + this.arrayType().componentTypeName() + "[" + this.length() + "] (id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 91;
    }

    @Override
    void validateAssignment(ValueContainer valueContainer) throws InvalidTypeException, ClassNotLoadedException {
        block3: {
            try {
                super.validateAssignment(valueContainer);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                boolean bl = false;
                JNITypeParser jNITypeParser = new JNITypeParser(valueContainer.signature());
                JNITypeParser jNITypeParser2 = new JNITypeParser(this.arrayType().signature());
                int n = jNITypeParser.dimensionCount();
                if (n <= jNITypeParser2.dimensionCount()) {
                    String string = jNITypeParser.componentSignature(n);
                    Type type = valueContainer.findType(string);
                    String string2 = jNITypeParser2.componentSignature(n);
                    Type type2 = this.arrayType().findComponentType(string2);
                    bl = ArrayTypeImpl.isComponentAssignable(type, type2);
                }
                if (bl) break block3;
                throw new InvalidTypeException("Cannot assign " + this.arrayType().name() + " to " + valueContainer.typeName());
            }
        }
    }

    class Component
    implements ValueContainer {
        Component() {
        }

        public Type type() throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().componentType();
        }

        public String typeName() {
            return ArrayReferenceImpl.this.arrayType().componentTypeName();
        }

        public String signature() {
            return ArrayReferenceImpl.this.arrayType().componentSignature();
        }

        public Type findType(String string) throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().findComponentType(string);
        }
    }
}

