/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.digested;

import com.sun.xml.internal.rngom.ast.builder.BuildException;
import com.sun.xml.internal.rngom.ast.builder.SchemaBuilder;
import com.sun.xml.internal.rngom.ast.util.CheckingSchemaBuilder;
import com.sun.xml.internal.rngom.digested.DAnnotation;
import com.sun.xml.internal.rngom.digested.DAttributePattern;
import com.sun.xml.internal.rngom.digested.DChoicePattern;
import com.sun.xml.internal.rngom.digested.DDataPattern;
import com.sun.xml.internal.rngom.digested.DDefine;
import com.sun.xml.internal.rngom.digested.DElementPattern;
import com.sun.xml.internal.rngom.digested.DEmptyPattern;
import com.sun.xml.internal.rngom.digested.DGrammarPattern;
import com.sun.xml.internal.rngom.digested.DGroupPattern;
import com.sun.xml.internal.rngom.digested.DInterleavePattern;
import com.sun.xml.internal.rngom.digested.DListPattern;
import com.sun.xml.internal.rngom.digested.DMixedPattern;
import com.sun.xml.internal.rngom.digested.DNotAllowedPattern;
import com.sun.xml.internal.rngom.digested.DOMPrinter;
import com.sun.xml.internal.rngom.digested.DOneOrMorePattern;
import com.sun.xml.internal.rngom.digested.DOptionalPattern;
import com.sun.xml.internal.rngom.digested.DPattern;
import com.sun.xml.internal.rngom.digested.DPatternVisitor;
import com.sun.xml.internal.rngom.digested.DRefPattern;
import com.sun.xml.internal.rngom.digested.DSchemaBuilderImpl;
import com.sun.xml.internal.rngom.digested.DTextPattern;
import com.sun.xml.internal.rngom.digested.DValuePattern;
import com.sun.xml.internal.rngom.digested.DZeroOrMorePattern;
import com.sun.xml.internal.rngom.nc.NameClass;
import com.sun.xml.internal.rngom.nc.NameClassVisitor;
import com.sun.xml.internal.rngom.nc.SimpleNameClass;
import com.sun.xml.internal.rngom.parse.Parseable;
import com.sun.xml.internal.rngom.parse.compact.CompactParseable;
import com.sun.xml.internal.rngom.parse.xml.SAXParseable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DXMLPrinter {
    protected XMLStreamWriter out;
    protected String indentStep = "\t";
    protected String newLine = System.getProperty("line.separator");
    protected int indent;
    protected boolean afterEnd = false;
    protected DXMLPrinterVisitor visitor;
    protected NameClassXMLPrinterVisitor ncVisitor;
    protected DOMPrinter domPrinter;

    public DXMLPrinter(XMLStreamWriter xMLStreamWriter) {
        this.out = xMLStreamWriter;
        this.visitor = new DXMLPrinterVisitor();
        this.ncVisitor = new NameClassXMLPrinterVisitor();
        this.domPrinter = new DOMPrinter(xMLStreamWriter);
    }

    public void printDocument(DGrammarPattern dGrammarPattern) throws XMLStreamException {
        try {
            this.visitor.startDocument();
            this.visitor.on(dGrammarPattern);
            this.visitor.endDocument();
        }
        catch (XMLWriterException xMLWriterException) {
            throw (XMLStreamException)xMLWriterException.getCause();
        }
    }

    public void print(DPattern dPattern) throws XMLStreamException {
        try {
            dPattern.accept(this.visitor);
        }
        catch (XMLWriterException xMLWriterException) {
            throw (XMLStreamException)xMLWriterException.getCause();
        }
    }

    public void print(NameClass nameClass) throws XMLStreamException {
        try {
            nameClass.accept(this.ncVisitor);
        }
        catch (XMLWriterException xMLWriterException) {
            throw (XMLStreamException)xMLWriterException.getCause();
        }
    }

    public void print(Node node) throws XMLStreamException {
        this.domPrinter.print(node);
    }

    public static void main(String[] stringArray) throws Exception {
        DefaultHandler defaultHandler = new DefaultHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }
        };
        Parseable parseable = stringArray[0].endsWith(".rng") ? new SAXParseable(new InputSource(stringArray[0]), defaultHandler) : new CompactParseable(new InputSource(stringArray[0]), defaultHandler);
        CheckingSchemaBuilder checkingSchemaBuilder = new CheckingSchemaBuilder((SchemaBuilder)new DSchemaBuilderImpl(), defaultHandler);
        try {
            DGrammarPattern dGrammarPattern = (DGrammarPattern)parseable.parse(checkingSchemaBuilder);
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(fileOutputStream);
            DXMLPrinter dXMLPrinter = new DXMLPrinter(xMLStreamWriter);
            dXMLPrinter.printDocument(dGrammarPattern);
            xMLStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (BuildException buildException) {
            SAXException sAXException;
            if (buildException.getCause() instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)buildException.getCause();
                System.out.println("(" + sAXParseException.getLineNumber() + "," + sAXParseException.getColumnNumber() + "): " + sAXParseException.getMessage());
                return;
            }
            if (buildException.getCause() instanceof SAXException && (sAXException = (SAXException)buildException.getCause()).getException() != null) {
                sAXException.getException().printStackTrace();
            }
            throw buildException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NameClassXMLPrinterVisitor
    extends XMLWriter
    implements NameClassVisitor<Void> {
        protected NameClassXMLPrinterVisitor() {
        }

        @Override
        public Void visitChoice(NameClass nameClass, NameClass nameClass2) {
            this.start("choice");
            nameClass.accept(this);
            nameClass2.accept(this);
            this.end();
            return null;
        }

        @Override
        public Void visitNsName(String string) {
            this.start("nsName");
            this.attr("ns", string);
            this.end();
            return null;
        }

        @Override
        public Void visitNsNameExcept(String string, NameClass nameClass) {
            this.start("nsName");
            this.attr("ns", string);
            this.start("except");
            nameClass.accept(this);
            this.end();
            this.end();
            return null;
        }

        @Override
        public Void visitAnyName() {
            this.start("anyName");
            this.end();
            return null;
        }

        @Override
        public Void visitAnyNameExcept(NameClass nameClass) {
            this.start("anyName");
            this.start("except");
            nameClass.accept(this);
            this.end();
            this.end();
            return null;
        }

        @Override
        public Void visitName(QName qName) {
            this.start("name");
            if (!qName.getPrefix().equals("")) {
                this.body(qName.getPrefix() + ":");
            }
            this.body(qName.getLocalPart());
            this.end();
            return null;
        }

        @Override
        public Void visitNull() {
            throw new UnsupportedOperationException("visitNull");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DXMLPrinterVisitor
    extends XMLWriter
    implements DPatternVisitor<Void> {
        protected DXMLPrinterVisitor() {
        }

        protected void on(DPattern dPattern) {
            dPattern.accept(this);
        }

        protected void unwrapGroup(DPattern dPattern) {
            if (dPattern instanceof DGroupPattern && dPattern.getAnnotation() == DAnnotation.EMPTY) {
                for (DPattern dPattern2 : (DGroupPattern)dPattern) {
                    this.on(dPattern2);
                }
            } else {
                this.on(dPattern);
            }
        }

        protected void unwrapChoice(DPattern dPattern) {
            if (dPattern instanceof DChoicePattern && dPattern.getAnnotation() == DAnnotation.EMPTY) {
                for (DPattern dPattern2 : (DChoicePattern)dPattern) {
                    this.on(dPattern2);
                }
            } else {
                this.on(dPattern);
            }
        }

        protected void on(NameClass nameClass) {
            if (nameClass instanceof SimpleNameClass) {
                QName qName = ((SimpleNameClass)nameClass).name;
                String string = qName.getLocalPart();
                if (!qName.getPrefix().equals("")) {
                    string = qName.getPrefix() + ":";
                }
                this.attr("name", string);
            } else {
                nameClass.accept(DXMLPrinter.this.ncVisitor);
            }
        }

        protected void on(DAnnotation dAnnotation) {
            if (dAnnotation == DAnnotation.EMPTY) {
                return;
            }
            for (DAnnotation.Attribute object : dAnnotation.getAttributes().values()) {
                this.attr(object.getPrefix(), object.getNs(), object.getLocalName(), object.getValue());
            }
            for (Element element : dAnnotation.getChildren()) {
                try {
                    this.newLine();
                    this.indent();
                    DXMLPrinter.this.print(element);
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new XMLWriterException((Throwable)xMLStreamException);
                }
            }
        }

        @Override
        public Void onAttribute(DAttributePattern dAttributePattern) {
            this.start("attribute");
            this.on(dAttributePattern.getName());
            this.on(dAttributePattern.getAnnotation());
            DPattern dPattern = dAttributePattern.getChild();
            if (!(dPattern instanceof DTextPattern)) {
                this.on(dAttributePattern.getChild());
            }
            this.end();
            return null;
        }

        @Override
        public Void onChoice(DChoicePattern dChoicePattern) {
            this.start("choice");
            this.on(dChoicePattern.getAnnotation());
            for (DPattern dPattern : dChoicePattern) {
                this.on(dPattern);
            }
            this.end();
            return null;
        }

        @Override
        public Void onData(DDataPattern dDataPattern) {
            List<DDataPattern.Param> list = dDataPattern.getParams();
            DPattern dPattern = dDataPattern.getExcept();
            this.start("data");
            this.attr("datatypeLibrary", dDataPattern.getDatatypeLibrary());
            this.attr("type", dDataPattern.getType());
            this.on(dDataPattern.getAnnotation());
            for (DDataPattern.Param param : list) {
                this.start("param");
                this.attr("ns", param.getNs());
                this.attr("name", param.getName());
                this.body(param.getValue());
                this.end();
            }
            if (dPattern != null) {
                this.start("except");
                this.unwrapChoice(dPattern);
                this.end();
            }
            this.end();
            return null;
        }

        @Override
        public Void onElement(DElementPattern dElementPattern) {
            this.start("element");
            this.on(dElementPattern.getName());
            this.on(dElementPattern.getAnnotation());
            this.unwrapGroup(dElementPattern.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onEmpty(DEmptyPattern dEmptyPattern) {
            this.start("empty");
            this.on(dEmptyPattern.getAnnotation());
            this.end();
            return null;
        }

        @Override
        public Void onGrammar(DGrammarPattern dGrammarPattern) {
            this.start("grammar");
            this.ns(null, "http://relaxng.org/ns/structure/1.0");
            this.on(dGrammarPattern.getAnnotation());
            this.start("start");
            this.on(dGrammarPattern.getStart());
            this.end();
            for (DDefine dDefine : dGrammarPattern) {
                this.start("define");
                this.attr("name", dDefine.getName());
                this.on(dDefine.getAnnotation());
                this.unwrapGroup(dDefine.getPattern());
                this.end();
            }
            this.end();
            return null;
        }

        @Override
        public Void onGroup(DGroupPattern dGroupPattern) {
            this.start("group");
            this.on(dGroupPattern.getAnnotation());
            for (DPattern dPattern : dGroupPattern) {
                this.on(dPattern);
            }
            this.end();
            return null;
        }

        @Override
        public Void onInterleave(DInterleavePattern dInterleavePattern) {
            this.start("interleave");
            this.on(dInterleavePattern.getAnnotation());
            for (DPattern dPattern : dInterleavePattern) {
                this.on(dPattern);
            }
            this.end();
            return null;
        }

        @Override
        public Void onList(DListPattern dListPattern) {
            this.start("list");
            this.on(dListPattern.getAnnotation());
            this.unwrapGroup(dListPattern.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onMixed(DMixedPattern dMixedPattern) {
            this.start("mixed");
            this.on(dMixedPattern.getAnnotation());
            this.unwrapGroup(dMixedPattern.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onNotAllowed(DNotAllowedPattern dNotAllowedPattern) {
            this.start("notAllowed");
            this.on(dNotAllowedPattern.getAnnotation());
            this.end();
            return null;
        }

        @Override
        public Void onOneOrMore(DOneOrMorePattern dOneOrMorePattern) {
            this.start("oneOrMore");
            this.on(dOneOrMorePattern.getAnnotation());
            this.unwrapGroup(dOneOrMorePattern.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onOptional(DOptionalPattern dOptionalPattern) {
            this.start("optional");
            this.on(dOptionalPattern.getAnnotation());
            this.unwrapGroup(dOptionalPattern.getChild());
            this.end();
            return null;
        }

        @Override
        public Void onRef(DRefPattern dRefPattern) {
            this.start("ref");
            this.attr("name", dRefPattern.getName());
            this.on(dRefPattern.getAnnotation());
            this.end();
            return null;
        }

        @Override
        public Void onText(DTextPattern dTextPattern) {
            this.start("text");
            this.on(dTextPattern.getAnnotation());
            this.end();
            return null;
        }

        @Override
        public Void onValue(DValuePattern dValuePattern) {
            this.start("value");
            if (!dValuePattern.getNs().equals("")) {
                this.attr("ns", dValuePattern.getNs());
            }
            this.attr("datatypeLibrary", dValuePattern.getDatatypeLibrary());
            this.attr("type", dValuePattern.getType());
            this.on(dValuePattern.getAnnotation());
            this.body(dValuePattern.getValue());
            this.end();
            return null;
        }

        @Override
        public Void onZeroOrMore(DZeroOrMorePattern dZeroOrMorePattern) {
            this.start("zeroOrMore");
            this.on(dZeroOrMorePattern.getAnnotation());
            this.unwrapGroup(dZeroOrMorePattern.getChild());
            this.end();
            return null;
        }
    }

    protected class XMLWriter {
        protected XMLWriter() {
        }

        protected void newLine() {
            try {
                DXMLPrinter.this.out.writeCharacters(DXMLPrinter.this.newLine);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        protected void indent() {
            try {
                for (int i = 0; i < DXMLPrinter.this.indent; ++i) {
                    DXMLPrinter.this.out.writeCharacters(DXMLPrinter.this.indentStep);
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        public void startDocument() {
            try {
                DXMLPrinter.this.out.writeStartDocument();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        public void endDocument() {
            try {
                DXMLPrinter.this.out.writeEndDocument();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        public final void start(String string) {
            try {
                this.newLine();
                this.indent();
                DXMLPrinter.this.out.writeStartElement(string);
                ++DXMLPrinter.this.indent;
                DXMLPrinter.this.afterEnd = false;
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        public void end() {
            try {
                --DXMLPrinter.this.indent;
                if (DXMLPrinter.this.afterEnd) {
                    this.newLine();
                    this.indent();
                }
                DXMLPrinter.this.out.writeEndElement();
                DXMLPrinter.this.afterEnd = true;
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        public void attr(String string, String string2, String string3, String string4) {
            try {
                DXMLPrinter.this.out.writeAttribute(string, string2, string3, string4);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        public void attr(String string, String string2) {
            try {
                DXMLPrinter.this.out.writeAttribute(string, string2);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        public void ns(String string, String string2) {
            try {
                DXMLPrinter.this.out.writeNamespace(string, string2);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }

        public void body(String string) {
            try {
                DXMLPrinter.this.out.writeCharacters(string);
                DXMLPrinter.this.afterEnd = false;
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterException((Throwable)xMLStreamException);
            }
        }
    }

    protected class XMLWriterException
    extends RuntimeException {
        protected XMLWriterException(Throwable throwable) {
            super(throwable);
        }
    }
}

