/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.newrmic.jrmp;

import com.sun.javadoc.ClassDoc;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.rmi.rmic.newrmic.BatchEnvironment;
import sun.rmi.rmic.newrmic.Generator;
import sun.rmi.rmic.newrmic.IndentingWriter;
import sun.rmi.rmic.newrmic.Main;
import sun.rmi.rmic.newrmic.Resources;
import sun.rmi.rmic.newrmic.jrmp.Constants;
import sun.rmi.rmic.newrmic.jrmp.RemoteClass;
import sun.rmi.rmic.newrmic.jrmp.StubSkeletonWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JrmpGenerator
implements Generator {
    private static final Map<String, Constants.StubVersion> versionOptions = new HashMap<String, Constants.StubVersion>();
    private static final Set<String> bootstrapClassNames;
    private Constants.StubVersion version = Constants.StubVersion.V1_2;

    @Override
    public boolean parseArgs(String[] stringArray, Main main) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!versionOptions.containsKey(string2)) continue;
            if (string != null && !string.equals(string2)) {
                main.error("rmic.cannot.use.both", string, string2);
                return false;
            }
            string = string2;
            this.version = versionOptions.get(string2);
            stringArray[i] = null;
        }
        return true;
    }

    @Override
    public Class<? extends BatchEnvironment> envClass() {
        return BatchEnvironment.class;
    }

    @Override
    public Set<String> bootstrapClassNames() {
        return Collections.unmodifiableSet(bootstrapClassNames);
    }

    @Override
    public void generate(BatchEnvironment batchEnvironment, ClassDoc classDoc, File file) {
        Object object;
        RemoteClass remoteClass = RemoteClass.forClass(batchEnvironment, classDoc);
        if (remoteClass == null) {
            return;
        }
        StubSkeletonWriter stubSkeletonWriter = new StubSkeletonWriter(batchEnvironment, remoteClass, this.version);
        File file2 = this.sourceFileForClass(stubSkeletonWriter.stubClassName(), file);
        try {
            object = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            stubSkeletonWriter.writeStub((IndentingWriter)object);
            ((BufferedWriter)object).close();
            if (batchEnvironment.verbose()) {
                batchEnvironment.output(Resources.getText("rmic.wrote", file2.getPath()));
            }
            batchEnvironment.addGeneratedFile(file2);
        }
        catch (IOException iOException) {
            batchEnvironment.error("rmic.cant.write", file2.toString());
            return;
        }
        object = this.sourceFileForClass(stubSkeletonWriter.skeletonClassName(), file);
        if (this.version == Constants.StubVersion.V1_1 || this.version == Constants.StubVersion.VCOMPAT) {
            try {
                IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream((File)object)));
                stubSkeletonWriter.writeSkeleton(indentingWriter);
                indentingWriter.close();
                if (batchEnvironment.verbose()) {
                    batchEnvironment.output(Resources.getText("rmic.wrote", ((File)object).getPath()));
                }
                batchEnvironment.addGeneratedFile((File)object);
            }
            catch (IOException iOException) {
                batchEnvironment.error("rmic.cant.write", ((File)object).toString());
                return;
            }
        } else {
            File file3 = this.classFileForClass(stubSkeletonWriter.skeletonClassName(), file);
            ((File)object).delete();
            file3.delete();
        }
    }

    private File sourceFileForClass(String string, File file) {
        return this.fileForClass(string, file, ".java");
    }

    private File classFileForClass(String string, File file) {
        return this.fileForClass(string, file, ".class");
    }

    private File fileForClass(String string, File file, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = string.substring(n + 1) + string2;
        if (n != -1) {
            String string4 = string.substring(0, n);
            String string5 = string4.replace('.', File.separatorChar);
            File file2 = new File(file, string5);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            return new File(file2, string3);
        }
        return new File(file, string3);
    }

    static {
        versionOptions.put("-v1.1", Constants.StubVersion.V1_1);
        versionOptions.put("-vcompat", Constants.StubVersion.VCOMPAT);
        versionOptions.put("-v1.2", Constants.StubVersion.V1_2);
        bootstrapClassNames = new HashSet<String>();
        bootstrapClassNames.add("java.lang.Exception");
        bootstrapClassNames.add("java.rmi.Remote");
        bootstrapClassNames.add("java.rmi.RemoteException");
        bootstrapClassNames.add("java.lang.RuntimeException");
    }
}

