/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.dtm.ref;

import com.sun.org.apache.xml.internal.dtm.Axis;
import com.sun.org.apache.xml.internal.dtm.DTMAxisIterator;
import com.sun.org.apache.xml.internal.dtm.DTMAxisTraverser;
import com.sun.org.apache.xml.internal.dtm.DTMException;
import com.sun.org.apache.xml.internal.dtm.DTMManager;
import com.sun.org.apache.xml.internal.dtm.DTMWSFilter;
import com.sun.org.apache.xml.internal.dtm.ref.DTMAxisIteratorBase;
import com.sun.org.apache.xml.internal.dtm.ref.DTMDefaultBaseTraversers;
import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.utils.NodeVector;
import com.sun.org.apache.xml.internal.utils.XMLStringFactory;
import javax.xml.transform.Source;

public abstract class DTMDefaultBaseIterators
extends DTMDefaultBaseTraversers {
    public DTMDefaultBaseIterators(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl) {
        super(dTMManager, source, n, dTMWSFilter, xMLStringFactory, bl);
    }

    public DTMDefaultBaseIterators(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl, int n2, boolean bl2, boolean bl3) {
        super(dTMManager, source, n, dTMWSFilter, xMLStringFactory, bl, n2, bl2, bl3);
    }

    public DTMAxisIterator getTypedAxisIterator(int n, int n2) {
        DTMAxisIterator dTMAxisIterator = null;
        switch (n) {
            case 13: {
                dTMAxisIterator = new TypedSingletonIterator(n2);
                break;
            }
            case 3: {
                dTMAxisIterator = new TypedChildrenIterator(n2);
                break;
            }
            case 10: {
                return new ParentIterator().setNodeType(n2);
            }
            case 0: {
                return new TypedAncestorIterator(n2);
            }
            case 1: {
                return new TypedAncestorIterator(n2).includeSelf();
            }
            case 2: {
                return new TypedAttributeIterator(n2);
            }
            case 4: {
                dTMAxisIterator = new TypedDescendantIterator(n2);
                break;
            }
            case 5: {
                dTMAxisIterator = new TypedDescendantIterator(n2).includeSelf();
                break;
            }
            case 6: {
                dTMAxisIterator = new TypedFollowingIterator(n2);
                break;
            }
            case 11: {
                dTMAxisIterator = new TypedPrecedingIterator(n2);
                break;
            }
            case 7: {
                dTMAxisIterator = new TypedFollowingSiblingIterator(n2);
                break;
            }
            case 12: {
                dTMAxisIterator = new TypedPrecedingSiblingIterator(n2);
                break;
            }
            case 9: {
                dTMAxisIterator = new TypedNamespaceIterator(n2);
                break;
            }
            case 19: {
                dTMAxisIterator = new TypedRootIterator(n2);
                break;
            }
            default: {
                throw new DTMException(XMLMessages.createXMLMessage("ER_TYPED_ITERATOR_AXIS_NOT_IMPLEMENTED", new Object[]{Axis.getNames(n)}));
            }
        }
        return dTMAxisIterator;
    }

    public DTMAxisIterator getAxisIterator(int n) {
        DTMAxisIterator dTMAxisIterator = null;
        switch (n) {
            case 13: {
                dTMAxisIterator = new SingletonIterator();
                break;
            }
            case 3: {
                dTMAxisIterator = new ChildrenIterator();
                break;
            }
            case 10: {
                return new ParentIterator();
            }
            case 0: {
                return new AncestorIterator();
            }
            case 1: {
                return new AncestorIterator().includeSelf();
            }
            case 2: {
                return new AttributeIterator();
            }
            case 4: {
                dTMAxisIterator = new DescendantIterator();
                break;
            }
            case 5: {
                dTMAxisIterator = new DescendantIterator().includeSelf();
                break;
            }
            case 6: {
                dTMAxisIterator = new FollowingIterator();
                break;
            }
            case 11: {
                dTMAxisIterator = new PrecedingIterator();
                break;
            }
            case 7: {
                dTMAxisIterator = new FollowingSiblingIterator();
                break;
            }
            case 12: {
                dTMAxisIterator = new PrecedingSiblingIterator();
                break;
            }
            case 9: {
                dTMAxisIterator = new NamespaceIterator();
                break;
            }
            case 19: {
                dTMAxisIterator = new RootIterator();
                break;
            }
            default: {
                throw new DTMException(XMLMessages.createXMLMessage("ER_ITERATOR_AXIS_NOT_IMPLEMENTED", new Object[]{Axis.getNames(n)}));
            }
        }
        return dTMAxisIterator;
    }

    public final class TypedSingletonIterator
    extends SingletonIterator {
        private final int _nodeType;

        public TypedSingletonIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = this._currentNode;
            int n2 = this._nodeType;
            this._currentNode = -1;
            if (n2 >= 14 ? DTMDefaultBaseIterators.this.getExpandedTypeID(n) == n2 : DTMDefaultBaseIterators.this.getNodeType(n) == n2) {
                return this.returnNode(n);
            }
            return -1;
        }
    }

    public class SingletonIterator
    extends InternalAxisIteratorBase {
        private boolean _isConstant;

        public SingletonIterator() {
            this(Integer.MIN_VALUE, false);
        }

        public SingletonIterator(int n) {
            this(n, false);
        }

        public SingletonIterator(int n, boolean bl) {
            this._currentNode = this._startNode = n;
            this._isConstant = bl;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            if (this._isRestartable) {
                if (this._currentNode == Integer.MIN_VALUE) {
                    this._currentNode = this._startNode = n;
                }
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator reset() {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            boolean bl = this._isRestartable;
            this._isRestartable = true;
            this.setStartNode(this._startNode);
            this._isRestartable = bl;
            return this;
        }

        public int next() {
            int n = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(n);
        }
    }

    public class NthDescendantIterator
    extends DescendantIterator {
        int _pos;

        public NthDescendantIterator(int n) {
            this._pos = n;
        }

        public int next() {
            int n;
            while ((n = super.next()) != -1) {
                n = DTMDefaultBaseIterators.this.makeNodeIdentity(n);
                int n2 = DTMDefaultBaseIterators.this._parent(n);
                int n3 = DTMDefaultBaseIterators.this._firstch(n2);
                int n4 = 0;
                do {
                    short s;
                    if (1 != (s = DTMDefaultBaseIterators.this._type(n3))) continue;
                    ++n4;
                } while (n4 < this._pos && (n3 = DTMDefaultBaseIterators.this._nextsib(n3)) != -1);
                if (n != n3) continue;
                return n;
            }
            return -1;
        }
    }

    public final class TypedDescendantIterator
    extends DescendantIterator {
        private final int _nodeType;

        public TypedDescendantIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            short s;
            if (this._startNode == -1) {
                return -1;
            }
            int n = this._currentNode;
            do {
                if (-1 != (s = DTMDefaultBaseIterators.this._type(++n)) && this.isDescendant(n)) continue;
                this._currentNode = -1;
                return -1;
            } while (s != this._nodeType && DTMDefaultBaseIterators.this._exptype(n) != this._nodeType);
            this._currentNode = n;
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(n));
        }
    }

    public class DescendantIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                n = DTMDefaultBaseIterators.this.makeNodeIdentity(n);
                this._startNode = n--;
                if (this._includeSelf) {
                    // empty if block
                }
                this._currentNode = n;
                return this.resetPosition();
            }
            return this;
        }

        protected boolean isDescendant(int n) {
            return DTMDefaultBaseIterators.this._parent(n) >= this._startNode || this._startNode == n;
        }

        public int next() {
            short s;
            if (this._startNode == -1) {
                return -1;
            }
            if (this._includeSelf && this._currentNode + 1 == this._startNode) {
                return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(++this._currentNode));
            }
            int n = this._currentNode;
            do {
                if (-1 != (s = DTMDefaultBaseIterators.this._type(++n)) && this.isDescendant(n)) continue;
                this._currentNode = -1;
                return -1;
            } while (2 == s || 3 == s || 13 == s);
            this._currentNode = n;
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(n));
        }

        public DTMAxisIterator reset() {
            boolean bl = this._isRestartable;
            this._isRestartable = true;
            this.setStartNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._startNode));
            this._isRestartable = bl;
            return this;
        }
    }

    public final class TypedAncestorIterator
    extends AncestorIterator {
        private final int _nodeType;

        public TypedAncestorIterator(int n) {
            this._nodeType = n;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            this.m_realStartNode = n;
            if (this._isRestartable) {
                int n2 = DTMDefaultBaseIterators.this.makeNodeIdentity(n);
                int n3 = this._nodeType;
                if (!this._includeSelf && n != -1) {
                    n2 = DTMDefaultBaseIterators.this._parent(n2);
                }
                this._startNode = n;
                if (n3 >= 14) {
                    while (n2 != -1) {
                        int n4 = DTMDefaultBaseIterators.this._exptype(n2);
                        if (n4 == n3) {
                            this.m_ancestors.addElement(DTMDefaultBaseIterators.this.makeNodeHandle(n2));
                        }
                        n2 = DTMDefaultBaseIterators.this._parent(n2);
                    }
                } else {
                    while (n2 != -1) {
                        int n5 = DTMDefaultBaseIterators.this._exptype(n2);
                        if (n5 >= 14 && DTMDefaultBaseIterators.this.m_expandedNameTable.getType(n5) == n3 || n5 < 14 && n5 == n3) {
                            this.m_ancestors.addElement(DTMDefaultBaseIterators.this.makeNodeHandle(n2));
                        }
                        n2 = DTMDefaultBaseIterators.this._parent(n2);
                    }
                }
                this.m_ancestorsPos = this.m_ancestors.size() - 1;
                this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
                return this.resetPosition();
            }
            return this;
        }
    }

    public class AncestorIterator
    extends InternalAxisIteratorBase {
        NodeVector m_ancestors;
        int m_ancestorsPos;
        int m_markedPos;
        int m_realStartNode;

        public AncestorIterator() {
            this.m_ancestors = new NodeVector();
        }

        public int getStartNode() {
            return this.m_realStartNode;
        }

        public final boolean isReverse() {
            return true;
        }

        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                AncestorIterator ancestorIterator = (AncestorIterator)super.clone();
                ancestorIterator._startNode = this._startNode;
                return ancestorIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DTMException(XMLMessages.createXMLMessage("ER_ITERATOR_CLONE_NOT_SUPPORTED", null));
            }
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            this.m_realStartNode = n;
            if (this._isRestartable) {
                int n2 = DTMDefaultBaseIterators.this.makeNodeIdentity(n);
                if (!this._includeSelf && n != -1) {
                    n2 = DTMDefaultBaseIterators.this._parent(n2);
                    n = DTMDefaultBaseIterators.this.makeNodeHandle(n2);
                }
                this._startNode = n;
                while (n2 != -1) {
                    this.m_ancestors.addElement(n);
                    n2 = DTMDefaultBaseIterators.this._parent(n2);
                    n = DTMDefaultBaseIterators.this.makeNodeHandle(n2);
                }
                this.m_ancestorsPos = this.m_ancestors.size() - 1;
                this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator reset() {
            this.m_ancestorsPos = this.m_ancestors.size() - 1;
            this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
            return this.resetPosition();
        }

        public int next() {
            int n;
            int n2 = this._currentNode;
            this._currentNode = (n = --this.m_ancestorsPos) >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
            return this.returnNode(n2);
        }

        public void setMark() {
            this.m_markedPos = this.m_ancestorsPos;
        }

        public void gotoMark() {
            this.m_ancestorsPos = this.m_markedPos;
            this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
        }
    }

    public final class TypedFollowingIterator
    extends FollowingIterator {
        private final int _nodeType;

        public TypedFollowingIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n;
            do {
                n = this._currentNode;
                this._currentNode = this.m_traverser.next(this._startNode, this._currentNode);
            } while (n != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n) != this._nodeType && DTMDefaultBaseIterators.this.getNodeType(n) != this._nodeType);
            return n == -1 ? -1 : this.returnNode(n);
        }
    }

    public class FollowingIterator
    extends InternalAxisIteratorBase {
        DTMAxisTraverser m_traverser;

        public FollowingIterator() {
            this.m_traverser = DTMDefaultBaseIterators.this.getAxisTraverser(6);
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = this.m_traverser.first(n);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n = this._currentNode;
            this._currentNode = this.m_traverser.next(this._startNode, this._currentNode);
            return this.returnNode(n);
        }
    }

    public final class TypedPrecedingIterator
    extends PrecedingIterator {
        private final int _nodeType;

        public TypedPrecedingIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = this._currentNode;
            int n2 = this._nodeType;
            if (n2 >= 14) {
                while (true) {
                    ++n;
                    if (this._sp < 0) {
                        n = -1;
                        break;
                    }
                    if (n >= this._stack[this._sp]) {
                        if (--this._sp >= 0) continue;
                        n = -1;
                        break;
                    }
                    if (DTMDefaultBaseIterators.this._exptype(n) == n2) break;
                }
            } else {
                while (true) {
                    ++n;
                    if (this._sp < 0) {
                        n = -1;
                        break;
                    }
                    if (n >= this._stack[this._sp]) {
                        if (--this._sp >= 0) continue;
                        n = -1;
                        break;
                    }
                    int n3 = DTMDefaultBaseIterators.this._exptype(n);
                    if (n3 < 14 ? n3 == n2 : DTMDefaultBaseIterators.this.m_expandedNameTable.getType(n3) == n2) break;
                }
            }
            this._currentNode = n;
            return n == -1 ? -1 : this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(n));
        }
    }

    public class PrecedingIterator
    extends InternalAxisIteratorBase {
        private final int _maxAncestors = 8;
        protected int[] _stack;
        protected int _sp;
        protected int _oldsp;
        protected int _markedsp;
        protected int _markedNode;
        protected int _markedDescendant;

        public PrecedingIterator() {
            this._maxAncestors = 8;
            this._stack = new int[8];
        }

        public boolean isReverse() {
            return true;
        }

        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                PrecedingIterator precedingIterator = (PrecedingIterator)super.clone();
                int[] nArray = new int[this._stack.length];
                System.arraycopy(this._stack, 0, nArray, 0, this._stack.length);
                precedingIterator._stack = nArray;
                return precedingIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DTMException(XMLMessages.createXMLMessage("ER_ITERATOR_CLONE_NOT_SUPPORTED", null));
            }
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                if (DTMDefaultBaseIterators.this._type(n = DTMDefaultBaseIterators.this.makeNodeIdentity(n)) == 2) {
                    n = DTMDefaultBaseIterators.this._parent(n);
                }
                this._startNode = n;
                int n2 = 0;
                this._stack[0] = n;
                int n3 = n;
                while ((n3 = DTMDefaultBaseIterators.this._parent(n3)) != -1) {
                    if (++n2 == this._stack.length) {
                        int[] nArray = new int[n2 + 4];
                        System.arraycopy(this._stack, 0, nArray, 0, n2);
                        this._stack = nArray;
                    }
                    this._stack[n2] = n3;
                }
                if (n2 > 0) {
                    --n2;
                }
                this._currentNode = this._stack[n2];
                this._oldsp = this._sp = n2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            ++this._currentNode;
            while (this._sp >= 0) {
                if (this._currentNode < this._stack[this._sp]) {
                    if (DTMDefaultBaseIterators.this._type(this._currentNode) != 2 && DTMDefaultBaseIterators.this._type(this._currentNode) != 13) {
                        return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._currentNode));
                    }
                } else {
                    --this._sp;
                }
                ++this._currentNode;
            }
            return -1;
        }

        public DTMAxisIterator reset() {
            this._sp = this._oldsp;
            return this.resetPosition();
        }

        public void setMark() {
            this._markedsp = this._sp;
            this._markedNode = this._currentNode;
            this._markedDescendant = this._stack[0];
        }

        public void gotoMark() {
            this._sp = this._markedsp;
            this._currentNode = this._markedNode;
        }
    }

    public final class TypedPrecedingSiblingIterator
    extends PrecedingSiblingIterator {
        private final int _nodeType;

        public TypedPrecedingSiblingIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = this._currentNode;
            int n2 = this._nodeType;
            int n3 = this._startNodeID;
            if (n2 >= 14) {
                while (n != -1 && n != n3 && DTMDefaultBaseIterators.this._exptype(n) != n2) {
                    n = DTMDefaultBaseIterators.this._nextsib(n);
                }
            } else {
                int n4;
                while (n != -1 && n != n3 && !((n4 = DTMDefaultBaseIterators.this._exptype(n)) < 14 ? n4 == n2 : DTMDefaultBaseIterators.this.m_expandedNameTable.getType(n4) == n2)) {
                    n = DTMDefaultBaseIterators.this._nextsib(n);
                }
            }
            if (n == -1 || n == this._startNodeID) {
                this._currentNode = -1;
                return -1;
            }
            this._currentNode = DTMDefaultBaseIterators.this._nextsib(n);
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(n));
        }
    }

    public class PrecedingSiblingIterator
    extends InternalAxisIteratorBase {
        protected int _startNodeID;

        public boolean isReverse() {
            return true;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._startNodeID = DTMDefaultBaseIterators.this.makeNodeIdentity(n);
                if ((n = this._startNodeID) == -1) {
                    this._currentNode = n;
                    return this.resetPosition();
                }
                short s = DTMDefaultBaseIterators.this.m_expandedNameTable.getType(DTMDefaultBaseIterators.this._exptype(n));
                if (2 == s || 13 == s) {
                    this._currentNode = n;
                } else {
                    this._currentNode = DTMDefaultBaseIterators.this._parent(n);
                    this._currentNode = -1 != this._currentNode ? DTMDefaultBaseIterators.this._firstch(this._currentNode) : n;
                }
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._currentNode == this._startNodeID || this._currentNode == -1) {
                return -1;
            }
            int n = this._currentNode;
            this._currentNode = DTMDefaultBaseIterators.this._nextsib(n);
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(n));
        }
    }

    public final class TypedAttributeIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedAttributeIterator(int n) {
            this._nodeType = n;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getTypedAttribute(n, this._nodeType);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(n);
        }
    }

    public final class AttributeIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstAttributeIdentity(DTMDefaultBaseIterators.this.makeNodeIdentity(n));
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n = this._currentNode;
            if (n != -1) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextAttributeIdentity(n);
                return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(n));
            }
            return -1;
        }
    }

    public final class TypedFollowingSiblingIterator
    extends FollowingSiblingIterator {
        private final int _nodeType;

        public TypedFollowingSiblingIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            if (this._currentNode == -1) {
                return -1;
            }
            int n = this._currentNode;
            int n2 = this._nodeType;
            if (n2 >= 14) {
                while ((n = DTMDefaultBaseIterators.this._nextsib(n)) != -1 && DTMDefaultBaseIterators.this._exptype(n) != n2) {
                }
            } else {
                int n3;
                while ((n = DTMDefaultBaseIterators.this._nextsib(n)) != -1 && !((n3 = DTMDefaultBaseIterators.this._exptype(n)) < 14 ? n3 == n2 : DTMDefaultBaseIterators.this.m_expandedNameTable.getType(n3) == n2)) {
                }
            }
            this._currentNode = n;
            return this._currentNode == -1 ? -1 : this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._currentNode));
        }
    }

    public class FollowingSiblingIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.makeNodeIdentity(n);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            this._currentNode = this._currentNode == -1 ? -1 : DTMDefaultBaseIterators.this._nextsib(this._currentNode);
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._currentNode));
        }
    }

    public final class NamespaceAttributeIterator
    extends InternalAxisIteratorBase {
        private final int _nsType;

        public NamespaceAttributeIterator(int n) {
            this._nsType = n;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(n, false);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n = this._currentNode;
            if (-1 != n) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, n, false);
            }
            return this.returnNode(n);
        }
    }

    public class TypedRootIterator
    extends RootIterator {
        private final int _nodeType;

        public TypedRootIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            if (this._startNode == this._currentNode) {
                return -1;
            }
            int n = this._nodeType;
            int n2 = this._startNode;
            int n3 = DTMDefaultBaseIterators.this.getExpandedTypeID(n2);
            this._currentNode = n2;
            if (n >= 14 ? n == n3 : (n3 < 14 ? n3 == n : DTMDefaultBaseIterators.this.m_expandedNameTable.getType(n3) == n)) {
                return this.returnNode(n2);
            }
            return -1;
        }
    }

    public class RootIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int n) {
            if (this._isRestartable) {
                this._startNode = DTMDefaultBaseIterators.this.getDocumentRoot(n);
                this._currentNode = -1;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._startNode == this._currentNode) {
                return -1;
            }
            this._currentNode = this._startNode;
            return this.returnNode(this._startNode);
        }
    }

    public class TypedNamespaceIterator
    extends NamespaceIterator {
        private final int _nodeType;

        public TypedNamespaceIterator(int n) {
            this._nodeType = n;
        }

        public int next() {
            int n = this._currentNode;
            while (n != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n) == this._nodeType || DTMDefaultBaseIterators.this.getNodeType(n) == this._nodeType || DTMDefaultBaseIterators.this.getNamespaceType(n) == this._nodeType) {
                    this._currentNode = n;
                    return this.returnNode(n);
                }
                n = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, n, true);
            }
            this._currentNode = -1;
            return -1;
        }
    }

    public class NamespaceIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(n, true);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n = this._currentNode;
            if (-1 != n) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, n, true);
            }
            return this.returnNode(n);
        }
    }

    public final class NamespaceChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nsType;

        public NamespaceChildrenIterator(int n) {
            this._nsType = n;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = n == -1 ? -1 : -2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._currentNode != -1) {
                int n;
                int n2 = n = -2 == this._currentNode ? DTMDefaultBaseIterators.this._firstch(DTMDefaultBaseIterators.this.makeNodeIdentity(this._startNode)) : DTMDefaultBaseIterators.this._nextsib(this._currentNode);
                while (n != -1) {
                    if (DTMDefaultBaseIterators.this.m_expandedNameTable.getNamespaceID(DTMDefaultBaseIterators.this._exptype(n)) == this._nsType) {
                        this._currentNode = n;
                        return this.returnNode(n);
                    }
                    n = DTMDefaultBaseIterators.this._nextsib(n);
                }
            }
            return -1;
        }
    }

    public final class TypedChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedChildrenIterator(int n) {
            this._nodeType = n;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = n == -1 ? -1 : DTMDefaultBaseIterators.this._firstch(DTMDefaultBaseIterators.this.makeNodeIdentity(this._startNode));
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n = this._currentNode;
            int n2 = this._nodeType;
            if (n2 >= 14) {
                while (n != -1 && DTMDefaultBaseIterators.this._exptype(n) != n2) {
                    n = DTMDefaultBaseIterators.this._nextsib(n);
                }
            } else {
                int n3;
                while (n != -1 && !((n3 = DTMDefaultBaseIterators.this._exptype(n)) < 14 ? n3 == n2 : DTMDefaultBaseIterators.this.m_expandedNameTable.getType(n3) == n2)) {
                    n = DTMDefaultBaseIterators.this._nextsib(n);
                }
            }
            if (n == -1) {
                this._currentNode = -1;
                return -1;
            }
            this._currentNode = DTMDefaultBaseIterators.this._nextsib(n);
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(n));
        }
    }

    public final class ParentIterator
    extends InternalAxisIteratorBase {
        private int _nodeType;

        public ParentIterator() {
            this._nodeType = -1;
        }

        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = DTMDefaultBaseIterators.this.getParent(n);
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator setNodeType(int n) {
            this._nodeType = n;
            return this;
        }

        public int next() {
            int n = this._currentNode;
            if (this._nodeType >= 14) {
                if (this._nodeType != DTMDefaultBaseIterators.this.getExpandedTypeID(this._currentNode)) {
                    n = -1;
                }
            } else if (this._nodeType != -1 && this._nodeType != DTMDefaultBaseIterators.this.getNodeType(this._currentNode)) {
                n = -1;
            }
            this._currentNode = -1;
            return this.returnNode(n);
        }
    }

    public final class ChildrenIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int n) {
            if (n == 0) {
                n = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = n;
                this._currentNode = n == -1 ? -1 : DTMDefaultBaseIterators.this._firstch(DTMDefaultBaseIterators.this.makeNodeIdentity(n));
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._currentNode != -1) {
                int n = this._currentNode;
                this._currentNode = DTMDefaultBaseIterators.this._nextsib(n);
                return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(n));
            }
            return -1;
        }
    }

    public abstract class InternalAxisIteratorBase
    extends DTMAxisIteratorBase {
        protected int _currentNode;

        public void setMark() {
            this._markedNode = this._currentNode;
        }

        public void gotoMark() {
            this._currentNode = this._markedNode;
        }
    }
}

