/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.client;

import com.sun.xml.internal.ws.client.SenderException;
import com.sun.xml.internal.ws.client.dispatch.DispatchContext;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.internal.ws.encoding.internal.InternalEncoder;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.internal.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.internal.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPUtil;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.Service;

public class SOAPXMLEncoder
extends SOAPEncoder {
    private static final Logger logger = Logger.getLogger(new StringBuffer().append("javax.enterprise.resource.webservices.jaxws").append(".client.dispatch.util").toString());

    protected boolean skipHeader(MessageInfo messageInfo) {
        return messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.PAYLOAD;
    }

    protected QName getHeaderTag() {
        return SOAPConstants.QNAME_SOAP_HEADER;
    }

    protected void skipHeader(XMLStreamReader xMLStreamReader) {
    }

    public InternalMessage toInternalMessage(MessageInfo messageInfo) {
        InternalMessage internalMessage = new InternalMessage();
        DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context");
        if (dispatchContext != null) {
            Object object;
            DispatchContext.MessageType messageType = (DispatchContext.MessageType)((Object)dispatchContext.getProperty("com.sun.xml.internal.ws.rt.client.dispatch.messagetype"));
            Object[] objectArray = messageInfo.getData();
            BodyBlock bodyBlock = null;
            switch (messageType) {
                case JAXB_MESSAGE: {
                    break;
                }
                case JAXB_PAYLOAD: {
                    object = new JAXBBeanInfo(objectArray[0], this.getJAXBContext(messageInfo));
                    bodyBlock = new BodyBlock((JAXBBeanInfo)object);
                    break;
                }
                case SOURCE_PAYLOAD: {
                    objectArray = messageInfo.getData();
                    bodyBlock = new BodyBlock((Source)objectArray[0]);
                    break;
                }
            }
            if (bodyBlock != null) {
                internalMessage.setBody(bodyBlock);
            }
            if ((object = (Map)((Map)messageInfo.getMetaData("com.sun.xml.internal.ws.context.request")).get("javax.xml.ws.binding.attachments.outbound")) != null) {
                for (Map.Entry entry : object.entrySet()) {
                    internalMessage.addAttachment(AttachmentBlock.fromDataHandler((String)entry.getKey(), (DataHandler)entry.getValue()));
                }
            }
        } else {
            SOAPEPTFactory sOAPEPTFactory = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            InternalEncoder internalEncoder = sOAPEPTFactory.getInternalEncoder();
            return (InternalMessage)internalEncoder.toInternalMessage(messageInfo);
        }
        return internalMessage;
    }

    public SOAPMessage toSOAPMessage(InternalMessage internalMessage, MessageInfo messageInfo) {
        SOAPMessage sOAPMessage = null;
        XMLStreamWriter xMLStreamWriter = null;
        JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = null;
        boolean bl = false;
        try {
            this.setAttachmentsMap(messageInfo, internalMessage);
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            if (messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic") {
                xMLStreamWriter = XMLStreamWriterFactory.createFIStreamWriter(byteArrayBuffer);
                jAXWSAttachmentMarshaller = MessageInfoUtil.getAttachmentMarshaller(messageInfo);
                if (jAXWSAttachmentMarshaller != null) {
                    bl = jAXWSAttachmentMarshaller.isXOPPackage();
                    jAXWSAttachmentMarshaller.setXOPPackage(false);
                }
            } else {
                messageInfo.setMetaData("com.sun.xml.internal.bind.api.Bridge.outputStream", byteArrayBuffer);
                xMLStreamWriter = XMLStreamWriterFactory.createXMLStreamWriter(byteArrayBuffer);
            }
            xMLStreamWriter.writeStartDocument();
            this.startEnvelope(xMLStreamWriter);
            this.writeEnvelopeNamespaces(xMLStreamWriter, messageInfo);
            if (!this.skipHeader(messageInfo)) {
                this.writeHeaders(xMLStreamWriter, internalMessage, messageInfo);
            }
            this.writeBody(xMLStreamWriter, internalMessage, messageInfo);
            this.endEnvelope(xMLStreamWriter);
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.close();
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", this.getContentType(messageInfo, jAXWSAttachmentMarshaller));
            sOAPMessage = SOAPUtil.createMessage(mimeHeaders, byteArrayBuffer.newInputStream(), this.getBindingId());
            this.processAttachments(internalMessage, sOAPMessage);
            if (jAXWSAttachmentMarshaller != null) {
                jAXWSAttachmentMarshaller.setXOPPackage(bl);
            }
        }
        catch (IOException iOException) {
            throw new SenderException("sender.request.messageNotReady", new Object[]{iOException});
        }
        catch (SOAPException sOAPException) {
            throw new SenderException(sOAPException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SenderException(xMLStreamException);
        }
        finally {
            if (xMLStreamWriter != null) {
                try {
                    xMLStreamWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new SenderException(xMLStreamException);
                }
            }
        }
        return sOAPMessage;
    }

    public InternalMessage createInternalMessage(MessageInfo messageInfo) {
        InternalMessage internalMessage = new InternalMessage();
        Object object = messageInfo.getResponse();
        BodyBlock bodyBlock = null;
        if (this.getJAXBContext(messageInfo) != null) {
            JAXBBeanInfo jAXBBeanInfo = new JAXBBeanInfo(object, this.getJAXBContext(messageInfo));
            bodyBlock = new BodyBlock(jAXBBeanInfo);
        } else if (object instanceof Source) {
            bodyBlock = new BodyBlock((Source)object);
        }
        internalMessage.setBody(bodyBlock);
        return internalMessage;
    }

    protected String getContentType(MessageInfo messageInfo, JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller) {
        String string = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (jAXWSAttachmentMarshaller == null) {
            jAXWSAttachmentMarshaller = MessageInfoUtil.getAttachmentMarshaller(messageInfo);
        }
        if (jAXWSAttachmentMarshaller != null && jAXWSAttachmentMarshaller.isXopped()) {
            return "application/xop+xml;type=\"text/xml\"";
        }
        return string == "optimistic" ? "application/fastinfoset" : "text/xml";
    }

    protected String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }
}

