/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List
extends Component
implements ItemSelectable,
Accessible {
    Vector items = new Vector();
    int rows = 0;
    boolean multipleMode = false;
    int[] selected = new int[0];
    int visibleIndex = -1;
    transient ActionListener actionListener;
    transient ItemListener itemListener;
    private static final String base = "list";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -3304312411574666869L;
    static final int DEFAULT_VISIBLE_ROWS = 4;
    private int listSerializedDataVersion = 1;

    public List() throws HeadlessException {
        this(0, false);
    }

    public List(int n) throws HeadlessException {
        this(n, false);
    }

    public List(int n, boolean bl) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.rows = n != 0 ? n : 4;
        this.multipleMode = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<List> clazz = List.class;
        synchronized (List.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createList(this);
            }
            super.addNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                this.selected = listPeer.getSelectedIndexes();
            }
            super.removeNotify();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    @Deprecated
    public int countItems() {
        return this.items.size();
    }

    public String getItem(int n) {
        return this.getItemImpl(n);
    }

    final String getItemImpl(int n) {
        return (String)this.items.elementAt(n);
    }

    public synchronized String[] getItems() {
        Object[] objectArray = new String[this.items.size()];
        this.items.copyInto(objectArray);
        return objectArray;
    }

    public void add(String string) {
        this.addItem(string);
    }

    @Deprecated
    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    @Deprecated
    public synchronized void addItem(String string, int n) {
        if (n < -1 || n >= this.items.size()) {
            n = -1;
        }
        if (string == null) {
            string = "";
        }
        if (n == -1) {
            this.items.addElement(string);
        } else {
            this.items.insertElementAt(string, n);
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.addItem(string, n);
        }
    }

    public synchronized void replaceItem(String string, int n) {
        this.remove(n);
        this.add(string, n);
    }

    public void removeAll() {
        this.clear();
    }

    @Deprecated
    public synchronized void clear() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.clear();
        }
        this.items = new Vector();
        this.selected = new int[0];
    }

    public synchronized void remove(String string) {
        int n = this.items.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("item " + string + " not found in list");
        }
        this.remove(n);
    }

    public void remove(int n) {
        this.delItem(n);
    }

    @Deprecated
    public void delItem(int n) {
        this.delItems(n, n);
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        return nArray.length == 1 ? nArray[0] : -1;
    }

    public synchronized int[] getSelectedIndexes() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            this.selected = listPeer.getSelectedIndexes();
        }
        return (int[])this.selected.clone();
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        return n < 0 ? null : this.getItem(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.getItem(nArray[i]);
        }
        return stringArray;
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(int n) {
        ListPeer listPeer;
        do {
            if ((listPeer = (ListPeer)this.peer) != null) {
                listPeer.select(n);
                return;
            }
            List list = this;
            synchronized (list) {
                boolean bl = false;
                for (int i = 0; i < this.selected.length; ++i) {
                    if (this.selected[i] != n) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (!this.multipleMode) {
                        this.selected = new int[1];
                        this.selected[0] = n;
                    } else {
                        int[] nArray = new int[this.selected.length + 1];
                        System.arraycopy(this.selected, 0, nArray, 0, this.selected.length);
                        nArray[this.selected.length] = n;
                        this.selected = nArray;
                    }
                }
            }
        } while (listPeer != this.peer);
    }

    public synchronized void deselect(int n) {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null && (this.isMultipleMode() || this.getSelectedIndex() == n)) {
            listPeer.deselect(n);
        }
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i] != n) continue;
            int[] nArray = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, nArray, 0, i);
            System.arraycopy(this.selected, i + 1, nArray, i, this.selected.length - (i + 1));
            this.selected = nArray;
            return;
        }
    }

    public boolean isIndexSelected(int n) {
        return this.isSelected(n);
    }

    @Deprecated
    public boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    @Deprecated
    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    @Deprecated
    public synchronized void setMultipleSelections(boolean bl) {
        if (bl != this.multipleMode) {
            this.multipleMode = bl;
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                listPeer.setMultipleSelections(bl);
            }
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void makeVisible(int n) {
        this.visibleIndex = n;
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.makeVisible(n);
        }
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension preferredSize(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            return listPeer != null ? listPeer.preferredSize(n) : super.preferredSize();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 ? this.preferredSize(this.rows) : super.preferredSize();
        }
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension minimumSize(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            return listPeer != null ? listPeer.minimumSize(n) : super.minimumSize();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.rows > 0 ? this.minimumSize(this.rows) : super.minimumSize();
        }
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener eventListener = null;
        if (clazz == ActionListener.class) {
            eventListener = this.actionListener;
        } else if (clazz == ItemListener.class) {
            eventListener = this.itemListener;
        } else {
            return super.getListeners(clazz);
        }
        return AWTEventMulticaster.getListeners((EventListener)eventListener, clazz);
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 1001: {
                return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
            }
            case 701: {
                return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        ItemListener itemListener = this.itemListener;
        if (itemListener != null) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        ActionListener actionListener = this.actionListener;
        if (actionListener != null) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",selected=" + this.getSelectedItem();
    }

    @Deprecated
    public synchronized void delItems(int n, int n2) {
        for (int i = n2; i >= n; --i) {
            this.items.removeElementAt(i);
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.delItems(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        List list = this;
        synchronized (list) {
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                this.selected = listPeer.getSelectedIndexes();
            }
        }
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTList();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTList
    extends Component.AccessibleAWTComponent
    implements AccessibleSelection,
    ItemListener,
    ActionListener {
        private static final long serialVersionUID = 7924617370136012829L;

        public AccessibleAWTList() {
            super(List.this);
            List.this.addActionListener(this);
            List.this.addItemListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (List.this.isMultipleMode()) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return List.this.getItemCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Accessible getAccessibleChild(int n) {
            List list = List.this;
            synchronized (list) {
                if (n >= List.this.getItemCount()) {
                    return null;
                }
                return new AccessibleAWTListChild(List.this, n);
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return List.this.getSelectedIndexes().length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Accessible getAccessibleSelection(int n) {
            List list = List.this;
            synchronized (list) {
                int n2 = this.getAccessibleSelectionCount();
                if (n < 0 || n >= n2) {
                    return null;
                }
                return this.getAccessibleChild(List.this.getSelectedIndexes()[n]);
            }
        }

        public boolean isAccessibleChildSelected(int n) {
            return List.this.isIndexSelected(n);
        }

        public void addAccessibleSelection(int n) {
            List.this.select(n);
        }

        public void removeAccessibleSelection(int n) {
            List.this.deselect(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAccessibleSelection() {
            List list = List.this;
            synchronized (list) {
                int[] nArray = List.this.getSelectedIndexes();
                if (nArray == null) {
                    return;
                }
                for (int i = nArray.length - 1; i >= 0; --i) {
                    List.this.deselect(nArray[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectAllAccessibleSelection() {
            List list = List.this;
            synchronized (list) {
                for (int i = List.this.getItemCount() - 1; i >= 0; --i) {
                    List.this.select(i);
                }
            }
        }

        protected class AccessibleAWTListChild
        extends Component.AccessibleAWTComponent
        implements Accessible {
            private static final long serialVersionUID = 4412022926028300317L;
            private List parent;
            private int indexInParent;

            public AccessibleAWTListChild(List list, int n) {
                super(List.this);
                this.parent = list;
                this.setAccessibleParent(list);
                this.indexInParent = n;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
                if (this.parent.isIndexSelected(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                return accessibleStateSet;
            }

            public Locale getLocale() {
                return this.parent.getLocale();
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Color getBackground() {
                return this.parent.getBackground();
            }

            public void setBackground(Color color) {
                this.parent.setBackground(color);
            }

            public Color getForeground() {
                return this.parent.getForeground();
            }

            public void setForeground(Color color) {
                this.parent.setForeground(color);
            }

            public Cursor getCursor() {
                return this.parent.getCursor();
            }

            public void setCursor(Cursor cursor) {
                this.parent.setCursor(cursor);
            }

            public Font getFont() {
                return this.parent.getFont();
            }

            public void setFont(Font font) {
                this.parent.setFont(font);
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.parent.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.parent.isEnabled();
            }

            public void setEnabled(boolean bl) {
                this.parent.setEnabled(bl);
            }

            public boolean isVisible() {
                return false;
            }

            public void setVisible(boolean bl) {
                this.parent.setVisible(bl);
            }

            public boolean isShowing() {
                return false;
            }

            public boolean contains(Point point) {
                return false;
            }

            public Point getLocationOnScreen() {
                return null;
            }

            public Point getLocation() {
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return null;
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                return null;
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return false;
            }

            public void requestFocus() {
            }

            public void addFocusListener(FocusListener focusListener) {
            }

            public void removeFocusListener(FocusListener focusListener) {
            }
        }
    }
}

