/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.OrQueryExp;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.QueryExp;

class AndQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -1081892073854801359L;
    private QueryExp exp1;
    private QueryExp exp2;

    public AndQueryExp() {
    }

    public AndQueryExp(QueryExp queryExp, QueryExp queryExp2) {
        this.exp1 = queryExp;
        this.exp2 = queryExp2;
    }

    public QueryExp getLeftExp() {
        return this.exp1;
    }

    public QueryExp getRightExp() {
        return this.exp2;
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        return this.exp1.apply(objectName) && this.exp2.apply(objectName);
    }

    public String toString() {
        return "(" + this.exp1 + ") and (" + this.exp2 + ")";
    }

    String toQueryString() {
        return AndQueryExp.parens(this.exp1) + " and " + AndQueryExp.parens(this.exp2);
    }

    private static String parens(QueryExp queryExp) {
        String string = Query.toString(queryExp);
        if (queryExp instanceof OrQueryExp) {
            return "(" + string + ")";
        }
        return string;
    }
}

