/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.text.ParsePosition;
import java.util.Iterator;
import java.util.TreeSet;
import sun.text.normalizer.RuleCharacterIterator;
import sun.text.normalizer.SymbolTable;
import sun.text.normalizer.UCharacter;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.UnicodeMatcher;
import sun.text.normalizer.Utility;
import sun.text.normalizer.VersionInfo;

public class UnicodeSet
implements UnicodeMatcher {
    private static final int LOW = 0;
    private static final int HIGH = 0x110000;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    private int len;
    private int[] list;
    private int[] rangeList;
    private int[] buffer;
    TreeSet strings = new TreeSet();
    private String pat = null;
    private static final int START_EXTRA = 16;
    private static final int GROW_EXTRA = 16;
    private static UnicodeSet INCLUSIONS = null;
    static final VersionInfo NO_VERSION = VersionInfo.getInstance(0, 0, 0, 0);
    public static final int IGNORE_SPACE = 1;

    public UnicodeSet() {
        this.list = new int[17];
        this.list[this.len++] = 0x110000;
    }

    public UnicodeSet(int n, int n2) {
        this();
        this.complement(n, n2);
    }

    public UnicodeSet(String string) {
        this();
        this.applyPattern(string, null, null, 1);
    }

    public UnicodeSet set(UnicodeSet unicodeSet) {
        this.list = (int[])unicodeSet.list.clone();
        this.len = unicodeSet.len;
        this.pat = unicodeSet.pat;
        this.strings = (TreeSet)unicodeSet.strings.clone();
        return this;
    }

    public final UnicodeSet applyPattern(String string) {
        return this.applyPattern(string, null, null, 1);
    }

    private static void _appendToPat(StringBuffer stringBuffer, String string, boolean bl) {
        for (int i = 0; i < string.length(); i += UTF16.getCharCount(i)) {
            UnicodeSet._appendToPat(stringBuffer, UTF16.charAt(string, i), bl);
        }
    }

    private static void _appendToPat(StringBuffer stringBuffer, int n, boolean bl) {
        if (bl && Utility.isUnprintable(n) && Utility.escapeUnprintable(stringBuffer, n)) {
            return;
        }
        switch (n) {
            case 36: 
            case 38: 
            case 45: 
            case 58: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 125: {
                stringBuffer.append('\\');
                break;
            }
            default: {
                if (!UCharacterProperty.isRuleWhiteSpace(n)) break;
                stringBuffer.append('\\');
            }
        }
        UTF16.append(stringBuffer, n);
    }

    private StringBuffer _toPattern(StringBuffer stringBuffer, boolean bl) {
        if (this.pat != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.pat.length()) {
                int n3 = UTF16.charAt(this.pat, n2);
                n2 += UTF16.getCharCount(n3);
                if (bl && Utility.isUnprintable(n3)) {
                    if (n % 2 == 1) {
                        stringBuffer.setLength(stringBuffer.length() - 1);
                    }
                    Utility.escapeUnprintable(stringBuffer, n3);
                    n = 0;
                    continue;
                }
                UTF16.append(stringBuffer, n3);
                if (n3 == 92) {
                    ++n;
                    continue;
                }
                n = 0;
            }
            return stringBuffer;
        }
        return this._generatePattern(stringBuffer, bl);
    }

    public StringBuffer _generatePattern(StringBuffer stringBuffer, boolean bl) {
        int n;
        int n2;
        int n3;
        stringBuffer.append('[');
        int n4 = this.getRangeCount();
        if (n4 > 1 && this.getRangeStart(0) == 0 && this.getRangeEnd(n4 - 1) == 0x10FFFF) {
            stringBuffer.append('^');
            for (n3 = 1; n3 < n4; ++n3) {
                n2 = this.getRangeEnd(n3 - 1) + 1;
                n = this.getRangeStart(n3) - 1;
                UnicodeSet._appendToPat(stringBuffer, n2, bl);
                if (n2 == n) continue;
                if (n2 + 1 != n) {
                    stringBuffer.append('-');
                }
                UnicodeSet._appendToPat(stringBuffer, n, bl);
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = this.getRangeStart(n3);
                n = this.getRangeEnd(n3);
                UnicodeSet._appendToPat(stringBuffer, n2, bl);
                if (n2 == n) continue;
                if (n2 + 1 != n) {
                    stringBuffer.append('-');
                }
                UnicodeSet._appendToPat(stringBuffer, n, bl);
            }
        }
        if (this.strings.size() > 0) {
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append('{');
                UnicodeSet._appendToPat(stringBuffer, (String)iterator.next(), bl);
                stringBuffer.append('}');
            }
        }
        return stringBuffer.append(']');
    }

    public UnicodeSet add(int n, int n2) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n, 6));
        }
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (n < n2) {
            this.add(this.range(n, n2), 2, 0);
        } else if (n == n2) {
            this.add(n);
        }
        return this;
    }

    public final UnicodeSet add(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n, 6));
        }
        int n2 = this.findCodePoint(n);
        if ((n2 & 1) != 0) {
            return this;
        }
        if (n == this.list[n2] - 1) {
            this.list[n2] = n;
            if (n == 0x10FFFF) {
                this.ensureCapacity(this.len + 1);
                this.list[this.len++] = 0x110000;
            }
            if (n2 > 0 && n == this.list[n2 - 1]) {
                System.arraycopy(this.list, n2 + 1, this.list, n2 - 1, this.len - n2 - 1);
                this.len -= 2;
            }
        } else if (n2 > 0 && n == this.list[n2 - 1]) {
            int n3 = n2 - 1;
            this.list[n3] = this.list[n3] + 1;
        } else {
            if (this.len + 2 > this.list.length) {
                int[] nArray = new int[this.len + 2 + 16];
                if (n2 != 0) {
                    System.arraycopy(this.list, 0, nArray, 0, n2);
                }
                System.arraycopy(this.list, n2, nArray, n2 + 2, this.len - n2);
                this.list = nArray;
            } else {
                System.arraycopy(this.list, n2, this.list, n2 + 2, this.len - n2);
            }
            this.list[n2] = n;
            this.list[n2 + 1] = n + 1;
            this.len += 2;
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet add(String string) {
        int n = UnicodeSet.getSingleCP(string);
        if (n < 0) {
            this.strings.add(string);
            this.pat = null;
        } else {
            this.add(n, n);
        }
        return this;
    }

    private static int getSingleCP(String string) {
        if (string.length() < 1) {
            throw new IllegalArgumentException("Can't use zero-length strings in UnicodeSet");
        }
        if (string.length() > 2) {
            return -1;
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        int n = UTF16.charAt(string, 0);
        if (n > 65535) {
            return n;
        }
        return -1;
    }

    public UnicodeSet complement(int n, int n2) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n, 6));
        }
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n2, 6));
        }
        if (n <= n2) {
            this.xor(this.range(n, n2), 2, 0);
        }
        this.pat = null;
        return this;
    }

    public UnicodeSet complement() {
        if (this.list[0] == 0) {
            System.arraycopy(this.list, 1, this.list, 0, this.len - 1);
            --this.len;
        } else {
            this.ensureCapacity(this.len + 1);
            System.arraycopy(this.list, 0, this.list, 1, this.len);
            this.list[0] = 0;
            ++this.len;
        }
        this.pat = null;
        return this;
    }

    public boolean contains(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(n, 6));
        }
        int n2 = this.findCodePoint(n);
        return (n2 & 1) != 0;
    }

    private final int findCodePoint(int n) {
        if (n < this.list[0]) {
            return 0;
        }
        if (this.len >= 2 && n >= this.list[this.len - 2]) {
            return this.len - 1;
        }
        int n2 = 0;
        int n3 = this.len - 1;
        int n4;
        while ((n4 = n2 + n3 >>> 1) != n2) {
            if (n < this.list[n4]) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n3;
    }

    public UnicodeSet addAll(UnicodeSet unicodeSet) {
        this.add(unicodeSet.list, unicodeSet.len, 0);
        this.strings.addAll(unicodeSet.strings);
        return this;
    }

    public UnicodeSet retainAll(UnicodeSet unicodeSet) {
        this.retain(unicodeSet.list, unicodeSet.len, 0);
        this.strings.retainAll(unicodeSet.strings);
        return this;
    }

    public UnicodeSet removeAll(UnicodeSet unicodeSet) {
        this.retain(unicodeSet.list, unicodeSet.len, 2);
        this.strings.removeAll(unicodeSet.strings);
        return this;
    }

    public UnicodeSet clear() {
        this.list[0] = 0x110000;
        this.len = 1;
        this.pat = null;
        this.strings.clear();
        return this;
    }

    public int getRangeCount() {
        return this.len / 2;
    }

    public int getRangeStart(int n) {
        return this.list[n * 2];
    }

    public int getRangeEnd(int n) {
        return this.list[n * 2 + 1] - 1;
    }

    UnicodeSet applyPattern(String string, ParsePosition parsePosition, SymbolTable symbolTable, int n) {
        boolean bl;
        boolean bl2 = bl = parsePosition == null;
        if (bl) {
            parsePosition = new ParsePosition(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        RuleCharacterIterator ruleCharacterIterator = new RuleCharacterIterator(string, symbolTable, parsePosition);
        this.applyPattern(ruleCharacterIterator, symbolTable, stringBuffer, n);
        if (ruleCharacterIterator.inVariable()) {
            UnicodeSet.syntaxError(ruleCharacterIterator, "Extra chars in variable value");
        }
        this.pat = stringBuffer.toString();
        if (bl) {
            int n2 = parsePosition.getIndex();
            if ((n & 1) != 0) {
                n2 = Utility.skipWhitespace(string, n2);
            }
            if (n2 != string.length()) {
                throw new IllegalArgumentException("Parse of \"" + string + "\" failed at " + n2);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void applyPattern(RuleCharacterIterator ruleCharacterIterator, SymbolTable symbolTable, StringBuffer stringBuffer, int n) {
        int n2 = 3;
        if ((n & 1) != 0) {
            n2 |= 4;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = null;
        boolean bl = false;
        UnicodeSet unicodeSet = null;
        Object object = null;
        char c = '\u0000';
        int n3 = 0;
        int n4 = 0;
        char c2 = '\u0000';
        boolean bl2 = false;
        this.clear();
        block25: while (n4 != 2 && !ruleCharacterIterator.atEnd()) {
            int n5;
            UnicodeSet unicodeSet2;
            boolean bl3;
            int n6;
            block66: {
                UnicodeMatcher unicodeMatcher;
                block68: {
                    block67: {
                        n6 = 0;
                        bl3 = false;
                        unicodeSet2 = null;
                        n5 = 0;
                        if (!UnicodeSet.resemblesPropertyPattern(ruleCharacterIterator, n2)) break block67;
                        n5 = 2;
                        break block66;
                    }
                    object = ruleCharacterIterator.getPos(object);
                    n6 = ruleCharacterIterator.next(n2);
                    bl3 = ruleCharacterIterator.isEscaped();
                    if (n6 != 91 || bl3) break block68;
                    if (n4 == 1) {
                        ruleCharacterIterator.setPos(object);
                        n5 = 1;
                        break block66;
                    } else {
                        n4 = 1;
                        stringBuffer2.append('[');
                        object = ruleCharacterIterator.getPos(object);
                        n6 = ruleCharacterIterator.next(n2);
                        bl3 = ruleCharacterIterator.isEscaped();
                        if (n6 == 94 && !bl3) {
                            bl2 = true;
                            stringBuffer2.append('^');
                            object = ruleCharacterIterator.getPos(object);
                            n6 = ruleCharacterIterator.next(n2);
                            bl3 = ruleCharacterIterator.isEscaped();
                        }
                        if (n6 == 45) {
                            bl3 = true;
                            break block66;
                        } else {
                            ruleCharacterIterator.setPos(object);
                            continue;
                        }
                    }
                }
                if (symbolTable != null && (unicodeMatcher = symbolTable.lookupMatcher(n6)) != null) {
                    try {
                        unicodeSet2 = (UnicodeSet)unicodeMatcher;
                        n5 = 3;
                    }
                    catch (ClassCastException classCastException) {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Syntax error");
                    }
                }
            }
            if (n5 != 0) {
                if (c == '\u0001') {
                    if (c2 != '\u0000') {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Char expected after operator");
                    }
                    this.add(n3, n3);
                    UnicodeSet._appendToPat(stringBuffer2, n3, false);
                    c2 = '\u0000';
                    c = '\u0000';
                }
                if (c2 == '-' || c2 == '&') {
                    stringBuffer2.append(c2);
                }
                if (unicodeSet2 == null) {
                    if (unicodeSet == null) {
                        unicodeSet = new UnicodeSet();
                    }
                    unicodeSet2 = unicodeSet;
                }
                switch (n5) {
                    case 1: {
                        unicodeSet2.applyPattern(ruleCharacterIterator, symbolTable, stringBuffer2, n);
                        break;
                    }
                    case 2: {
                        ruleCharacterIterator.skipIgnored(n2);
                        unicodeSet2.applyPropertyPattern(ruleCharacterIterator, stringBuffer2, symbolTable);
                        break;
                    }
                    case 3: {
                        unicodeSet2._toPattern(stringBuffer2, false);
                        break;
                    }
                }
                bl = true;
                if (n4 == 0) {
                    this.set(unicodeSet2);
                    n4 = 2;
                    break;
                }
                switch (c2) {
                    case '-': {
                        this.removeAll(unicodeSet2);
                        break;
                    }
                    case '&': {
                        this.retainAll(unicodeSet2);
                        break;
                    }
                    case '\u0000': {
                        this.addAll(unicodeSet2);
                        break;
                    }
                }
                c2 = '\u0000';
                c = '\u0002';
                continue;
            }
            if (n4 == 0) {
                UnicodeSet.syntaxError(ruleCharacterIterator, "Missing '['");
            }
            if (!bl3) {
                switch (n6) {
                    case 93: {
                        if (c == '\u0001') {
                            this.add(n3, n3);
                            UnicodeSet._appendToPat(stringBuffer2, n3, false);
                        }
                        if (c2 == '-') {
                            this.add(c2, c2);
                            stringBuffer2.append(c2);
                        } else if (c2 == '&') {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Trailing '&'");
                        }
                        stringBuffer2.append(']');
                        n4 = 2;
                        continue block25;
                    }
                    case 45: {
                        if (c2 == '\u0000') {
                            if (c != '\u0000') {
                                c2 = (char)n6;
                                continue block25;
                            }
                            this.add(n6, n6);
                            n6 = ruleCharacterIterator.next(n2);
                            bl3 = ruleCharacterIterator.isEscaped();
                            if (n6 == 93 && !bl3) {
                                stringBuffer2.append("-]");
                                n4 = 2;
                                continue block25;
                            }
                        }
                        UnicodeSet.syntaxError(ruleCharacterIterator, "'-' not after char or set");
                    }
                    case 38: {
                        if (c == '\u0002' && c2 == '\u0000') {
                            c2 = (char)n6;
                            continue block25;
                        }
                        UnicodeSet.syntaxError(ruleCharacterIterator, "'&' not after set");
                    }
                    case 94: {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "'^' not after '['");
                    }
                    case 123: {
                        if (c2 != '\u0000') {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Missing operand after operator");
                        }
                        if (c == '\u0001') {
                            this.add(n3, n3);
                            UnicodeSet._appendToPat(stringBuffer2, n3, false);
                        }
                        c = '\u0000';
                        if (stringBuffer3 == null) {
                            stringBuffer3 = new StringBuffer();
                        } else {
                            stringBuffer3.setLength(0);
                        }
                        boolean bl4 = false;
                        while (!ruleCharacterIterator.atEnd()) {
                            n6 = ruleCharacterIterator.next(n2);
                            bl3 = ruleCharacterIterator.isEscaped();
                            if (n6 == 125 && !bl3) {
                                bl4 = true;
                                break;
                            }
                            UTF16.append(stringBuffer3, n6);
                        }
                        if (stringBuffer3.length() < 1 || !bl4) {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Invalid multicharacter string");
                        }
                        this.add(stringBuffer3.toString());
                        stringBuffer2.append('{');
                        UnicodeSet._appendToPat(stringBuffer2, stringBuffer3.toString(), false);
                        stringBuffer2.append('}');
                        continue block25;
                    }
                    case 36: {
                        boolean bl5;
                        object = ruleCharacterIterator.getPos(object);
                        n6 = ruleCharacterIterator.next(n2);
                        bl3 = ruleCharacterIterator.isEscaped();
                        boolean bl6 = bl5 = n6 == 93 && !bl3;
                        if (symbolTable == null && !bl5) {
                            n6 = 36;
                            ruleCharacterIterator.setPos(object);
                            break;
                        }
                        if (bl5 && c2 == '\u0000') {
                            if (c == '\u0001') {
                                this.add(n3, n3);
                                UnicodeSet._appendToPat(stringBuffer2, n3, false);
                            }
                            this.add(65535);
                            bl = true;
                            stringBuffer2.append('$').append(']');
                            n4 = 2;
                            continue block25;
                        }
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Unquoted '$'");
                        break;
                    }
                }
            }
            switch (c) {
                case '\u0000': {
                    c = '\u0001';
                    n3 = n6;
                    break;
                }
                case '\u0001': {
                    if (c2 == '-') {
                        if (n3 >= n6) {
                            UnicodeSet.syntaxError(ruleCharacterIterator, "Invalid range");
                        }
                        this.add(n3, n6);
                        UnicodeSet._appendToPat(stringBuffer2, n3, false);
                        stringBuffer2.append(c2);
                        UnicodeSet._appendToPat(stringBuffer2, n6, false);
                        c2 = '\u0000';
                        c = '\u0000';
                        break;
                    }
                    this.add(n3, n3);
                    UnicodeSet._appendToPat(stringBuffer2, n3, false);
                    n3 = n6;
                    break;
                }
                case '\u0002': {
                    if (c2 != '\u0000') {
                        UnicodeSet.syntaxError(ruleCharacterIterator, "Set expected after operator");
                    }
                    n3 = n6;
                    c = '\u0001';
                    continue block25;
                }
            }
        }
        if (n4 != 2) {
            UnicodeSet.syntaxError(ruleCharacterIterator, "Missing ']'");
        }
        ruleCharacterIterator.skipIgnored(n2);
        if (bl2) {
            this.complement();
        }
        if (bl) {
            stringBuffer.append(stringBuffer2.toString());
            return;
        }
        this._generatePattern(stringBuffer, false);
    }

    private static void syntaxError(RuleCharacterIterator ruleCharacterIterator, String string) {
        throw new IllegalArgumentException("Error: " + string + " at \"" + Utility.escape(ruleCharacterIterator.toString()) + '\"');
    }

    private void ensureCapacity(int n) {
        if (n <= this.list.length) {
            return;
        }
        int[] nArray = new int[n + 16];
        System.arraycopy(this.list, 0, nArray, 0, this.len);
        this.list = nArray;
    }

    private void ensureBufferCapacity(int n) {
        if (this.buffer != null && n <= this.buffer.length) {
            return;
        }
        this.buffer = new int[n + 16];
    }

    private int[] range(int n, int n2) {
        if (this.rangeList == null) {
            this.rangeList = new int[]{n, n2 + 1, 0x110000};
        } else {
            this.rangeList[0] = n;
            this.rangeList[1] = n2 + 1;
        }
        return this.rangeList;
    }

    private UnicodeSet xor(int[] nArray, int n, int n2) {
        int n3;
        this.ensureBufferCapacity(this.len + n);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.list[n4++];
        if (n2 == 1 || n2 == 2) {
            n3 = 0;
            if (nArray[n5] == 0) {
                n3 = nArray[++n5];
            }
        } else {
            n3 = nArray[n5++];
        }
        while (true) {
            if (n7 < n3) {
                this.buffer[n6++] = n7;
                n7 = this.list[n4++];
                continue;
            }
            if (n3 < n7) {
                this.buffer[n6++] = n3;
                n3 = nArray[n5++];
                continue;
            }
            if (n7 == 0x110000) break;
            n7 = this.list[n4++];
            n3 = nArray[n5++];
        }
        this.buffer[n6++] = 0x110000;
        this.len = n6;
        int[] nArray2 = this.list;
        this.list = this.buffer;
        this.buffer = nArray2;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnicodeSet add(int[] nArray, int n, int n2) {
        this.ensureBufferCapacity(this.len + n);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.list[n3++];
        int n7 = nArray[n4++];
        block6: while (true) {
            switch (n2) {
                case 0: {
                    if (n6 < n7) {
                        if (n5 > 0 && n6 <= this.buffer[n5 - 1]) {
                            n6 = UnicodeSet.max(this.list[n3], this.buffer[--n5]);
                        } else {
                            this.buffer[n5++] = n6;
                            n6 = this.list[n3];
                        }
                        ++n3;
                        n2 ^= 1;
                        break;
                    }
                    if (n7 < n6) {
                        if (n5 > 0 && n7 <= this.buffer[n5 - 1]) {
                            n7 = UnicodeSet.max(nArray[n4], this.buffer[--n5]);
                        } else {
                            this.buffer[n5++] = n7;
                            n7 = nArray[n4];
                        }
                        ++n4;
                        n2 ^= 2;
                        break;
                    }
                    if (n6 == 0x110000) break block6;
                    if (n5 > 0 && n6 <= this.buffer[n5 - 1]) {
                        n6 = UnicodeSet.max(this.list[n3], this.buffer[--n5]);
                    } else {
                        this.buffer[n5++] = n6;
                        n6 = this.list[n3];
                    }
                    ++n3;
                    n2 ^= 1;
                    n7 = nArray[n4++];
                    n2 ^= 2;
                    break;
                }
                case 3: {
                    if (n7 <= n6) {
                        if (n6 == 0x110000) break block6;
                        this.buffer[n5++] = n6;
                    } else {
                        if (n7 == 0x110000) break block6;
                        this.buffer[n5++] = n7;
                    }
                    n6 = this.list[n3++];
                    n2 ^= 1;
                    n7 = nArray[n4++];
                    n2 ^= 2;
                    break;
                }
                case 1: {
                    if (n6 < n7) {
                        this.buffer[n5++] = n6;
                        n6 = this.list[n3++];
                        n2 ^= 1;
                        break;
                    }
                    if (n7 < n6) {
                        n7 = nArray[n4++];
                        n2 ^= 2;
                        break;
                    }
                    if (n6 == 0x110000) break block6;
                    n6 = this.list[n3++];
                    n2 ^= 1;
                    n7 = nArray[n4++];
                    n2 ^= 2;
                    break;
                }
                case 2: {
                    if (n7 < n6) {
                        this.buffer[n5++] = n7;
                        n7 = nArray[n4++];
                        n2 ^= 2;
                        break;
                    }
                    if (n6 < n7) {
                        n6 = this.list[n3++];
                        n2 ^= 1;
                        break;
                    }
                    if (n6 == 0x110000) break block6;
                    n6 = this.list[n3++];
                    n2 ^= 1;
                    n7 = nArray[n4++];
                    n2 ^= 2;
                }
            }
        }
        this.buffer[n5++] = 0x110000;
        this.len = n5;
        int[] nArray2 = this.list;
        this.list = this.buffer;
        this.buffer = nArray2;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnicodeSet retain(int[] nArray, int n, int n2) {
        this.ensureBufferCapacity(this.len + n);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.list[n3++];
        int n7 = nArray[n4++];
        block6: while (true) {
            switch (n2) {
                case 0: {
                    if (n6 < n7) {
                        n6 = this.list[n3++];
                        n2 ^= 1;
                        break;
                    }
                    if (n7 < n6) {
                        n7 = nArray[n4++];
                        n2 ^= 2;
                        break;
                    }
                    if (n6 == 0x110000) break block6;
                    this.buffer[n5++] = n6;
                    n6 = this.list[n3++];
                    n2 ^= 1;
                    n7 = nArray[n4++];
                    n2 ^= 2;
                    break;
                }
                case 3: {
                    if (n6 < n7) {
                        this.buffer[n5++] = n6;
                        n6 = this.list[n3++];
                        n2 ^= 1;
                        break;
                    }
                    if (n7 < n6) {
                        this.buffer[n5++] = n7;
                        n7 = nArray[n4++];
                        n2 ^= 2;
                        break;
                    }
                    if (n6 == 0x110000) break block6;
                    this.buffer[n5++] = n6;
                    n6 = this.list[n3++];
                    n2 ^= 1;
                    n7 = nArray[n4++];
                    n2 ^= 2;
                    break;
                }
                case 1: {
                    if (n6 < n7) {
                        n6 = this.list[n3++];
                        n2 ^= 1;
                        break;
                    }
                    if (n7 < n6) {
                        this.buffer[n5++] = n7;
                        n7 = nArray[n4++];
                        n2 ^= 2;
                        break;
                    }
                    if (n6 == 0x110000) break block6;
                    n6 = this.list[n3++];
                    n2 ^= 1;
                    n7 = nArray[n4++];
                    n2 ^= 2;
                    break;
                }
                case 2: {
                    if (n7 < n6) {
                        n7 = nArray[n4++];
                        n2 ^= 2;
                        break;
                    }
                    if (n6 < n7) {
                        this.buffer[n5++] = n6;
                        n6 = this.list[n3++];
                        n2 ^= 1;
                        break;
                    }
                    if (n6 == 0x110000) break block6;
                    n6 = this.list[n3++];
                    n2 ^= 1;
                    n7 = nArray[n4++];
                    n2 ^= 2;
                }
            }
        }
        this.buffer[n5++] = 0x110000;
        this.len = n5;
        int[] nArray2 = this.list;
        this.list = this.buffer;
        this.buffer = nArray2;
        this.pat = null;
        return this;
    }

    private static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static synchronized UnicodeSet getInclusions() {
        if (INCLUSIONS == null) {
            UCharacterProperty uCharacterProperty = UCharacterProperty.getInstance();
            INCLUSIONS = uCharacterProperty.getInclusions();
        }
        return INCLUSIONS;
    }

    private UnicodeSet applyFilter(Filter filter) {
        this.clear();
        int n = -1;
        UnicodeSet unicodeSet = UnicodeSet.getInclusions();
        int n2 = unicodeSet.getRangeCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = unicodeSet.getRangeStart(i);
            int n4 = unicodeSet.getRangeEnd(i);
            for (int j = n3; j <= n4; ++j) {
                if (filter.contains(j)) {
                    if (n >= 0) continue;
                    n = j;
                    continue;
                }
                if (n < 0) continue;
                this.add(n, j - 1);
                n = -1;
            }
        }
        if (n >= 0) {
            this.add(n, 0x10FFFF);
        }
        return this;
    }

    private static String mungeCharName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int n2 = UTF16.charAt(string, n);
            n += UTF16.getCharCount(n2);
            if (UCharacterProperty.isRuleWhiteSpace(n2)) {
                if (stringBuffer.length() == 0 || stringBuffer.charAt(stringBuffer.length() - 1) == ' ') continue;
                n2 = 32;
            }
            UTF16.append(stringBuffer, n2);
        }
        if (stringBuffer.length() != 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public UnicodeSet applyPropertyAlias(String string, String string2, SymbolTable symbolTable) {
        if (string.equals("Age")) {
            VersionInfo versionInfo = VersionInfo.getInstance(UnicodeSet.mungeCharName(string2));
            this.applyFilter(new VersionFilter(versionInfo));
            return this;
        }
        throw new IllegalArgumentException("Unsupported property");
    }

    private static boolean resemblesPropertyPattern(RuleCharacterIterator ruleCharacterIterator, int n) {
        boolean bl = false;
        Object object = ruleCharacterIterator.getPos(null);
        int n2 = ruleCharacterIterator.next(n &= 0xFFFFFFFD);
        if (n2 == 91 || n2 == 92) {
            int n3 = ruleCharacterIterator.next(n & 0xFFFFFFFB);
            bl = n2 == 91 ? n3 == 58 : n3 == 78 || n3 == 112 || n3 == 80;
        }
        ruleCharacterIterator.setPos(object);
        return bl;
    }

    private UnicodeSet applyPropertyPattern(String string, ParsePosition parsePosition, SymbolTable symbolTable) {
        String string2;
        String string3;
        int n;
        int n2 = parsePosition.getIndex();
        if (n2 + 5 > string.length()) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.regionMatches(n2, "[:", 0, 2)) {
            bl = true;
            if ((n2 = Utility.skipWhitespace(string, n2 + 2)) < string.length() && string.charAt(n2) == '^') {
                ++n2;
                bl3 = true;
            }
        } else if (string.regionMatches(true, n2, "\\p", 0, 2) || string.regionMatches(n2, "\\N", 0, 2)) {
            n = string.charAt(n2 + 1);
            bl3 = n == 80;
            bl2 = n == 78;
            n2 = Utility.skipWhitespace(string, n2 + 2);
            if (n2 == string.length() || string.charAt(n2++) != '{') {
                return null;
            }
        } else {
            return null;
        }
        if ((n = string.indexOf(bl ? ":]" : "}", n2)) < 0) {
            return null;
        }
        int n3 = string.indexOf(61, n2);
        if (n3 >= 0 && n3 < n && !bl2) {
            string3 = string.substring(n2, n3);
            string2 = string.substring(n3 + 1, n);
        } else {
            string3 = string.substring(n2, n);
            string2 = "";
            if (bl2) {
                string2 = string3;
                string3 = "na";
            }
        }
        this.applyPropertyAlias(string3, string2, symbolTable);
        if (bl3) {
            this.complement();
        }
        parsePosition.setIndex(n + (bl ? 2 : 1));
        return this;
    }

    private void applyPropertyPattern(RuleCharacterIterator ruleCharacterIterator, StringBuffer stringBuffer, SymbolTable symbolTable) {
        String string = ruleCharacterIterator.lookahead();
        ParsePosition parsePosition = new ParsePosition(0);
        this.applyPropertyPattern(string, parsePosition, symbolTable);
        if (parsePosition.getIndex() == 0) {
            UnicodeSet.syntaxError(ruleCharacterIterator, "Invalid property pattern");
        }
        ruleCharacterIterator.jumpahead(parsePosition.getIndex());
        stringBuffer.append(string.substring(0, parsePosition.getIndex()));
    }

    private static class VersionFilter
    implements Filter {
        VersionInfo version;

        VersionFilter(VersionInfo versionInfo) {
            this.version = versionInfo;
        }

        public boolean contains(int n) {
            VersionInfo versionInfo = UCharacter.getAge(n);
            return versionInfo != NO_VERSION && versionInfo.compareTo(this.version) <= 0;
        }
    }

    private static interface Filter {
        public boolean contains(int var1);
    }
}

