/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelChannelMixer;
import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelIdentifier;
import com.sun.media.sound.ModelOscillator;
import com.sun.media.sound.ModelOscillatorStream;
import com.sun.media.sound.ModelSource;
import com.sun.media.sound.ModelTransform;
import com.sun.media.sound.ModelWavetable;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftChannel;
import com.sun.media.sound.SoftControl;
import com.sun.media.sound.SoftEnvelopeGenerator;
import com.sun.media.sound.SoftFilter;
import com.sun.media.sound.SoftInstrument;
import com.sun.media.sound.SoftLowFrequencyOscillator;
import com.sun.media.sound.SoftPerformer;
import com.sun.media.sound.SoftProcess;
import com.sun.media.sound.SoftResamplerStreamer;
import com.sun.media.sound.SoftSynthesizer;
import com.sun.media.sound.SoftTuning;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sound.midi.VoiceStatus;

public class SoftVoice
extends VoiceStatus {
    public int exclusiveClass = 0;
    public boolean releaseTriggered = false;
    private int noteOn_noteNumber = 0;
    private int noteOn_velocity = 0;
    private int noteOff_velocity = 0;
    protected ModelChannelMixer channelmixer = null;
    protected double tunedKey = 0.0;
    protected SoftTuning tuning = null;
    protected SoftChannel stealer_channel = null;
    protected ModelConnectionBlock[] stealer_extendedConnectionBlocks = null;
    protected SoftPerformer stealer_performer = null;
    protected ModelChannelMixer stealer_channelmixer = null;
    protected int stealer_voiceID = -1;
    protected int stealer_noteNumber = 0;
    protected int stealer_velocity = 0;
    protected boolean stealer_releaseTriggered = false;
    protected int voiceID = -1;
    protected boolean sustain = false;
    protected boolean sostenuto = false;
    protected boolean portamento = false;
    private SoftFilter filter_left;
    private SoftFilter filter_right;
    private SoftProcess eg = new SoftEnvelopeGenerator();
    private SoftProcess lfo = new SoftLowFrequencyOscillator();
    protected Map<String, SoftControl> objects = new HashMap<String, SoftControl>();
    protected SoftSynthesizer synthesizer;
    protected SoftInstrument instrument;
    protected SoftPerformer performer;
    protected SoftChannel softchannel = null;
    protected boolean on = false;
    private boolean audiostarted = false;
    private boolean started = false;
    private boolean stopping = false;
    private float osc_attenuation = 0.0f;
    private ModelOscillatorStream osc_stream;
    private int osc_stream_nrofchannels;
    private float[][] osc_buff = new float[2][];
    private boolean osc_stream_off_transmitted = false;
    private boolean out_mixer_end = false;
    private float out_mixer_left = 0.0f;
    private float out_mixer_right = 0.0f;
    private float out_mixer_effect1 = 0.0f;
    private float out_mixer_effect2 = 0.0f;
    private float last_out_mixer_left = 0.0f;
    private float last_out_mixer_right = 0.0f;
    private float last_out_mixer_effect1 = 0.0f;
    private float last_out_mixer_effect2 = 0.0f;
    protected ModelConnectionBlock[] extendedConnectionBlocks = null;
    private ModelConnectionBlock[] connections;
    private double[] connections_last = new double[50];
    private double[][][] connections_src = new double[50][3][];
    private int[][] connections_src_kc = new int[50][3];
    private double[][] connections_dst = new double[50][];
    private boolean soundoff = false;
    private float lastMuteValue = 0.0f;
    private float lastSoloMuteValue = 0.0f;
    protected double[] co_noteon_keynumber = new double[1];
    protected double[] co_noteon_velocity = new double[1];
    protected double[] co_noteon_on = new double[1];
    private SoftControl co_noteon = new SoftControl(){
        double[] keynumber;
        double[] velocity;
        double[] on;
        {
            this.keynumber = SoftVoice.this.co_noteon_keynumber;
            this.velocity = SoftVoice.this.co_noteon_velocity;
            this.on = SoftVoice.this.co_noteon_on;
        }

        public double[] get(int n, String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("keynumber")) {
                return this.keynumber;
            }
            if (string.equals("velocity")) {
                return this.velocity;
            }
            if (string.equals("on")) {
                return this.on;
            }
            return null;
        }
    };
    private double[] co_mixer_active = new double[1];
    private double[] co_mixer_gain = new double[1];
    private double[] co_mixer_pan = new double[1];
    private double[] co_mixer_balance = new double[1];
    private double[] co_mixer_reverb = new double[1];
    private double[] co_mixer_chorus = new double[1];
    private SoftControl co_mixer = new SoftControl(){
        double[] active;
        double[] gain;
        double[] pan;
        double[] balance;
        double[] reverb;
        double[] chorus;
        {
            this.active = SoftVoice.this.co_mixer_active;
            this.gain = SoftVoice.this.co_mixer_gain;
            this.pan = SoftVoice.this.co_mixer_pan;
            this.balance = SoftVoice.this.co_mixer_balance;
            this.reverb = SoftVoice.this.co_mixer_reverb;
            this.chorus = SoftVoice.this.co_mixer_chorus;
        }

        public double[] get(int n, String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("active")) {
                return this.active;
            }
            if (string.equals("gain")) {
                return this.gain;
            }
            if (string.equals("pan")) {
                return this.pan;
            }
            if (string.equals("balance")) {
                return this.balance;
            }
            if (string.equals("reverb")) {
                return this.reverb;
            }
            if (string.equals("chorus")) {
                return this.chorus;
            }
            return null;
        }
    };
    private double[] co_osc_pitch = new double[1];
    private SoftControl co_osc = new SoftControl(){
        double[] pitch;
        {
            this.pitch = SoftVoice.this.co_osc_pitch;
        }

        public double[] get(int n, String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("pitch")) {
                return this.pitch;
            }
            return null;
        }
    };
    private double[] co_filter_freq = new double[1];
    private double[] co_filter_type = new double[1];
    private double[] co_filter_q = new double[1];
    private SoftControl co_filter = new SoftControl(){
        double[] freq;
        double[] ftype;
        double[] q;
        {
            this.freq = SoftVoice.this.co_filter_freq;
            this.ftype = SoftVoice.this.co_filter_type;
            this.q = SoftVoice.this.co_filter_q;
        }

        public double[] get(int n, String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("freq")) {
                return this.freq;
            }
            if (string.equals("type")) {
                return this.ftype;
            }
            if (string.equals("q")) {
                return this.q;
            }
            return null;
        }
    };
    protected SoftResamplerStreamer resampler;
    private int nrofchannels;

    public SoftVoice(SoftSynthesizer softSynthesizer) {
        this.synthesizer = softSynthesizer;
        this.filter_left = new SoftFilter(softSynthesizer.getFormat().getSampleRate());
        this.filter_right = new SoftFilter(softSynthesizer.getFormat().getSampleRate());
        this.nrofchannels = softSynthesizer.getFormat().getChannels();
    }

    private int getValueKC(ModelIdentifier modelIdentifier) {
        if (modelIdentifier.getObject().equals("midi_cc")) {
            int n = Integer.parseInt(modelIdentifier.getVariable());
            if (n != 0 && n != 32 && n < 120) {
                return n;
            }
        } else if (modelIdentifier.getObject().equals("midi_rpn")) {
            if (modelIdentifier.getVariable().equals("1")) {
                return 120;
            }
            if (modelIdentifier.getVariable().equals("2")) {
                return 121;
            }
        }
        return -1;
    }

    private double[] getValue(ModelIdentifier modelIdentifier) {
        SoftControl softControl = this.objects.get(modelIdentifier.getObject());
        if (softControl == null) {
            return null;
        }
        return softControl.get(modelIdentifier.getInstance(), modelIdentifier.getVariable());
    }

    private double transformValue(double d, ModelSource modelSource) {
        if (modelSource.getTransform() != null) {
            return modelSource.getTransform().transform(d);
        }
        return d;
    }

    private double transformValue(double d, ModelDestination modelDestination) {
        if (modelDestination.getTransform() != null) {
            return modelDestination.getTransform().transform(d);
        }
        return d;
    }

    private double processKeyBasedController(double d, int n) {
        if (n == -1) {
            return d;
        }
        if (this.softchannel.keybasedcontroller_active != null && this.softchannel.keybasedcontroller_active[this.note] != null && this.softchannel.keybasedcontroller_active[this.note][n]) {
            double d2 = this.softchannel.keybasedcontroller_value[this.note][n];
            if (n == 10 || n == 91 || n == 93) {
                return d2;
            }
            if ((d += d2 * 2.0 - 1.0) > 1.0) {
                d = 1.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
        }
        return d;
    }

    private void processConnection(int n) {
        ModelConnectionBlock modelConnectionBlock = this.connections[n];
        double[][] dArray = this.connections_src[n];
        double[] dArray2 = this.connections_dst[n];
        if (dArray2 == null || Double.isInfinite(dArray2[0])) {
            return;
        }
        double d = modelConnectionBlock.getScale();
        if (this.softchannel.keybasedcontroller_active == null) {
            ModelSource[] modelSourceArray = modelConnectionBlock.getSources();
            for (int i = 0; i < modelSourceArray.length && (d *= this.transformValue(dArray[i][0], modelSourceArray[i])) != 0.0; ++i) {
            }
        } else {
            ModelSource[] modelSourceArray = modelConnectionBlock.getSources();
            int[] nArray = this.connections_src_kc[n];
            for (int i = 0; i < modelSourceArray.length && (d *= this.transformValue(this.processKeyBasedController(dArray[i][0], nArray[i]), modelSourceArray[i])) != 0.0; ++i) {
            }
        }
        d = this.transformValue(d, modelConnectionBlock.getDestination());
        dArray2[0] = dArray2[0] - this.connections_last[n] + d;
        this.connections_last[n] = d;
    }

    protected void updateTuning(SoftTuning softTuning) {
        this.tunedKey = this.tuning.getTuning(this.note) / 100.0;
        if (!this.portamento) {
            this.co_noteon_keynumber[0] = this.tunedKey * 0.0078125;
            int[] nArray = this.performer.midi_connections[4];
            if (nArray == null) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                this.processConnection(nArray[i]);
            }
        }
    }

    protected void setNote(int n) {
        this.note = n;
        this.tunedKey = this.tuning.getTuning(n) / 100.0;
    }

    protected void noteOn(int n, int n2) {
        int n3;
        this.sustain = false;
        this.sostenuto = false;
        this.portamento = false;
        this.soundoff = false;
        this.on = true;
        this.active = true;
        this.started = true;
        this.noteOn_noteNumber = n;
        this.noteOn_velocity = n2;
        this.lastMuteValue = 0.0f;
        this.lastSoloMuteValue = 0.0f;
        this.setNote(n);
        this.co_noteon_keynumber[0] = this.performer.forcedKeynumber ? 0.0 : this.tunedKey * 0.0078125;
        this.co_noteon_velocity[0] = this.performer.forcedVelocity ? 0.0 : (double)((float)n2 * 0.0078125f);
        this.co_mixer_active[0] = 0.0;
        this.co_mixer_gain[0] = 0.0;
        this.co_mixer_pan[0] = 0.0;
        this.co_mixer_balance[0] = 0.0;
        this.co_mixer_reverb[0] = 0.0;
        this.co_mixer_chorus[0] = 0.0;
        this.co_osc_pitch[0] = 0.0;
        this.co_filter_freq[0] = 0.0;
        this.co_filter_q[0] = 0.0;
        this.co_filter_type[0] = 0.0;
        this.co_noteon_on[0] = 1.0;
        this.eg.reset();
        this.lfo.reset();
        this.filter_left.reset();
        this.filter_right.reset();
        this.objects.put("master", this.synthesizer.getMainMixer().co_master);
        this.objects.put("eg", this.eg);
        this.objects.put("lfo", this.lfo);
        this.objects.put("noteon", this.co_noteon);
        this.objects.put("osc", this.co_osc);
        this.objects.put("mixer", this.co_mixer);
        this.objects.put("filter", this.co_filter);
        this.connections = this.performer.connections;
        if (this.connections_last == null || this.connections_last.length < this.connections.length) {
            this.connections_last = new double[this.connections.length];
        }
        if (this.connections_src == null || this.connections_src.length < this.connections.length) {
            this.connections_src = new double[this.connections.length][][];
            this.connections_src_kc = new int[this.connections.length][];
        }
        if (this.connections_dst == null || this.connections_dst.length < this.connections.length) {
            this.connections_dst = new double[this.connections.length][];
        }
        for (n3 = 0; n3 < this.connections.length; ++n3) {
            ModelConnectionBlock modelConnectionBlock = this.connections[n3];
            this.connections_last[n3] = 0.0;
            if (modelConnectionBlock.getSources() != null) {
                ModelSource[] modelSourceArray = modelConnectionBlock.getSources();
                if (this.connections_src[n3] == null || this.connections_src[n3].length < modelSourceArray.length) {
                    this.connections_src[n3] = new double[modelSourceArray.length][];
                    this.connections_src_kc[n3] = new int[modelSourceArray.length];
                }
                double[][] object = this.connections_src[n3];
                int[] nArray = this.connections_src_kc[n3];
                this.connections_src[n3] = object;
                for (int i = 0; i < modelSourceArray.length; ++i) {
                    nArray[i] = this.getValueKC(modelSourceArray[i].getIdentifier());
                    object[i] = this.getValue(modelSourceArray[i].getIdentifier());
                }
            }
            this.connections_dst[n3] = (double[])(modelConnectionBlock.getDestination() != null ? this.getValue(modelConnectionBlock.getDestination().getIdentifier()) : null);
        }
        for (n3 = 0; n3 < this.connections.length; ++n3) {
            this.processConnection(n3);
        }
        if (this.extendedConnectionBlocks != null) {
            for (ModelConnectionBlock modelConnectionBlock : this.extendedConnectionBlocks) {
                ModelTransform modelTransform;
                ModelTransform modelTransform2;
                double d;
                ModelSource modelSource;
                int n4;
                int n5;
                Object object;
                double d2 = 0.0;
                if (this.softchannel.keybasedcontroller_active == null) {
                    object = modelConnectionBlock.getSources();
                    n5 = ((ModelSource[])object).length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        modelSource = object[n4];
                        d = this.getValue(modelSource.getIdentifier())[0];
                        modelTransform2 = modelSource.getTransform();
                        if (modelTransform2 == null) {
                            d2 += d;
                            continue;
                        }
                        d2 += modelTransform2.transform(d);
                    }
                } else {
                    object = modelConnectionBlock.getSources();
                    n5 = ((ModelSource[])object).length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        modelSource = object[n4];
                        d = this.getValue(modelSource.getIdentifier())[0];
                        d = this.processKeyBasedController(d, this.getValueKC(modelSource.getIdentifier()));
                        modelTransform2 = modelSource.getTransform();
                        if (modelTransform2 == null) {
                            d2 += d;
                            continue;
                        }
                        d2 += modelTransform2.transform(d);
                    }
                }
                if ((modelTransform = ((ModelDestination)(object = modelConnectionBlock.getDestination())).getTransform()) != null) {
                    d2 = modelTransform.transform(d2);
                }
                double[] dArray = this.getValue(((ModelDestination)object).getIdentifier());
                dArray[0] = dArray[0] + d2;
            }
        }
        this.eg.init(this.synthesizer);
        this.lfo.init(this.synthesizer);
    }

    protected void setPolyPressure(int n) {
        int[] nArray = this.performer.midi_connections[2];
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void setChannelPressure(int n) {
        int[] nArray = this.performer.midi_connections[1];
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void controlChange(int n, int n2) {
        int[] nArray = this.performer.midi_ctrl_connections[n];
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void nrpnChange(int n, int n2) {
        int[] nArray = this.performer.midi_nrpn_connections.get(n);
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void rpnChange(int n, int n2) {
        int[] nArray = this.performer.midi_rpn_connections.get(n);
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void setPitchBend(int n) {
        int[] nArray = this.performer.midi_connections[0];
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void setMute(boolean bl) {
        this.co_mixer_gain[0] = this.co_mixer_gain[0] - (double)this.lastMuteValue;
        this.lastMuteValue = bl ? -960.0f : 0.0f;
        this.co_mixer_gain[0] = this.co_mixer_gain[0] + (double)this.lastMuteValue;
    }

    protected void setSoloMute(boolean bl) {
        this.co_mixer_gain[0] = this.co_mixer_gain[0] - (double)this.lastSoloMuteValue;
        this.lastSoloMuteValue = bl ? -960.0f : 0.0f;
        this.co_mixer_gain[0] = this.co_mixer_gain[0] + (double)this.lastSoloMuteValue;
    }

    protected void shutdown() {
        if (this.co_noteon_on[0] < -0.5) {
            return;
        }
        this.on = false;
        this.co_noteon_on[0] = -1.0;
        int[] nArray = this.performer.midi_connections[3];
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void soundOff() {
        this.on = false;
        this.soundoff = true;
    }

    protected void noteOff(int n) {
        if (!this.on) {
            return;
        }
        this.on = false;
        this.noteOff_velocity = n;
        if (this.softchannel.sustain) {
            this.sustain = true;
            return;
        }
        if (this.sostenuto) {
            return;
        }
        this.co_noteon_on[0] = 0.0;
        int[] nArray = this.performer.midi_connections[3];
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void redamp() {
        if (this.co_noteon_on[0] > 0.5) {
            return;
        }
        if (this.co_noteon_on[0] < -0.5) {
            return;
        }
        this.sustain = true;
        this.co_noteon_on[0] = 1.0;
        int[] nArray = this.performer.midi_connections[3];
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.processConnection(nArray[i]);
        }
    }

    protected void processControlLogic() {
        if (this.stopping) {
            this.active = false;
            this.stopping = false;
            this.audiostarted = false;
            if (this.osc_stream != null) {
                try {
                    this.osc_stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.stealer_channel != null) {
                this.stealer_channel.initVoice(this, this.stealer_performer, this.stealer_voiceID, this.stealer_noteNumber, this.stealer_velocity, this.stealer_extendedConnectionBlocks, this.stealer_channelmixer, this.stealer_releaseTriggered);
                this.stealer_releaseTriggered = false;
                this.stealer_channel = null;
                this.stealer_performer = null;
                this.stealer_voiceID = -1;
                this.stealer_noteNumber = 0;
                this.stealer_velocity = 0;
                this.stealer_extendedConnectionBlocks = null;
                this.stealer_channelmixer = null;
            }
        }
        if (this.started) {
            this.audiostarted = true;
            ModelOscillator modelOscillator = this.performer.oscillators[0];
            this.osc_stream_off_transmitted = false;
            if (modelOscillator instanceof ModelWavetable) {
                try {
                    this.resampler.open((ModelWavetable)modelOscillator, this.synthesizer.getFormat().getSampleRate());
                    this.osc_stream = this.resampler;
                }
                catch (IOException iOException) {}
            } else {
                this.osc_stream = modelOscillator.open(this.synthesizer.getFormat().getSampleRate());
            }
            this.osc_attenuation = modelOscillator.getAttenuation();
            this.osc_stream_nrofchannels = modelOscillator.getChannels();
            if (this.osc_buff == null || this.osc_buff.length < this.osc_stream_nrofchannels) {
                this.osc_buff = new float[this.osc_stream_nrofchannels][];
            }
            if (this.osc_stream != null) {
                this.osc_stream.noteOn(this.softchannel, this, this.noteOn_noteNumber, this.noteOn_velocity);
            }
        }
        if (this.audiostarted) {
            int n;
            if (this.portamento) {
                double d = this.tunedKey - this.co_noteon_keynumber[0] * 128.0;
                double d2 = Math.abs(d);
                if (d2 < 1.0E-10) {
                    this.co_noteon_keynumber[0] = this.tunedKey * 0.0078125;
                    this.portamento = false;
                } else {
                    if (d2 > this.softchannel.portamento_time) {
                        d = Math.signum(d) * this.softchannel.portamento_time;
                    }
                    this.co_noteon_keynumber[0] = this.co_noteon_keynumber[0] + d * 0.0078125;
                }
                int[] nArray = this.performer.midi_connections[4];
                if (nArray == null) {
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    this.processConnection(nArray[i]);
                }
            }
            this.eg.processControlLogic();
            this.lfo.processControlLogic();
            for (n = 0; n < this.performer.ctrl_connections.length; ++n) {
                this.processConnection(this.performer.ctrl_connections[n]);
            }
            this.osc_stream.setPitch((float)this.co_osc_pitch[0]);
            n = (int)this.co_filter_type[0];
            double d = this.co_filter_freq[0] == 13500.0 ? 19912.126958213175 : 440.0 * Math.exp((this.co_filter_freq[0] - 6900.0) * (Math.log(2.0) / 1200.0));
            double d3 = this.co_filter_q[0] / 10.0;
            this.filter_left.setFilterType(n);
            this.filter_left.setFrequency(d);
            this.filter_left.setResonance(d3);
            this.filter_right.setFilterType(n);
            this.filter_right.setFrequency(d);
            this.filter_right.setResonance(d3);
            float f = (float)Math.exp(((double)(-this.osc_attenuation) + this.co_mixer_gain[0]) * (Math.log(10.0) / 200.0));
            if (this.co_mixer_gain[0] <= -960.0) {
                f = 0.0f;
            }
            if (this.soundoff) {
                this.stopping = true;
                f = 0.0f;
            }
            this.volume = (int)(Math.sqrt(f) * 128.0);
            double d4 = this.co_mixer_pan[0] * 0.001;
            if (d4 < 0.0) {
                d4 = 0.0;
            } else if (d4 > 1.0) {
                d4 = 1.0;
            }
            if (d4 == 0.5) {
                this.out_mixer_right = this.out_mixer_left = f * 0.70710677f;
            } else {
                this.out_mixer_left = f * (float)Math.cos(d4 * Math.PI * 0.5);
                this.out_mixer_right = f * (float)Math.sin(d4 * Math.PI * 0.5);
            }
            double d5 = this.co_mixer_balance[0] * 0.001;
            if (d5 != 0.5) {
                if (d5 > 0.5) {
                    this.out_mixer_left = (float)((double)this.out_mixer_left * ((1.0 - d5) * 2.0));
                } else {
                    this.out_mixer_right = (float)((double)this.out_mixer_right * (d5 * 2.0));
                }
            }
            if (this.synthesizer.reverb_on) {
                this.out_mixer_effect1 = (float)(this.co_mixer_reverb[0] * 0.001);
                this.out_mixer_effect1 *= f;
            } else {
                this.out_mixer_effect1 = 0.0f;
            }
            if (this.synthesizer.chorus_on) {
                this.out_mixer_effect2 = (float)(this.co_mixer_chorus[0] * 0.001);
                this.out_mixer_effect2 *= f;
            } else {
                this.out_mixer_effect2 = 0.0f;
            }
            boolean bl = this.out_mixer_end = this.co_mixer_active[0] < 0.5;
            if (!this.on && !this.osc_stream_off_transmitted) {
                this.osc_stream_off_transmitted = true;
                if (this.osc_stream != null) {
                    this.osc_stream.noteOff(this.noteOff_velocity);
                }
            }
        }
        if (this.started) {
            this.last_out_mixer_left = this.out_mixer_left;
            this.last_out_mixer_right = this.out_mixer_right;
            this.last_out_mixer_effect1 = this.out_mixer_effect1;
            this.last_out_mixer_effect2 = this.out_mixer_effect2;
            this.started = false;
        }
    }

    protected void mixAudioStream(SoftAudioBuffer softAudioBuffer, SoftAudioBuffer softAudioBuffer2, float f, float f2) {
        int n = softAudioBuffer.getSize();
        if ((double)f < 1.0E-9 && (double)f2 < 1.0E-9) {
            return;
        }
        if (f == f2) {
            float[] fArray = softAudioBuffer2.array();
            float[] fArray2 = softAudioBuffer.array();
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                fArray[n2] = fArray[n2] + fArray2[i] * f2;
            }
        } else {
            float f3 = f;
            float f4 = (f2 - f) / (float)n;
            float[] fArray = softAudioBuffer2.array();
            float[] fArray3 = softAudioBuffer.array();
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                fArray[n3] = fArray[n3] + fArray3[i] * (f3 += f4);
            }
        }
    }

    protected void processAudioLogic(SoftAudioBuffer[] softAudioBufferArray) {
        if (!this.audiostarted) {
            return;
        }
        int n = softAudioBufferArray[0].getSize();
        try {
            int n2;
            this.osc_buff[0] = softAudioBufferArray[10].array();
            if (this.nrofchannels != 1) {
                this.osc_buff[1] = softAudioBufferArray[11].array();
            }
            if ((n2 = this.osc_stream.read(this.osc_buff, 0, n)) == -1) {
                this.stopping = true;
                return;
            }
            if (n2 != n) {
                Arrays.fill(this.osc_buff[0], n2, n, 0.0f);
                if (this.nrofchannels != 1) {
                    Arrays.fill(this.osc_buff[1], n2, n, 0.0f);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SoftAudioBuffer softAudioBuffer = softAudioBufferArray[0];
        SoftAudioBuffer softAudioBuffer2 = softAudioBufferArray[1];
        SoftAudioBuffer softAudioBuffer3 = softAudioBufferArray[2];
        SoftAudioBuffer softAudioBuffer4 = softAudioBufferArray[3];
        SoftAudioBuffer softAudioBuffer5 = softAudioBufferArray[10];
        SoftAudioBuffer softAudioBuffer6 = softAudioBufferArray[11];
        if (this.osc_stream_nrofchannels == 1) {
            softAudioBuffer6 = null;
        }
        if (!Double.isInfinite(this.co_filter_freq[0])) {
            this.filter_left.processAudio(softAudioBuffer5);
            if (softAudioBuffer6 != null) {
                this.filter_right.processAudio(softAudioBuffer6);
            }
        }
        if (this.nrofchannels == 1) {
            this.out_mixer_left = (this.out_mixer_left + this.out_mixer_right) / 2.0f;
            this.mixAudioStream(softAudioBuffer5, softAudioBuffer, this.last_out_mixer_left, this.out_mixer_left);
            if (softAudioBuffer6 != null) {
                this.mixAudioStream(softAudioBuffer6, softAudioBuffer, this.last_out_mixer_left, this.out_mixer_left);
            }
        } else {
            this.mixAudioStream(softAudioBuffer5, softAudioBuffer, this.last_out_mixer_left, this.out_mixer_left);
            if (softAudioBuffer6 != null) {
                this.mixAudioStream(softAudioBuffer6, softAudioBuffer2, this.last_out_mixer_right, this.out_mixer_right);
            } else {
                this.mixAudioStream(softAudioBuffer5, softAudioBuffer2, this.last_out_mixer_right, this.out_mixer_right);
            }
        }
        if (softAudioBuffer6 == null) {
            this.mixAudioStream(softAudioBuffer5, softAudioBuffer3, this.last_out_mixer_effect1, this.out_mixer_effect1);
            this.mixAudioStream(softAudioBuffer5, softAudioBuffer4, this.last_out_mixer_effect2, this.out_mixer_effect2);
        } else {
            this.mixAudioStream(softAudioBuffer5, softAudioBuffer3, this.last_out_mixer_effect1 * 0.5f, this.out_mixer_effect1 * 0.5f);
            this.mixAudioStream(softAudioBuffer5, softAudioBuffer4, this.last_out_mixer_effect2 * 0.5f, this.out_mixer_effect2 * 0.5f);
            this.mixAudioStream(softAudioBuffer6, softAudioBuffer3, this.last_out_mixer_effect1 * 0.5f, this.out_mixer_effect1 * 0.5f);
            this.mixAudioStream(softAudioBuffer6, softAudioBuffer4, this.last_out_mixer_effect2 * 0.5f, this.out_mixer_effect2 * 0.5f);
        }
        this.last_out_mixer_left = this.out_mixer_left;
        this.last_out_mixer_right = this.out_mixer_right;
        this.last_out_mixer_effect1 = this.out_mixer_effect1;
        this.last_out_mixer_effect2 = this.out_mixer_effect2;
        if (this.out_mixer_end) {
            this.stopping = true;
        }
    }
}

