/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Highlighter;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.AccessibleHTML;
import javax.swing.text.html.BRView;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CommentView;
import javax.swing.text.html.FormView;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HRuleView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.HiddenTagView;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.IsindexView;
import javax.swing.text.html.LineView;
import javax.swing.text.html.ListView;
import javax.swing.text.html.Map;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.NoFramesView;
import javax.swing.text.html.ObjectView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.ResourceLoader;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TableView;

public class HTMLEditorKit
extends StyledEditorKit
implements Accessible {
    private JEditorPane theEditor;
    public static final String DEFAULT_CSS = "default.css";
    private AccessibleContext accessibleContext;
    private static final Cursor MoveCursor = Cursor.getPredefinedCursor(12);
    private static final Cursor DefaultCursor = Cursor.getPredefinedCursor(0);
    private static final ViewFactory defaultFactory = new HTMLFactory();
    MutableAttributeSet input;
    private static StyleSheet defaultStyles = null;
    private LinkController linkHandler = new LinkController();
    private static Parser defaultParser = null;
    private Cursor defaultCursor = DefaultCursor;
    private Cursor linkCursor = MoveCursor;
    private boolean isAutoFormSubmission = true;
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_BORDER = "html-image-border";
    private static final String INSERT_TABLE_HTML = "<table border=1><tr><td></td></tr></table>";
    private static final String INSERT_UL_HTML = "<ul><li></li></ul>";
    private static final String INSERT_OL_HTML = "<ol><li></li></ol>";
    private static final String INSERT_HR_HTML = "<hr>";
    private static final String INSERT_PRE_HTML = "<pre></pre>";
    private static final NavigateLinkAction nextLinkAction = new NavigateLinkAction("next-link-action");
    private static final NavigateLinkAction previousLinkAction = new NavigateLinkAction("previous-link-action");
    private static final ActivateLinkAction activateLinkAction = new ActivateLinkAction("activate-link-action");
    private static final Action[] defaultActions = new Action[]{new InsertHTMLTextAction("InsertTable", "<table border=1><tr><td></td></tr></table>", HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableRow", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TABLE, HTML.Tag.TR, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableDataCell", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertUnorderedList", "<ul><li></li></ul>", HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertUnorderedListItem", "<ul><li></li></ul>", HTML.Tag.UL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertOrderedList", "<ol><li></li></ol>", HTML.Tag.BODY, HTML.Tag.OL), new InsertHTMLTextAction("InsertOrderedListItem", "<ol><li></li></ol>", HTML.Tag.OL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.OL), new InsertHRAction(), new InsertHTMLTextAction("InsertPre", "<pre></pre>", HTML.Tag.BODY, HTML.Tag.PRE), nextLinkAction, previousLinkAction, activateLinkAction, new BeginAction("caret-begin", false), new BeginAction("selection-begin", true)};
    private boolean foundLink = false;
    private int prevHypertextOffset = -1;
    private Object linkNavigationTag;

    public String getContentType() {
        return "text/html";
    }

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    public Document createDefaultDocument() {
        StyleSheet styleSheet = this.getStyleSheet();
        StyleSheet styleSheet2 = new StyleSheet();
        styleSheet2.addStyleSheet(styleSheet);
        HTMLDocument hTMLDocument = new HTMLDocument(styleSheet2);
        hTMLDocument.setParser(this.getParser());
        hTMLDocument.setAsynchronousLoadPriority(4);
        hTMLDocument.setTokenThreshold(100);
        return hTMLDocument;
    }

    private Parser ensureParser(HTMLDocument hTMLDocument) throws IOException {
        Parser parser = hTMLDocument.getParser();
        if (parser == null) {
            parser = this.getParser();
        }
        if (parser == null) {
            throw new IOException("Can't load parser");
        }
        return parser;
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            if (n > document.getLength()) {
                throw new BadLocationException("Invalid location", n);
            }
            Parser parser = this.ensureParser(hTMLDocument);
            ParserCallback parserCallback = hTMLDocument.getReader(n);
            Boolean bl = (Boolean)document.getProperty("IgnoreCharsetDirective");
            parser.parse(reader, parserCallback, bl == null ? false : bl);
            parserCallback.flush();
        } else {
            super.read(reader, document, n);
        }
    }

    public void insertHTML(HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) throws BadLocationException, IOException {
        if (n > hTMLDocument.getLength()) {
            throw new BadLocationException("Invalid location", n);
        }
        Parser parser = this.ensureParser(hTMLDocument);
        ParserCallback parserCallback = hTMLDocument.getReader(n, n2, n3, tag);
        Boolean bl = (Boolean)hTMLDocument.getProperty("IgnoreCharsetDirective");
        parser.parse(new StringReader(string), parserCallback, bl == null ? false : bl);
        parserCallback.flush();
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLWriter hTMLWriter = new HTMLWriter(writer, (HTMLDocument)document, n, n2);
            hTMLWriter.write();
        } else if (document instanceof StyledDocument) {
            MinimalHTMLWriter minimalHTMLWriter = new MinimalHTMLWriter(writer, (StyledDocument)document, n, n2);
            minimalHTMLWriter.write();
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public void install(JEditorPane jEditorPane) {
        jEditorPane.addMouseListener(this.linkHandler);
        jEditorPane.addMouseMotionListener(this.linkHandler);
        jEditorPane.addCaretListener(nextLinkAction);
        super.install(jEditorPane);
        this.theEditor = jEditorPane;
    }

    public void deinstall(JEditorPane jEditorPane) {
        jEditorPane.removeMouseListener(this.linkHandler);
        jEditorPane.removeMouseMotionListener(this.linkHandler);
        jEditorPane.removeCaretListener(nextLinkAction);
        super.deinstall(jEditorPane);
        this.theEditor = null;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        defaultStyles = styleSheet;
    }

    public StyleSheet getStyleSheet() {
        if (defaultStyles == null) {
            defaultStyles = new StyleSheet();
            try {
                InputStream inputStream = HTMLEditorKit.getResourceAsStream(DEFAULT_CSS);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
                defaultStyles.loadRules(bufferedReader, null);
                ((Reader)bufferedReader).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultStyles;
    }

    static InputStream getResourceAsStream(String string) {
        try {
            return ResourceLoader.getResourceAsStream(string);
        }
        catch (Throwable throwable) {
            return HTMLEditorKit.class.getResourceAsStream(string);
        }
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        mutableAttributeSet.addAttributes(element.getAttributes());
        mutableAttributeSet.removeAttribute(StyleConstants.ComposedTextAttribute);
        Object object = mutableAttributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            if (tag == HTML.Tag.IMG) {
                mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
                mutableAttributeSet.removeAttribute(HTML.Attribute.HEIGHT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.WIDTH);
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            } else if (tag == HTML.Tag.HR || tag == HTML.Tag.BR) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            } else if (tag == HTML.Tag.COMMENT) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.COMMENT);
            } else if (tag == HTML.Tag.INPUT) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Tag.INPUT);
            } else if (tag instanceof HTML.UnknownTag) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.ENDTAG);
            }
        }
    }

    public MutableAttributeSet getInputAttributes() {
        if (this.input == null) {
            this.input = this.getStyleSheet().addStyle(null, null);
        }
        return this.input;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public void setLinkCursor(Cursor cursor) {
        this.linkCursor = cursor;
    }

    public Cursor getLinkCursor() {
        return this.linkCursor;
    }

    public boolean isAutoFormSubmission() {
        return this.isAutoFormSubmission;
    }

    public void setAutoFormSubmission(boolean bl) {
        this.isAutoFormSubmission = bl;
    }

    public Object clone() {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)super.clone();
        if (hTMLEditorKit != null) {
            hTMLEditorKit.input = null;
            hTMLEditorKit.linkHandler = new LinkController();
        }
        return hTMLEditorKit;
    }

    protected Parser getParser() {
        if (defaultParser == null) {
            try {
                Class<?> clazz = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                defaultParser = (Parser)clazz.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultParser;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.theEditor == null) {
            return null;
        }
        if (this.accessibleContext == null) {
            AccessibleHTML accessibleHTML = new AccessibleHTML(this.theEditor);
            this.accessibleContext = accessibleHTML.getAccessibleContext();
        }
        return this.accessibleContext;
    }

    private static Object getAttrValue(AttributeSet attributeSet, HTML.Attribute attribute) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            if (object instanceof AttributeSet) {
                Object object2 = HTMLEditorKit.getAttrValue((AttributeSet)object, attribute);
                if (object2 == null) continue;
                return object2;
            }
            if (obj != attribute) continue;
            return object;
        }
        return null;
    }

    private static int getBodyElementStart(JTextComponent jTextComponent) {
        Element element = jTextComponent.getDocument().getRootElements()[0];
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element2 = element.getElement(i);
            if (!"body".equals(element2.getName())) continue;
            return element2.getStartOffset();
        }
        return 0;
    }

    static class BeginAction
    extends TextAction {
        private boolean select;

        BeginAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            int n = HTMLEditorKit.getBodyElementStart(jTextComponent);
            if (jTextComponent != null) {
                if (this.select) {
                    jTextComponent.moveCaretPosition(n);
                } else {
                    jTextComponent.setCaretPosition(n);
                }
            }
        }
    }

    static class ActivateLinkAction
    extends TextAction {
        public ActivateLinkAction(String string) {
            super(string);
        }

        private void activateLink(String string, HTMLDocument hTMLDocument, JEditorPane jEditorPane, int n) {
            try {
                URL uRL = (URL)hTMLDocument.getProperty("stream");
                URL uRL2 = new URL(uRL, string);
                HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL2, uRL2.toExternalForm(), hTMLDocument.getCharacterElement(n));
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        private void doObjectAction(JEditorPane jEditorPane, Element element) {
            AccessibleAction accessibleAction;
            AccessibleContext accessibleContext;
            Component component;
            View view = this.getView(jEditorPane, element);
            if (view != null && view instanceof ObjectView && (component = ((ObjectView)view).getComponent()) != null && component instanceof Accessible && (accessibleContext = component.getAccessibleContext()) != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                accessibleAction.doAccessibleAction(0);
            }
        }

        private View getRootView(JEditorPane jEditorPane) {
            return jEditorPane.getUI().getRootView(jEditorPane);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private View getView(JEditorPane jEditorPane, Element element) {
            Object object;
            block3: {
                object = this.lock(jEditorPane);
                try {
                    View view = this.getRootView(jEditorPane);
                    int n = element.getStartOffset();
                    if (view == null) break block3;
                    View view2 = this.getView(view, element, n);
                    Object var8_8 = null;
                    this.unlock(object);
                    return view2;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.unlock(object);
                    throw throwable;
                }
            }
            View view = null;
            Object var8_9 = null;
            this.unlock(object);
            return view;
        }

        private View getView(View view, Element element, int n) {
            if (view.getElement() == element) {
                return view;
            }
            int n2 = view.getViewIndex(n, Position.Bias.Forward);
            if (n2 != -1 && n2 < view.getViewCount()) {
                return this.getView(view.getView(n2), element, n);
            }
            return null;
        }

        private Object lock(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
                return document;
            }
            return null;
        }

        private void unlock(Object object) {
            if (object != null) {
                ((AbstractDocument)object).readUnlock();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Element element;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.isEditable() || !(jTextComponent instanceof JEditorPane)) {
                return;
            }
            JEditorPane jEditorPane = (JEditorPane)jTextComponent;
            Document document = jEditorPane.getDocument();
            if (document == null || !(document instanceof HTMLDocument)) {
                return;
            }
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            ElementIterator elementIterator = new ElementIterator(hTMLDocument);
            int n = jEditorPane.getCaretPosition();
            Object var8_8 = null;
            Object var9_9 = null;
            while ((element = elementIterator.next()) != null) {
                Object object;
                String string = element.getName();
                AttributeSet attributeSet = element.getAttributes();
                Object object2 = HTMLEditorKit.getAttrValue(attributeSet, HTML.Attribute.HREF);
                if (object2 != null) {
                    if (n < element.getStartOffset() || n > element.getEndOffset()) continue;
                    this.activateLink((String)object2, hTMLDocument, jEditorPane, n);
                    return;
                }
                if (!string.equals(HTML.Tag.OBJECT.toString()) || (object = HTMLEditorKit.getAttrValue(attributeSet, HTML.Attribute.CLASSID)) == null || n < element.getStartOffset() || n > element.getEndOffset()) continue;
                this.doObjectAction(jEditorPane, element);
                return;
            }
        }
    }

    static class NavigateLinkAction
    extends TextAction
    implements CaretListener {
        private static final FocusHighlightPainter focusPainter = new FocusHighlightPainter(null);
        private final boolean focusBack;

        public NavigateLinkAction(String string) {
            super(string);
            this.focusBack = "previous-link-action".equals(string);
        }

        public void caretUpdate(CaretEvent caretEvent) {
            JTextComponent jTextComponent;
            HTMLEditorKit hTMLEditorKit;
            Object object = caretEvent.getSource();
            if (object instanceof JTextComponent && (hTMLEditorKit = this.getHTMLEditorKit(jTextComponent = (JTextComponent)object)) != null && hTMLEditorKit.foundLink) {
                hTMLEditorKit.foundLink = false;
                jTextComponent.getAccessibleContext().firePropertyChange("AccessibleHypertextOffset", hTMLEditorKit.prevHypertextOffset, caretEvent.getDot());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Element element;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent == null || jTextComponent.isEditable()) {
                return;
            }
            Document document = jTextComponent.getDocument();
            HTMLEditorKit hTMLEditorKit = this.getHTMLEditorKit(jTextComponent);
            if (document == null || hTMLEditorKit == null) {
                return;
            }
            ElementIterator elementIterator = new ElementIterator(document);
            int n = jTextComponent.getCaretPosition();
            int n2 = -1;
            int n3 = -1;
            while ((element = elementIterator.next()) != null) {
                String string = element.getName();
                AttributeSet attributeSet = element.getAttributes();
                Object object = HTMLEditorKit.getAttrValue(attributeSet, HTML.Attribute.HREF);
                if (!string.equals(HTML.Tag.OBJECT.toString()) && object == null) continue;
                int n4 = element.getStartOffset();
                if (this.focusBack) {
                    if (n4 >= n && n2 >= 0) {
                        hTMLEditorKit.foundLink = true;
                        jTextComponent.setCaretPosition(n2);
                        this.moveCaretPosition(jTextComponent, hTMLEditorKit, n2, n3);
                        hTMLEditorKit.prevHypertextOffset = n2;
                        return;
                    }
                } else if (n4 > n) {
                    hTMLEditorKit.foundLink = true;
                    jTextComponent.setCaretPosition(n4);
                    this.moveCaretPosition(jTextComponent, hTMLEditorKit, n4, element.getEndOffset());
                    hTMLEditorKit.prevHypertextOffset = n4;
                    return;
                }
                n2 = element.getStartOffset();
                n3 = element.getEndOffset();
            }
            if (this.focusBack && n2 >= 0) {
                hTMLEditorKit.foundLink = true;
                jTextComponent.setCaretPosition(n2);
                this.moveCaretPosition(jTextComponent, hTMLEditorKit, n2, n3);
                hTMLEditorKit.prevHypertextOffset = n2;
            }
        }

        private void moveCaretPosition(JTextComponent jTextComponent, HTMLEditorKit hTMLEditorKit, int n, int n2) {
            Highlighter highlighter = jTextComponent.getHighlighter();
            if (highlighter != null) {
                int n3 = Math.min(n2, n);
                int n4 = Math.max(n2, n);
                try {
                    if (hTMLEditorKit.linkNavigationTag != null) {
                        highlighter.changeHighlight(hTMLEditorKit.linkNavigationTag, n3, n4);
                    } else {
                        hTMLEditorKit.linkNavigationTag = highlighter.addHighlight(n3, n4, NavigateLinkAction.focusPainter);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private HTMLEditorKit getHTMLEditorKit(JTextComponent jTextComponent) {
            EditorKit editorKit;
            if (jTextComponent instanceof JEditorPane && (editorKit = ((JEditorPane)jTextComponent).getEditorKit()) instanceof HTMLEditorKit) {
                return (HTMLEditorKit)editorKit;
            }
            return null;
        }

        static class FocusHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            FocusHighlightPainter(Color color) {
                super(color);
            }

            public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
                    Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    return rectangle;
                }
                try {
                    Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                    Rectangle rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    return rectangle;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
        }
    }

    static class InsertHRAction
    extends InsertHTMLTextAction {
        InsertHRAction() {
            super("InsertHR", HTMLEditorKit.INSERT_HR_HTML, null, HTML.Tag.IMPLIED, null, null, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            HTMLDocument hTMLDocument;
            Element element;
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null && (element = (hTMLDocument = this.getHTMLDocument(jEditorPane)).getParagraphElement(n = jEditorPane.getSelectionStart())).getParentElement() != null) {
                this.parentTag = (HTML.Tag)element.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected String html;
        protected HTML.Tag parentTag;
        protected HTML.Tag addTag;
        protected HTML.Tag alternateParentTag;
        protected HTML.Tag alternateAddTag;
        boolean adjustSelection;

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2) {
            this(string, string2, tag, tag2, null, null);
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4) {
            this(string, string2, tag, tag2, tag3, tag4, true);
        }

        InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4, boolean bl) {
            super(string);
            this.html = string2;
            this.parentTag = tag;
            this.addTag = tag2;
            this.alternateParentTag = tag3;
            this.alternateAddTag = tag4;
            this.adjustSelection = bl;
        }

        protected void insertHTML(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) {
            try {
                this.getHTMLEditorKit(jEditorPane).insertHTML(hTMLDocument, n, string, n2, n3, tag);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to insert: " + iOException);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException("Unable to insert: " + badLocationException);
            }
        }

        protected void insertAtBoundary(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            this.insertAtBoundry(jEditorPane, hTMLDocument, n, element, string, tag, tag2);
        }

        @Deprecated
        protected void insertAtBoundry(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            Element element2;
            Element element3;
            boolean bl;
            boolean bl2 = bl = n == 0;
            if (n > 0 || element == null) {
                for (element3 = hTMLDocument.getDefaultRootElement(); element3 != null && element3.getStartOffset() != n && !element3.isLeaf(); element3 = element3.getElement(element3.getElementIndex(n))) {
                }
                element2 = element3 != null ? element3.getParentElement() : null;
            } else {
                element2 = element;
            }
            if (element2 != null) {
                int n2 = 0;
                int n3 = 0;
                if (bl && element != null) {
                    element3 = element2;
                    while (element3 != null && !element3.isLeaf()) {
                        element3 = element3.getElement(element3.getElementIndex(n));
                        ++n2;
                    }
                } else {
                    element3 = element2;
                    --n;
                    while (element3 != null && !element3.isLeaf()) {
                        element3 = element3.getElement(element3.getElementIndex(n));
                        ++n2;
                    }
                    element3 = element2;
                    ++n;
                    while (element3 != null && element3 != element) {
                        element3 = element3.getElement(element3.getElementIndex(n));
                        ++n3;
                    }
                }
                n2 = Math.max(0, n2 - 1);
                this.insertHTML(jEditorPane, hTMLDocument, n, string, n2, n3, tag2);
            }
        }

        boolean insertIntoTag(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, HTML.Tag tag, HTML.Tag tag2) {
            int n2;
            Element element = this.findElementMatchingTag(hTMLDocument, n, tag);
            if (element != null && element.getStartOffset() == n) {
                this.insertAtBoundary(jEditorPane, hTMLDocument, n, element, this.html, tag, tag2);
                return true;
            }
            if (n > 0 && (n2 = this.elementCountToTag(hTMLDocument, n - 1, tag)) != -1) {
                this.insertHTML(jEditorPane, hTMLDocument, n, this.html, n2, 0, tag2);
                return true;
            }
            return false;
        }

        void adjustSelection(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, int n2) {
            int n3 = hTMLDocument.getLength();
            if (n3 != n2 && n < n3) {
                if (n > 0) {
                    String string;
                    try {
                        string = hTMLDocument.getText(n - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        string = null;
                    }
                    if (string != null && string.length() > 0 && string.charAt(0) == '\n') {
                        jEditorPane.select(n, n);
                    } else {
                        jEditorPane.select(n + 1, n + 1);
                    }
                } else {
                    jEditorPane.select(1, 1);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                HTMLDocument hTMLDocument = this.getHTMLDocument(jEditorPane);
                int n = jEditorPane.getSelectionStart();
                int n2 = hTMLDocument.getLength();
                boolean bl = !this.insertIntoTag(jEditorPane, hTMLDocument, n, this.parentTag, this.addTag) && this.alternateParentTag != null ? this.insertIntoTag(jEditorPane, hTMLDocument, n, this.alternateParentTag, this.alternateAddTag) : true;
                if (this.adjustSelection && bl) {
                    this.adjustSelection(jEditorPane, hTMLDocument, n, n2);
                }
            }
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        public HTMLTextAction(String string) {
            super(string);
        }

        protected HTMLDocument getHTMLDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                return (HTMLDocument)document;
            }
            throw new IllegalArgumentException("document must be HTMLDocument");
        }

        protected HTMLEditorKit getHTMLEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof HTMLEditorKit) {
                return (HTMLEditorKit)editorKit;
            }
            throw new IllegalArgumentException("EditorKit must be HTMLEditorKit");
        }

        protected Element[] getElementsAt(HTMLDocument hTMLDocument, int n) {
            return this.getElementsAt(hTMLDocument.getDefaultRootElement(), n, 0);
        }

        private Element[] getElementsAt(Element element, int n, int n2) {
            if (element.isLeaf()) {
                Element[] elementArray = new Element[n2 + 1];
                elementArray[n2] = element;
                return elementArray;
            }
            Element[] elementArray = this.getElementsAt(element.getElement(element.getElementIndex(n)), n, n2 + 1);
            elementArray[n2] = element;
            return elementArray;
        }

        protected int elementCountToTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            int n2 = -1;
            Element element = hTMLDocument.getCharacterElement(n);
            while (element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != tag) {
                element = element.getParentElement();
                ++n2;
            }
            if (element == null) {
                return -1;
            }
            return n2;
        }

        protected Element findElementMatchingTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            Element element = null;
            for (Element element2 = hTMLDocument.getDefaultRootElement(); element2 != null; element2 = element2.getElement(element2.getElementIndex(n))) {
                if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != tag) continue;
                element = element2;
            }
            return element;
        }
    }

    public static class HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            Object object;
            Object object2;
            AttributeSet attributeSet = element.getAttributes();
            Object object3 = attributeSet.getAttribute("$ename");
            Object object4 = object2 = object3 != null ? null : attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object2 instanceof HTML.Tag) {
                object = (HTML.Tag)object2;
                if (object == HTML.Tag.CONTENT) {
                    return new InlineView(element);
                }
                if (object == HTML.Tag.IMPLIED) {
                    String string = (String)element.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (string != null && string.equals("pre")) {
                        return new LineView(element);
                    }
                    return new ParagraphView(element);
                }
                if (object == HTML.Tag.P || object == HTML.Tag.H1 || object == HTML.Tag.H2 || object == HTML.Tag.H3 || object == HTML.Tag.H4 || object == HTML.Tag.H5 || object == HTML.Tag.H6 || object == HTML.Tag.DT) {
                    return new ParagraphView(element);
                }
                if (object == HTML.Tag.MENU || object == HTML.Tag.DIR || object == HTML.Tag.UL || object == HTML.Tag.OL) {
                    return new ListView(element);
                }
                if (object == HTML.Tag.BODY) {
                    return new BodyBlockView(element);
                }
                if (object == HTML.Tag.HTML) {
                    return new BlockView(element, 1);
                }
                if (object == HTML.Tag.LI || object == HTML.Tag.CENTER || object == HTML.Tag.DL || object == HTML.Tag.DD || object == HTML.Tag.DIV || object == HTML.Tag.BLOCKQUOTE || object == HTML.Tag.PRE || object == HTML.Tag.FORM) {
                    return new BlockView(element, 1);
                }
                if (object == HTML.Tag.NOFRAMES) {
                    return new NoFramesView(element, 1);
                }
                if (object == HTML.Tag.IMG) {
                    return new ImageView(element);
                }
                if (object == HTML.Tag.ISINDEX) {
                    return new IsindexView(element);
                }
                if (object == HTML.Tag.HR) {
                    return new HRuleView(element);
                }
                if (object == HTML.Tag.BR) {
                    return new BRView(element);
                }
                if (object == HTML.Tag.TABLE) {
                    return new TableView(element);
                }
                if (object == HTML.Tag.INPUT || object == HTML.Tag.SELECT || object == HTML.Tag.TEXTAREA) {
                    return new FormView(element);
                }
                if (object == HTML.Tag.OBJECT) {
                    return new ObjectView(element);
                }
                if (object == HTML.Tag.FRAMESET) {
                    if (element.getAttributes().isDefined(HTML.Attribute.ROWS)) {
                        return new FrameSetView(element, 1);
                    }
                    if (element.getAttributes().isDefined(HTML.Attribute.COLS)) {
                        return new FrameSetView(element, 0);
                    }
                    throw new RuntimeException("Can't build a" + object + ", " + element + ":" + "no ROWS or COLS defined.");
                }
                if (object == HTML.Tag.FRAME) {
                    return new FrameView(element);
                }
                if (object instanceof HTML.UnknownTag) {
                    return new HiddenTagView(element);
                }
                if (object == HTML.Tag.COMMENT) {
                    return new CommentView(element);
                }
                if (object == HTML.Tag.HEAD) {
                    return new BlockView(element, 0){

                        public float getPreferredSpan(int n) {
                            return 0.0f;
                        }

                        public float getMinimumSpan(int n) {
                            return 0.0f;
                        }

                        public float getMaximumSpan(int n) {
                            return 0.0f;
                        }

                        protected void loadChildren(ViewFactory viewFactory) {
                        }

                        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
                            return shape;
                        }

                        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) {
                            return this.getElement().getEndOffset();
                        }
                    };
                }
                if (object == HTML.Tag.TITLE || object == HTML.Tag.META || object == HTML.Tag.LINK || object == HTML.Tag.STYLE || object == HTML.Tag.SCRIPT || object == HTML.Tag.AREA || object == HTML.Tag.MAP || object == HTML.Tag.PARAM || object == HTML.Tag.APPLET) {
                    return new HiddenTagView(element);
                }
            }
            Object object5 = object = object3 != null ? (String)object3 : element.getName();
            if (object != null) {
                if (((String)object).equals("content")) {
                    return new LabelView(element);
                }
                if (((String)object).equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (((String)object).equals("section")) {
                    return new BoxView(element, 1);
                }
                if (((String)object).equals("component")) {
                    return new ComponentView(element);
                }
                if (((String)object).equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }

        static class BodyBlockView
        extends BlockView
        implements ComponentListener {
            private Reference<JViewport> cachedViewPort = null;
            private boolean isListening = false;
            private int viewVisibleWidth = Integer.MAX_VALUE;
            private int componentVisibleWidth = Integer.MAX_VALUE;

            public BodyBlockView(Element element) {
                super(element, 1);
            }

            protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
                sizeRequirements = super.calculateMajorAxisRequirements(n, sizeRequirements);
                sizeRequirements.maximum = Integer.MAX_VALUE;
                return sizeRequirements;
            }

            protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
                Container container;
                Container container2 = this.getContainer();
                if (container2 != null && container2 instanceof JEditorPane && (container = container2.getParent()) != null && container instanceof JViewport) {
                    Serializable serializable;
                    JViewport jViewport = (JViewport)container;
                    if (this.cachedViewPort != null) {
                        serializable = this.cachedViewPort.get();
                        if (serializable != null) {
                            if (serializable != jViewport) {
                                serializable.removeComponentListener(this);
                            }
                        } else {
                            this.cachedViewPort = null;
                        }
                    }
                    if (this.cachedViewPort == null) {
                        jViewport.addComponentListener(this);
                        this.cachedViewPort = new WeakReference<JViewport>(jViewport);
                    }
                    this.componentVisibleWidth = jViewport.getExtentSize().width;
                    if (this.componentVisibleWidth > 0) {
                        serializable = container2.getInsets();
                        this.viewVisibleWidth = this.componentVisibleWidth - ((Insets)serializable).left - this.getLeftInset();
                        n = Math.min(n, this.viewVisibleWidth);
                    }
                } else if (this.cachedViewPort != null) {
                    JViewport jViewport = this.cachedViewPort.get();
                    if (jViewport != null) {
                        jViewport.removeComponentListener(this);
                    }
                    this.cachedViewPort = null;
                }
                super.layoutMinorAxis(n, n2, nArray, nArray2);
            }

            public void setParent(View view) {
                if (view == null && this.cachedViewPort != null) {
                    JViewport jViewport = this.cachedViewPort.get();
                    if (jViewport != null) {
                        ((JComponent)jViewport).removeComponentListener(this);
                    }
                    this.cachedViewPort = null;
                }
                super.setParent(view);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent componentEvent) {
                Document document;
                if (!(componentEvent.getSource() instanceof JViewport)) {
                    return;
                }
                JViewport jViewport = (JViewport)componentEvent.getSource();
                if (this.componentVisibleWidth != jViewport.getExtentSize().width && (document = this.getDocument()) instanceof AbstractDocument) {
                    AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
                    abstractDocument.readLock();
                    try {
                        this.layoutChanged(0);
                        this.preferenceChanged(null, true, true);
                        Object var6_5 = null;
                        abstractDocument.readUnlock();
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        abstractDocument.readUnlock();
                        throw throwable;
                    }
                }
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        }
    }

    public static class ParserCallback {
        public static final Object IMPLIED = "_implied_";

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] cArray, int n) {
        }

        public void handleComment(char[] cArray, int n) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleEndTag(HTML.Tag tag, int n) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleError(String string, int n) {
        }

        public void handleEndOfLineString(String string) {
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        private Element curElem = null;
        private boolean curElemImage = false;
        private String href = null;
        private transient Position.Bias[] bias = new Position.Bias[1];
        private int curOffset;

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n;
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (!jEditorPane.isEditable() && jEditorPane.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && (n = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                this.activateLink(n, jEditorPane, mouseEvent);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (!jEditorPane.isEnabled()) {
                return;
            }
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
            boolean bl = true;
            Cursor cursor = hTMLEditorKit.getDefaultCursor();
            if (!jEditorPane.isEditable()) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n = jEditorPane.getUI().viewToModel(jEditorPane, point, this.bias);
                if (this.bias[0] == Position.Bias.Backward && n > 0) {
                    --n;
                }
                if (n >= 0 && jEditorPane.getDocument() instanceof HTMLDocument) {
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    Element element = hTMLDocument.getCharacterElement(n);
                    if (!this.doesElementContainLocation(jEditorPane, element, n, mouseEvent.getX(), mouseEvent.getY())) {
                        element = null;
                    }
                    if (this.curElem != element || this.curElemImage) {
                        Element element2 = this.curElem;
                        this.curElem = element;
                        String string = null;
                        this.curElemImage = false;
                        if (element != null) {
                            AttributeSet attributeSet = element.getAttributes();
                            AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                            if (attributeSet2 == null) {
                                boolean bl2 = this.curElemImage = attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMG;
                                if (this.curElemImage) {
                                    string = this.getMapHREF(jEditorPane, hTMLDocument, element, attributeSet, n, mouseEvent.getX(), mouseEvent.getY());
                                }
                            } else {
                                string = (String)attributeSet2.getAttribute(HTML.Attribute.HREF);
                            }
                        }
                        if (string != this.href) {
                            this.fireEvents(jEditorPane, hTMLDocument, string, element2, mouseEvent);
                            this.href = string;
                            if (string != null) {
                                cursor = hTMLEditorKit.getLinkCursor();
                            }
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                    this.curOffset = n;
                }
            }
            if (bl && jEditorPane.getCursor() != cursor) {
                jEditorPane.setCursor(cursor);
            }
        }

        private String getMapHREF(JEditorPane jEditorPane, HTMLDocument hTMLDocument, Element element, AttributeSet attributeSet, int n, int n2, int n3) {
            Map map;
            Object object = attributeSet.getAttribute(HTML.Attribute.USEMAP);
            if (object != null && object instanceof String && (map = hTMLDocument.getMap((String)object)) != null && n < hTMLDocument.getLength()) {
                Rectangle rectangle;
                Object object2;
                TextUI textUI = jEditorPane.getUI();
                try {
                    object2 = textUI.modelToView(jEditorPane, n, Position.Bias.Forward);
                    Rectangle rectangle2 = textUI.modelToView(jEditorPane, n + 1, Position.Bias.Backward);
                    rectangle = object2.getBounds();
                    rectangle.add(rectangle2 instanceof Rectangle ? rectangle2 : rectangle2.getBounds());
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                if (rectangle != null && (object2 = map.getArea(n2 - rectangle.x, n3 - rectangle.y, rectangle.width, rectangle.height)) != null) {
                    return (String)object2.getAttribute(HTML.Attribute.HREF);
                }
            }
            return null;
        }

        private boolean doesElementContainLocation(JEditorPane jEditorPane, Element element, int n, int n2, int n3) {
            if (element != null && n > 0 && element.getStartOffset() == n) {
                try {
                    TextUI textUI = jEditorPane.getUI();
                    Rectangle rectangle = textUI.modelToView(jEditorPane, n, Position.Bias.Forward);
                    if (rectangle == null) {
                        return false;
                    }
                    Rectangle rectangle2 = rectangle instanceof Rectangle ? rectangle : rectangle.getBounds();
                    Rectangle rectangle3 = textUI.modelToView(jEditorPane, element.getEndOffset(), Position.Bias.Backward);
                    if (rectangle3 != null) {
                        Rectangle rectangle4 = rectangle3 instanceof Rectangle ? rectangle3 : rectangle3.getBounds();
                        rectangle2.add(rectangle4);
                    }
                    return rectangle2.contains(n2, n3);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }

        protected void activateLink(int n, JEditorPane jEditorPane) {
            this.activateLink(n, jEditorPane, null);
        }

        void activateLink(int n, JEditorPane jEditorPane, MouseEvent mouseEvent) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                Element element = hTMLDocument.getCharacterElement(n);
                AttributeSet attributeSet = element.getAttributes();
                AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                HyperlinkEvent hyperlinkEvent = null;
                int n2 = -1;
                int n3 = -1;
                if (mouseEvent != null) {
                    n2 = mouseEvent.getX();
                    n3 = mouseEvent.getY();
                }
                this.href = attributeSet2 == null ? this.getMapHREF(jEditorPane, hTMLDocument, element, attributeSet, n, n2, n3) : (String)attributeSet2.getAttribute(HTML.Attribute.HREF);
                if (this.href != null) {
                    hyperlinkEvent = this.createHyperlinkEvent(jEditorPane, hTMLDocument, this.href, attributeSet2, element, mouseEvent);
                }
                if (hyperlinkEvent != null) {
                    jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                }
            }
        }

        HyperlinkEvent createHyperlinkEvent(JEditorPane jEditorPane, HTMLDocument hTMLDocument, String string, AttributeSet attributeSet, Element element, MouseEvent mouseEvent) {
            String string2;
            URL uRL;
            Serializable serializable;
            try {
                serializable = hTMLDocument.getBase();
                uRL = new URL((URL)serializable, string);
                if (string != null && "file".equals(uRL.getProtocol()) && string.startsWith("#")) {
                    string2 = ((URL)serializable).getFile();
                    String string3 = uRL.getFile();
                    if (string2 != null && string3 != null && !string3.startsWith(string2)) {
                        uRL = new URL((URL)serializable, string2 + string);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            if (!hTMLDocument.isFrameDocument()) {
                serializable = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string, element, mouseEvent);
            } else {
                String string4 = string2 = attributeSet != null ? (String)attributeSet.getAttribute(HTML.Attribute.TARGET) : null;
                if (string2 == null || string2.equals("")) {
                    string2 = hTMLDocument.getBaseTarget();
                }
                if (string2 == null || string2.equals("")) {
                    string2 = "_self";
                }
                serializable = new HTMLFrameHyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string, element, mouseEvent, string2);
            }
            return serializable;
        }

        void fireEvents(JEditorPane jEditorPane, HTMLDocument hTMLDocument, String string, Element element, MouseEvent mouseEvent) {
            HyperlinkEvent hyperlinkEvent;
            URL uRL;
            if (this.href != null) {
                try {
                    uRL = new URL(hTMLDocument.getBase(), this.href);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.EXITED, uRL, this.href, element, mouseEvent);
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
            if (string != null) {
                try {
                    uRL = new URL(hTMLDocument.getBase(), string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ENTERED, uRL, string, this.curElem, mouseEvent);
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
        }
    }
}

