/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.channels.MembershipKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sun.nio.ch.MembershipKeyImpl;

class MembershipRegistry {
    private Map<InetAddress, List<MembershipKeyImpl>> groups = null;

    MembershipRegistry() {
    }

    MembershipKey checkMembership(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        List<MembershipKeyImpl> list;
        if (this.groups != null && (list = this.groups.get(inetAddress)) != null) {
            for (MembershipKeyImpl membershipKeyImpl : list) {
                if (!membershipKeyImpl.getNetworkInterface().equals(networkInterface)) continue;
                if (inetAddress2 == null) {
                    if (membershipKeyImpl.getSourceAddress() == null) {
                        return membershipKeyImpl;
                    }
                    throw new IllegalStateException("Already a member to receive all packets");
                }
                if (membershipKeyImpl.getSourceAddress() == null) {
                    throw new IllegalStateException("Already have source-specific membership");
                }
                if (!inetAddress2.equals(membershipKeyImpl.getSourceAddress())) continue;
                return membershipKeyImpl;
            }
        }
        return null;
    }

    void add(MembershipKeyImpl membershipKeyImpl) {
        List<MembershipKeyImpl> list;
        InetAddress inetAddress = membershipKeyImpl.getGroup();
        if (this.groups == null) {
            this.groups = new HashMap<InetAddress, List<MembershipKeyImpl>>();
            list = null;
        } else {
            list = this.groups.get(inetAddress);
        }
        if (list == null) {
            list = new LinkedList<MembershipKeyImpl>();
            this.groups.put(inetAddress, list);
        }
        list.add(membershipKeyImpl);
    }

    void remove(MembershipKeyImpl membershipKeyImpl) {
        InetAddress inetAddress = membershipKeyImpl.getGroup();
        List<MembershipKeyImpl> list = this.groups.get(inetAddress);
        if (list != null) {
            Iterator<MembershipKeyImpl> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != membershipKeyImpl) continue;
                iterator.remove();
                break;
            }
            if (list.isEmpty()) {
                this.groups.remove(inetAddress);
            }
        }
    }

    void invalidateAll() {
        for (InetAddress inetAddress : this.groups.keySet()) {
            for (MembershipKeyImpl membershipKeyImpl : this.groups.get(inetAddress)) {
                membershipKeyImpl.invalidate();
            }
        }
    }
}

