/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.Util;
import sun.rmi.server.WeakClassHashMap;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final boolean logCalls = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.logCalls"));
    public static final Log callLog = Log.getLog("sun.rmi.server.call", "RMI", logCalls);
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
    private boolean forceStubUse = false;
    private static final boolean suppressStackTraces = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.suppressStackTraces"));
    private transient Skeleton skel;
    private transient Map<Long, Method> hashToMethod_Map = null;
    private static final WeakClassHashMap<Map<Long, Method>> hashToMethod_Maps = new HashToMethod_Maps();
    private static final Map<Class<?>, ?> withoutSkeletons = Collections.synchronizedMap(new WeakHashMap());

    public UnicastServerRef() {
    }

    public UnicastServerRef(LiveRef liveRef) {
        super(liveRef);
    }

    public UnicastServerRef(int n) {
        super(new LiveRef(n));
    }

    public UnicastServerRef(boolean bl) {
        this(0);
        this.forceStubUse = bl;
    }

    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        this.forceStubUse = true;
        return (RemoteStub)this.exportObject(remote, object, false);
    }

    public Remote exportObject(Remote remote, Object object, boolean bl) throws RemoteException {
        Remote remote2;
        Class<?> clazz = remote.getClass();
        try {
            remote2 = Util.createProxy(clazz, this.getClientRef(), this.forceStubUse);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExportException("remote object implements illegal remote interface", illegalArgumentException);
        }
        if (remote2 instanceof RemoteStub) {
            this.setSkeleton(remote);
        }
        Target target = new Target(remote, this, remote2, this.ref.getObjID(), bl);
        this.ref.exportObject(target);
        this.hashToMethod_Map = hashToMethod_Maps.get(clazz);
        return remote2;
    }

    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public void setSkeleton(Remote remote) throws RemoteException {
        if (!withoutSkeletons.containsKey(remote.getClass())) {
            try {
                this.skel = Util.createSkeleton(remote);
            }
            catch (SkeletonNotFoundException skeletonNotFoundException) {
                withoutSkeletons.put(remote.getClass(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatch(Remote var1_1, RemoteCall var2_2) throws IOException {
        block28: {
            block26: {
                try {
                    try {
                        try {
                            var6_3 = var2_2.getInputStream();
                            var3_6 = var6_3.readInt();
                            if (var3_6 >= 0) {
                                if (this.skel == null) throw new UnmarshalException("skeleton class not found but required for client version");
                                this.oldDispatch(var1_1, var2_2, var3_6);
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Exception var7_12) {
                            throw new UnmarshalException("error unmarshalling call header", var7_12);
                        }
                        var15_7 = null;
                        break block26;
lbl-1000:
                        // 1 sources

                        {
                            var4_11 = var6_3.readLong();
                        }
                        var7_13 = (MarshalInputStream)var6_3;
                        var7_13.skipDefaultResolveClass();
                        var8_15 = this.hashToMethod_Map.get(var4_11);
                        if (var8_15 == null) {
                            throw new UnmarshalException("unrecognized method hash: method not supported by remote object");
                        }
                        this.logCall(var1_1, var8_15);
                        var9_16 = var8_15.getParameterTypes();
                        var10_17 = new Object[var9_16.length];
                        try {
                            try {
                                this.unmarshalCustomCallData(var6_3);
                                for (var11_18 = 0; var11_18 < var9_16.length; ++var11_18) {
                                    var10_17[var11_18] = UnicastServerRef.unmarshalValue(var9_16[var11_18], var6_3);
                                }
                                var13_22 = null;
                            }
                            catch (IOException var11_19) {
                                throw new UnmarshalException("error unmarshalling arguments", var11_19);
                            }
                            catch (ClassNotFoundException var11_20) {
                                throw new UnmarshalException("error unmarshalling arguments", var11_20);
                            }
                        }
                        catch (Throwable var12_24) {
                            var13_23 = null;
                            var2_2.releaseInputStream();
                            throw var12_24;
                        }
                        var2_2.releaseInputStream();
                        try {
                            var11_21 = var8_15.invoke(var1_1, var10_17);
                        }
                        catch (InvocationTargetException var12_25) {
                            throw var12_25.getTargetException();
                        }
                        try {
                            var12_26 = var2_2.getResultStream(true);
                            var13_22 = var8_15.getReturnType();
                            if (var13_22 != Void.TYPE) {
                                UnicastServerRef.marshalValue(var13_22, var11_21, var12_26);
                            }
                            break block28;
                        }
                        catch (IOException var12_27) {
                            throw new MarshalException("error marshalling return", var12_27);
                        }
                    }
                    catch (Throwable var6_4) {
                        this.logCallException(var6_4);
                        var7_14 = var2_2.getResultStream(false);
                        if (var6_4 instanceof Error) {
                            var6_5 /* !! */  = new ServerError("Error occurred in server thread", (Error)var6_4);
                        } else if (var6_4 instanceof RemoteException) {
                            var6_5 /* !! */  = new ServerException("RemoteException occurred in server thread", (Exception)var6_4);
                        }
                        if (UnicastServerRef.suppressStackTraces) {
                            UnicastServerRef.clearStackTraces(var6_5 /* !! */ );
                        }
                        var7_14.writeObject(var6_5 /* !! */ );
                        var15_9 = null;
                        var2_2.releaseInputStream();
                        var2_2.releaseOutputStream();
                        return;
                    }
                }
                catch (Throwable var14_28) {
                    var15_10 = null;
                    var2_2.releaseInputStream();
                    var2_2.releaseOutputStream();
                    throw var14_28;
                }
            }
            var2_2.releaseInputStream();
            var2_2.releaseOutputStream();
            return;
        }
        var15_8 = null;
        var2_2.releaseInputStream();
        var2_2.releaseOutputStream();
    }

    protected void unmarshalCustomCallData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void oldDispatch(Remote remote, RemoteCall remoteCall, int n) throws IOException {
        try {
            try {
                long l;
                ObjectInput objectInput;
                try {
                    objectInput = remoteCall.getInputStream();
                    l = objectInput.readLong();
                }
                catch (Exception exception) {
                    throw new UnmarshalException("error unmarshalling call header", exception);
                }
                this.logCall(remote, this.skel.getOperations()[n]);
                this.unmarshalCustomCallData(objectInput);
                this.skel.dispatch(remote, remoteCall, n, l);
            }
            catch (Throwable throwable) {
                RemoteException remoteException;
                this.logCallException(throwable);
                ObjectOutput objectOutput = remoteCall.getResultStream(false);
                if (throwable instanceof Error) {
                    remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
                } else if (throwable instanceof RemoteException) {
                    remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
                }
                if (suppressStackTraces) {
                    UnicastServerRef.clearStackTraces(remoteException);
                }
                objectOutput.writeObject(remoteException);
                Object var9_11 = null;
                remoteCall.releaseInputStream();
                remoteCall.releaseOutputStream();
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
            throw throwable;
        }
        remoteCall.releaseInputStream();
        remoteCall.releaseOutputStream();
    }

    public static void clearStackTraces(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        while (throwable != null) {
            throwable.setStackTrace(stackTraceElementArray);
            throwable = throwable.getCause();
        }
    }

    private void logCall(Remote remote, Object object) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String string;
            try {
                string = this.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                string = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + string + ": " + remote.getClass().getName() + this.ref.getObjID().toString() + ": " + object + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable throwable) {
        Object object;
        if (callLog.isLoggable(Log.BRIEF)) {
            object = "";
            try {
                object = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, (String)object + "exception: ", throwable);
        }
        if (wantExceptionLog) {
            Object object2 = object = System.err;
            synchronized (object2) {
                ((PrintStream)object).println();
                ((PrintStream)object).println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                throwable.printStackTrace((PrintStream)object);
            }
        }
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashToMethod_Maps
    extends WeakClassHashMap<Map<Long, Method>> {
        HashToMethod_Maps() {
        }

        @Override
        protected Map<Long, Method> computeValue(Class<?> clazz) {
            HashMap<Long, Method> hashMap = new HashMap<Long, Method>();
            for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    if (!Remote.class.isAssignableFrom(clazz3)) continue;
                    Method[] methodArray = clazz3.getMethods();
                    int n = methodArray.length;
                    for (int i = 0; i < n; ++i) {
                        Method method;
                        final Method method2 = method = methodArray[i];
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                method2.setAccessible(true);
                                return null;
                            }
                        });
                        hashMap.put(Util.computeMethodHash(method2), method2);
                    }
                }
            }
            return hashMap;
        }
    }
}

