/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XEmbedHelper;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;

public class XEmbedClientHelper
extends XEmbedHelper
implements XEventDispatcher {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.X11.xembed.XEmbedClientHelper");
    private XEmbeddedFramePeer embedded;
    private long server;
    private boolean active;
    private boolean applicationActive;

    XEmbedClientHelper() {
    }

    void setClient(XEmbeddedFramePeer xEmbeddedFramePeer) {
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine("XEmbed client: " + xEmbeddedFramePeer);
        }
        if (this.embedded != null) {
            XToolkit.removeEventDispatcher(this.embedded.getWindow(), this);
            this.active = false;
        }
        this.embedded = xEmbeddedFramePeer;
        if (this.embedded != null) {
            XToolkit.addEventDispatcher(this.embedded.getWindow(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install() {
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine("Installing xembedder on " + this.embedded);
        }
        long[] lArray = new long[]{0L, 1L};
        long l = Native.card32ToData(lArray);
        try {
            XEmbedInfo.setAtomData(this.embedded.getWindow(), l, 2);
            Object var5_3 = null;
            unsafe.freeMemory(l);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            unsafe.freeMemory(l);
            throw throwable;
        }
        long l2 = this.embedded.getParentWindowHandle();
        if (l2 != 0L) {
            XToolkit.awtLock();
            try {
                XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.embedded.getWindow(), l2, 0, 0);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
    }

    void handleClientMessage(XEvent xEvent) {
        XClientMessageEvent xClientMessageEvent = xEvent.get_xclient();
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine(xClientMessageEvent.toString());
        }
        if (xClientMessageEvent.get_message_type() == XEmbed.getAtom()) {
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Embedded message: " + XEmbedClientHelper.msgidToString((int)xClientMessageEvent.get_data(1)));
            }
            switch ((int)xClientMessageEvent.get_data(1)) {
                case 0: {
                    this.active = true;
                    this.server = this.getEmbedder(this.embedded, xClientMessageEvent);
                    if (!this.embedded.isReparented()) {
                        this.embedded.setReparented(true);
                        this.embedded.updateSizeHints();
                    }
                    this.embedded.notifyStarted();
                    break;
                }
                case 1: {
                    this.applicationActive = true;
                    break;
                }
                case 2: {
                    if (!this.applicationActive) break;
                    this.applicationActive = false;
                    this.handleWindowFocusOut();
                    break;
                }
                case 4: {
                    this.handleFocusIn((int)xClientMessageEvent.get_data(2));
                    break;
                }
                case 5: {
                    if (!this.applicationActive) break;
                    this.handleWindowFocusOut();
                }
            }
        }
    }

    void handleFocusIn(int n) {
        if (this.embedded.focusAllowedFor()) {
            this.embedded.handleWindowFocusInSync(0L);
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                SunToolkit.executeOnEventHandlerThread(this.embedded.target, new Runnable(){

                    public void run() {
                        Component component = ((Container)((XEmbedClientHelper)XEmbedClientHelper.this).embedded.target).getFocusTraversalPolicy().getFirstComponent((Container)((XEmbedClientHelper)XEmbedClientHelper.this).embedded.target);
                        if (component != null) {
                            component.requestFocusInWindow();
                        }
                    }
                });
                break;
            }
            case 2: {
                SunToolkit.executeOnEventHandlerThread(this.embedded.target, new Runnable(){

                    public void run() {
                        Component component = ((Container)((XEmbedClientHelper)XEmbedClientHelper.this).embedded.target).getFocusTraversalPolicy().getLastComponent((Container)((XEmbedClientHelper)XEmbedClientHelper.this).embedded.target);
                        if (component != null) {
                            component.requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    public void dispatchEvent(XEvent xEvent) {
        switch (xEvent.get_type()) {
            case 33: {
                this.handleClientMessage(xEvent);
                break;
            }
            case 21: {
                this.handleReparentNotify(xEvent);
            }
        }
    }

    public void handleReparentNotify(XEvent xEvent) {
        XReparentEvent xReparentEvent = xEvent.get_xreparent();
        long l = xReparentEvent.get_parent();
        if (this.active) {
            this.embedded.notifyStopped();
            X11GraphicsConfig x11GraphicsConfig = (X11GraphicsConfig)this.embedded.getGraphicsConfiguration();
            X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsConfig.getDevice();
            if (l == XlibUtil.getRootWindow(x11GraphicsDevice.getScreen()) || l == XToolkit.getDefaultRootWindow()) {
                this.active = false;
            } else {
                this.server = l;
                this.embedded.notifyStarted();
            }
        }
    }

    boolean requestFocus() {
        if (this.active && this.embedded.focusAllowedFor()) {
            this.sendMessage(this.server, 3);
            return true;
        }
        return false;
    }

    void handleWindowFocusOut() {
        if (XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow() == this.embedded.target) {
            this.embedded.handleWindowFocusOutSync(null, 0L);
        }
    }

    long getEmbedder(XWindowPeer xWindowPeer, XClientMessageEvent xClientMessageEvent) {
        return XlibUtil.getParentWindow(xWindowPeer.getWindow());
    }

    boolean isApplicationActive() {
        return this.applicationActive;
    }

    boolean isActive() {
        return this.active;
    }

    void traverseOutForward() {
        if (this.active) {
            this.sendMessage(this.server, 6);
        }
    }

    void traverseOutBackward() {
        if (this.active) {
            this.sendMessage(this.server, 7);
        }
    }

    void registerAccelerator(AWTKeyStroke aWTKeyStroke, int n) {
        if (this.active) {
            long l = this.getX11KeySym(aWTKeyStroke);
            long l2 = this.getX11Mods(aWTKeyStroke);
            this.sendMessage(this.server, 12, n, l, l2);
        }
    }

    void unregisterAccelerator(int n) {
        if (this.active) {
            this.sendMessage(this.server, 13, n, 0L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getX11KeySym(AWTKeyStroke aWTKeyStroke) {
        long l;
        XToolkit.awtLock();
        try {
            l = XWindow.getKeySymForAWTKeyCode(aWTKeyStroke.getKeyCode());
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        return l;
    }

    long getX11Mods(AWTKeyStroke aWTKeyStroke) {
        return XWindow.getXModifiers(aWTKeyStroke);
    }
}

