/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dm;
import com.google.android.gms.location.ActivityRecognitionResultCreator;
import com.google.android.gms.location.DetectedActivity;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityRecognitionResult
implements SafeParcelable {
    public static final String EXTRA_ACTIVITY_RESULT = "com.google.android.location.internal.EXTRA_ACTIVITY_RESULT";
    public static final ActivityRecognitionResultCreator CREATOR = new ActivityRecognitionResultCreator();
    private final int iM;
    List<DetectedActivity> ov;
    long ow;
    long ox;

    public ActivityRecognitionResult(List<DetectedActivity> probableActivities, long time, long elapsedRealtimeMillis) {
        dm.b(probableActivities != null && probableActivities.size() > 0, "Must have at least 1 detected activity");
        this.iM = 1;
        this.ov = probableActivities;
        this.ow = time;
        this.ox = elapsedRealtimeMillis;
    }

    public ActivityRecognitionResult(DetectedActivity mostProbableActivity, long time, long elapsedRealtimeMillis) {
        this(Collections.singletonList(mostProbableActivity), time, elapsedRealtimeMillis);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra(EXTRA_ACTIVITY_RESULT);
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        return (ActivityRecognitionResult)intent.getExtras().get(EXTRA_ACTIVITY_RESULT);
    }

    public DetectedActivity getMostProbableActivity() {
        return this.ov.get(0);
    }

    public int getActivityConfidence(int activityType) {
        for (DetectedActivity detectedActivity : this.ov) {
            if (detectedActivity.getType() != activityType) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.ov;
    }

    public long getTime() {
        return this.ow;
    }

    public long getElapsedRealtimeMillis() {
        return this.ox;
    }

    public String toString() {
        return "ActivityRecognitionResult [probableActivities=" + this.ov + ", timeMillis=" + this.ow + ", elapsedRealtimeMillis=" + this.ox + "]";
    }

    public ActivityRecognitionResult(int versionCode, List<DetectedActivity> probableActivities, long timeMillis, long elapsedRealtimeMillis) {
        this.iM = 1;
        this.ov = probableActivities;
        this.ow = timeMillis;
        this.ox = elapsedRealtimeMillis;
    }

    public int getVersionCode() {
        return this.iM;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        ActivityRecognitionResultCreator.a(this, out, flags);
    }
}

