/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBusSignal
extends Message {
    private static Map<Class<? extends DBusSignal>, Type[]> typeCache = new HashMap<Class<? extends DBusSignal>, Type[]>();
    private static Map<String, Class<? extends DBusSignal>> classCache = new HashMap<String, Class<? extends DBusSignal>>();
    private static Map<Class<? extends DBusSignal>, Constructor<? extends DBusSignal>> conCache = new HashMap<Class<? extends DBusSignal>, Constructor<? extends DBusSignal>>();
    private static Map<String, String> signames = new HashMap<String, String>();
    private static Map<String, String> intnames = new HashMap<String, String>();
    private Class<? extends DBusSignal> c;
    private boolean bodydone = false;
    private byte[] blen;

    DBusSignal() {
    }

    public DBusSignal(String string, String string2, String string3, String string4, String string5, Object ... objectArray) throws DBusException {
        super((byte)66, (byte)4, (byte)0);
        if (null == string2 || null == string4 || null == string3) {
            throw new MessageFormatException(Gettext._("Must specify object path, interface and signal name to Signals."));
        }
        this.headers.put((byte)1, string2);
        this.headers.put((byte)3, string4);
        this.headers.put((byte)2, string3);
        Vector<Object[]> vector = new Vector<Object[]>();
        vector.add(new Object[]{(byte)1, new Object[]{"o", string2}});
        vector.add(new Object[]{(byte)2, new Object[]{"s", string3}});
        vector.add(new Object[]{(byte)3, new Object[]{"s", string4}});
        if (null != string) {
            this.headers.put((byte)7, string);
            vector.add(new Object[]{(byte)7, new Object[]{"s", string}});
        }
        if (null != string5) {
            vector.add(new Object[]{(byte)8, new Object[]{"g", string5}});
            this.headers.put((byte)8, string5);
            this.setArgs(objectArray);
        }
        this.blen = new byte[4];
        this.appendBytes(this.blen);
        this.append("ua(yv)", ++this.serial, vector.toArray());
        this.pad((byte)8);
        long l = this.bytecounter;
        if (null != string5) {
            this.append(string5, objectArray);
        }
        this.marshallint(this.bytecounter - l, this.blen, 0, 4);
        this.bodydone = true;
    }

    static void addInterfaceMap(String string, String string2) {
        intnames.put(string2, string);
    }

    static void addSignalMap(String string, String string2) {
        signames.put(string2, string);
    }

    static DBusSignal createSignal(Class<? extends DBusSignal> clazz, String string, String string2, String string3, long l, Object ... objectArray) throws DBusException {
        String string4 = "";
        if (null != clazz.getEnclosingClass()) {
            string4 = null != clazz.getEnclosingClass().getAnnotation(DBusInterfaceName.class) ? clazz.getEnclosingClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(clazz.getEnclosingClass().getName()).replaceAll(".");
        } else {
            throw new DBusException(Gettext._("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package."));
        }
        internalsig internalsig2 = new internalsig(string, string2, string4, clazz.getSimpleName(), string3, objectArray, l);
        internalsig2.c = clazz;
        return internalsig2;
    }

    private static Class<? extends DBusSignal> createSignalClass(String string, String string2) throws DBusException {
        String string3 = string + '$' + string2;
        Class<DBusSignal> clazz = classCache.get(string3);
        if (null == clazz) {
            clazz = DBusMatchRule.getCachedSignalType(string3);
        }
        if (null != clazz) {
            return clazz;
        }
        do {
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            string3 = string3.replaceAll("\\.([^\\.]*)$", "\\$$1");
        } while (null == clazz && string3.matches(".*\\..*"));
        if (null == clazz) {
            throw new DBusException(Gettext._("Could not create class from signal ") + string + '.' + string2);
        }
        classCache.put(string3, clazz);
        return clazz;
    }

    DBusSignal createReal(AbstractConnection abstractConnection) throws DBusException {
        Object[] objectArray;
        Object object;
        String string = intnames.get(this.getInterface());
        String string2 = signames.get(this.getName());
        if (null == string) {
            string = this.getInterface();
        }
        if (null == string2) {
            string2 = this.getName();
        }
        if (null == this.c) {
            this.c = DBusSignal.createSignalClass(string, string2);
        }
        Type[] typeArray = typeCache.get(this.c);
        Constructor<DBusSignal> constructor = conCache.get(this.c);
        if (null == typeArray) {
            constructor = this.c.getDeclaredConstructors()[0];
            conCache.put(this.c, constructor);
            object = constructor.getGenericParameterTypes();
            typeArray = new Type[((Type[])object).length - 1];
            for (int i = 1; i < ((Type[])object).length; ++i) {
                if (object[i] instanceof TypeVariable) {
                    objectArray = ((TypeVariable)object[i]).getBounds();
                    int n = objectArray.length;
                    for (int j = 0; j < n; ++j) {
                        Object object2;
                        typeArray[i - 1] = object2 = objectArray[j];
                    }
                    continue;
                }
                typeArray[i - 1] = object[i];
            }
            typeCache.put(this.c, typeArray);
        }
        try {
            Object[] objectArray2 = Marshalling.deSerializeParameters(this.getParameters(), typeArray, abstractConnection);
            if (null == objectArray2) {
                object = constructor.newInstance(this.getPath());
            } else {
                objectArray = new Object[objectArray2.length + 1];
                objectArray[0] = this.getPath();
                System.arraycopy(objectArray2, 0, objectArray, 1, objectArray2.length);
                object = constructor.newInstance(objectArray);
            }
            object.headers = this.headers;
            object.wiredata = this.wiredata;
            object.bytecounter = this.wiredata.length;
            return object;
        }
        catch (Exception exception) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(exception.getMessage());
        }
    }

    protected DBusSignal(String string, Object ... objectArray) throws DBusException {
        super((byte)66, (byte)4, (byte)0);
        if (!string.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$")) {
            throw new DBusException(Gettext._("Invalid object path: ") + string);
        }
        Class<?> clazz = this.getClass();
        String string2 = clazz.isAnnotationPresent(DBusMemberName.class) ? clazz.getAnnotation(DBusMemberName.class).value() : clazz.getSimpleName();
        String string3 = null;
        Class<?> clazz2 = clazz.getEnclosingClass();
        if (null == clazz2 || !DBusInterface.class.isAssignableFrom(clazz2) || clazz2.getName().equals(clazz2.getSimpleName())) {
            throw new DBusException(Gettext._("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package."));
        }
        string3 = null != clazz2.getAnnotation(DBusInterfaceName.class) ? clazz2.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(clazz2.getName()).replaceAll(".");
        this.headers.put((byte)1, string);
        this.headers.put((byte)3, string2);
        this.headers.put((byte)2, string3);
        Vector<Object[]> vector = new Vector<Object[]>();
        vector.add(new Object[]{(byte)1, new Object[]{"o", string}});
        vector.add(new Object[]{(byte)2, new Object[]{"s", string3}});
        vector.add(new Object[]{(byte)3, new Object[]{"s", string2}});
        String string4 = null;
        if (0 < objectArray.length) {
            try {
                Type[] typeArray = typeCache.get(clazz);
                if (null == typeArray) {
                    Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
                    conCache.put(clazz, constructor);
                    Type[] typeArray2 = constructor.getGenericParameterTypes();
                    typeArray = new Type[typeArray2.length - 1];
                    for (int i = 1; i <= typeArray.length; ++i) {
                        typeArray[i - 1] = typeArray2[i] instanceof TypeVariable ? ((TypeVariable)typeArray2[i]).getBounds()[0] : typeArray2[i];
                    }
                    typeCache.put(clazz, typeArray);
                }
                string4 = Marshalling.getDBusType(typeArray);
                vector.add(new Object[]{(byte)8, new Object[]{"g", string4}});
                this.headers.put((byte)8, string4);
                this.setArgs(objectArray);
            }
            catch (Exception exception) {
                if (AbstractConnection.EXCEPTION_DEBUG) {
                    // empty if block
                }
                throw new DBusException(Gettext._("Failed to add signal parameters: ") + exception.getMessage());
            }
        }
        this.blen = new byte[4];
        this.appendBytes(this.blen);
        this.append("ua(yv)", ++this.serial, vector.toArray());
        this.pad((byte)8);
    }

    void appendbody(AbstractConnection abstractConnection) throws DBusException {
        if (this.bodydone) {
            return;
        }
        Type[] typeArray = typeCache.get(this.getClass());
        Object[] objectArray = Marshalling.convertParameters(this.getParameters(), typeArray, abstractConnection);
        this.setArgs(objectArray);
        String string = this.getSig();
        long l = this.bytecounter;
        if (null != objectArray && 0 < objectArray.length) {
            this.append(string, objectArray);
        }
        this.marshallint(this.bytecounter - l, this.blen, 0, 4);
        this.bodydone = true;
    }

    static class internalsig
    extends DBusSignal {
        public internalsig(String string, String string2, String string3, String string4, String string5, Object[] objectArray, long l) throws DBusException {
            super(string, string2, string3, string4, string5, objectArray, l);
        }
    }
}

