/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.version;

import net.java.sip.communicator.impl.version.VersionImpl;
import net.java.sip.communicator.impl.version.VersionServiceImpl;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.utils.version.VersionService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class VersionActivator
implements BundleActivator {
    private final Logger logger = Logger.getLogger(VersionActivator.class);
    private static BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Started.");
        }
        bundleContext = context;
        context.registerService(VersionService.class.getName(), (Object)new VersionServiceImpl(), null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Jitsi Version Service ... [REGISTERED]");
        }
        VersionImpl version = VersionImpl.currentVersion();
        String applicationName = version.getApplicationName();
        String versionString = ((Object)((Object)version)).toString();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Jitsi Version: " + applicationName + " " + versionString));
        }
        ConfigurationService cfg = VersionActivator.getConfigurationService();
        cfg.setProperty("sip-communicator.version", (Object)applicationName, true);
        cfg.setProperty("sip-communicator.application.name", (Object)versionString, true);
    }

    private static ConfigurationService getConfigurationService() {
        return (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public void stop(BundleContext context) throws Exception {
    }
}

