/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.compute;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.OAuth2Utils;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Clock;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.Collection;

@Beta
public class ComputeCredential
extends Credential {
    public static final String TOKEN_SERVER_ENCODED_URL = OAuth2Utils.getMetadataServerUrl() + "/computeMetadata/v1/instance/service-accounts/default/token";

    public ComputeCredential(HttpTransport transport, JsonFactory jsonFactory) {
        this(new Builder(transport, jsonFactory));
    }

    protected ComputeCredential(Builder builder) {
        super((Credential.Builder)builder);
    }

    protected TokenResponse executeRefreshToken() throws IOException {
        GenericUrl tokenUrl = new GenericUrl(this.getTokenServerEncodedUrl());
        HttpRequest request = this.getTransport().createRequestFactory().buildGetRequest(tokenUrl);
        request.setParser((ObjectParser)new JsonObjectParser(this.getJsonFactory()));
        request.getHeaders().set("Metadata-Flavor", (Object)"Google");
        return (TokenResponse)request.execute().parseAs(TokenResponse.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static class Builder
    extends Credential.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory) {
            super(BearerToken.authorizationHeaderAccessMethod());
            this.setTransport(transport);
            this.setJsonFactory(jsonFactory);
            this.setTokenServerEncodedUrl(TOKEN_SERVER_ENCODED_URL);
        }

        public ComputeCredential build() {
            return new ComputeCredential(this);
        }

        public Builder setTransport(HttpTransport transport) {
            return (Builder)super.setTransport((HttpTransport)Preconditions.checkNotNull((Object)transport));
        }

        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            return (Builder)super.setJsonFactory((JsonFactory)Preconditions.checkNotNull((Object)jsonFactory));
        }

        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            return (Builder)super.setTokenServerUrl((GenericUrl)Preconditions.checkNotNull((Object)tokenServerUrl));
        }

        public Builder setTokenServerEncodedUrl(String tokenServerEncodedUrl) {
            return (Builder)super.setTokenServerEncodedUrl((String)Preconditions.checkNotNull((Object)tokenServerEncodedUrl));
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            Preconditions.checkArgument((clientAuthentication == null ? 1 : 0) != 0);
            return this;
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            return (Builder)super.setRequestInitializer(requestInitializer);
        }

        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            return (Builder)super.addRefreshListener(refreshListener);
        }

        public Builder setRefreshListeners(Collection<CredentialRefreshListener> refreshListeners) {
            return (Builder)super.setRefreshListeners(refreshListeners);
        }
    }
}

